/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.ISourceCodeParser;
import org.eclipse.cdt.core.dom.parser.cpp.AbstractCPPParserExtensionConfiguration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.KeywordSetKey;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.GNUCPPSourceParser;
import org.eclipse.cdt.internal.core.parser.scanner2.DOMScanner;
import org.eclipse.cdt.internal.core.parser.token.KeywordSets;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkageFactory;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractCPPLanguage
extends AbstractLanguage
implements ICLanguageKeywords {
    static /* synthetic */ Class class$0;

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.dom.IPDOMLinkageFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new PDOMCPPLinkageFactory();
        }
        return super.getAdapter(adapter);
    }

    public IASTTranslationUnit getASTTranslationUnit(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory codeReaderFactory, IIndex index, IParserLogService log) throws CoreException {
        return this.getASTTranslationUnit(reader, scanInfo, codeReaderFactory, index, 0, log);
    }

    public IASTTranslationUnit getASTTranslationUnit(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory codeReaderFactory, IIndex index, int options, IParserLogService log) throws CoreException {
        IScanner scanner = this.createScanner(reader, scanInfo, codeReaderFactory, log);
        scanner.setScanComments((options & 2) != 0);
        ISourceCodeParser parser = this.createParser(scanner, log, index, false, options);
        IASTTranslationUnit ast = parser.parse();
        return ast;
    }

    public IASTCompletionNode getCompletionNode(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, IParserLogService log, int offset) throws CoreException {
        IScanner scanner = this.createScanner(reader, scanInfo, fileCreator, log);
        scanner.setContentAssistMode(offset);
        ISourceCodeParser parser = this.createParser(scanner, log, index, true, 0);
        parser.parse();
        IASTCompletionNode node = parser.getCompletionNode();
        return node;
    }

    public IASTName[] getSelectedNames(IASTTranslationUnit ast, int start, int length) {
        IASTNode selectedNode = ast.selectNodeForLocation(ast.getFilePath(), start, length);
        if (selectedNode == null) {
            return new IASTName[0];
        }
        if (selectedNode instanceof IASTName) {
            return new IASTName[]{(IASTName)selectedNode};
        }
        NameCollector collector = new NameCollector();
        selectedNode.accept(collector);
        return collector.getNames();
    }

    public IContributedModelBuilder createModelBuilder(ITranslationUnit tu) {
        return null;
    }

    protected IScanner createScanner(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IParserLogService log) {
        return new DOMScanner(reader, scanInfo, ParserMode.COMPLETE_PARSE, ParserLanguage.CPP, log, this.getScannerExtensionConfiguration(), fileCreator);
    }

    protected ISourceCodeParser createParser(IScanner scanner, IParserLogService log, IIndex index, boolean forCompletion, int options) {
        ParserMode mode = null;
        mode = forCompletion ? ParserMode.COMPLETION_PARSE : ((options & 1) != 0 ? ParserMode.STRUCTURAL_PARSE : ParserMode.COMPLETE_PARSE);
        return new GNUCPPSourceParser(scanner, mode, log, this.getParserExtensionConfiguration(), index);
    }

    protected abstract IScannerExtensionConfiguration getScannerExtensionConfiguration();

    protected abstract AbstractCPPParserExtensionConfiguration getParserExtensionConfiguration();

    public String[] getKeywords() {
        HashSet<String> keywords = KeywordSets.getKeywords(KeywordSetKey.KEYWORDS, ParserLanguage.CPP);
        keywords = new HashSet<String>(keywords);
        CharArrayIntMap additionalKeywords = this.getScannerExtensionConfiguration().getAdditionalKeywords();
        if (additionalKeywords != null) {
            Iterator iterator = additionalKeywords.toList().iterator();
            while (iterator.hasNext()) {
                char[] name = (char[])iterator.next();
                keywords.add(new String(name));
            }
        }
        return keywords.toArray(new String[keywords.size()]);
    }

    public String[] getBuiltinTypes() {
        Set types = KeywordSets.getKeywords(KeywordSetKey.TYPES, ParserLanguage.CPP);
        return types.toArray(new String[types.size()]);
    }

    public String[] getPreprocessorKeywords() {
        HashSet<String> keywords = KeywordSets.getKeywords(KeywordSetKey.PP_DIRECTIVE, ParserLanguage.CPP);
        keywords = new HashSet<String>(keywords);
        CharArrayIntMap additionalKeywords = this.getScannerExtensionConfiguration().getAdditionalPreprocessorKeywords();
        if (additionalKeywords != null) {
            Iterator iterator = additionalKeywords.toList().iterator();
            while (iterator.hasNext()) {
                char[] name = (char[])iterator.next();
                keywords.add(new String(name));
            }
        }
        return keywords.toArray(new String[keywords.size()]);
    }

    protected static class NameCollector
    extends CPPASTVisitor {
        private List nameList;

        protected NameCollector() {
            this.shouldVisitNames = true;
            this.nameList = new ArrayList();
        }

        public int visit(IASTName name) {
            this.nameList.add(name);
            return 3;
        }

        public IASTName[] getNames() {
            return this.nameList.toArray(new IASTName[this.nameList.size()]);
        }
    }
}

