/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.templateengine;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.cdt.core.templateengine.TemplateEngine;
import org.eclipse.cdt.core.templateengine.TemplateEngineMessages;
import org.eclipse.cdt.core.templateengine.TemplateInitializationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TemplateDescriptor {
    public static final String PROPERTY_GROUP = "property-group";
    public static final String PROCESS = "process";
    public static final String IF = "if";
    public static final String ID = "id";
    public static final String DEFAULT = "default";
    public static final String PERSIST = "persist";
    public static final String BOOL_TRUE = "true";
    private Document document;
    private Element rootElement;
    private List persistVector;
    private String pluginId;

    public TemplateDescriptor(URL descriptorURL, String pluginId) throws TemplateInitializationException {
        String msg = MessageFormat.format(TemplateEngineMessages.getString("TemplateCore.InitFailed"), descriptorURL);
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(descriptorURL.openStream());
        }
        catch (ParserConfigurationException pce) {
            throw new TemplateInitializationException(msg, pce);
        }
        catch (IOException ioe) {
            throw new TemplateInitializationException(msg, ioe);
        }
        catch (SAXException se) {
            throw new TemplateInitializationException(msg, se);
        }
        this.rootElement = this.document.getDocumentElement();
        this.persistVector = new ArrayList();
        this.pluginId = pluginId;
    }

    public Map getTemplateDefaults(Element rootElement) {
        Map templateDefaults = new HashMap();
        List children = TemplateEngine.getChildrenOfElement(rootElement);
        int i = 0;
        int l = children.size();
        while (i < l) {
            Element propertyGroupElement = (Element)children.get(i);
            if (this.isNestedElement(propertyGroupElement)) {
                templateDefaults = this.getTemplateDefaults(propertyGroupElement);
            }
            this.propertyElements(templateDefaults, propertyGroupElement);
            ++i;
        }
        return templateDefaults;
    }

    private boolean isNestedElement(Element element) {
        boolean result = false;
        if (element != null) {
            List children = TemplateEngine.getChildrenOfElement(element);
            String elementName = element.getNodeName();
            String testElementName = null;
            if (children.size() > 0) {
                Element testElement = (Element)children.get(0);
                testElementName = testElement.getNodeName();
            }
            result = elementName.equals(testElementName);
        }
        return result;
    }

    public List getPropertyGroupList() {
        ArrayList<Element> list;
        ArrayList<Element> resultList = null;
        resultList = list = new ArrayList<Element>();
        if (this.rootElement != null) {
            List tempList = TemplateEngine.getChildrenOfElement(this.rootElement);
            int i = 0;
            int l = tempList.size();
            while (i < l) {
                Element nextPropertyGroup = (Element)tempList.get(i);
                String nextPGName = nextPropertyGroup.getNodeName();
                if (nextPGName.equalsIgnoreCase(PROPERTY_GROUP)) {
                    list.add(nextPropertyGroup);
                }
                ++i;
            }
        }
        return resultList;
    }

    public Element getRootPropertyGroup(Element rootElement) {
        if (rootElement != null) {
            String rootElementName = rootElement.getNodeName();
            if (rootElementName.equalsIgnoreCase(PROPERTY_GROUP) && this.isNestedElement(rootElement)) {
                return rootElement;
            }
            return rootElement;
        }
        String nextPGElementName = null;
        List propertyGroupList = TemplateEngine.getChildrenOfElement(rootElement);
        int i = 0;
        int l = propertyGroupList.size();
        while (i < l) {
            Element nextPGElement = (Element)propertyGroupList.get(i);
            if (this.isNestedElement(nextPGElement)) {
                nextPGElementName = nextPGElement.getNodeName();
            }
            if (nextPGElementName.equalsIgnoreCase(PROPERTY_GROUP) && this.isNestedElement(nextPGElement)) {
                return nextPGElement;
            }
            ++i;
        }
        return null;
    }

    private void propertyElements(Map defaults, Element propertyGroupElement) {
        List children = TemplateEngine.getChildrenOfElement(propertyGroupElement);
        int i = 0;
        int l = children.size();
        while (i < l) {
            String persist;
            Element propertyElement = (Element)children.get(i);
            String key = propertyElement.getAttribute(ID);
            String value = propertyElement.getAttribute(DEFAULT);
            if (key != null && !key.equals("")) {
                defaults.put(key, value);
            }
            if ((persist = propertyElement.getAttribute(PERSIST)) != null && persist.trim().equalsIgnoreCase(BOOL_TRUE)) {
                this.persistVector.add(key);
            }
            ++i;
        }
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public List getPersistTrueIDs() {
        return this.persistVector;
    }

    public String getPluginId() {
        return this.pluginId;
    }
}

