/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisiblityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;

public class CPPImplicitMethod
extends CPPImplicitFunction
implements ICPPMethod {
    public CPPImplicitMethod(ICPPClassScope scope, char[] name, IType returnType, IParameter[] params) {
        super(name, scope, returnType, params, false);
    }

    public int getVisibility() throws DOMException {
        IASTDeclaration decl = this.getPrimaryDeclaration();
        if (decl == null) {
            return 1;
        }
        IASTCompositeTypeSpecifier cls = (IASTCompositeTypeSpecifier)decl.getParent();
        IASTDeclaration[] members = cls.getMembers();
        ICPPASTVisiblityLabel vis = null;
        int i = 0;
        while (i < members.length) {
            if (members[i] instanceof ICPPASTVisiblityLabel) {
                vis = (ICPPASTVisiblityLabel)members[i];
            } else if (members[i] == decl) break;
            ++i;
        }
        if (vis != null) {
            return vis.getVisibility();
        }
        if (cls.getKey() == 3) {
            return 3;
        }
        return 1;
    }

    public ICPPClassType getClassOwner() throws DOMException {
        ICPPClassScope scope = (ICPPClassScope)this.getScope();
        return scope.getClassType();
    }

    public IASTDeclaration getPrimaryDeclaration() throws DOMException {
        if (this.declarations != null) {
            int i = 0;
            while (i < this.declarations.length) {
                IASTDeclaration decl = (IASTDeclaration)this.declarations[i].getParent();
                if (decl.getParent() instanceof ICPPASTCompositeTypeSpecifier) {
                    return decl;
                }
                ++i;
            }
        }
        IFunctionType ftype = this.getType();
        IType[] params = ftype.getParameterTypes();
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)ASTInternal.getPhysicalNodeOfScope(this.getScope());
        if (compSpec == null) {
            return null;
        }
        IASTDeclaration[] members = compSpec.getMembers();
        int i = 0;
        while (i < members.length) {
            IASTDeclarator dtor = null;
            IASTDeclarator[] ds = null;
            int di = -1;
            IASTDeclaration member = members[i];
            if (member instanceof ICPPASTTemplateDeclaration) {
                member = ((ICPPASTTemplateDeclaration)member).getDeclaration();
            }
            if (member instanceof IASTSimpleDeclaration) {
                ds = ((IASTSimpleDeclaration)member).getDeclarators();
            } else if (member instanceof IASTFunctionDefinition) {
                dtor = ((IASTFunctionDefinition)member).getDeclarator();
            }
            if (ds != null && ds.length > 0) {
                di = 0;
                dtor = ds[0];
            }
            while (dtor != null) {
                IASTName name = dtor.getName();
                if (dtor instanceof ICPPASTFunctionDeclarator && CharArrayUtils.equals(name.toCharArray(), this.getNameCharArray())) {
                    IType t0 = CPPVisitor.createType(dtor);
                    boolean ok = false;
                    if (t0 instanceof IFunctionType) {
                        IFunctionType t = (IFunctionType)t0;
                        IType[] ps = t.getParameterTypes();
                        if (ps.length == params.length) {
                            int idx = 0;
                            while (idx < ps.length && ps[idx] != null) {
                                if (!ps[idx].isSameType(params[idx])) break;
                                ++idx;
                            }
                            ok = idx == ps.length;
                        } else if (ps.length == 0 && params.length == 1) {
                            IType t1 = params[0];
                            ok = t1 instanceof IBasicType && ((IBasicType)t1).getType() == 1;
                        }
                    } else {
                        ok = false;
                    }
                    if (ok) {
                        name.setBinding(this);
                        if (member instanceof IASTSimpleDeclaration) {
                            this.addDeclaration(dtor);
                        } else if (member instanceof IASTFunctionDefinition) {
                            this.addDefinition(dtor);
                        }
                        return members[i];
                    }
                }
                IASTDeclarator iASTDeclarator = dtor = di > -1 && ++di < ds.length ? ds[di] : null;
            }
            ++i;
        }
        return null;
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isDestructor() {
        char[] n = this.getNameCharArray();
        if (n != null && n.length > 0) {
            return n[0] == '~';
        }
        return false;
    }

    public boolean isImplicit() {
        try {
            return this.getPrimaryDeclaration() == null;
        }
        catch (DOMException dOMException) {
            return true;
        }
    }
}

