/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplatePartialSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.parser.util.ObjectMap;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.index.IIndexInternalTemplateParameter;
import org.eclipse.core.runtime.CoreException;

public class IndexCPPSignatureUtil {
    public static String getSignature(IBinding binding) throws CoreException, DOMException {
        ICPPSpecialization spec;
        StringBuffer buffer = new StringBuffer();
        if (binding instanceof ICPPTemplateInstance) {
            ICPPTemplateInstance inst = (ICPPTemplateInstance)binding;
            buffer.append(IndexCPPSignatureUtil.getTemplateArgString(inst.getArguments(), true));
        } else if (binding instanceof ICPPClassTemplatePartialSpecialization) {
            ICPPClassTemplatePartialSpecialization partial = (ICPPClassTemplatePartialSpecialization)binding;
            buffer.append(IndexCPPSignatureUtil.getTemplateArgString(partial.getArguments(), false));
        } else if (binding instanceof ICPPSpecialization && !((spec = (ICPPSpecialization)binding) instanceof ICPPTemplateDefinition) && spec.getSpecializedBinding() instanceof ICPPTemplateDefinition) {
            ICPPTemplateDefinition template = (ICPPTemplateDefinition)spec.getSpecializedBinding();
            ICPPTemplateParameter[] params = template.getTemplateParameters();
            ObjectMap argMap = spec.getArgumentMap();
            IType[] args = new IType[params.length];
            int i = 0;
            while (i < params.length) {
                args[i] = (IType)argMap.get(params[i]);
                ++i;
            }
            buffer.append(IndexCPPSignatureUtil.getTemplateArgString(args, false));
        }
        if (binding instanceof IFunction) {
            IFunction function = (IFunction)binding;
            buffer.append(IndexCPPSignatureUtil.getFunctionParameterString(function.getType()));
        }
        return buffer.toString();
    }

    private static String getTemplateArgString(IType[] types, boolean qualifyTemplateParameters) throws CoreException, DOMException {
        StringBuffer buffer = new StringBuffer();
        buffer.append('<');
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                buffer.append(',');
            }
            if (qualifyTemplateParameters && types[i] instanceof ICPPTemplateParameter) {
                ICPPBinding parent = null;
                if (types[i] instanceof IIndexInternalTemplateParameter) {
                    parent = ((IIndexInternalTemplateParameter)((Object)types[i])).getParameterOwner();
                } else {
                    IName parentName = ((ICPPTemplateParameter)((Object)types[i])).getScope().getScopeName();
                    if (parentName instanceof IASTName) {
                        parent = (ICPPBinding)((IASTName)parentName).resolveBinding();
                    }
                }
                if (parent != null) {
                    buffer.append(CPPVisitor.renderQualifiedName(parent.getQualifiedName()));
                    String sig = IndexCPPSignatureUtil.getSignature(parent);
                    if (sig != null) {
                        buffer.append(sig);
                    }
                    buffer.append("::");
                }
                buffer.append(((ICPPTemplateParameter)((Object)types[i])).getName());
            } else {
                buffer.append(ASTTypeUtil.getType(types[i]));
            }
            ++i;
        }
        buffer.append('>');
        return buffer.toString();
    }

    private static String getFunctionParameterString(IFunctionType fType) throws DOMException {
        IType[] types = fType.getParameterTypes();
        if (types.length == 1 && types[0] instanceof IBasicType && ((IBasicType)types[0]).getType() == 1) {
            types = new IType[]{};
        }
        StringBuffer result = new StringBuffer();
        result.append('(');
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                result.append(',');
            }
            result.append(ASTTypeUtil.getType(types[i]));
            ++i;
        }
        result.append(')');
        return result.toString();
    }

    public static Integer getSignatureMemento(IBinding binding) throws CoreException, DOMException {
        String sig = IndexCPPSignatureUtil.getSignature(binding);
        return sig.length() == 0 ? null : new Integer(sig.hashCode());
    }

    public static Integer getSignatureMemento(ICPPFunctionType type) throws DOMException {
        String sig = IndexCPPSignatureUtil.getFunctionParameterString(type);
        return sig.length() == 0 ? null : new Integer(sig.hashCode());
    }

    public static int compareSignatures(IBinding a, IBinding b) {
        try {
            int siga = IndexCPPSignatureUtil.getSignature(a).hashCode();
            int sigb = IndexCPPSignatureUtil.getSignature(b).hashCode();
            return siga < sigb ? -1 : (siga > sigb ? 1 : 0);
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
        }
        catch (DOMException de) {
            CCorePlugin.log(de);
        }
        return 0;
    }
}

