/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.indexer;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.indexer.ILanguageMapper;
import org.eclipse.cdt.internal.core.indexer.StandaloneIndexerTask;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class StandaloneIndexer {
    public static final int SKIP_NO_REFERENCES = 0;
    public static final int SKIP_ALL_REFERENCES = 1;
    public static final int SKIP_TYPE_REFERENCES = 2;
    public static final int UPDATE_ALL = 1;
    public static final int UPDATE_CHECK_TIMESTAMPS = 2;
    protected static final List NO_TUS = new ArrayList();
    protected IWritableIndex fIndex;
    protected boolean fIndexAllFiles;
    protected Set fValidSourceUnitNames;
    protected IScannerInfo fScanner;
    protected ILanguageMapper fMapper;
    protected IParserLogService fLog;
    protected boolean fShowActivity;
    protected boolean fShowProblems;
    protected boolean fTraceStatistics;
    protected int fSkipReferences = 0;
    protected FilenameFilter fExclusionFilter;
    protected String[] fFilesToParseUpFront = new String[0];
    protected int fUpdateOptions = 1;
    private IndexerProgress fProgress = null;
    private volatile StandaloneIndexerTask fDelegate;
    private static FilenameFilter DEFAULT_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return true;
        }
    };

    public IWritableIndex getIndex() {
        return this.fIndex;
    }

    public boolean getIndexAllFiles() {
        return this.fIndexAllFiles;
    }

    public Set getValidSourceUnitNames() {
        return this.fValidSourceUnitNames;
    }

    public void setValidSourceUnitNames(Set validSourceUnitNames) {
        this.fValidSourceUnitNames = validSourceUnitNames;
    }

    public IScannerInfo getScannerInfo() {
        return this.fScanner;
    }

    public ILanguageMapper getLanguageMapper() {
        return this.fMapper;
    }

    public IParserLogService getParserLog() {
        return this.fLog;
    }

    public boolean getShowActivity() {
        return this.fShowActivity;
    }

    public void setShowActivity(boolean showActivity) {
        this.fShowActivity = showActivity;
    }

    public boolean getShowProblems() {
        return this.fShowProblems;
    }

    public void setShowProblems(boolean showProblems) {
        this.fShowProblems = showProblems;
    }

    public boolean getTraceStatistics() {
        return this.fTraceStatistics;
    }

    public void setTraceStatistics(boolean traceStatistics) {
        this.fTraceStatistics = traceStatistics;
    }

    private IndexerProgress createProgress() {
        IndexerProgress progress = new IndexerProgress();
        progress.fTimeEstimate = 1000;
        return progress;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clearIndex() throws CoreException, InterruptedException {
        IWritableIndex index = this.getIndex();
        index.acquireWriteLock(0);
        try {
            index.clear();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            index.releaseWriteLock(0);
            throw throwable;
        }
        {
            Object var2_4 = null;
            index.releaseWriteLock(0);
            return;
        }
    }

    public synchronized IndexerProgress getProgressInformation() {
        return this.fDelegate != null ? this.fDelegate.getProgressInformation() : this.fProgress;
    }

    public int getUpdateOptions() {
        return this.fUpdateOptions;
    }

    public void setUpdateOptions(int options) {
        this.fUpdateOptions = options;
    }

    public void rebuild(List tus, IProgressMonitor monitor) throws IOException {
        this.fProgress = this.createProgress();
        try {
            this.clearIndex();
            this.fDelegate = this.createTask(this.getFilesAdded(tus), NO_TUS, NO_TUS);
            this.fDelegate.setUpdateFlags(this.fUpdateOptions);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {}
        if (this.fDelegate != null) {
            this.fDelegate.run(monitor);
        }
    }

    public void handleDelta(List added, List changed, List removed, IProgressMonitor monitor) throws IOException {
        this.fProgress = new IndexerProgress();
        this.fDelegate = this.createTask(this.getFilesAdded(added), changed, removed);
        if (this.fDelegate instanceof StandaloneIndexerTask) {
            this.fDelegate.setUpdateFlags(this.fUpdateOptions);
        }
        if (this.fDelegate != null) {
            this.fDelegate.run(monitor);
        }
    }

    private List getFilesAdded(List tus) {
        ArrayList<String> added = new ArrayList<String>();
        FilenameFilter filter = this.getExclusionFilter();
        if (filter == null) {
            filter = DEFAULT_FILTER;
        }
        Iterator iter = tus.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            File file = new File(path);
            if (file.isDirectory()) {
                String[] files = file.list(filter);
                int i = 0;
                while (i < files.length) {
                    added.add(files[i]);
                    ++i;
                }
                continue;
            }
            if (!filter.accept(file.getParentFile(), file.getName())) continue;
            added.add(path);
        }
        return added;
    }

    protected abstract StandaloneIndexerTask createTask(List var1, List var2, List var3);

    public int getSkipReferences() {
        return this.fSkipReferences;
    }

    public void setSkipReferences(int skipReferences) {
        this.fSkipReferences = skipReferences;
    }

    public String[] getFilesToParseUpFront() {
        return this.fFilesToParseUpFront;
    }

    public void setFilesToParseUpFront(String[] filesToParseUpFront) {
        this.fFilesToParseUpFront = filesToParseUpFront;
    }

    public FilenameFilter getExclusionFilter() {
        return this.fExclusionFilter;
    }

    public void setExclusionFilter(FilenameFilter exclusionFilter) {
        this.fExclusionFilter = exclusionFilter;
    }
}

