/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.indexer;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IndexFileLocation;
import org.eclipse.cdt.internal.core.indexer.StandaloneIndexer;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.PDOMWriter;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public abstract class StandaloneIndexerTask
extends PDOMWriter {
    private static final Object NO_CONTEXT = new Object();
    protected StandaloneIndexer fIndexer;
    protected Map fContextMap = new HashMap();
    private List fFilesUpFront = new ArrayList();
    private String fDummyFileName;
    private URI fDummyFileURI;
    private int fUpdateFlags = 1;

    protected StandaloneIndexerTask(StandaloneIndexer indexer) {
        this.fIndexer = indexer;
        this.setShowActivity(this.fIndexer.getShowActivity());
        this.setShowProblems(this.fIndexer.getShowProblems());
        this.setSkipReferences(this.fIndexer.getSkipReferences());
    }

    public final StandaloneIndexer getIndexer() {
        return this.fIndexer;
    }

    public final IndexerProgress getProgressInformation() {
        return super.getProgressInformation();
    }

    public void setUpdateFlags(int flags) {
        this.fUpdateFlags = flags;
    }

    public final boolean updateAll() {
        return (this.fUpdateFlags & 1) != 0;
    }

    public final boolean updateChangedTimestamps() {
        return (this.fUpdateFlags & 2) != 0;
    }

    public final void setParseUpFront() {
        String[] files = this.fIndexer.getFilesToParseUpFront();
        int i = 0;
        while (i < files.length) {
            this.fFilesUpFront.add(files[i]);
            ++i;
        }
    }

    protected final boolean getIndexAllFiles() {
        return this.getIndexer().getIndexAllFiles();
    }

    private IASTTranslationUnit createAST(IIndexFileLocation location, IScannerInfo scannerInfo, int options, IProgressMonitor pm) throws IOException, CoreException {
        String path = location.getFullPath();
        if (path == null) {
            return null;
        }
        ILanguage language = this.fIndexer.getLanguageMapper().getLanguage(path);
        if (language == null) {
            return null;
        }
        CodeReader codeReader = new CodeReader(path);
        if (codeReader == null) {
            return null;
        }
        return this.createAST((AbstractLanguage)language, codeReader, scannerInfo, options, pm);
    }

    protected abstract IASTTranslationUnit createAST(AbstractLanguage var1, CodeReader var2, IScannerInfo var3, int var4, IProgressMonitor var5) throws CoreException;

    protected void parseTUs(IWritableIndex index, int readlockCount, Collection sources, Collection headers, IProgressMonitor monitor) throws IOException, CoreException, InterruptedException {
        IIndexFileLocation ifl;
        String path;
        String sourcePath;
        int options = 0;
        if (this.fIndexer.getSkipReferences() == 1) {
            options |= 1;
        }
        Iterator iter = this.fFilesUpFront.iterator();
        while (iter.hasNext()) {
            String upfront = (String)iter.next();
            this.parseUpFront(upfront, options, index, readlockCount, monitor);
        }
        iter = sources.iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            sourcePath = (String)iter.next();
            path = new File(sourcePath).getCanonicalPath();
            ifl = this.getIndexFileLocation(path);
            if (!this.needToUpdate(ifl, 0)) continue;
            this.parseTU(ifl, options, index, readlockCount, monitor);
        }
        iter = headers.iterator();
        while (iter.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            sourcePath = (String)iter.next();
            path = new File(sourcePath).getCanonicalPath();
            IIndexFileLocation location = this.getIndexFileLocation(path);
            if (!this.needToUpdate(location, 0)) {
                iter.remove();
                continue;
            }
            IIndexFileLocation context = this.findContext(index, location);
            if (context == null) continue;
            this.parseTU(context, options, index, readlockCount, monitor);
        }
        if (this.getIndexAllFiles()) {
            iter = headers.iterator();
            while (iter.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                sourcePath = (String)iter.next();
                path = new File(sourcePath).getCanonicalPath();
                ifl = this.getIndexFileLocation(path);
                if (!this.needToUpdate(ifl, 0)) {
                    iter.remove();
                    continue;
                }
                this.parseTU(ifl, options, index, readlockCount, monitor);
            }
        }
    }

    protected final boolean isOutdated(IIndexFileLocation ifl, IIndexFile indexFile) throws CoreException {
        if (indexFile == null) {
            return true;
        }
        File res = new File(ifl.getFullPath());
        if (res != null) {
            return indexFile == null || res.lastModified() != indexFile.getTimestamp();
        }
        return false;
    }

    private void parseTU(IIndexFileLocation location, int options, IWritableIndex index, int readlockCount, IProgressMonitor pm) throws IOException, CoreException, InterruptedException {
        String path = location.getFullPath();
        try {
            IScannerInfo scanner = this.fIndexer.getScannerInfo();
            if (scanner == null) {
                this.updateInfo(0, 0, -1);
            } else {
                int configHash = StandaloneIndexerTask.computeHashCode(scanner);
                if (this.needToUpdate(location, configHash)) {
                    if (this.fShowActivity) {
                        System.out.println("Indexer: parsing " + path);
                    }
                    long start = System.currentTimeMillis();
                    IASTTranslationUnit ast = this.createAST(location, scanner, options, pm);
                    this.fStatistics.fParsingTime = (int)((long)this.fStatistics.fParsingTime + (System.currentTimeMillis() - start));
                    if (ast != null) {
                        this.addSymbols(ast, index, readlockCount, configHash, pm);
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    private void parseUpFront(String file, int options, IWritableIndex index, int readlockCount, IProgressMonitor pm) throws CoreException, InterruptedException {
        if ((file = file.trim()).length() == 0) {
            return;
        }
        try {
            if (this.fShowActivity) {
                System.out.println("Indexer: parsing " + file + " up front");
            }
            long start = System.currentTimeMillis();
            IASTTranslationUnit ast = null;
            ILanguage l = this.fIndexer.getLanguageMapper().getLanguage(file);
            if (l instanceof AbstractLanguage) {
                AbstractLanguage lang = (AbstractLanguage)l;
                IScannerInfo scanInfo = this.fIndexer.getScannerInfo();
                String code = "#include \"" + file + "\"\n";
                if (this.fDummyFileName == null) {
                    this.fDummyFileName = String.valueOf(file) + "___";
                    this.fDummyFileURI = this.findLocation(this.fDummyFileName).getURI();
                }
                CodeReader codeReader = new CodeReader(this.fDummyFileName, code.toCharArray());
                ast = this.createAST(lang, codeReader, scanInfo, options, pm);
            }
            this.fStatistics.fParsingTime = (int)((long)this.fStatistics.fParsingTime + (System.currentTimeMillis() - start));
            if (ast != null) {
                this.addSymbols(ast, index, readlockCount, 0, pm);
                this.updateInfo(-1, 1, 0);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }

    protected boolean needToUpdate(IIndexFileLocation fileLoc, int configHash) throws CoreException {
        return this.fDummyFileURI == null || !this.fDummyFileURI.equals(fileLoc.getURI());
    }

    private IIndexFileLocation findContext(IIndex index, IIndexFileLocation location) {
        Object cachedContext = this.fContextMap.get(location);
        if (cachedContext != null) {
            return cachedContext == NO_CONTEXT ? null : (IIndexFileLocation)cachedContext;
        }
        IIndexFileLocation context = null;
        this.fContextMap.put(location, NO_CONTEXT);
        try {
            IIndexFile pdomFile = index.getFile(location);
            if (pdomFile != null) {
                IIndexInclude[] includedBy = index.findIncludedBy(pdomFile, 0);
                ArrayList<IIndexFileLocation> paths = new ArrayList<IIndexFileLocation>(includedBy.length);
                int i = 0;
                while (i < includedBy.length) {
                    IIndexInclude include = includedBy[i];
                    IIndexFileLocation incLocation = include.getIncludedByLocation();
                    if (this.isValidSourceUnitName(incLocation.getFullPath()) && (context = incLocation) != null) {
                        this.fContextMap.put(location, context);
                        return context;
                    }
                    paths.add(incLocation);
                    ++i;
                }
                Iterator iter = paths.iterator();
                while (iter.hasNext()) {
                    IIndexFileLocation nextLevel = (IIndexFileLocation)iter.next();
                    context = this.findContext(index, nextLevel);
                    if (context == null) continue;
                    this.fContextMap.put(location, context);
                    return context;
                }
            }
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void removeTU(IWritableIndex index, IIndexFileLocation ifl, int readlocks) throws CoreException, InterruptedException {
        index.acquireWriteLock(readlocks);
        try {
            IIndexFragmentFile file = (IIndexFragmentFile)index.getFile(ifl);
            if (file != null) {
                index.clearFile(file, null);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            index.releaseWriteLock(readlocks);
            throw throwable;
        }
        {
            Object var5_7 = null;
            index.releaseWriteLock(readlocks);
            return;
        }
    }

    protected void traceEnd(long start) {
        if (this.fIndexer.getTraceStatistics()) {
            IndexerProgress info = this.getProgressInformation();
            String name = this.getClass().getName();
            name = name.substring(name.lastIndexOf(46) + 1);
            System.out.println(String.valueOf(name) + " " + " (" + info.fCompletedSources + " sources, " + info.fCompletedHeaders + " headers)");
            boolean allFiles = this.getIndexAllFiles();
            boolean skipRefs = this.fIndexer.getSkipReferences() == 1;
            boolean skipTypeRefs = skipRefs || this.fIndexer.getSkipReferences() == 2;
            System.out.println(String.valueOf(name) + " Options: " + "parseAllFiles=" + allFiles + ",skipReferences=" + skipRefs + ", skipTypeReferences=" + skipTypeRefs + ".");
            System.out.println(String.valueOf(name) + " Timings: " + (System.currentTimeMillis() - start) + " total, " + this.fStatistics.fParsingTime + " parser, " + this.fStatistics.fResolutionTime + " resolution, " + this.fStatistics.fAddToIndexTime + " index update.");
            int sum = this.fStatistics.fDeclarationCount + this.fStatistics.fReferenceCount + this.fStatistics.fProblemBindingCount;
            double problemPct = sum == 0 ? 0.0 : (double)this.fStatistics.fProblemBindingCount / (double)sum;
            NumberFormat nf = NumberFormat.getPercentInstance();
            nf.setMaximumFractionDigits(2);
            nf.setMinimumFractionDigits(2);
            System.out.println(String.valueOf(name) + " Result: " + this.fStatistics.fDeclarationCount + " declarations, " + this.fStatistics.fReferenceCount + " references, " + this.fStatistics.fErrorCount + " errors, " + this.fStatistics.fProblemBindingCount + "(" + nf.format(problemPct) + ") problems.");
            IWritableIndex index = this.fIndexer.getIndex();
            if (index != null) {
                long hits;
                long misses = index.getCacheMisses();
                long tries = misses + (hits = index.getCacheHits());
                double missPct = tries == 0L ? 0.0 : (double)misses / (double)tries;
                System.out.println(String.valueOf(name) + " Cache: " + hits + " hits, " + misses + "(" + nf.format(missPct) + ") misses.");
            }
        }
    }

    public abstract void run(IProgressMonitor var1) throws IOException;

    protected IIndexFileLocation getIndexFileLocation(String path) {
        String absolutePath = new File(path).getAbsolutePath();
        return new IndexFileLocation(URIUtil.toURI((String)absolutePath), absolutePath);
    }

    protected boolean isValidSourceUnitName(String filename) {
        Path path = new Path(filename);
        if (this.fIndexer.getValidSourceUnitNames() == null || this.fIndexer.getValidSourceUnitNames().size() == 0) {
            return true;
        }
        return this.fIndexer.getValidSourceUnitNames().contains(path.getFileExtension());
    }

    protected long getLastModified(IIndexFileLocation location) {
        return new File(location.getFullPath()).lastModified();
    }

    protected static int computeHashCode(IScannerInfo scannerInfo) {
        String[] a;
        int result = 0;
        Map macros = scannerInfo.getDefinedSymbols();
        if (macros != null) {
            Iterator i = macros.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                result = StandaloneIndexerTask.addToHashcode(result, key);
                if (value == null || value.length() <= 0) continue;
                result = StandaloneIndexerTask.addToHashcode(result, value);
            }
        }
        if ((a = scannerInfo.getIncludePaths()) != null) {
            int i = 0;
            while (i < a.length) {
                result = StandaloneIndexerTask.addToHashcode(result, a[i]);
                ++i;
            }
        }
        if (scannerInfo instanceof IExtendedScannerInfo) {
            IExtendedScannerInfo esi = (IExtendedScannerInfo)scannerInfo;
            a = esi.getIncludeFiles();
            if (a != null) {
                int i = 0;
                while (i < a.length) {
                    result = StandaloneIndexerTask.addToHashcode(result, a[i]);
                    ++i;
                }
            }
            if ((a = esi.getLocalIncludePath()) != null) {
                int i = 0;
                while (i < a.length) {
                    result = StandaloneIndexerTask.addToHashcode(result, a[i]);
                    ++i;
                }
            }
            if ((a = esi.getMacroFiles()) != null) {
                int i = 0;
                while (i < a.length) {
                    result = StandaloneIndexerTask.addToHashcode(result, a[i]);
                    ++i;
                }
            }
        }
        return result;
    }

    private static int addToHashcode(int result, String key) {
        return result * 31 + key.hashCode();
    }
}

