/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTSignatureUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisiblityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.IProblemRequestor;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.IASTDeclarationAmbiguity;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPVisitor;
import org.eclipse.cdt.internal.core.model.ASTStringUtil;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.Enumeration;
import org.eclipse.cdt.internal.core.model.Enumerator;
import org.eclipse.cdt.internal.core.model.Field;
import org.eclipse.cdt.internal.core.model.FieldInfo;
import org.eclipse.cdt.internal.core.model.Function;
import org.eclipse.cdt.internal.core.model.FunctionDeclaration;
import org.eclipse.cdt.internal.core.model.FunctionInfo;
import org.eclipse.cdt.internal.core.model.FunctionTemplate;
import org.eclipse.cdt.internal.core.model.FunctionTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.IDebugLogConstants;
import org.eclipse.cdt.internal.core.model.Include;
import org.eclipse.cdt.internal.core.model.Macro;
import org.eclipse.cdt.internal.core.model.Method;
import org.eclipse.cdt.internal.core.model.MethodDeclaration;
import org.eclipse.cdt.internal.core.model.MethodInfo;
import org.eclipse.cdt.internal.core.model.MethodTemplate;
import org.eclipse.cdt.internal.core.model.MethodTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.Namespace;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.SourceManipulation;
import org.eclipse.cdt.internal.core.model.SourceManipulationInfo;
import org.eclipse.cdt.internal.core.model.Structure;
import org.eclipse.cdt.internal.core.model.StructureDeclaration;
import org.eclipse.cdt.internal.core.model.StructureTemplate;
import org.eclipse.cdt.internal.core.model.StructureTemplateDeclaration;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.TypeDef;
import org.eclipse.cdt.internal.core.model.Using;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.model.Variable;
import org.eclipse.cdt.internal.core.model.VariableDeclaration;
import org.eclipse.cdt.internal.core.model.VariableTemplate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class CModelBuilder2
implements IContributedModelBuilder {
    private final TranslationUnit fTranslationUnit;
    private String fTranslationUnitFileName;
    private ASTAccessVisibility fCurrentVisibility;
    private Stack fVisibilityStack;
    private IProgressMonitor fProgressMonitor;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.model.CModelBuilder2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public CModelBuilder2(ITranslationUnit tu, IProgressMonitor monitor) {
        this.fTranslationUnit = (TranslationUnit)tu;
        this.fProgressMonitor = monitor;
    }

    /*
     * Exception decompiling
     */
    public void parse(boolean quickParseMode) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 299->303)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isCanceled() {
        return this.fProgressMonitor != null && this.fProgressMonitor.isCanceled();
    }

    private void checkCanceled() {
        if (this.fProgressMonitor != null && this.fProgressMonitor.isCanceled()) {
            Util.debugLog("CModelBuilder2: cancelled ", IDebugLogConstants.MODEL, false);
            throw new OperationCanceledException();
        }
    }

    private void buildModel(IASTTranslationUnit ast) throws CModelException, DOMException {
        this.fTranslationUnitFileName = ast.getFilePath();
        this.fVisibilityStack = new Stack();
        IASTPreprocessorIncludeStatement[] includeDirectives = ast.getIncludeDirectives();
        HashSet allIncludes = new HashSet();
        int i = 0;
        while (i < includeDirectives.length) {
            IASTPreprocessorIncludeStatement includeDirective = includeDirectives[i];
            if (this.isLocalToFile(includeDirective)) {
                this.createInclusion(this.fTranslationUnit, includeDirective, allIncludes);
            }
            ++i;
        }
        IASTPreprocessorMacroDefinition[] macroDefinitions = ast.getMacroDefinitions();
        int i2 = 0;
        while (i2 < macroDefinitions.length) {
            IASTPreprocessorMacroDefinition macroDefinition = macroDefinitions[i2];
            if (this.isLocalToFile(macroDefinition)) {
                this.createMacro(this.fTranslationUnit, macroDefinition);
            }
            ++i2;
        }
        IASTDeclaration[] declarations = ast.getDeclarations();
        int i3 = 0;
        while (i3 < declarations.length) {
            IASTDeclaration declaration = declarations[i3];
            if (this.isLocalToFile(declaration)) {
                this.createDeclaration(this.fTranslationUnit, declaration);
            }
            ++i3;
        }
        List children = this.fTranslationUnit.getElementInfo().internalGetChildren();
        Collections.sort(children, new Comparator(){

            public int compare(Object o1, Object o2) {
                try {
                    SourceManipulationInfo info1 = ((SourceManipulation)o1).getSourceManipulationInfo();
                    SourceManipulationInfo info2 = ((SourceManipulation)o2).getSourceManipulationInfo();
                    int delta = info1.getStartPos() - info2.getStartPos();
                    if (delta == 0) {
                        delta = info1.getIdStartPos() - info2.getIdStartPos();
                    }
                    return delta;
                }
                catch (CModelException cModelException) {
                    return 0;
                }
            }
        });
        if (this.isCanceled()) {
            return;
        }
        IProblemRequestor problemRequestor = this.fTranslationUnit.getProblemRequestor();
        if (problemRequestor != null && problemRequestor.isActive()) {
            IASTProblem problem;
            IASTProblem[] ppProblems;
            problemRequestor.beginReporting();
            IASTProblem[] problems = ppProblems = ast.getPreprocessorProblems();
            int i4 = 0;
            while (i4 < problems.length) {
                problem = problems[i4];
                if (this.isLocalToFile(problem)) {
                    problemRequestor.acceptProblem(new ProblemAdapter(problem));
                }
                ++i4;
            }
            problems = CPPVisitor.getProblems(ast);
            i4 = 0;
            while (i4 < problems.length) {
                problem = problems[i4];
                if (this.isLocalToFile(problem)) {
                    problemRequestor.acceptProblem(new ProblemAdapter(problem));
                }
                ++i4;
            }
            problemRequestor.endReporting();
        }
    }

    private boolean isLocalToFile(IASTNode node) {
        return this.fTranslationUnitFileName.equals(node.getContainingFilename());
    }

    private Include createInclusion(Parent parent, IASTPreprocessorIncludeStatement inclusion, Set allIncludes) throws CModelException {
        IASTName name = inclusion.getName();
        Include element = new Include((ICElement)parent, ASTStringUtil.getSimpleName(name), inclusion.isSystemInclude());
        element.setFullPathName(inclusion.getPath());
        element.setActive(inclusion.isActive());
        element.setResolved(inclusion.isResolved());
        if (!allIncludes.add(element)) {
            element.setIndex(allIncludes.size());
            allIncludes.add(element);
        }
        parent.addChild(element);
        this.setIdentifierPosition(element, (IASTNode)name);
        this.setBodyPosition(element, (IASTNode)inclusion);
        return element;
    }

    private Macro createMacro(Parent parent, IASTPreprocessorMacroDefinition macro) throws CModelException {
        IASTName name = macro.getName();
        Macro element = new Macro(parent, ASTStringUtil.getSimpleName(name));
        parent.addChild(element);
        this.setIdentifierPosition(element, (IASTNode)name);
        this.setBodyPosition(element, (IASTNode)macro);
        return element;
    }

    private void createDeclaration(Parent parent, IASTDeclaration declaration) throws CModelException, DOMException {
        if (declaration instanceof IASTFunctionDefinition) {
            this.createFunctionDefinition(parent, (IASTFunctionDefinition)declaration, false);
        } else if (declaration instanceof IASTSimpleDeclaration) {
            this.createSimpleDeclarations(parent, (IASTSimpleDeclaration)declaration, false);
        } else if (declaration instanceof ICPPASTVisiblityLabel) {
            this.handleVisibilityLabel((ICPPASTVisiblityLabel)declaration);
        } else if (declaration instanceof ICPPASTNamespaceDefinition) {
            this.createNamespace(parent, (ICPPASTNamespaceDefinition)declaration);
        } else if (!(declaration instanceof ICPPASTNamespaceAlias)) {
            if (declaration instanceof ICPPASTTemplateDeclaration) {
                this.createTemplateDeclaration(parent, (ICPPASTTemplateDeclaration)declaration);
            } else if (!(declaration instanceof ICPPASTTemplateSpecialization) && !(declaration instanceof ICPPASTExplicitTemplateInstantiation)) {
                if (declaration instanceof ICPPASTUsingDeclaration) {
                    this.createUsingDeclaration(parent, (ICPPASTUsingDeclaration)declaration);
                } else if (declaration instanceof ICPPASTUsingDirective) {
                    this.createUsingDirective(parent, (ICPPASTUsingDirective)declaration);
                } else if (declaration instanceof ICPPASTLinkageSpecification) {
                    this.createLinkageSpecification(parent, (ICPPASTLinkageSpecification)declaration);
                } else if (!(declaration instanceof IASTASMDeclaration || declaration instanceof IASTProblemDeclaration || declaration instanceof IASTAmbiguousDeclaration || declaration instanceof IASTDeclarationAmbiguity || $assertionsDisabled)) {
                    throw new AssertionError((Object)("TODO: " + declaration.getClass().getName()));
                }
            }
        }
    }

    private void createTemplateDeclaration(Parent parent, ICPPASTTemplateDeclaration templateDeclaration) throws CModelException, DOMException {
        IASTDeclaration declaration = templateDeclaration.getDeclaration();
        if (declaration instanceof IASTFunctionDefinition) {
            FunctionDeclaration element = this.createFunctionDefinition(parent, (IASTFunctionDefinition)declaration, true);
            String[] parameterTypes = ASTStringUtil.getTemplateParameterArray(templateDeclaration.getTemplateParameters());
            if (element instanceof FunctionTemplate) {
                FunctionTemplate functionTemplate = (FunctionTemplate)element;
                functionTemplate.setTemplateParameterTypes(parameterTypes);
            } else if (element instanceof MethodTemplate) {
                MethodTemplate methodTemplate = (MethodTemplate)element;
                methodTemplate.setTemplateParameterTypes(parameterTypes);
            }
            if (element instanceof SourceManipulation) {
                this.setBodyPosition(element, (IASTNode)templateDeclaration);
            }
        } else if (declaration instanceof IASTSimpleDeclaration) {
            CElement[] elements = this.createSimpleDeclarations(parent, (IASTSimpleDeclaration)declaration, true);
            String[] parameterTypes = ASTStringUtil.getTemplateParameterArray(templateDeclaration.getTemplateParameters());
            int i = 0;
            while (i < elements.length) {
                MethodDeclaration methodTemplate;
                FunctionDeclaration functionTemplate;
                StructureDeclaration classTemplate;
                CElement element = elements[i];
                if (element instanceof StructureTemplate) {
                    classTemplate = (StructureTemplate)element;
                    ((StructureTemplate)classTemplate).setTemplateParameterTypes(parameterTypes);
                } else if (element instanceof StructureTemplateDeclaration) {
                    classTemplate = (StructureTemplateDeclaration)element;
                    ((StructureTemplateDeclaration)classTemplate).setTemplateParameterTypes(parameterTypes);
                } else if (element instanceof VariableTemplate) {
                    VariableTemplate varTemplate = (VariableTemplate)element;
                    varTemplate.setTemplateParameterTypes(parameterTypes);
                } else if (element instanceof FunctionTemplateDeclaration) {
                    functionTemplate = (FunctionTemplateDeclaration)element;
                    ((FunctionTemplateDeclaration)functionTemplate).setTemplateParameterTypes(parameterTypes);
                } else if (element instanceof MethodTemplateDeclaration) {
                    methodTemplate = (MethodTemplateDeclaration)element;
                    ((MethodTemplateDeclaration)methodTemplate).setTemplateParameterTypes(parameterTypes);
                } else if (element instanceof FunctionTemplate) {
                    functionTemplate = (FunctionTemplate)element;
                    ((FunctionTemplate)functionTemplate).setTemplateParameterTypes(parameterTypes);
                } else if (element instanceof MethodTemplate) {
                    methodTemplate = (MethodTemplate)element;
                    ((MethodTemplate)methodTemplate).setTemplateParameterTypes(parameterTypes);
                }
                if (element instanceof SourceManipulation) {
                    this.setBodyPosition((SourceManipulation)element, (IASTNode)templateDeclaration);
                }
                ++i;
            }
        } else if (declaration instanceof ICPPASTTemplateDeclaration) {
            this.createTemplateDeclaration(parent, (ICPPASTTemplateDeclaration)declaration);
        } else if (!(declaration instanceof IASTProblemDeclaration) && !$assertionsDisabled) {
            throw new AssertionError((Object)("TODO: " + declaration.getClass().getName()));
        }
    }

    private void createLinkageSpecification(Parent parent, ICPPASTLinkageSpecification linkageDeclaration) throws CModelException, DOMException {
        IASTDeclaration[] declarations = linkageDeclaration.getDeclarations();
        int i = 0;
        while (i < declarations.length) {
            IASTDeclaration declaration = declarations[i];
            if (linkageDeclaration.getFileLocation() != null || this.isLocalToFile(declaration)) {
                this.createDeclaration(parent, declaration);
            }
            ++i;
        }
    }

    private CElement[] createSimpleDeclarations(Parent parent, IASTSimpleDeclaration declaration, boolean isTemplate) throws CModelException, DOMException {
        CElement[] elements;
        boolean isCompositeType;
        IASTDeclSpecifier declSpecifier = declaration.getDeclSpecifier();
        IASTDeclarator[] declarators = declaration.getDeclarators();
        boolean bl = isCompositeType = declSpecifier instanceof IASTCompositeTypeSpecifier || declSpecifier instanceof IASTEnumerationSpecifier;
        if (declarators.length == 0) {
            CElement element = this.createSimpleDeclaration(parent, declSpecifier, null, isTemplate);
            elements = new CElement[]{element};
        } else if (declarators.length == 1 && isCompositeType) {
            elements = new CElement[declarators.length];
            IASTDeclarator declarator = declarators[0];
            CElement element = this.createTypedefOrFunctionOrVariable(parent, declSpecifier, declarator, isTemplate);
            if (element instanceof IParent) {
                parent = (Parent)element;
                if (!isTemplate) {
                    this.setBodyPosition((SourceManipulation)element, declSpecifier.getParent());
                }
            }
            elements[0] = element;
            this.createSimpleDeclaration(parent, declSpecifier, null, isTemplate);
        } else {
            if (isCompositeType) {
                this.createSimpleDeclaration(parent, declSpecifier, null, isTemplate);
            }
            elements = new CElement[declarators.length];
            int i = 0;
            while (i < declarators.length) {
                IASTDeclarator declarator = declarators[i];
                CElement element = this.createSimpleDeclaration(parent, declSpecifier, declarator, isTemplate);
                if (!isTemplate && element instanceof SourceManipulation) {
                    this.setBodyPosition((SourceManipulation)element, (IASTNode)declarator);
                }
                elements[i] = element;
                ++i;
            }
        }
        return elements;
    }

    private CElement createSimpleDeclaration(Parent parent, IASTDeclSpecifier declSpecifier, IASTDeclarator declarator, boolean isTemplate) throws CModelException, DOMException {
        if (declSpecifier instanceof IASTCompositeTypeSpecifier) {
            if (declarator != null) {
                return this.createTypedefOrFunctionOrVariable(parent, declSpecifier, declarator, isTemplate);
            }
            return this.createCompositeType(parent, (IASTCompositeTypeSpecifier)declSpecifier, isTemplate);
        }
        if (declSpecifier instanceof IASTElaboratedTypeSpecifier) {
            if (declarator != null) {
                return this.createTypedefOrFunctionOrVariable(parent, declSpecifier, declarator, isTemplate);
            }
            return this.createElaboratedTypeDeclaration(parent, (IASTElaboratedTypeSpecifier)declSpecifier, isTemplate);
        }
        if (declSpecifier instanceof IASTEnumerationSpecifier) {
            if (declarator != null) {
                return this.createTypedefOrFunctionOrVariable(parent, declSpecifier, declarator, isTemplate);
            }
            return this.createEnumeration(parent, (IASTEnumerationSpecifier)declSpecifier);
        }
        if (declSpecifier instanceof IASTNamedTypeSpecifier) {
            if (declarator != null) {
                return this.createTypedefOrFunctionOrVariable(parent, declSpecifier, declarator, isTemplate);
            }
        } else if (declSpecifier instanceof IASTSimpleDeclSpecifier) {
            if (declarator != null) {
                return this.createTypedefOrFunctionOrVariable(parent, declSpecifier, declarator, isTemplate);
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError((Object)("TODO: " + declSpecifier.getClass().getName()));
        }
        return null;
    }

    private CElement createTypedefOrFunctionOrVariable(Parent parent, IASTDeclSpecifier declSpecifier, IASTDeclarator declarator, boolean isTemplate) throws CModelException {
        if (!$assertionsDisabled && declarator == null) {
            throw new AssertionError();
        }
        if (declSpecifier.getStorageClass() == 1) {
            return this.createTypeDef(parent, declSpecifier, declarator);
        }
        if (declarator instanceof IASTFunctionDeclarator && !this.hasNestedPointerOperators(declarator)) {
            return this.createFunctionDeclaration(parent, declSpecifier, (IASTFunctionDeclarator)declarator, isTemplate);
        }
        return this.createVariable(parent, declSpecifier, declarator, isTemplate);
    }

    private boolean hasNestedPointerOperators(IASTDeclarator declarator) {
        declarator = declarator.getNestedDeclarator();
        while (declarator != null) {
            if (declarator.getPointerOperators().length > 0) {
                return true;
            }
            declarator = declarator.getNestedDeclarator();
        }
        return false;
    }

    private void createNamespace(Parent parent, ICPPASTNamespaceDefinition declaration) throws CModelException, DOMException {
        IASTName name = declaration.getName();
        String nsName = ASTStringUtil.getQualifiedName(name);
        Namespace element = new Namespace(parent, nsName);
        parent.addChild(element);
        if (name != null && nsName.length() > 0) {
            this.setIdentifierPosition(element, (IASTNode)name);
        } else {
            IASTFileLocation nsLocation = CModelBuilder2.getMinFileLocation(declaration.getNodeLocations());
            if (nsLocation != null) {
                element.setIdPos(nsLocation.getNodeOffset(), "namespace".length());
            }
        }
        this.setBodyPosition(element, (IASTNode)declaration);
        element.setTypeName("namespace");
        IASTDeclaration[] nsDeclarations = declaration.getDeclarations();
        int i = 0;
        while (i < nsDeclarations.length) {
            IASTDeclaration nsDeclaration = nsDeclarations[i];
            if (declaration.getFileLocation() != null || this.isLocalToFile(nsDeclaration)) {
                this.createDeclaration(element, nsDeclaration);
            }
            ++i;
        }
    }

    private StructureDeclaration createElaboratedTypeDeclaration(Parent parent, IASTElaboratedTypeSpecifier elaboratedTypeSpecifier, boolean isTemplate) throws CModelException {
        String type;
        int kind;
        switch (elaboratedTypeSpecifier.getKind()) {
            case 1: {
                kind = isTemplate ? 84 : 66;
                type = "struct";
                break;
            }
            case 2: {
                kind = isTemplate ? 86 : 68;
                type = "union";
                break;
            }
            case 3: {
                kind = isTemplate ? 82 : 64;
                type = "class";
                break;
            }
            case 0: {
                kind = 64;
                type = "enum";
                break;
            }
            default: {
                kind = 64;
                type = "";
            }
        }
        IASTName astClassName = elaboratedTypeSpecifier.getName();
        String className = ASTStringUtil.getSimpleName(astClassName);
        StructureDeclaration element = isTemplate ? new StructureTemplateDeclaration((ICElement)parent, kind, className) : new StructureDeclaration(parent, className, kind);
        element.setTypeName(type);
        parent.addChild(element);
        if (className.length() > 0) {
            this.setIdentifierPosition(element, (IASTNode)astClassName);
        } else {
            IASTFileLocation classLocation = CModelBuilder2.getMinFileLocation(elaboratedTypeSpecifier.getNodeLocations());
            if (classLocation != null) {
                element.setIdPos(classLocation.getNodeOffset(), type.length());
            }
        }
        this.setBodyPosition(element, (IASTNode)elaboratedTypeSpecifier);
        return element;
    }

    private Enumeration createEnumeration(Parent parent, IASTEnumerationSpecifier enumSpecifier) throws CModelException {
        IASTName astEnumName = enumSpecifier.getName();
        String enumName = ASTStringUtil.getSimpleName(astEnumName);
        Enumeration element = new Enumeration(parent, enumName);
        parent.addChild(element);
        IASTEnumerationSpecifier.IASTEnumerator[] enumerators = enumSpecifier.getEnumerators();
        int i = 0;
        while (i < enumerators.length) {
            IASTEnumerationSpecifier.IASTEnumerator enumerator = enumerators[i];
            this.createEnumerator(element, enumerator);
            ++i;
        }
        if (astEnumName != null && enumName.length() > 0) {
            this.setIdentifierPosition(element, (IASTNode)astEnumName);
        } else {
            IASTFileLocation enumLocation = enumSpecifier.getFileLocation();
            element.setIdPos(enumLocation.getNodeOffset(), "enum".length());
        }
        this.setBodyPosition(element, (IASTNode)enumSpecifier);
        element.setTypeName("enum");
        return element;
    }

    private Enumerator createEnumerator(Parent enumarator, IASTEnumerationSpecifier.IASTEnumerator enumDef) throws CModelException {
        IASTName astEnumName = enumDef.getName();
        Enumerator element = new Enumerator(enumarator, ASTStringUtil.getSimpleName(astEnumName));
        IASTExpression initialValue = enumDef.getValue();
        if (initialValue != null) {
            element.setConstantExpression(ASTSignatureUtil.getExpressionString(initialValue));
        }
        enumarator.addChild(element);
        this.setIdentifierPosition(element, (IASTNode)astEnumName);
        this.setBodyPosition(element, (IASTNode)enumDef);
        return element;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Structure createCompositeType(Parent parent, IASTCompositeTypeSpecifier compositeTypeSpecifier, boolean isTemplate) throws CModelException, DOMException {
        Object var13_17;
        Structure element;
        ASTAccessVisibility defaultVisibility;
        String type;
        int kind;
        switch (compositeTypeSpecifier.getKey()) {
            case 1: {
                kind = isTemplate ? 85 : 67;
                type = "struct";
                defaultVisibility = ASTAccessVisibility.PUBLIC;
                break;
            }
            case 2: {
                kind = isTemplate ? 87 : 69;
                type = "union";
                defaultVisibility = ASTAccessVisibility.PUBLIC;
                break;
            }
            case 3: {
                kind = isTemplate ? 83 : 65;
                type = "class";
                defaultVisibility = ASTAccessVisibility.PRIVATE;
                break;
            }
            default: {
                kind = 65;
                type = "";
                defaultVisibility = ASTAccessVisibility.PUBLIC;
            }
        }
        IASTName astClassName = compositeTypeSpecifier.getName();
        String className = ASTStringUtil.getSimpleName(astClassName);
        if (!isTemplate) {
            Structure classElement;
            element = classElement = new Structure((ICElement)parent, kind, className);
        } else {
            StructureTemplate classTemplate = new StructureTemplate((ICElement)parent, kind, className);
            element = classTemplate;
        }
        if (compositeTypeSpecifier instanceof ICPPASTCompositeTypeSpecifier) {
            ICPPASTCompositeTypeSpecifier cppCompositeTypeSpecifier = (ICPPASTCompositeTypeSpecifier)compositeTypeSpecifier;
            ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] baseSpecifiers = cppCompositeTypeSpecifier.getBaseSpecifiers();
            int i = 0;
            while (i < baseSpecifiers.length) {
                ASTAccessVisibility visibility;
                ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier baseSpecifier = baseSpecifiers[i];
                IASTName baseName = baseSpecifier.getName();
                switch (baseSpecifier.getVisibility()) {
                    case 1: {
                        visibility = ASTAccessVisibility.PUBLIC;
                        break;
                    }
                    case 2: {
                        visibility = ASTAccessVisibility.PROTECTED;
                        break;
                    }
                    case 3: {
                        visibility = ASTAccessVisibility.PRIVATE;
                        break;
                    }
                    default: {
                        visibility = ASTAccessVisibility.PUBLIC;
                    }
                }
                element.addSuperClass(ASTStringUtil.getSimpleName(baseName), visibility);
                ++i;
            }
        }
        element.setTypeName(type);
        parent.addChild(element);
        if (!isTemplate) {
            this.setBodyPosition(element, (IASTNode)compositeTypeSpecifier);
        }
        if (className.length() > 0) {
            this.setIdentifierPosition(element, (IASTNode)astClassName);
        } else {
            IASTFileLocation classLocation = CModelBuilder2.getMinFileLocation(compositeTypeSpecifier.getNodeLocations());
            if (classLocation != null) {
                if (compositeTypeSpecifier.getStorageClass() == 1) {
                    int delta = "typedef".length() + 1;
                    element.setIdPos(classLocation.getNodeOffset() + delta, type.length());
                    if (!isTemplate) {
                        SourceManipulationInfo info = element.getSourceManipulationInfo();
                        info.setPos(info.getStartPos() + delta, info.getLength() - delta);
                    }
                } else {
                    element.setIdPos(classLocation.getNodeOffset(), type.length());
                }
            }
        }
        this.pushDefaultVisibility(defaultVisibility);
        try {
            IASTDeclaration[] memberDeclarations = compositeTypeSpecifier.getMembers();
            int i = 0;
            while (i < memberDeclarations.length) {
                IASTDeclaration member = memberDeclarations[i];
                if (compositeTypeSpecifier.getFileLocation() != null || this.isLocalToFile(member)) {
                    this.createDeclaration(element, member);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            var13_17 = null;
            this.popDefaultVisibility();
            throw throwable;
        }
        {
            var13_17 = null;
            this.popDefaultVisibility();
            return element;
        }
    }

    private TypeDef createTypeDef(Parent parent, IASTDeclSpecifier declSpecifier, IASTDeclarator declarator) throws CModelException {
        IASTDeclarator nestedDeclarator = declarator;
        while (nestedDeclarator.getNestedDeclarator() != null) {
            nestedDeclarator = nestedDeclarator.getNestedDeclarator();
        }
        IASTName astTypedefName = nestedDeclarator.getName();
        if (astTypedefName == null) {
            return null;
        }
        String name = ASTStringUtil.getSimpleName(astTypedefName);
        TypeDef element = new TypeDef(parent, name);
        String typeName = ASTStringUtil.getSignatureString(declSpecifier, declarator);
        element.setTypeName(typeName);
        parent.addChild(element);
        SourceManipulationInfo info = element.getSourceManipulationInfo();
        if (name.length() > 0) {
            this.setIdentifierPosition(info, (IASTNode)astTypedefName);
        } else {
            this.setIdentifierPosition(info, (IASTNode)declSpecifier);
        }
        if (declSpecifier instanceof IASTCompositeTypeSpecifier) {
            this.setBodyPosition(info, (IASTNode)astTypedefName);
        } else {
            this.setBodyPosition(info, declSpecifier.getParent());
        }
        return element;
    }

    private VariableDeclaration createVariable(Parent parent, IASTDeclSpecifier specifier, IASTDeclarator declarator, boolean isTemplate) throws CModelException {
        SourceManipulationInfo info;
        VariableDeclaration element;
        IASTDeclarator nestedDeclarator = declarator;
        while (nestedDeclarator.getNestedDeclarator() != null) {
            nestedDeclarator = nestedDeclarator.getNestedDeclarator();
        }
        IASTName astVariableName = nestedDeclarator.getName();
        if (astVariableName == null) {
            return null;
        }
        String variableName = ASTStringUtil.getQualifiedName(astVariableName);
        if (declarator instanceof IASTFieldDeclarator || parent instanceof IStructure || CModelBuilder2.getScope(astVariableName) instanceof ICPPClassScope) {
            Field newElement = new Field(parent, variableName);
            if (specifier instanceof ICPPASTDeclSpecifier) {
                ICPPASTDeclSpecifier cppSpecifier = (ICPPASTDeclSpecifier)specifier;
                newElement.setMutable(cppSpecifier.getStorageClass() == 6);
            }
            newElement.setTypeName(ASTStringUtil.getSignatureString(specifier, declarator));
            FieldInfo fieldInfo = (FieldInfo)newElement.getElementInfo();
            fieldInfo.setVisibility(this.getCurrentVisibility());
            element = newElement;
            info = fieldInfo;
        } else {
            if (isTemplate) {
                VariableTemplate newElement = new VariableTemplate(parent, variableName);
                element = newElement;
            } else if (specifier.getStorageClass() == 2) {
                VariableDeclaration newElement;
                element = newElement = new VariableDeclaration(parent, variableName);
            } else {
                Variable newElement = new Variable(parent, variableName);
                element = newElement;
            }
            element.setTypeName(ASTStringUtil.getSignatureString(specifier, declarator));
            info = element.getSourceManipulationInfo();
        }
        element.setConst(specifier.isConst());
        element.setVolatile(specifier.isVolatile());
        element.setStatic(specifier.getStorageClass() == 3);
        parent.addChild(element);
        this.setIdentifierPosition(info, (IASTNode)astVariableName);
        if (!isTemplate) {
            if (specifier instanceof IASTCompositeTypeSpecifier) {
                this.setBodyPosition(info, (IASTNode)astVariableName);
            } else {
                this.setBodyPosition(info, specifier.getParent());
            }
        }
        return element;
    }

    private FunctionDeclaration createFunctionDefinition(Parent parent, IASTFunctionDefinition functionDeclaration, boolean isTemplate) throws CModelException, DOMException {
        FunctionInfo info;
        FunctionDeclaration element;
        IASTFunctionDeclarator declarator;
        IASTDeclarator nestedDeclarator = declarator = functionDeclaration.getDeclarator();
        while (nestedDeclarator.getNestedDeclarator() != null) {
            nestedDeclarator = nestedDeclarator.getNestedDeclarator();
        }
        IASTName name = nestedDeclarator.getName();
        if (name == null) {
            return null;
        }
        IASTDeclSpecifier declSpecifier = functionDeclaration.getDeclSpecifier();
        String functionName = ASTStringUtil.getSimpleName(name);
        String[] parameterTypes = ASTStringUtil.getParameterSignatureArray(declarator);
        String returnType = ASTStringUtil.getTypeString(declSpecifier, declarator);
        if (declarator instanceof ICPPASTFunctionDeclarator) {
            IASTName simpleName;
            ICPPASTFunctionDeclarator cppFunctionDeclarator = (ICPPASTFunctionDeclarator)declarator;
            if (name instanceof ICPPASTQualifiedName) {
                ICPPASTQualifiedName quName = (ICPPASTQualifiedName)name;
                simpleName = quName.getLastName();
            } else {
                simpleName = name;
            }
            IScope scope = null;
            boolean isMethod = parent instanceof IStructure;
            if (!isMethod && name instanceof ICPPASTQualifiedName) {
                IASTName[] names = ((ICPPASTQualifiedName)name).getNames();
                if (isTemplate) {
                    int i = 0;
                    while (i < names.length) {
                        if (names[i] instanceof ICPPASTTemplateId) {
                            isMethod = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (!isMethod) {
                    scope = CPPVisitor.getContainingScope(simpleName);
                    isMethod = scope instanceof ICPPClassScope;
                }
            }
            if (isMethod) {
                IBinding binding;
                Method methodElement = isTemplate ? new MethodTemplate(parent, ASTStringUtil.getQualifiedName(name)) : new Method(parent, ASTStringUtil.getQualifiedName(name));
                element = methodElement;
                methodElement.setParameterTypes(parameterTypes);
                methodElement.setReturnType(returnType);
                methodElement.setConst(cppFunctionDeclarator.isConst());
                MethodInfo methodInfo = methodElement.getMethodInfo();
                info = methodInfo;
                ICPPMethod methodBinding = null;
                if (scope != null && (binding = simpleName.resolveBinding()) instanceof ICPPMethod) {
                    methodBinding = (ICPPMethod)binding;
                }
                if (methodBinding != null) {
                    methodInfo.setVirtual(methodBinding.isVirtual());
                    methodInfo.setInline(methodBinding.isInline());
                    methodInfo.setFriend(((ICPPASTDeclSpecifier)declSpecifier).isFriend());
                    methodInfo.setVolatile(cppFunctionDeclarator.isVolatile());
                    methodInfo.setVisibility(this.adaptVisibilityConstant(methodBinding.getVisibility()));
                    methodInfo.setPureVirtual(false);
                    methodElement.setConstructor(methodBinding instanceof ICPPConstructor);
                    methodElement.setDestructor(methodBinding.isDestructor());
                } else {
                    if (declSpecifier instanceof ICPPASTDeclSpecifier) {
                        ICPPASTDeclSpecifier cppDeclSpecifier = (ICPPASTDeclSpecifier)declSpecifier;
                        methodInfo.setVirtual(cppDeclSpecifier.isVirtual());
                        methodInfo.setInline(cppDeclSpecifier.isInline());
                        methodInfo.setFriend(cppDeclSpecifier.isFriend());
                    }
                    methodInfo.setVolatile(cppFunctionDeclarator.isVolatile());
                    methodInfo.setVisibility(this.getCurrentVisibility());
                    methodInfo.setPureVirtual(false);
                    boolean isConstructor = scope != null ? CPPVisitor.isConstructor(scope, (IASTDeclarator)declarator) : parent.getElementName().equals(functionName);
                    methodElement.setConstructor(isConstructor);
                    methodElement.setDestructor(functionName.charAt(0) == '~');
                }
            } else {
                element = isTemplate ? new FunctionTemplate(parent, ASTStringUtil.getQualifiedName(name)) : new Function(parent, ASTStringUtil.getQualifiedName(name));
                element.setParameterTypes(parameterTypes);
                element.setReturnType(returnType);
                info = element.getFunctionInfo();
                info.setConst(cppFunctionDeclarator.isConst());
            }
        } else {
            element = new Function(parent, functionName);
            element.setParameterTypes(parameterTypes);
            element.setReturnType(returnType);
            info = element.getFunctionInfo();
        }
        info.setStatic(declSpecifier.getStorageClass() == 3);
        parent.addChild(element);
        this.setIdentifierPosition(info, (IASTNode)name);
        if (!isTemplate) {
            this.setBodyPosition(info, (IASTNode)functionDeclaration);
        }
        return element;
    }

    private FunctionDeclaration createFunctionDeclaration(Parent parent, IASTDeclSpecifier declSpecifier, IASTFunctionDeclarator declarator, boolean isTemplate) throws CModelException {
        FunctionInfo info;
        FunctionDeclaration element;
        IASTDeclarator nestedDeclarator = declarator;
        while (nestedDeclarator.getNestedDeclarator() != null) {
            nestedDeclarator = nestedDeclarator.getNestedDeclarator();
        }
        IASTName name = nestedDeclarator.getName();
        if (name == null) {
            return null;
        }
        String functionName = ASTStringUtil.getSimpleName(name);
        String[] parameterTypes = ASTStringUtil.getParameterSignatureArray(declarator);
        String returnType = ASTStringUtil.getTypeString(declSpecifier, declarator);
        if (declarator instanceof ICPPASTFunctionDeclarator) {
            ICPPASTFunctionDeclarator cppFunctionDeclarator = (ICPPASTFunctionDeclarator)declarator;
            if (parent instanceof IStructure) {
                MethodDeclaration methodElement = isTemplate ? new MethodTemplateDeclaration(parent, functionName) : new MethodDeclaration(parent, functionName);
                element = methodElement;
                methodElement.setParameterTypes(parameterTypes);
                methodElement.setReturnType(returnType);
                methodElement.setConst(cppFunctionDeclarator.isConst());
                MethodInfo methodInfo = methodElement.getMethodInfo();
                info = methodInfo;
                if (declSpecifier instanceof ICPPASTDeclSpecifier) {
                    ICPPASTDeclSpecifier cppDeclSpecifier = (ICPPASTDeclSpecifier)declSpecifier;
                    methodInfo.setVirtual(cppDeclSpecifier.isVirtual());
                    methodInfo.setInline(cppDeclSpecifier.isInline());
                    methodInfo.setFriend(cppDeclSpecifier.isFriend());
                }
                methodInfo.setVolatile(cppFunctionDeclarator.isVolatile());
                methodInfo.setVisibility(this.getCurrentVisibility());
                methodInfo.setPureVirtual(cppFunctionDeclarator.isPureVirtual());
                methodElement.setConstructor(functionName.equals(parent.getElementName()));
                methodElement.setDestructor(functionName.charAt(0) == '~');
            } else {
                element = isTemplate ? new FunctionTemplateDeclaration(parent, functionName) : new FunctionDeclaration(parent, functionName);
                element.setParameterTypes(parameterTypes);
                element.setReturnType(returnType);
                info = (FunctionInfo)element.getElementInfo();
                info.setConst(cppFunctionDeclarator.isConst());
            }
        } else if (declarator instanceof IASTStandardFunctionDeclarator) {
            element = isTemplate ? new FunctionTemplateDeclaration(parent, functionName) : new FunctionDeclaration(parent, functionName);
            element.setParameterTypes(parameterTypes);
            element.setReturnType(returnType);
            info = (FunctionInfo)element.getElementInfo();
        } else {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
        info.setStatic(declSpecifier.getStorageClass() == 3);
        parent.addChild(element);
        this.setIdentifierPosition(info, (IASTNode)name);
        if (!isTemplate) {
            this.setBodyPosition(info, (IASTNode)declarator);
        }
        return element;
    }

    private Using createUsingDirective(Parent parent, ICPPASTUsingDirective usingDirDeclaration) throws CModelException {
        IASTName name = usingDirDeclaration.getQualifiedName();
        Using element = new Using((ICElement)parent, ASTStringUtil.getQualifiedName(name), true);
        parent.addChild(element);
        this.setIdentifierPosition(element, (IASTNode)name);
        this.setBodyPosition(element, (IASTNode)usingDirDeclaration);
        return element;
    }

    private Using createUsingDeclaration(Parent parent, ICPPASTUsingDeclaration usingDeclaration) throws CModelException {
        IASTName name = usingDeclaration.getName();
        Using element = new Using((ICElement)parent, ASTStringUtil.getSimpleName(name), false);
        parent.addChild(element);
        this.setIdentifierPosition(element, (IASTNode)name);
        this.setBodyPosition(element, (IASTNode)usingDeclaration);
        return element;
    }

    private void setBodyPosition(SourceManipulation element, IASTNode astNode) throws CModelException {
        this.setBodyPosition(element.getSourceManipulationInfo(), astNode);
    }

    private void setBodyPosition(SourceManipulationInfo info, IASTNode astNode) {
        IASTFileLocation location = astNode.getFileLocation();
        if (location != null) {
            info.setPos(location.getNodeOffset(), location.getNodeLength());
            info.setLines(location.getStartingLineNumber(), location.getEndingLineNumber());
        } else {
            IASTFileLocation maxLocation;
            IASTNodeLocation[] locations = astNode.getNodeLocations();
            IASTFileLocation minLocation = CModelBuilder2.getMinFileLocation(locations);
            if (minLocation != null && (maxLocation = CModelBuilder2.getMaxFileLocation(locations)) != null) {
                int startOffset = minLocation.getNodeOffset();
                int endOffset = maxLocation.getNodeOffset() + maxLocation.getNodeLength();
                info.setPos(startOffset, endOffset - startOffset);
                int startLine = minLocation.getStartingLineNumber();
                int endLine = maxLocation.getEndingLineNumber();
                info.setLines(startLine, endLine);
            }
        }
    }

    private void setIdentifierPosition(SourceManipulation element, IASTNode astName) throws CModelException {
        this.setIdentifierPosition(element.getSourceManipulationInfo(), astName);
    }

    private void setIdentifierPosition(SourceManipulationInfo info, IASTNode astName) {
        IASTFileLocation location = astName.getFileLocation();
        if (location != null) {
            if (!$assertionsDisabled && !this.fTranslationUnitFileName.equals(location.getFileName())) {
                throw new AssertionError();
            }
            info.setIdPos(location.getNodeOffset(), location.getNodeLength());
        } else {
            IASTFileLocation maxLocation;
            IASTNodeLocation[] locations = astName.getNodeLocations();
            IASTFileLocation minLocation = CModelBuilder2.getMinFileLocation(locations);
            if (minLocation != null && (maxLocation = CModelBuilder2.getMaxFileLocation(locations)) != null) {
                int startOffset = minLocation.getNodeOffset();
                int endOffset = maxLocation.getNodeOffset() + maxLocation.getNodeLength();
                info.setIdPos(startOffset, endOffset - startOffset);
            }
        }
    }

    private static IASTFileLocation getMaxFileLocation(IASTNodeLocation[] locations) {
        if (locations == null || locations.length == 0) {
            return null;
        }
        IASTNodeLocation nodeLocation = locations[locations.length - 1];
        if (nodeLocation instanceof IASTFileLocation) {
            return (IASTFileLocation)nodeLocation;
        }
        if (nodeLocation instanceof IASTMacroExpansion) {
            IASTNodeLocation[] macroLocations = ((IASTMacroExpansion)nodeLocation).getExpansionLocations();
            return CModelBuilder2.getMaxFileLocation(macroLocations);
        }
        return null;
    }

    private static IASTFileLocation getMinFileLocation(IASTNodeLocation[] locations) {
        if (locations == null || locations.length == 0) {
            return null;
        }
        IASTNodeLocation nodeLocation = locations[0];
        if (nodeLocation instanceof IASTFileLocation) {
            return (IASTFileLocation)nodeLocation;
        }
        if (nodeLocation instanceof IASTMacroExpansion) {
            IASTNodeLocation[] macroLocations = ((IASTMacroExpansion)nodeLocation).getExpansionLocations();
            return CModelBuilder2.getMinFileLocation(macroLocations);
        }
        return null;
    }

    private void handleVisibilityLabel(ICPPASTVisiblityLabel visibilityLabel) {
        this.setCurrentVisibility(this.adaptVisibilityConstant(visibilityLabel.getVisibility()));
    }

    private ASTAccessVisibility adaptVisibilityConstant(int visibility) {
        switch (visibility) {
            case 1: {
                return ASTAccessVisibility.PUBLIC;
            }
            case 2: {
                return ASTAccessVisibility.PROTECTED;
            }
            case 3: {
                return ASTAccessVisibility.PRIVATE;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Unknown visibility");
        }
        return ASTAccessVisibility.PUBLIC;
    }

    private void setCurrentVisibility(ASTAccessVisibility visibility) {
        this.fCurrentVisibility = visibility;
    }

    private ASTAccessVisibility getCurrentVisibility() {
        if (this.fCurrentVisibility == null) {
            return ASTAccessVisibility.PUBLIC;
        }
        return this.fCurrentVisibility;
    }

    private void popDefaultVisibility() {
        if (!this.fVisibilityStack.isEmpty()) {
            this.setCurrentVisibility((ASTAccessVisibility)this.fVisibilityStack.pop());
        }
    }

    private void pushDefaultVisibility(ASTAccessVisibility visibility) {
        this.fVisibilityStack.push(this.getCurrentVisibility());
        this.setCurrentVisibility(visibility);
    }

    private static IScope getScope(IASTName astName) {
        IBinding binding = astName.getBinding();
        if (binding != null) {
            try {
                return binding.getScope();
            }
            catch (DOMException dOMException) {
                return null;
            }
        }
        return null;
    }

    private static class ProblemAdapter
    implements IProblem {
        private IASTProblem fASTProblem;

        public ProblemAdapter(IASTProblem problem) {
            this.fASTProblem = problem;
        }

        public boolean checkCategory(int bitmask) {
            return this.fASTProblem.checkCategory(bitmask);
        }

        public String getArguments() {
            return this.fASTProblem.getArguments();
        }

        public int getID() {
            return this.fASTProblem.getID();
        }

        public String getMessage() {
            return this.fASTProblem.getMessage();
        }

        public char[] getOriginatingFileName() {
            return this.fASTProblem.getContainingFilename().toCharArray();
        }

        public int getSourceEnd() {
            IASTFileLocation location = this.fASTProblem.getFileLocation();
            if (location != null) {
                return location.getNodeOffset() + location.getNodeLength() - 1;
            }
            return -1;
        }

        public int getSourceLineNumber() {
            IASTFileLocation location = this.fASTProblem.getFileLocation();
            if (location != null) {
                return location.getStartingLineNumber();
            }
            return -1;
        }

        public int getSourceStart() {
            IASTFileLocation location = this.fASTProblem.getFileLocation();
            if (location != null) {
                return location.getNodeOffset();
            }
            return -1;
        }

        public boolean isError() {
            return this.fASTProblem.isError();
        }

        public boolean isWarning() {
            return this.fASTProblem.isWarning();
        }
    }
}

