/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.cdt.internal.core.pdom.db.DBStatus;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;

final class Chunk {
    private final byte[] fBuffer = new byte[4096];
    final Database fDatabase;
    final int fSequenceNumber;
    boolean fCacheHitFlag = false;
    boolean fDirty = false;
    boolean fLocked = false;
    int fCacheIndex = -1;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.db.Chunk");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    Chunk(Database db, int sequenceNumber) {
        this.fDatabase = db;
        this.fSequenceNumber = sequenceNumber;
    }

    void read() throws CoreException {
        try {
            ByteBuffer buf = ByteBuffer.wrap(this.fBuffer);
            this.fDatabase.read(buf, this.fSequenceNumber * 4096);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    void flush() throws CoreException {
        try {
            ByteBuffer buf = ByteBuffer.wrap(this.fBuffer);
            this.fDatabase.write(buf, this.fSequenceNumber * 4096);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
        this.fDirty = false;
    }

    public void putByte(int offset, byte value) {
        if (!$assertionsDisabled && !this.fLocked) {
            throw new AssertionError();
        }
        this.fDirty = true;
        this.fBuffer[offset % 4096] = value;
    }

    public byte getByte(int offset) {
        return this.fBuffer[offset % 4096];
    }

    public byte[] getBytes(int offset, int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(this.fBuffer, offset % 4096, bytes, 0, length);
        return bytes;
    }

    public void putBytes(int offset, byte[] bytes) {
        if (!$assertionsDisabled && !this.fLocked) {
            throw new AssertionError();
        }
        this.fDirty = true;
        System.arraycopy(bytes, 0, this.fBuffer, offset % 4096, bytes.length);
    }

    public void putInt(int offset, int value) {
        if (!$assertionsDisabled && !this.fLocked) {
            throw new AssertionError();
        }
        this.fDirty = true;
        int idx = offset % 4096;
        this.fBuffer[idx] = (byte)(value >> 24);
        this.fBuffer[++idx] = (byte)(value >> 16);
        this.fBuffer[++idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
    }

    public int getInt(int offset) {
        int idx = offset % 4096;
        return (this.fBuffer[idx] & 0xFF) << 24 | (this.fBuffer[++idx] & 0xFF) << 16 | (this.fBuffer[++idx] & 0xFF) << 8 | (this.fBuffer[++idx] & 0xFF) << 0;
    }

    public void putShort(int offset, short value) {
        if (!$assertionsDisabled && !this.fLocked) {
            throw new AssertionError();
        }
        this.fDirty = true;
        int idx = offset % 4096;
        this.fBuffer[idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
    }

    public short getShort(int offset) {
        int idx = offset % 4096;
        return (short)(this.fBuffer[idx] << 8 | this.fBuffer[++idx] & 0xFF);
    }

    public long getLong(int offset) {
        int idx = offset % 4096;
        return ((long)this.fBuffer[idx] & 0xFFL) << 56 | ((long)this.fBuffer[++idx] & 0xFFL) << 48 | ((long)this.fBuffer[++idx] & 0xFFL) << 40 | ((long)this.fBuffer[++idx] & 0xFFL) << 32 | ((long)this.fBuffer[++idx] & 0xFFL) << 24 | ((long)this.fBuffer[++idx] & 0xFFL) << 16 | ((long)this.fBuffer[++idx] & 0xFFL) << 8 | ((long)this.fBuffer[++idx] & 0xFFL) << 0;
    }

    public void putLong(int offset, long value) {
        if (!$assertionsDisabled && !this.fLocked) {
            throw new AssertionError();
        }
        this.fDirty = true;
        int idx = offset % 4096;
        this.fBuffer[idx] = (byte)(value >> 56);
        this.fBuffer[++idx] = (byte)(value >> 48);
        this.fBuffer[++idx] = (byte)(value >> 40);
        this.fBuffer[++idx] = (byte)(value >> 32);
        this.fBuffer[++idx] = (byte)(value >> 24);
        this.fBuffer[++idx] = (byte)(value >> 16);
        this.fBuffer[++idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
    }

    public void putChar(int offset, char value) {
        if (!$assertionsDisabled && !this.fLocked) {
            throw new AssertionError();
        }
        this.fDirty = true;
        int idx = offset % 4096;
        this.fBuffer[idx] = (byte)(value >> 8);
        this.fBuffer[++idx] = (byte)value;
    }

    public char getChar(int offset) {
        int idx = offset % 4096;
        return (char)(this.fBuffer[idx] << 8 | this.fBuffer[++idx] & 0xFF);
    }

    public void getCharArray(int offset, char[] result) {
        ByteBuffer buf = ByteBuffer.wrap(this.fBuffer);
        buf.position(offset % 4096);
        buf.asCharBuffer().get(result);
    }

    void clear(int offset, int length) {
        if (!$assertionsDisabled && !this.fLocked) {
            throw new AssertionError();
        }
        this.fDirty = true;
        int idx = offset % 4096;
        int end = idx + length;
        while (idx < end) {
            this.fBuffer[idx] = 0;
            ++idx;
        }
    }
}

