/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.ChunkCache;
import org.eclipse.cdt.internal.core.pdom.db.DBStatus;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.db.LongString;
import org.eclipse.cdt.internal.core.pdom.db.ShortString;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Database {
    private final File fLocation;
    private final boolean fReadOnly;
    private RandomAccessFile fFile;
    private boolean fExclusiveLock = false;
    private boolean fLocked;
    private boolean fIsMarkedIncomplete = false;
    private int fVersion;
    private final Chunk fHeaderChunk;
    private Chunk[] fChunks;
    private ChunkCache fCache;
    private long malloced;
    private long freed;
    private long cacheHits;
    private long cacheMisses;
    public static final int VERSION_OFFSET = 0;
    public static final int CHUNK_SIZE = 4096;
    public static final int MIN_SIZE = 16;
    public static final int INT_SIZE = 4;
    public static final int CHAR_SIZE = 2;
    public static final int PREV_OFFSET = 4;
    public static final int NEXT_OFFSET = 8;
    public static final int DATA_AREA = 1028;
    public static final int MAX_SIZE = 4092;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.db.Database");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Database(File location, ChunkCache cache, int version, boolean openReadOnly) throws CoreException {
        try {
            this.fLocation = location;
            this.fReadOnly = openReadOnly;
            this.fCache = cache;
            this.openFile();
            int nChunksOnDisk = (int)(this.fFile.length() / 4096L);
            this.fHeaderChunk = new Chunk(this, 0);
            this.fHeaderChunk.fLocked = true;
            if (nChunksOnDisk <= 0) {
                this.fVersion = version;
                this.fChunks = new Chunk[1];
            } else {
                this.fHeaderChunk.read();
                this.fVersion = this.fHeaderChunk.getInt(0);
                this.fChunks = new Chunk[nChunksOnDisk];
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    private void openFile() throws FileNotFoundException {
        this.fFile = new RandomAccessFile(this.fLocation, this.fReadOnly ? "r" : "rw");
    }

    void read(ByteBuffer buf, int i) throws IOException {
        int retries = 0;
        while (true) {
            try {
                this.fFile.getChannel().read(buf, i);
                return;
            }
            catch (ClosedChannelException e) {
                this.reopen(e, ++retries);
                continue;
            }
            break;
        }
    }

    void write(ByteBuffer buf, int i) throws IOException {
        int retries = 0;
        while (true) {
            try {
                this.fFile.getChannel().write(buf, i);
                return;
            }
            catch (ClosedChannelException e) {
                this.reopen(e, ++retries);
                continue;
            }
            break;
        }
    }

    private void reopen(ClosedChannelException e, int attempt) throws ClosedChannelException, FileNotFoundException {
        if (e instanceof ClosedByInterruptException || attempt >= 20) {
            throw e;
        }
        this.openFile();
    }

    public void transferTo(FileChannel target) throws IOException {
        if (!$assertionsDisabled && !this.fLocked) {
            throw new AssertionError();
        }
        FileChannel from = this.fFile.getChannel();
        from.transferTo(0L, from.size(), target);
    }

    public int getVersion() throws CoreException {
        return this.fVersion;
    }

    public void setVersion(int version) throws CoreException {
        if (!$assertionsDisabled && !this.fExclusiveLock) {
            throw new AssertionError();
        }
        this.fHeaderChunk.putInt(0, version);
        this.fVersion = version;
    }

    public void clear(int version) throws CoreException {
        if (!$assertionsDisabled && !this.fExclusiveLock) {
            throw new AssertionError();
        }
        this.removeChunksFromCache();
        this.fVersion = version;
        this.fHeaderChunk.clear(0, 4096);
        this.fChunks = new Chunk[1];
        try {
            this.fHeaderChunk.flush();
            this.fFile.getChannel().truncate(4096L);
        }
        catch (IOException e) {
            CCorePlugin.log(e);
        }
        this.freed = 0L;
        this.malloced = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChunksFromCache() {
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int i = 1;
            while (i < this.fChunks.length) {
                Chunk chunk = this.fChunks[i];
                if (chunk != null) {
                    this.fCache.remove(chunk);
                    this.fChunks[i] = null;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk getChunk(int offset) throws CoreException {
        if (offset < 4096) {
            return this.fHeaderChunk;
        }
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            if (!$assertionsDisabled && !this.fLocked) {
                throw new AssertionError();
            }
            int index = offset / 4096;
            Chunk chunk = this.fChunks[index];
            if (chunk == null) {
                ++this.cacheMisses;
                chunk = this.fChunks[index] = new Chunk(this, index);
                chunk.read();
            } else {
                ++this.cacheHits;
            }
            this.fCache.add(chunk, this.fExclusiveLock);
            return chunk;
        }
    }

    public int malloc(int size) throws CoreException {
        Chunk chunk;
        if (!$assertionsDisabled && !this.fExclusiveLock) {
            throw new AssertionError();
        }
        if (size > 4092) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, CCorePlugin.getResourceString("pdom.requestTooLarge"), (Throwable)new IllegalArgumentException()));
        }
        int freeblock = 0;
        int matchsize = 0;
        int blocksize = 16;
        while (blocksize <= 4096) {
            if (blocksize - 4 >= size) {
                if (matchsize == 0) {
                    matchsize = blocksize;
                }
                if ((freeblock = this.getFirstBlock(blocksize)) != 0) break;
            }
            blocksize += 16;
        }
        if (freeblock == 0) {
            freeblock = this.createNewChunk();
            blocksize = 4096;
            chunk = this.getChunk(freeblock);
        } else {
            chunk = this.getChunk(freeblock);
            this.removeBlock(chunk, blocksize, freeblock);
        }
        if (blocksize != matchsize) {
            this.addBlock(chunk, blocksize - matchsize, freeblock + matchsize);
        }
        chunk.putInt(freeblock, -matchsize);
        chunk.clear(freeblock + 4, size);
        this.malloced += (long)matchsize;
        return freeblock + 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createNewChunk() throws CoreException {
        if (!$assertionsDisabled && !this.fExclusiveLock) {
            throw new AssertionError();
        }
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int oldLen = this.fChunks.length;
            Chunk chunk = new Chunk(this, oldLen);
            chunk.fDirty = true;
            Chunk[] newchunks = new Chunk[oldLen + 1];
            System.arraycopy(this.fChunks, 0, newchunks, 0, oldLen);
            newchunks[oldLen] = chunk;
            this.fChunks = newchunks;
            this.fCache.add(chunk, true);
            return oldLen * 4096;
        }
    }

    private int getFirstBlock(int blocksize) throws CoreException {
        if (!$assertionsDisabled && !this.fLocked) {
            throw new AssertionError();
        }
        return this.fHeaderChunk.getInt(blocksize / 16 * 4);
    }

    private void setFirstBlock(int blocksize, int block) throws CoreException {
        if (!$assertionsDisabled && !this.fExclusiveLock) {
            throw new AssertionError();
        }
        this.fHeaderChunk.putInt(blocksize / 16 * 4, block);
    }

    private void removeBlock(Chunk chunk, int blocksize, int block) throws CoreException {
        if (!$assertionsDisabled && !this.fExclusiveLock) {
            throw new AssertionError();
        }
        int prevblock = chunk.getInt(block + 4);
        int nextblock = chunk.getInt(block + 8);
        if (prevblock != 0) {
            this.putInt(prevblock + 8, nextblock);
        } else {
            this.setFirstBlock(blocksize, nextblock);
        }
        if (nextblock != 0) {
            this.putInt(nextblock + 4, prevblock);
        }
    }

    private void addBlock(Chunk chunk, int blocksize, int block) throws CoreException {
        if (!$assertionsDisabled && !this.fExclusiveLock) {
            throw new AssertionError();
        }
        chunk.putInt(block, blocksize);
        int prevfirst = this.getFirstBlock(blocksize);
        chunk.putInt(block + 4, 0);
        chunk.putInt(block + 8, prevfirst);
        if (prevfirst != 0) {
            this.putInt(prevfirst + 4, block);
        }
        this.setFirstBlock(blocksize, block);
    }

    public void free(int offset) throws CoreException {
        if (!$assertionsDisabled && !this.fExclusiveLock) {
            throw new AssertionError();
        }
        int block = offset - 4;
        Chunk chunk = this.getChunk(block);
        int blocksize = -chunk.getInt(block);
        if (blocksize < 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.core", 0, "Already Freed", (Throwable)new Exception()));
        }
        this.addBlock(chunk, blocksize, block);
        this.freed += (long)blocksize;
    }

    public void putByte(int offset, byte value) throws CoreException {
        this.getChunk(offset).putByte(offset, value);
    }

    public byte getByte(int offset) throws CoreException {
        return this.getChunk(offset).getByte(offset);
    }

    public void putInt(int offset, int value) throws CoreException {
        this.getChunk(offset).putInt(offset, value);
    }

    public int getInt(int offset) throws CoreException {
        return this.getChunk(offset).getInt(offset);
    }

    public void putShort(int offset, short value) throws CoreException {
        this.getChunk(offset).putShort(offset, value);
    }

    public short getShort(int offset) throws CoreException {
        return this.getChunk(offset).getShort(offset);
    }

    public void putLong(int offset, long value) throws CoreException {
        this.getChunk(offset).putLong(offset, value);
    }

    public long getLong(int offset) throws CoreException {
        return this.getChunk(offset).getLong(offset);
    }

    public void putChar(int offset, char value) throws CoreException {
        this.getChunk(offset).putChar(offset, value);
    }

    public char getChar(int offset) throws CoreException {
        return this.getChunk(offset).getChar(offset);
    }

    public IString newString(String string) throws CoreException {
        if (string.length() > 2044) {
            return new LongString(this, string);
        }
        return new ShortString(this, string);
    }

    public IString newString(char[] chars) throws CoreException {
        if (chars.length > 2044) {
            return new LongString(this, chars);
        }
        return new ShortString(this, chars);
    }

    public IString getString(int offset) throws CoreException {
        int length = this.getInt(offset);
        if (length > 2044) {
            return new LongString(this, offset);
        }
        return new ShortString(this, offset);
    }

    public void reportFreeBlocks() throws CoreException {
        System.out.println("Allocated size: " + this.fChunks.length * 4096);
        System.out.println("malloc'ed: " + this.malloced);
        System.out.println("free'd: " + this.freed);
        System.out.println("wasted: " + ((long)(this.fChunks.length * 4096) - (this.malloced - this.freed)));
        System.out.println("Free blocks");
        int bs = 16;
        while (bs <= 4096) {
            int count = 0;
            int block = this.getFirstBlock(bs);
            while (block != 0) {
                ++count;
                block = this.getInt(block + 8);
            }
            if (count != 0) {
                System.out.println("Block size: " + bs + "=" + count);
            }
            bs += 16;
        }
    }

    public void close() throws CoreException {
        if (!$assertionsDisabled && !this.fExclusiveLock) {
            throw new AssertionError();
        }
        this.flush();
        this.removeChunksFromCache();
        this.fHeaderChunk.clear(0, 4096);
        this.fHeaderChunk.fDirty = false;
        this.fChunks = new Chunk[1];
        try {
            this.fFile.close();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new DBStatus(e));
        }
    }

    public File getLocation() {
        return this.fLocation;
    }

    void releaseChunk(Chunk chunk) {
        if (!chunk.fLocked) {
            this.fChunks[chunk.fSequenceNumber] = null;
        }
    }

    public ChunkCache getChunkCache() {
        return this.fCache;
    }

    public void setExclusiveLock() {
        this.fExclusiveLock = true;
        this.fLocked = true;
    }

    public void setLocked(boolean val) {
        this.fLocked = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void giveUpExclusiveLock(boolean flush) throws CoreException {
        if (!this.fExclusiveLock) return;
        try {
            ArrayList<Chunk> dirtyChunks = new ArrayList<Chunk>();
            ChunkCache chunkCache = this.fCache;
            synchronized (chunkCache) {
                int i = 1;
                while (true) {
                    block15: {
                        Chunk chunk;
                        block17: {
                            block16: {
                                if (i >= this.fChunks.length) {
                                    break;
                                }
                                chunk = this.fChunks[i];
                                if (chunk == null) break block15;
                                if (chunk.fCacheIndex >= 0) break block16;
                                if (chunk.fDirty) {
                                    dirtyChunks.add(chunk);
                                    break block15;
                                } else {
                                    chunk.fLocked = false;
                                    this.fChunks[i] = null;
                                }
                                break block15;
                            }
                            if (!chunk.fLocked) break block17;
                            if (chunk.fDirty) {
                                if (flush) {
                                    dirtyChunks.add(chunk);
                                }
                                break block15;
                            } else {
                                chunk.fLocked = false;
                            }
                            break block15;
                        }
                        if (!$assertionsDisabled && chunk.fDirty) {
                            throw new AssertionError();
                        }
                    }
                    ++i;
                }
            }
            this.flushAndUnlockChunks(dirtyChunks, flush);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fExclusiveLock = false;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.fExclusiveLock = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void flush() throws CoreException {
        if (!$assertionsDisabled && !this.fLocked) {
            throw new AssertionError();
        }
        if (this.fExclusiveLock) {
            try {
                this.giveUpExclusiveLock(true);
            }
            catch (Throwable throwable) {
                Object var1_3 = null;
                this.setExclusiveLock();
                throw throwable;
            }
            {
                Object var1_4 = null;
                this.setExclusiveLock();
                return;
            }
        }
        ArrayList<Chunk> dirtyChunks = new ArrayList<Chunk>();
        ChunkCache chunkCache = this.fCache;
        synchronized (chunkCache) {
            int i = 1;
            while (i < this.fChunks.length) {
                Chunk chunk = this.fChunks[i];
                if (chunk != null && chunk.fDirty) {
                    dirtyChunks.add(chunk);
                }
                ++i;
            }
        }
        this.flushAndUnlockChunks(dirtyChunks, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushAndUnlockChunks(ArrayList dirtyChunks, boolean isComplete) throws CoreException {
        if (!$assertionsDisabled && Thread.holdsLock(this.fCache)) {
            throw new AssertionError();
        }
        Chunk chunk = this.fHeaderChunk;
        synchronized (chunk) {
            if (!(this.fHeaderChunk.fDirty || isComplete && this.fIsMarkedIncomplete)) {
                return;
            }
            if (!dirtyChunks.isEmpty()) {
                this.markFileIncomplete();
                Iterator it = dirtyChunks.iterator();
                while (it.hasNext()) {
                    Chunk chunk2 = (Chunk)it.next();
                    if (!chunk2.fDirty) continue;
                    chunk2.flush();
                }
                ChunkCache chunkCache = this.fCache;
                synchronized (chunkCache) {
                    Iterator it2 = dirtyChunks.iterator();
                    while (it2.hasNext()) {
                        Chunk chunk3 = (Chunk)it2.next();
                        chunk3.fLocked = false;
                        if (chunk3.fCacheIndex >= 0) continue;
                        this.fChunks[chunk3.fSequenceNumber] = null;
                    }
                }
            }
            if (isComplete && (this.fHeaderChunk.fDirty || this.fIsMarkedIncomplete)) {
                this.fHeaderChunk.putInt(0, this.fVersion);
                this.fHeaderChunk.flush();
                this.fIsMarkedIncomplete = false;
            }
        }
    }

    private void markFileIncomplete() throws CoreException {
        if (!this.fIsMarkedIncomplete) {
            this.fIsMarkedIncomplete = true;
            try {
                ByteBuffer buf = ByteBuffer.wrap(new byte[4]);
                this.fFile.getChannel().write(buf, 0L);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new DBStatus(e));
            }
        }
    }

    public void resetCacheCounters() {
        this.cacheMisses = 0L;
        this.cacheHits = 0L;
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }
}

