/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFileLocalScope;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMName;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNotImplementedError;
import org.eclipse.core.runtime.CoreException;

public abstract class PDOMBinding
extends PDOMNamedNode
implements IIndexFragmentBinding {
    private static final int FIRST_DECL_OFFSET = 12;
    private static final int FIRST_DEF_OFFSET = 16;
    private static final int FIRST_REF_OFFSET = 20;
    protected static final int RECORD_SIZE = 24;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected PDOMBinding(PDOM pdom, PDOMNode parent, char[] name) throws CoreException {
        super(pdom, parent, name);
    }

    public PDOMBinding(PDOM pdom, int record) {
        super(pdom, record);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.isAssignableFrom(clazz)) {
            return this;
        }
        return null;
    }

    public static boolean isOrphaned(PDOM pdom, int record) throws CoreException {
        Database db = pdom.getDB();
        return db.getInt(record + 12) == 0 && db.getInt(record + 16) == 0 && db.getInt(record + 20) == 0;
    }

    public int getRecord() {
        return this.record;
    }

    public boolean hasDeclaration() throws CoreException {
        Database db = this.pdom.getDB();
        return db.getInt(this.record + 12) != 0 || db.getInt(this.record + 16) != 0;
    }

    public void addDeclaration(PDOMName name) throws CoreException {
        PDOMName first = this.getFirstDeclaration();
        if (first != null) {
            first.setPrevInBinding(name);
            name.setNextInBinding(first);
        }
        this.setFirstDeclaration(name);
    }

    public void addDefinition(PDOMName name) throws CoreException {
        PDOMName first = this.getFirstDefinition();
        if (first != null) {
            first.setPrevInBinding(name);
            name.setNextInBinding(first);
        }
        this.setFirstDefinition(name);
    }

    public void addReference(PDOMName name) throws CoreException {
        PDOMName first = this.getFirstReference();
        if (first != null) {
            first.setPrevInBinding(name);
            name.setNextInBinding(first);
        }
        this.setFirstReference(name);
    }

    public PDOMName getFirstDeclaration() throws CoreException {
        int namerec = this.pdom.getDB().getInt(this.record + 12);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    public void setFirstDeclaration(PDOMName name) throws CoreException {
        int namerec = name != null ? name.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 12, namerec);
    }

    public PDOMName getFirstDefinition() throws CoreException {
        int namerec = this.pdom.getDB().getInt(this.record + 16);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    public void setFirstDefinition(PDOMName name) throws CoreException {
        int namerec = name != null ? name.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 16, namerec);
    }

    public PDOMName getFirstReference() throws CoreException {
        int namerec = this.pdom.getDB().getInt(this.record + 20);
        return namerec != 0 ? new PDOMName(this.pdom, namerec) : null;
    }

    public void setFirstReference(PDOMName name) throws CoreException {
        int namerec = name != null ? name.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 20, namerec);
    }

    public String getName() {
        try {
            return super.getDBName().getString();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return "";
        }
    }

    public char[] getNameCharArray() {
        try {
            return super.getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[0];
        }
    }

    public IScope getParent() throws DOMException {
        try {
            IIndexBinding parent = this.getParentBinding();
            if (parent instanceof IScope) {
                return (IScope)((Object)parent);
            }
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
        }
        return null;
    }

    public final IScope getScope() {
        try {
            IIndexBinding parent = this.getParentBinding();
            if (parent instanceof IScope) {
                return (IScope)((Object)parent);
            }
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
        }
        return null;
    }

    public IIndexBinding getParentBinding() throws CoreException {
        PDOMNode parent = this.getParentNode();
        if (parent instanceof IIndexBinding) {
            return (IIndexBinding)((Object)parent);
        }
        return null;
    }

    public IIndexFragment getFragment() {
        return this.pdom;
    }

    protected abstract int getRecordSize();

    public String toString() {
        return String.valueOf(this.getName()) + " " + this.getNodeType();
    }

    protected final void fail() {
        throw new PDOMNotImplementedError();
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public IName getScopeName() throws DOMException {
        try {
            PDOMName name = this.getFirstDefinition();
            if (name == null) {
                name = this.getFirstDeclaration();
            }
            return name;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public final String[] getQualifiedName() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            PDOMNode node = this;
            while (node != null) {
                if (node instanceof PDOMBinding && !(node instanceof ICPPTemplateInstance)) {
                    result.add(0, ((PDOMBinding)node).getName());
                }
                node = node.getParentNode();
            }
            return result.toArray(new String[result.size()]);
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return null;
        }
    }

    public final boolean isFileLocal() throws CoreException {
        return this.getParentNode() instanceof PDOMFileLocalScope;
    }

    public boolean hasDefinition() throws CoreException {
        return this.getFirstDefinition() != null;
    }

    private static int comparePDOMBindingQNs(PDOMBinding b0, PDOMBinding b1) {
        try {
            int cmp = 0;
            do {
                IString s1;
                IString s0;
                if ((cmp = (s0 = b0.getDBName()).compare(s1 = b1.getDBName(), true)) != 0) continue;
                b0 = (PDOMBinding)b0.getParentBinding();
                b1 = (PDOMBinding)b1.getParentBinding();
                if (b0 != null && b1 != null) continue;
                int n = b0 == b1 ? 0 : (cmp = b0 == null ? -1 : 1);
            } while (cmp == 0 && b1 != null && b0 != null);
            return cmp;
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return -1;
        }
    }

    public int pdomCompareTo(PDOMBinding other) {
        int cmp = PDOMBinding.comparePDOMBindingQNs(this, other);
        if (cmp == 0) {
            int t2;
            int t1 = this.getNodeType();
            return t1 < (t2 = other.getNodeType()) ? -1 : (t1 > t2 ? 1 : 0);
        }
        return cmp;
    }

    public final boolean pdomEquals(PDOMBinding other) {
        return this.pdomCompareTo(other) == 0;
    }

    public final int getBindingConstant() {
        return this.getNodeType();
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
    }

    public final void delete(PDOMLinkage linkage) throws CoreException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }
}

