/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICBasicType;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndexCBindingConstants;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.IBTreeComparator;
import org.eclipse.cdt.internal.core.pdom.dom.FindBinding;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMMemberOwner;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMASTAdapter;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCBasicType;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCEnumeration;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCEnumerator;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCField;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunction;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCFunctionType;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCParameter;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCStructure;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCTypedef;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCVariable;
import org.eclipse.core.runtime.CoreException;

class PDOMCLinkage
extends PDOMLinkage
implements IIndexCBindingConstants {
    public PDOMCLinkage(PDOM pdom, int record) {
        super(pdom, record);
    }

    public PDOMCLinkage(PDOM pdom) throws CoreException {
        super(pdom, "C", "C".toCharArray());
    }

    public int getNodeType() {
        return 0;
    }

    public String getID() {
        return "C";
    }

    /*
     * Unable to fully structure code
     */
    public PDOMBinding addBinding(IBinding binding, IASTName fromName) throws CoreException {
        pdomBinding = this.adaptBinding(binding);
        if (pdomBinding != null) {
            if (this.shouldUpdate(pdomBinding, fromName)) {
                pdomBinding.update(this, fromName.getBinding());
            }
        } else {
            parent = this.getAdaptedParent(binding, true, false);
            if (parent == null) {
                return null;
            }
            if ((binding = PDOMASTAdapter.getAdapterIfAnonymous(binding)) == null || binding instanceof IParameter) {
                return null;
            }
            if (binding instanceof IField) {
                if (parent instanceof IPDOMMemberOwner) {
                    pdomBinding = new PDOMCField(this.pdom, (IPDOMMemberOwner)parent, (IField)binding);
                }
            } else if (binding instanceof IVariable) {
                var = (IVariable)binding;
                pdomBinding = new PDOMCVariable(this.pdom, parent, var);
            } else if (binding instanceof IFunction) {
                func = (IFunction)binding;
                pdomBinding = new PDOMCFunction(this.pdom, parent, func);
            } else if (binding instanceof ICompositeType) {
                pdomBinding = new PDOMCStructure(this.pdom, parent, (ICompositeType)binding);
            } else if (binding instanceof IEnumeration) {
                pdomBinding = new PDOMCEnumeration(this.pdom, parent, (IEnumeration)binding);
            } else if (binding instanceof IEnumerator) {
                try {
                    enumeration = (IEnumeration)((IEnumerator)binding).getType();
                    pdomEnumeration = this.adaptBinding(enumeration);
                    if (!(pdomEnumeration instanceof PDOMCEnumeration)) ** GOTO lbl40
                    pdomBinding = new PDOMCEnumerator(this.pdom, parent, (IEnumerator)binding, (PDOMCEnumeration)pdomEnumeration);
                }
                catch (DOMException e) {
                    throw new CoreException(Util.createStatus(e));
                }
            } else if (binding instanceof ITypedef) {
                pdomBinding = new PDOMCTypedef(this.pdom, parent, (ITypedef)binding);
            }
lbl40:
            // 10 sources

            if (pdomBinding != null) {
                parent.addChild(pdomBinding);
                this.afterAddBinding(pdomBinding);
            }
        }
        return pdomBinding;
    }

    private boolean shouldUpdate(PDOMBinding pdomBinding, IASTName fromName) throws CoreException {
        if (fromName != null) {
            if (fromName.isDefinition()) {
                return true;
            }
            if (fromName.isReference()) {
                return false;
            }
            return !pdomBinding.hasDefinition();
        }
        return false;
    }

    public PDOMBinding addBinding(IASTName name) throws CoreException {
        if (name == null) {
            return null;
        }
        char[] namechars = name.toCharArray();
        if (namechars == null) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        if (binding == null || binding instanceof IProblemBinding) {
            return null;
        }
        if (binding instanceof IParameter) {
            return null;
        }
        return this.addBinding(binding, name);
    }

    public int getBindingType(IBinding binding) {
        if (binding instanceof IField) {
            return 8;
        }
        if (binding instanceof IVariable) {
            return 5;
        }
        if (binding instanceof IFunction) {
            return 6;
        }
        if (binding instanceof ICompositeType) {
            return 7;
        }
        if (binding instanceof IEnumeration) {
            return 9;
        }
        if (binding instanceof IEnumerator) {
            return 10;
        }
        if (binding instanceof ITypedef) {
            return 11;
        }
        return 0;
    }

    public PDOMBinding adaptBinding(IBinding inputBinding) throws CoreException {
        PDOMBinding result;
        IBinding binding = inputBinding;
        if (binding instanceof PDOMBinding) {
            PDOMBinding pdomBinding = (PDOMBinding)binding;
            if (pdomBinding.getPDOM() == this.getPDOM()) {
                return pdomBinding;
            }
        } else if ((binding = PDOMASTAdapter.getAdapterIfAnonymous(binding)) == null) {
            return null;
        }
        if ((result = (PDOMBinding)this.pdom.getCachedResult(inputBinding)) != null) {
            return result;
        }
        PDOMNode parent = this.getAdaptedParent(binding, false, false);
        if (parent == this) {
            result = FindBinding.findBinding(this.getIndex(), this.getPDOM(), binding.getNameCharArray(), new int[]{this.getBindingType(binding)});
        } else if (parent instanceof IPDOMMemberOwner) {
            result = FindBinding.findBinding(parent, this.getPDOM(), binding.getNameCharArray(), new int[]{this.getBindingType(binding)});
        }
        if (result != null) {
            this.pdom.putCachedResult(inputBinding, result);
        }
        return result;
    }

    public PDOMNode getNode(int record) throws CoreException {
        if (record == 0) {
            return null;
        }
        switch (PDOMNode.getNodeType(this.pdom, record)) {
            case 5: {
                return new PDOMCVariable(this.pdom, record);
            }
            case 6: {
                return new PDOMCFunction(this.pdom, record);
            }
            case 7: {
                return new PDOMCStructure(this.pdom, record);
            }
            case 8: {
                return new PDOMCField(this.pdom, record);
            }
            case 9: {
                return new PDOMCEnumeration(this.pdom, record);
            }
            case 10: {
                return new PDOMCEnumerator(this.pdom, record);
            }
            case 11: {
                return new PDOMCTypedef(this.pdom, record);
            }
            case 12: {
                return new PDOMCParameter(this.pdom, record);
            }
            case 13: {
                return new PDOMCBasicType(this.pdom, record);
            }
            case 14: {
                return new PDOMCFunctionType(this.pdom, record);
            }
        }
        return super.getNode(record);
    }

    public PDOMNode addType(PDOMNode parent, IType type) throws CoreException {
        if (type instanceof IProblemBinding) {
            return null;
        }
        if (type instanceof ICBasicType) {
            return new PDOMCBasicType(this.pdom, parent, (ICBasicType)type);
        }
        if (type instanceof IFunctionType) {
            return new PDOMCFunctionType(this.pdom, parent, (IFunctionType)type);
        }
        if (type instanceof IBinding) {
            return this.addBinding((IBinding)((Object)type), null);
        }
        return super.addType(parent, type);
    }

    public IBTreeComparator getIndexComparator() {
        return new FindBinding.DefaultBindingBTreeComparator(this.getPDOM());
    }

    protected boolean isFileLocalBinding(IBinding binding) throws DOMException {
        if (binding instanceof IField) {
            return false;
        }
        if (binding instanceof IVariable) {
            IVariable var = (IVariable)binding;
            return var.isStatic();
        }
        if (binding instanceof IFunction) {
            IFunction f = (IFunction)binding;
            return f.isStatic();
        }
        return false;
    }
}

