/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPDelegate;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPEnumerator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDelegateCreator;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPEnumeration;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPEnumerator
extends PDOMCPPBinding
implements IEnumerator,
ICPPBinding,
ICPPDelegateCreator {
    private static final int ENUMERATION = 24;
    private static final int NEXT_ENUMERATOR = 28;
    protected static final int RECORD_SIZE = 32;

    public PDOMCPPEnumerator(PDOM pdom, PDOMNode parent, IEnumerator enumerator, PDOMCPPEnumeration enumeration) throws CoreException {
        super(pdom, parent, enumerator.getNameCharArray());
        pdom.getDB().putInt(this.record + 24, enumeration.getRecord());
        enumeration.addEnumerator(this);
    }

    public PDOMCPPEnumerator(PDOM pdom, int record) {
        super(pdom, record);
    }

    protected int getRecordSize() {
        return 32;
    }

    public int getNodeType() {
        return 15;
    }

    public PDOMCPPEnumerator getNextEnumerator() throws CoreException {
        int value = this.pdom.getDB().getInt(this.record + 28);
        return value != 0 ? new PDOMCPPEnumerator(this.pdom, value) : null;
    }

    public void setNextEnumerator(PDOMCPPEnumerator enumerator) throws CoreException {
        int value = enumerator != null ? enumerator.getRecord() : 0;
        this.pdom.getDB().putInt(this.record + 28, value);
    }

    public IType getType() throws DOMException {
        try {
            return new PDOMCPPEnumeration(this.pdom, this.pdom.getDB().getInt(this.record + 24));
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public ICPPDelegate createDelegate(IASTName name) {
        return new CPPEnumerator.CPPEnumeratorDelegate(name, this);
    }
}

