/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.settings.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingSerializer;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettingsContainer;
import org.eclipse.cdt.internal.core.settings.model.CExternalSettinsDeltaCalculator;

public class CExternalSettingsHolder
extends CExternalSettingsContainer {
    private Map fSettingsMap;
    static final String ELEMENT_EXT_SETTINGS_CONTAINER = "externalSettings";
    static final CExternalSetting[] EMPTY_EXT_SETTINGS_ARRAY = new CExternalSetting[0];
    private boolean fIsModified;

    CExternalSettingsHolder() {
    }

    CExternalSettingsHolder(ICStorageElement element) {
        ICStorageElement[] children = element.getChildren();
        ArrayList<CExternalSetting> externalSettingList = null;
        int i = 0;
        while (i < children.length) {
            ICStorageElement child = children[i];
            String name = child.getName();
            if ("externalSetting".equals(name)) {
                if (externalSettingList == null) {
                    externalSettingList = new ArrayList<CExternalSetting>();
                }
                CExternalSetting setting = CExternalSettingSerializer.load(child);
                externalSettingList.add(setting);
            }
            ++i;
        }
        if (externalSettingList != null && externalSettingList.size() != 0) {
            i = 0;
            while (i < externalSettingList.size()) {
                CExternalSetting setting = (CExternalSetting)externalSettingList.get(i);
                this.createExternalSetting(setting.getCompatibleLanguageIds(), setting.getCompatibleContentTypeIds(), setting.getCompatibleExtensions(), setting.getEntries());
                ++i;
            }
        }
    }

    CExternalSettingsHolder(CExternalSettingsHolder base) {
        if (base.fSettingsMap != null) {
            this.fSettingsMap = new HashMap(base.fSettingsMap);
        }
    }

    public CExternalSetting[] getExternalSettings() {
        if (this.fSettingsMap != null) {
            return this.fSettingsMap.values().toArray(new CExternalSetting[this.fSettingsMap.size()]);
        }
        return EMPTY_EXT_SETTINGS_ARRAY;
    }

    void setExternallSettings(CExternalSetting[] settings) {
        this.setExternalSettings(settings, false);
    }

    void setExternalSettings(CExternalSetting[] settings, boolean add) {
        if (!add) {
            this.removeExternalSettings();
        }
        if (settings != null) {
            int i = 0;
            while (i < settings.length) {
                CExternalSetting setting = settings[i];
                this.createExternalSetting(setting.getCompatibleLanguageIds(), setting.getCompatibleContentTypeIds(), setting.getCompatibleExtensions(), setting.getEntries());
                ++i;
            }
        }
        this.fIsModified = true;
    }

    void addExternalSettings(CExternalSetting[] settings) {
        this.setExternalSettings(settings, true);
    }

    public CExternalSetting createExternalSetting(String[] languageIDs, String[] contentTypeIDs, String[] extensions, ICSettingEntry[] entries) {
        return this.createExternalSetting(new CExternalSetting(languageIDs, contentTypeIDs, extensions, entries));
    }

    private CExternalSetting createExternalSetting(CExternalSetting setting) {
        CExternalSetting newSetting;
        CExternalSettinsDeltaCalculator.ExtSettingMapKey key = new CExternalSettinsDeltaCalculator.ExtSettingMapKey(setting);
        if (this.fSettingsMap != null) {
            newSetting = (CExternalSetting)this.fSettingsMap.get(key);
            newSetting = newSetting == null ? new CExternalSetting(setting) : new CExternalSetting(newSetting, setting.getEntries());
            this.fSettingsMap.put(key, newSetting);
        } else {
            newSetting = new CExternalSetting(setting);
            this.fSettingsMap = new HashMap();
            this.fSettingsMap.put(key, newSetting);
        }
        this.fIsModified = true;
        return newSetting;
    }

    public void removeExternalSetting(CExternalSetting setting) {
        CExternalSettinsDeltaCalculator.ExtSettingMapKey key;
        CExternalSetting settingToRemove;
        if (this.fSettingsMap != null && setting.equals(settingToRemove = (CExternalSetting)this.fSettingsMap.get(key = new CExternalSettinsDeltaCalculator.ExtSettingMapKey(setting)))) {
            this.fSettingsMap.remove(key);
            this.fIsModified = true;
        }
    }

    public void removeExternalSettings() {
        if (this.fSettingsMap != null) {
            this.fSettingsMap.clear();
            this.fSettingsMap = null;
            this.fIsModified = true;
        }
    }

    public void serialize(ICStorageElement el) {
        if (this.fSettingsMap != null && this.fSettingsMap.size() != 0) {
            Iterator iter = this.fSettingsMap.values().iterator();
            while (iter.hasNext()) {
                CExternalSetting setting = (CExternalSetting)iter.next();
                ICStorageElement child = el.createChild("externalSetting");
                CExternalSettingSerializer.store(setting, child);
            }
        }
    }

    public boolean isModified() {
        return this.fIsModified;
    }
}

