/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.formatter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTASMDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFieldDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblem;
import org.eclipse.cdt.core.dom.ast.IASTProblemDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTProblemExpression;
import org.eclipse.cdt.core.dom.ast.IASTProblemHolder;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTDesignatedInitializer;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTPointer;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExplicitTemplateInstantiation;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionTryBlockDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTLinkageSpecification;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceAlias;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTPointerToMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplatedTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisiblityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.internal.formatter.AbortFormatting;
import org.eclipse.cdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.cdt.internal.formatter.Scribe;
import org.eclipse.cdt.internal.formatter.align.Alignment;
import org.eclipse.cdt.internal.formatter.align.AlignmentException;
import org.eclipse.cdt.internal.formatter.scanner.Scanner;
import org.eclipse.cdt.internal.formatter.scanner.Token;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterVisitor
extends CPPASTVisitor {
    private static boolean DEBUG;
    private Scanner localScanner;
    public DefaultCodeFormatterOptions preferences;
    public Scribe scribe;
    private String fTranslationUnitFile;
    private boolean fInsideFor;
    private MultiStatus fStatus;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.formatter.CodeFormatterVisitor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.cdt.core/debug/formatter"));
    }

    public CodeFormatterVisitor(DefaultCodeFormatterOptions preferences, Map settings, int offset, int length) {
        this.shouldVisitNames = true;
        this.shouldVisitDeclarations = true;
        this.shouldVisitInitializers = true;
        this.shouldVisitParameterDeclarations = true;
        this.shouldVisitDeclarators = true;
        this.shouldVisitDeclSpecifiers = true;
        this.shouldVisitExpressions = true;
        this.shouldVisitStatements = true;
        this.shouldVisitTypeIds = true;
        this.shouldVisitEnumerators = true;
        this.shouldVisitTranslationUnit = true;
        this.shouldVisitProblems = true;
        this.shouldVisitBaseSpecifiers = true;
        this.shouldVisitNamespaces = true;
        this.shouldVisitTemplateParameters = true;
        this.localScanner = new Scanner(){

            public Token nextToken() {
                Token t = super.nextToken();
                while (t != null && (t.isWhiteSpace() || t.isPreprocessor())) {
                    t = super.nextToken();
                }
                return t;
            }
        };
        this.preferences = preferences;
        this.scribe = new Scribe(this, offset, length);
    }

    public TextEdit format(String string, IASTTranslationUnit unit) {
        long startTime;
        block3: {
            this.scribe.reset();
            startTime = System.currentTimeMillis();
            char[] compilationUnitSource = string.toCharArray();
            this.localScanner.setSource(compilationUnitSource);
            this.scribe.initializeScanner(compilationUnitSource);
            this.scribe.setSkipPositions(CodeFormatterVisitor.collectInactiveCodePositions(unit));
            this.fTranslationUnitFile = unit.getFilePath();
            this.fStatus = new MultiStatus("org.eclipse.cdt.core", 0, "Formatting problem(s)", null);
            try {
                unit.accept(this);
            }
            catch (RuntimeException e) {
                this.reportFormattingProblem(e);
                if (!DEBUG) break block3;
                return this.failedToFormat(e);
            }
        }
        if (DEBUG) {
            System.out.println("Formatting time: " + (System.currentTimeMillis() - startTime));
        }
        return this.scribe.getRootEdit();
    }

    IStatus getStatus() {
        return this.fStatus;
    }

    private final TextEdit failedToFormat(RuntimeException e) {
        if (DEBUG) {
            System.out.println("COULD NOT FORMAT: " + e.getMessage());
            System.out.println(this.scribe.scanner);
            System.out.println(this.scribe);
            System.out.flush();
            System.err.flush();
            e.printStackTrace();
            System.err.flush();
        }
        return null;
    }

    private void reportFormattingProblem(RuntimeException e) {
        String errorMessage = e.getMessage();
        if (errorMessage == null) {
            errorMessage = "Unknown error";
        }
        this.fStatus.add(CodeFormatterVisitor.createStatus(errorMessage, e));
    }

    private static IStatus createStatus(String msg, Throwable e) {
        return new Status(2, "org.eclipse.cdt.core", msg, e);
    }

    /*
     * Unable to fully structure code
     */
    public int visit(IASTTranslationUnit tu) {
        this.scribe.lastNumberOfNewLines = 1;
        this.scribe.startNewLine();
        indentLevel = this.scribe.indentationLevel;
        decls = tu.getDeclarations();
        i = 0;
        while (i < decls.length) {
            block6: {
                declaration = decls[i];
                if (this.fTranslationUnitFile.equals(declaration.getContainingFilename())) {
                    try {
                        this.visit(declaration);
                        this.scribe.startNewLine();
                        break block6;
                    }
                    catch (RuntimeException e) {
                        this.reportFormattingProblem(e);
                        if (i >= decls.length - 1) break block6;
                        this.exitAlignments();
                        this.skipToNode(decls[i + 1]);
                        ** while (this.scribe.indentationLevel < indentLevel)
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.scribe.indent();
                        continue;
                    }
lbl22:
                    // 2 sources

                    while (this.scribe.indentationLevel > indentLevel) {
                        this.scribe.unIndent();
                    }
                }
            }
            ++i;
        }
        this.scribe.printEndOfTranslationUnit();
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    public int visit(IASTDeclaration node) {
        block23: {
            indentLevel = this.scribe.indentationLevel;
            try {
                locations = node.getNodeLocations();
                if (locations.length == 0) {
                    throw new AbortFormatting("Empty location array in " + node.getClass().getName());
                }
                if (locations[0] instanceof IASTMacroExpansion && !(node instanceof IASTProblemDeclaration)) {
                    this.skipNode(node);
                } else {
                    if (node instanceof IASTFunctionDefinition) {
                        return this.visit((IASTFunctionDefinition)node);
                    }
                    if (node instanceof IASTSimpleDeclaration) {
                        return this.visit((IASTSimpleDeclaration)node);
                    }
                    if (node instanceof IASTASMDeclaration) {
                        return this.visit((IASTASMDeclaration)node);
                    }
                    if (node instanceof ICPPASTVisiblityLabel) {
                        return this.visit((ICPPASTVisiblityLabel)node);
                    }
                    if (node instanceof ICPPASTNamespaceDefinition) {
                        return this.visit((ICPPASTNamespaceDefinition)node);
                    }
                    if (node instanceof ICPPASTNamespaceAlias) {
                        this.formatNode(node);
                    } else if (node instanceof ICPPASTUsingDeclaration) {
                        this.formatNode(node);
                    } else if (node instanceof ICPPASTUsingDirective) {
                        this.formatNode(node);
                    } else {
                        if (node instanceof ICPPASTLinkageSpecification) {
                            return this.visit((ICPPASTLinkageSpecification)node);
                        }
                        if (node instanceof ICPPASTTemplateDeclaration) {
                            return this.visit((ICPPASTTemplateDeclaration)node);
                        }
                        if (node instanceof ICPPASTTemplateSpecialization) {
                            return this.visit((ICPPASTTemplateSpecialization)node);
                        }
                        if (node instanceof ICPPASTExplicitTemplateInstantiation) {
                            return this.visit((ICPPASTExplicitTemplateInstantiation)node);
                        }
                        if (node instanceof IASTProblemDeclaration) {
                            return this.visit((IASTProblemDeclaration)node);
                        }
                        this.formatNode(node);
                    }
                }
                break block23;
            }
            catch (ASTProblemException e) {
                if (node instanceof IASTProblemDeclaration) {
                    throw e;
                }
                this.skipNode(node);
                ** while (this.scribe.indentationLevel > indentLevel)
            }
lbl-1000:
            // 1 sources

            {
                this.scribe.unIndent();
                continue;
            }
        }
        return 1;
    }

    public int visit(IASTName node) {
        IASTNodeLocation[] locations = node.getNodeLocations();
        if (locations.length == 0) {
            return 1;
        }
        if (locations[0] instanceof IASTMacroExpansion) {
            this.formatNode(node);
        } else if (node instanceof ICPPASTQualifiedName) {
            this.visit((ICPPASTQualifiedName)node);
        } else if (node instanceof ICPPASTTemplateId) {
            this.visit((ICPPASTTemplateId)node);
        } else {
            this.formatNode(node);
        }
        return 1;
    }

    public int visit(IASTInitializer node) {
        IASTNodeLocation[] locations = node.getNodeLocations();
        if (locations.length == 0) {
            return 1;
        }
        if (locations[0] instanceof IASTMacroExpansion) {
            this.formatNode(node);
            return 1;
        }
        if (node instanceof ICPPASTConstructorInitializer) {
            this.visit((ICPPASTConstructorInitializer)node);
            return 1;
        }
        if (this.peekNextToken() == 38) {
            this.scribe.printNextToken(38, this.scribe.printComment());
            if (this.scribe.printComment()) {
                this.scribe.space();
            }
        }
        if (node instanceof IASTInitializerExpression) {
            this.visit((IASTInitializerExpression)node);
        } else if (node instanceof IASTInitializerList) {
            this.visit((IASTInitializerList)node);
        } else if (node instanceof ICASTDesignatedInitializer) {
            this.formatNode(node);
        } else {
            this.formatNode(node);
        }
        return 1;
    }

    public int visit(IASTParameterDeclaration parameterDeclaration) {
        this.formatNode(parameterDeclaration);
        return 1;
    }

    public int visit(IASTDeclarator node) {
        IASTDeclarator nestedDecl;
        IASTName name;
        IASTNodeLocation[] locations = node.getNodeLocations();
        if (locations.length == 0) {
            return 1;
        }
        if (locations[0] instanceof IASTMacroExpansion) {
            this.formatNode(node);
            return 1;
        }
        this.formatPointers(node.getPointerOperators());
        if (this.scribe.printComment()) {
            this.scribe.space();
        }
        if ((name = node.getName()) != null) {
            name.accept(this);
        }
        if ((nestedDecl = node.getNestedDeclarator()) != null) {
            this.scribe.printNextToken(8, false);
            nestedDecl.accept(this);
            this.scribe.printNextToken(9, false);
        }
        if (node instanceof ICPPASTFunctionTryBlockDeclarator) {
            this.visit((IASTStandardFunctionDeclarator)node);
            this.skipNode(node);
            return 1;
        }
        if (node instanceof ICPPASTFunctionDeclarator) {
            return this.visit((ICPPASTFunctionDeclarator)node);
        }
        if (node instanceof IASTStandardFunctionDeclarator) {
            this.visit((IASTStandardFunctionDeclarator)node);
        } else if (node instanceof ICASTKnRFunctionDeclarator) {
            this.visit((ICASTKnRFunctionDeclarator)node);
        } else if (node instanceof IASTFieldDeclarator) {
            this.visit((IASTFieldDeclarator)node);
        } else if (node instanceof IASTArrayDeclarator) {
            this.visit((IASTArrayDeclarator)node);
        }
        IASTInitializer initializer = node.getInitializer();
        if (initializer != null) {
            initializer.accept(this);
        }
        return 1;
    }

    public int visit(IASTDeclSpecifier node) {
        IASTNodeLocation[] locations = node.getNodeLocations();
        if (locations.length == 0) {
            return 1;
        }
        if (locations[0] instanceof IASTMacroExpansion) {
            this.formatNode(node);
        } else if (node instanceof ICPPASTCompositeTypeSpecifier) {
            this.visit((ICPPASTCompositeTypeSpecifier)node);
        } else if (node instanceof ICASTCompositeTypeSpecifier) {
            this.visit((ICASTCompositeTypeSpecifier)node);
        } else if (node instanceof ICPPASTElaboratedTypeSpecifier) {
            this.visit((ICPPASTElaboratedTypeSpecifier)node);
        } else if (node instanceof ICASTElaboratedTypeSpecifier) {
            this.visit((ICASTElaboratedTypeSpecifier)node);
        } else if (node instanceof IASTEnumerationSpecifier) {
            this.visit((IASTEnumerationSpecifier)node);
        } else if (node instanceof IASTSimpleDeclSpecifier) {
            this.visit((IASTSimpleDeclSpecifier)node);
        } else if (node instanceof IASTNamedTypeSpecifier) {
            this.visit((IASTNamedTypeSpecifier)node);
        } else {
            this.formatNode(node);
        }
        return 1;
    }

    public int visit(IASTExpression node) {
        IASTNodeLocation[] locations = node.getNodeLocations();
        if (locations.length == 0) {
            return 1;
        }
        if (locations[0] instanceof IASTMacroExpansion) {
            this.skipNode(node);
        } else {
            if (locations[0].getNodeOffset() + locations[0].getNodeLength() < this.scribe.scanner.getCurrentPosition()) {
                return 1;
            }
            if (node instanceof IASTConditionalExpression) {
                this.visit((IASTConditionalExpression)node);
            } else if (node instanceof IASTFunctionCallExpression) {
                this.visit((IASTFunctionCallExpression)node);
            } else if (node instanceof IASTExpressionList) {
                this.visit((IASTExpressionList)node);
            } else if (node instanceof IASTTypeIdExpression) {
                this.visit((IASTTypeIdExpression)node);
            } else if (node instanceof IASTBinaryExpression) {
                this.visit((IASTBinaryExpression)node);
            } else if (node instanceof IASTLiteralExpression) {
                this.visit((IASTLiteralExpression)node);
            } else if (node instanceof IASTIdExpression) {
                this.visit((IASTIdExpression)node);
            } else if (node instanceof IASTCastExpression) {
                this.visit((IASTCastExpression)node);
            } else if (node instanceof IASTUnaryExpression) {
                this.visit((IASTUnaryExpression)node);
            } else if (node instanceof IASTProblemExpression) {
                this.visit((IASTProblemExpression)node);
            } else {
                this.formatNode(node);
            }
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    public int visit(IASTStatement node) {
        block44: {
            block45: {
                block43: {
                    this.scribe.printComment();
                    indentLevel = this.scribe.indentationLevel;
                    locations = node.getNodeLocations();
                    if (locations.length != 0) break block43;
                    return 1;
                }
                if (locations[0] instanceof IASTMacroExpansion && !(node instanceof IASTProblemStatement)) {
                    this.skipNode(node);
                    break block44;
                }
                if (locations[0].getNodeOffset() + locations[0].getNodeLength() >= this.scribe.scanner.getCurrentPosition()) break block45;
                return 1;
            }
            try {
                if (node instanceof IASTCompoundStatement) {
                    this.visit((IASTCompoundStatement)node);
                } else if (node instanceof IASTNullStatement) {
                    this.visit((IASTNullStatement)node);
                } else if (node instanceof IASTDeclarationStatement) {
                    this.visit((IASTDeclarationStatement)node);
                } else if (node instanceof ICPPASTForStatement) {
                    this.visit((IASTForStatement)node);
                } else if (node instanceof IASTForStatement) {
                    this.visit((IASTForStatement)node);
                } else if (node instanceof IASTIfStatement) {
                    this.visit((IASTIfStatement)node);
                } else if (node instanceof ICPPASTWhileStatement) {
                    this.visit((IASTWhileStatement)node);
                } else if (node instanceof IASTWhileStatement) {
                    this.visit((IASTWhileStatement)node);
                } else if (node instanceof IASTDoStatement) {
                    this.visit((IASTDoStatement)node);
                } else if (node instanceof IASTSwitchStatement) {
                    this.visit((IASTSwitchStatement)node);
                } else if (node instanceof IASTExpressionStatement) {
                    this.visit((IASTExpressionStatement)node);
                } else if (node instanceof IASTContinueStatement) {
                    this.visit((IASTContinueStatement)node);
                } else if (node instanceof IASTReturnStatement) {
                    this.visit((IASTReturnStatement)node);
                } else if (node instanceof IASTBreakStatement) {
                    this.visit((IASTBreakStatement)node);
                } else if (node instanceof IASTCaseStatement) {
                    this.visit((IASTCaseStatement)node);
                } else if (node instanceof IASTDefaultStatement) {
                    this.visit((IASTDefaultStatement)node);
                } else if (node instanceof IASTLabelStatement) {
                    this.visit((IASTLabelStatement)node);
                } else if (node instanceof IASTProblemStatement) {
                    this.visit((IASTProblemStatement)node);
                } else {
                    this.formatNode(node);
                }
                break block44;
            }
            catch (ASTProblemException e) {
                if (node instanceof IASTProblemStatement) {
                    throw e;
                }
                this.skipNode(node);
                ** while (this.scribe.indentationLevel > indentLevel)
            }
lbl-1000:
            // 1 sources

            {
                this.scribe.unIndent();
                continue;
            }
        }
        return 1;
    }

    public int visit(IASTTypeId typeId) {
        IASTDeclarator declarator;
        if (typeId instanceof IASTProblemHolder) {
            throw new ASTProblemException(((IASTProblemHolder)((Object)typeId)).getProblem());
        }
        IASTDeclSpecifier declSpec = typeId.getDeclSpecifier();
        if (declSpec != null) {
            declSpec.accept(this);
        }
        if ((declarator = typeId.getAbstractDeclarator()) != null) {
            declarator.accept(this);
        }
        return 1;
    }

    public int visit(IASTEnumerationSpecifier.IASTEnumerator enumerator) {
        this.formatNode(enumerator);
        return 1;
    }

    public int visit(IASTProblem problem) {
        this.formatNode(problem);
        return 1;
    }

    public int visit(ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier specifier) {
        this.formatNode(specifier);
        return 1;
    }

    public int visit(ICPPASTNamespaceDefinition node) {
        this.scribe.printComment();
        int line = this.scribe.line;
        this.scribe.printNextToken(91, false);
        this.scribe.space();
        node.getName().accept(this);
        IASTDeclaration[] memberDecls = node.getDeclarations();
        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_namespace_declaration);
        this.formatOpeningBrace(this.preferences.brace_position_for_namespace_declaration, this.preferences.insert_space_before_opening_brace_in_namespace_declaration);
        if (this.preferences.indent_body_declarations_compare_to_namespace_header) {
            this.scribe.indent();
        }
        this.scribe.startNewLine();
        int i = 0;
        while (i < memberDecls.length) {
            IASTDeclaration declaration = memberDecls[i];
            if (declaration instanceof ICPPASTVisiblityLabel) {
                this.visit((ICPPASTVisiblityLabel)declaration);
            } else {
                declaration.accept(this);
            }
            this.scribe.startNewLine();
            ++i;
        }
        if (this.preferences.indent_body_declarations_compare_to_namespace_header) {
            this.scribe.unIndent();
        }
        this.formatClosingBrace(this.preferences.brace_position_for_namespace_declaration);
        return 1;
    }

    private int visit(ICPPASTLinkageSpecification node) {
        this.scribe.printComment();
        int line = this.scribe.line;
        this.scribe.printNextToken(80, false);
        this.scribe.space();
        this.scribe.printNextToken(129);
        IASTDeclaration[] memberDecls = node.getDeclarations();
        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_namespace_declaration);
        this.formatOpeningBrace(this.preferences.brace_position_for_namespace_declaration, this.preferences.insert_space_before_opening_brace_in_namespace_declaration);
        if (this.preferences.indent_body_declarations_compare_to_namespace_header) {
            this.scribe.indent();
        }
        this.scribe.startNewLine();
        int i = 0;
        while (i < memberDecls.length) {
            IASTDeclaration declaration = memberDecls[i];
            if (declaration instanceof ICPPASTVisiblityLabel) {
                this.visit((ICPPASTVisiblityLabel)declaration);
            } else {
                declaration.accept(this);
            }
            this.scribe.startNewLine();
            ++i;
        }
        if (this.preferences.indent_body_declarations_compare_to_namespace_header) {
            this.scribe.unIndent();
        }
        this.formatClosingBrace(this.preferences.brace_position_for_namespace_declaration);
        return 1;
    }

    public int visit(ICPPASTTemplateParameter node) {
        IASTNodeLocation[] locations;
        block9: {
            locations = node.getNodeLocations();
            if (locations.length != 0) break block9;
            return 1;
        }
        try {
            if (locations[0] instanceof IASTMacroExpansion) {
                this.skipNode(node);
            } else if (node instanceof ICPPASTSimpleTypeTemplateParameter) {
                this.visit((ICPPASTSimpleTypeTemplateParameter)node);
            } else if (node instanceof ICPPASTTemplatedTypeTemplateParameter) {
                this.visit((ICPPASTTemplatedTypeTemplateParameter)node);
            } else {
                this.visit((IASTParameterDeclaration)((Object)node));
            }
        }
        catch (ASTProblemException aSTProblemException) {
            this.skipNode(node);
        }
        return 1;
    }

    public int visit(ICPPASTSimpleTypeTemplateParameter node) {
        switch (node.getParameterType()) {
            case 1: {
                this.scribe.printNextToken(65);
                this.scribe.space();
                break;
            }
            case 2: {
                this.scribe.printNextToken(118);
                this.scribe.space();
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unknown template paramter type");
                }
                this.formatNode(node);
                return 1;
            }
        }
        node.getName().accept(this);
        IASTTypeId defaultType = node.getDefaultType();
        if (defaultType != null) {
            this.scribe.printNextToken(38, this.scribe.printComment());
            defaultType.accept(this);
        }
        return 1;
    }

    public int visit(ICPPASTTemplatedTypeTemplateParameter node) {
        IASTExpression defaultValue;
        IASTName name;
        ICPPASTTemplateParameter[] templateParameters;
        this.scribe.printNextToken(111, this.scribe.printComment());
        this.scribe.printNextToken(42, this.scribe.printComment());
        if (this.scribe.printComment()) {
            this.scribe.space();
        }
        if ((templateParameters = node.getTemplateParameters()).length > 0) {
            ListAlignment align = new ListAlignment(16);
            this.formatList(Arrays.asList(templateParameters), align, false, false);
        }
        this.scribe.printNextToken(46, this.scribe.printComment());
        if (this.scribe.printComment()) {
            this.scribe.space();
        }
        if ((name = node.getName()) != null) {
            name.accept(this);
        }
        if ((defaultValue = node.getDefaultValue()) != null) {
            this.scribe.printNextToken(38, this.scribe.printComment());
            defaultValue.accept(this);
        }
        return 1;
    }

    private int visit(ICPPASTConstructorInitializer node) {
        this.scribe.printNextToken(8, false);
        IASTExpression value = node.getExpression();
        if (value != null) {
            value.accept(this);
        }
        this.scribe.printNextToken(9, false);
        return 1;
    }

    private int visit(ICPPASTConstructorChainInitializer node) {
        IASTName member = node.getMemberInitializerId();
        if (member != null) {
            member.accept(this);
            this.scribe.printNextToken(8, false);
            IASTExpression value = node.getInitializerValue();
            if (value != null) {
                value.accept(this);
            }
            this.scribe.printNextToken(9, false);
        } else {
            this.formatNode(node);
        }
        return 1;
    }

    private int visit(IASTFunctionDefinition node) {
        boolean needSpace;
        this.scribe.printComment();
        int line = this.scribe.line;
        IASTDeclSpecifier declSpec = node.getDeclSpecifier();
        declSpec.accept(this);
        IASTFunctionDeclarator decl = node.getDeclarator();
        boolean bl = needSpace = this.scribe.printComment() || decl.getPointerOperators().length == 0 && decl.getNestedDeclarator() == null;
        if (needSpace) {
            this.scribe.space();
        }
        decl.accept(this);
        IASTStatement bodyStmt = node.getBody();
        if (bodyStmt instanceof IASTCompoundStatement) {
            this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_method_declaration);
            this.formatBlock((IASTCompoundStatement)bodyStmt, this.preferences.brace_position_for_method_declaration, this.preferences.insert_space_before_opening_brace_in_method_declaration, this.preferences.indent_statements_compare_to_body);
        } else {
            bodyStmt.accept(this);
        }
        this.scribe.printTrailingComment();
        this.scribe.startNewLine();
        return 1;
    }

    private int visit(IASTASMDeclaration node) {
        this.formatNode(node);
        return 1;
    }

    private int visit(ICPPASTFunctionDeclarator node) {
        ICPPASTConstructorChainInitializer[] constructorChain;
        this.visit((IASTStandardFunctionDeclarator)node);
        this.skipConstVolatile();
        IASTTypeId[] exceptionSpecification = node.getExceptionSpecification();
        if (exceptionSpecification != null && this.peekNextToken() == 113) {
            this.formatExceptionSpecification(exceptionSpecification);
        }
        if ((constructorChain = node.getConstructorChain()) != null && constructorChain.length > 0) {
            this.scribe.printNextToken(4, true);
            this.scribe.printTrailingComment();
            this.scribe.startNewLine();
            this.scribe.indent();
            ListAlignment align = new ListAlignment(16);
            this.formatList(Arrays.asList(constructorChain), align, false, false);
            this.scribe.unIndent();
        } else {
            this.skipNode(node);
        }
        return 1;
    }

    private void formatExceptionSpecification(IASTTypeId[] exceptionSpecification) {
        if (exceptionSpecification.length > 0) {
            Alignment alignment = this.scribe.createAlignment("exceptionSpecification", 16, exceptionSpecification.length, this.scribe.scanner.getCurrentPosition());
            this.scribe.enterAlignment(alignment);
            boolean ok = false;
            do {
                try {
                    this.scribe.alignFragment(alignment, 0);
                    this.scribe.printNextToken(113, true);
                    this.scribe.printNextToken(8, this.scribe.printComment());
                    exceptionSpecification[0].accept(this);
                    int i = 1;
                    while (i < exceptionSpecification.length) {
                        this.scribe.printNextToken(6, this.preferences.insert_space_before_comma_in_array_initializer);
                        this.scribe.printTrailingComment();
                        if (this.preferences.insert_space_after_comma_in_array_initializer) {
                            this.scribe.space();
                        }
                        this.scribe.alignFragment(alignment, i);
                        exceptionSpecification[i].accept(this);
                        ++i;
                    }
                    this.scribe.printNextToken(9, this.scribe.printComment());
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
            } while (!ok);
            this.scribe.exitAlignment(alignment, true);
        } else {
            this.scribe.printNextToken(113, true);
            this.scribe.printNextToken(8, this.scribe.printComment());
            this.scribe.printNextToken(9, this.scribe.printComment());
        }
    }

    private void skipConstVolatile() {
        int token = this.peekNextToken();
        while (token == 67 || token == 124) {
            this.scribe.printNextToken(token, true);
            token = this.peekNextToken();
        }
    }

    private int visit(IASTStandardFunctionDeclarator node) {
        List<IASTParameterDeclaration> parameters = Arrays.asList(node.getParameters());
        ListAlignment align = new ListAlignment(this.preferences.alignment_for_parameters_in_method_declaration);
        align.fSpaceBeforeOpeningParen = this.preferences.insert_space_before_opening_paren_in_method_declaration;
        align.fSpaceAfterOpeningParen = this.preferences.insert_space_after_opening_paren_in_method_declaration;
        align.fSpaceBeforeClosingParen = this.preferences.insert_space_before_closing_paren_in_method_declaration;
        align.fSpaceBeforeComma = this.preferences.insert_space_before_comma_in_method_declaration_parameters;
        align.fSpaceAfterComma = this.preferences.insert_space_after_comma_in_method_declaration_parameters;
        this.formatList(parameters, align, true, node.takesVarArgs());
        return 1;
    }

    private void formatPointers(IASTPointerOperator[] pointers) {
        int i = 0;
        while (i < pointers.length) {
            IASTPointerOperator pointer = pointers[i];
            if (this.scribe.printComment()) {
                this.scribe.space();
            }
            this.scribe.printModifiers();
            if (pointer instanceof ICPPASTReferenceOperator) {
                this.scribe.printNextToken(30, false);
            } else if (pointer instanceof ICASTPointer) {
                this.scribe.printNextToken(23, false);
            } else if (pointer instanceof ICPPASTPointerToMember) {
                ICPPASTPointerToMember ptrToMember = (ICPPASTPointerToMember)pointer;
                IASTName name = ptrToMember.getName();
                if (name != null) {
                    name.accept(this);
                }
                this.scribe.printNextToken(23, false);
            } else {
                this.formatNode(pointer);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int visit(ICASTKnRFunctionDeclarator node) {
        List<IASTName> parameters = Arrays.asList(node.getParameterNames());
        ListAlignment align = new ListAlignment(this.preferences.alignment_for_parameters_in_method_declaration);
        align.fSpaceAfterOpeningParen = this.preferences.insert_space_after_opening_paren_in_method_declaration;
        align.fSpaceBeforeClosingParen = this.preferences.insert_space_before_closing_paren_in_method_declaration;
        align.fSpaceBeforeComma = this.preferences.insert_space_before_comma_in_method_declaration_parameters;
        align.fSpaceAfterComma = this.preferences.insert_space_after_comma_in_method_declaration_parameters;
        this.formatList(parameters, align, true, false);
        IASTDeclaration[] parameterDecls = node.getParameterDeclarations();
        this.scribe.startNewLine();
        this.scribe.indent();
        try {
            int i = 0;
            while (i < parameterDecls.length) {
                IASTDeclaration declaration = parameterDecls[i];
                declaration.accept(this);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.scribe.unIndent();
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.scribe.unIndent();
            return 1;
        }
    }

    private int visit(IASTFieldDeclarator node) {
        IASTExpression bitFieldSizeExpr = node.getBitFieldSize();
        if (bitFieldSizeExpr != null) {
            this.scribe.printNextToken(4, true);
            bitFieldSizeExpr.accept(this);
        }
        return 1;
    }

    private int visit(IASTArrayDeclarator node) {
        IASTArrayModifier[] arrayModifiers = node.getArrayModifiers();
        if (arrayModifiers != null) {
            int i = 0;
            while (i < arrayModifiers.length) {
                IASTArrayModifier arrayModifier = arrayModifiers[i];
                this.scribe.printNextToken(10, this.scribe.printComment());
                try {
                    arrayModifier.accept(this);
                }
                catch (ASTProblemException aSTProblemException) {
                    this.scribe.skipToToken(11);
                }
                this.scribe.printNextToken(11, this.scribe.printComment());
                ++i;
            }
        }
        return 1;
    }

    private int visit(IASTSimpleDeclaration node) {
        IASTDeclSpecifier declSpec = node.getDeclSpecifier();
        declSpec.accept(this);
        List<IASTDeclarator> declarators = Arrays.asList(node.getDeclarators());
        if (declarators.size() > 0) {
            if (this.scribe.printComment() || this.peekNextToken() == 1) {
                this.scribe.space();
            }
            ListAlignment align = new ListAlignment(16);
            this.formatList(declarators, align, false, false);
        }
        if (this.peekNextToken() != 5) {
            this.scribe.skipToToken(5);
        }
        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return 1;
    }

    protected boolean isCompositeTypeDeclaration(IASTDeclSpecifier declSpec) {
        return declSpec instanceof IASTCompositeTypeSpecifier || declSpec instanceof ICASTEnumerationSpecifier;
    }

    private int visit(ICPPASTTemplateDeclaration node) {
        ICPPASTTemplateParameter[] templateParameters;
        this.scribe.printNextToken(111, this.scribe.printComment());
        this.scribe.printNextToken(42, this.scribe.printComment());
        if (this.scribe.printComment()) {
            this.scribe.space();
        }
        if ((templateParameters = node.getTemplateParameters()).length > 0) {
            ListAlignment align = new ListAlignment(16);
            this.formatList(Arrays.asList(templateParameters), align, false, false);
        }
        this.scribe.printNextToken(46, this.scribe.printComment());
        if (this.scribe.printComment()) {
            this.scribe.space();
        }
        node.getDeclaration().accept(this);
        return 1;
    }

    private int visit(ICPPASTTemplateSpecialization node) {
        node.getDeclaration().accept(this);
        return 1;
    }

    private int visit(ICPPASTExplicitTemplateInstantiation node) {
        node.getDeclaration().accept(this);
        return 1;
    }

    private int visit(IASTSimpleDeclSpecifier node) {
        this.formatNode(node);
        return 1;
    }

    private int visit(IASTNamedTypeSpecifier node) {
        this.formatNode(node);
        return 1;
    }

    private int visit(ICASTCompositeTypeSpecifier node) {
        this.scribe.printComment();
        int line = this.scribe.line;
        this.scribe.printModifiers();
        switch (node.getKey()) {
            case 1: {
                this.scribe.printNextToken(109, true);
                break;
            }
            case 2: {
                this.scribe.printNextToken(119, true);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unexpected composite type specifier");
                }
                break;
            }
        }
        this.scribe.space();
        node.getName().accept(this);
        IASTDeclaration[] memberDecls = node.getMembers();
        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_type_declaration);
        this.formatOpeningBrace(this.preferences.brace_position_for_type_declaration, this.preferences.insert_space_before_opening_brace_in_type_declaration);
        if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
            this.scribe.indent();
        }
        this.scribe.startNewLine();
        int i = 0;
        while (i < memberDecls.length) {
            IASTDeclaration declaration = memberDecls[i];
            declaration.accept(this);
            this.scribe.startNewLine();
            ++i;
        }
        if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
            this.scribe.unIndent();
        }
        this.formatClosingBrace(this.preferences.brace_position_for_type_declaration);
        return 1;
    }

    private int visit(ICPPASTCompositeTypeSpecifier node) {
        this.scribe.printComment();
        int line = this.scribe.line;
        this.scribe.printModifiers();
        int headerIndent = this.scribe.numberOfIndentations;
        switch (node.getKey()) {
            case 1: {
                this.scribe.printNextToken(109, true);
                break;
            }
            case 2: {
                this.scribe.printNextToken(119, true);
                break;
            }
            case 3: {
                this.scribe.printNextToken(65, true);
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Unexpected composite type specifier");
                }
                break;
            }
        }
        this.scribe.space();
        node.getName().accept(this);
        List<ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier> baseSpecifiers = Arrays.asList(node.getBaseSpecifiers());
        if (baseSpecifiers.size() > 0) {
            this.scribe.printNextToken(4, true);
            this.scribe.space();
            ListAlignment align = new ListAlignment(16);
            this.formatList(baseSpecifiers, align, false, false);
        }
        this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_type_declaration);
        this.formatOpeningBrace(this.preferences.brace_position_for_type_declaration, this.preferences.insert_space_before_opening_brace_in_type_declaration);
        int braceIndent = this.scribe.numberOfIndentations;
        if (braceIndent > headerIndent) {
            this.scribe.unIndent();
        }
        if (this.preferences.indent_access_specifier_compare_to_type_header) {
            this.scribe.indent();
        }
        IASTDeclaration[] memberDecls = node.getMembers();
        this.scribe.startNewLine();
        int i = 0;
        while (i < memberDecls.length) {
            IASTDeclaration declaration = memberDecls[i];
            if (declaration instanceof ICPPASTVisiblityLabel) {
                if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
                    this.scribe.indent();
                }
                this.scribe.printComment();
                if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
                    this.scribe.unIndent();
                }
                this.visit((ICPPASTVisiblityLabel)declaration);
            } else {
                if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
                    this.scribe.indent();
                }
                declaration.accept(this);
                this.scribe.printComment();
                if (this.preferences.indent_body_declarations_compare_to_access_specifier) {
                    this.scribe.unIndent();
                }
            }
            this.scribe.startNewLine();
            ++i;
        }
        if (this.preferences.indent_access_specifier_compare_to_type_header) {
            this.scribe.unIndent();
        }
        if (this.scribe.numberOfIndentations < braceIndent) {
            this.scribe.indent();
        }
        this.formatClosingBrace(this.preferences.brace_position_for_type_declaration);
        return 1;
    }

    private int visit(ICPPASTVisiblityLabel node) {
        if (!this.preferences.indent_access_specifier_compare_to_type_header) {
            this.scribe.unIndent();
        }
        if (node.getNodeLocations()[0] instanceof IASTMacroExpansion) {
            this.skipNode(node);
        } else {
            switch (node.getVisibility()) {
                case 3: {
                    this.scribe.printNextToken(98, false);
                    break;
                }
                case 2: {
                    this.scribe.printNextToken(99, false);
                    break;
                }
                case 1: {
                    this.scribe.printNextToken(100, false);
                }
            }
            if (this.peekNextToken() != 4) {
                this.scribe.skipToToken(4);
            }
            this.scribe.printNextToken(4, false);
        }
        if (!this.preferences.indent_access_specifier_compare_to_type_header) {
            this.scribe.indent();
        }
        return 1;
    }

    private int visit(ICASTElaboratedTypeSpecifier node) {
        this.formatNode(node);
        return 1;
    }

    private int visit(ICPPASTElaboratedTypeSpecifier node) {
        this.formatNode(node);
        return 1;
    }

    private int visit(IASTEnumerationSpecifier node) {
        this.formatNode(node);
        return 1;
    }

    private void formatList(List elements, ListAlignment align, boolean encloseInParen, boolean addEllipsis) {
        int elementsLength;
        if (encloseInParen) {
            this.scribe.printNextToken(8, align.fSpaceBeforeOpeningParen);
        }
        if ((elementsLength = elements.size()) != 0 || addEllipsis) {
            if (align.fSpaceAfterOpeningParen) {
                this.scribe.space();
            }
            int continuationIndentation = align.fContinuationIndentation >= 0 ? align.fContinuationIndentation : this.preferences.continuation_indentation;
            Alignment listAlignment = this.scribe.createAlignment("listElements_" + align, align.fMode, elementsLength + (addEllipsis ? 1 : 0), this.scribe.scanner.getCurrentPosition(), continuationIndentation, false);
            this.scribe.enterAlignment(listAlignment);
            boolean ok = false;
            do {
                try {
                    int i = 0;
                    while (i < elementsLength) {
                        IASTNode node;
                        if (i > 0) {
                            int token = this.peekNextToken();
                            if (token == 1 ? !this.scribe.skipToToken(6) : token == 9 && (encloseInParen || !this.scribe.skipToToken(6))) break;
                            this.scribe.printNextToken(6, align.fSpaceBeforeComma);
                            this.scribe.printTrailingComment();
                        }
                        this.scribe.alignFragment(listAlignment, i);
                        if (i > 0 && align.fSpaceAfterComma) {
                            this.scribe.space();
                        }
                        if ((node = (IASTNode)elements.get(i)) instanceof ICPPASTConstructorChainInitializer) {
                            this.visit((ICPPASTConstructorChainInitializer)node);
                        } else {
                            node.accept(this);
                        }
                        ++i;
                    }
                    if (addEllipsis) {
                        if (i > 0) {
                            this.scribe.printNextToken(6, align.fSpaceBeforeComma);
                            this.scribe.printTrailingComment();
                        }
                        this.scribe.alignFragment(listAlignment, i);
                        if (i > 0 && align.fSpaceAfterComma) {
                            this.scribe.space();
                        }
                        this.scribe.printNextToken(48);
                    }
                    ok = true;
                }
                catch (AlignmentException e) {
                    this.scribe.redoAlignment(e);
                }
                catch (ASTProblemException aSTProblemException) {}
            } while (!ok);
            this.scribe.exitAlignment(listAlignment, true);
        }
        if (encloseInParen) {
            if (this.peekNextToken() == 1) {
                this.scribe.skipToToken(9);
            }
            this.scribe.printNextToken(9, align.fSpaceBeforeClosingParen);
        }
    }

    private int visit(IASTCompoundStatement node) {
        this.formatBlock(node, this.preferences.brace_position_for_block, this.preferences.insert_space_before_opening_brace_in_block, this.preferences.indent_statements_compare_to_block);
        return 1;
    }

    private int visit(IASTBreakStatement node) {
        this.scribe.printNextToken(61);
        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(IASTConditionalExpression node) {
        node.getLogicalConditionExpression().accept(this);
        Alignment conditionalExpressionAlignment = this.scribe.createAlignment("conditionalExpression", this.preferences.alignment_for_conditional_expression, 2, this.scribe.scanner.getCurrentPosition());
        this.scribe.enterAlignment(conditionalExpressionAlignment);
        boolean ok = false;
        do {
            try {
                this.scribe.alignFragment(conditionalExpressionAlignment, 0);
                this.scribe.printNextToken(7, this.preferences.insert_space_before_question_in_conditional);
                if (this.preferences.insert_space_after_question_in_conditional) {
                    this.scribe.space();
                }
                node.getPositiveResultExpression().accept(this);
                this.scribe.printTrailingComment();
                this.scribe.alignFragment(conditionalExpressionAlignment, 1);
                this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_conditional);
                if (this.preferences.insert_space_after_colon_in_conditional) {
                    this.scribe.space();
                }
                node.getNegativeResultExpression().accept(this);
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(conditionalExpressionAlignment, true);
        return 1;
    }

    private int visit(IASTFunctionCallExpression node) {
        node.getFunctionNameExpression().accept(this);
        IASTExpression paramExpr = node.getParameterExpression();
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_method_invocation);
        if (this.preferences.insert_space_after_opening_paren_in_method_invocation) {
            this.scribe.space();
        }
        if (paramExpr != null) {
            paramExpr.accept(this);
        }
        this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_method_invocation);
        if (this.scribe.printComment()) {
            this.scribe.space();
        }
        return 1;
    }

    private int visit(IASTExpressionList node) {
        List<IASTExpression> expressions = Arrays.asList(node.getExpressions());
        ListAlignment align = new ListAlignment(this.preferences.alignment_for_arguments_in_method_invocation);
        align.fSpaceAfterOpeningParen = this.preferences.insert_space_after_opening_paren_in_method_invocation;
        align.fSpaceBeforeClosingParen = this.preferences.insert_space_before_closing_paren_in_method_invocation;
        align.fSpaceBeforeComma = this.preferences.insert_space_before_comma_in_method_invocation_arguments;
        align.fSpaceAfterComma = this.preferences.insert_space_after_comma_in_method_invocation_arguments;
        this.formatList(expressions, align, false, false);
        return 1;
    }

    private int visit(IASTIdExpression node) {
        node.getName().accept(this);
        return 1;
    }

    private int visit(IASTCastExpression node) {
        switch (node.getOperator()) {
            case 0: {
                this.scribe.printNextToken(8, this.scribe.printComment());
                if (this.scribe.printComment()) {
                    this.scribe.space();
                }
                node.getTypeId().accept(this);
                this.scribe.printNextToken(9, this.scribe.printComment());
                if (this.scribe.printComment()) {
                    this.scribe.space();
                }
                node.getOperand().accept(this);
                if (!this.scribe.printComment()) break;
                this.scribe.space();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.scribe.printNextToken(this.peekNextToken(), this.scribe.printComment());
                this.scribe.printNextToken(42, this.scribe.printComment());
                if (this.scribe.printComment()) {
                    this.scribe.space();
                }
                node.getTypeId().accept(this);
                this.scribe.printNextToken(46, this.scribe.printComment());
                this.scribe.printNextToken(8, this.scribe.printComment());
                node.getOperand().accept(this);
                this.scribe.printNextToken(9, this.scribe.printComment());
                if (!this.scribe.printComment()) break;
                this.scribe.space();
                break;
            }
            default: {
                this.skipToNode(node.getOperand());
            }
        }
        return 1;
    }

    private int visit(IASTTypeIdExpression node) {
        this.scribe.printNextToken(this.peekNextToken());
        this.scribe.printNextToken(8);
        node.getTypeId().accept(this);
        if (this.peekNextToken() == 6) {
            this.scribe.printNextToken(6, this.preferences.insert_space_before_comma_in_method_invocation_arguments);
            this.scribe.printNextToken(this.peekNextToken(), this.preferences.insert_space_after_comma_in_method_invocation_arguments);
            this.scribe.skipToToken(9);
        }
        this.scribe.printNextToken(9);
        return 1;
    }

    private int visit(IASTInitializerExpression node) {
        Alignment expressionAlignment = this.scribe.createAlignment("assignmentExpression", 16, 1, this.scribe.scanner.getCurrentPosition());
        this.scribe.enterAlignment(expressionAlignment);
        boolean ok = false;
        do {
            try {
                this.scribe.alignFragment(expressionAlignment, 0);
                node.getExpression().accept(this);
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(expressionAlignment, true);
        return 1;
    }

    private int visit(IASTInitializerList node) {
        this.scribe.printComment();
        List<IASTInitializer> initializers = Arrays.asList(node.getInitializers());
        if (initializers.isEmpty() && this.preferences.keep_empty_array_initializer_on_one_line) {
            this.scribe.printNextToken(12, this.preferences.insert_space_before_opening_brace_in_array_initializer);
            this.scribe.printNextToken(13, this.preferences.insert_space_between_empty_braces_in_array_initializer);
        } else {
            int line = this.scribe.line;
            String brace_position = this.preferences.brace_position_for_array_initializer;
            this.formatLeftCurlyBrace(line, brace_position);
            this.formatOpeningBrace(brace_position, this.preferences.insert_space_before_opening_brace_in_array_initializer);
            if (this.preferences.insert_new_line_after_opening_brace_in_array_initializer) {
                this.scribe.printNewLine();
            }
            if (this.preferences.insert_space_after_opening_brace_in_array_initializer) {
                this.scribe.space();
            }
            ListAlignment align = new ListAlignment(this.preferences.alignment_for_expressions_in_array_initializer);
            align.fSpaceBeforeComma = this.preferences.insert_space_before_comma_in_array_initializer;
            align.fSpaceAfterComma = this.preferences.insert_space_after_comma_in_array_initializer;
            align.fContinuationIndentation = this.preferences.continuation_indentation_for_array_initializer;
            this.formatList(initializers, align, false, false);
            if (this.preferences.insert_new_line_before_closing_brace_in_array_initializer) {
                this.scribe.startNewLine();
            }
            if (this.preferences.insert_space_before_closing_brace_in_array_initializer) {
                this.scribe.space();
            }
            this.formatClosingBrace(brace_position);
        }
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(IASTUnaryExpression node) {
        IASTExpression operand = node.getOperand();
        int operator = node.getOperator();
        switch (operator) {
            case 11: {
                this.scribe.printNextToken(8, this.scribe.printComment());
                operand.accept(this);
                if (this.peekNextToken() != 9) {
                    this.scribe.skipToToken(9);
                }
                this.scribe.printNextToken(9, this.scribe.printComment());
                break;
            }
            case 0: {
                this.scribe.printNextToken(15, this.scribe.printComment());
                operand.accept(this);
                break;
            }
            case 1: {
                this.scribe.printNextToken(18, this.scribe.printComment());
                operand.accept(this);
                break;
            }
            case 9: {
                operand.accept(this);
                this.scribe.printNextToken(15, this.scribe.printComment());
                break;
            }
            case 10: {
                operand.accept(this);
                this.scribe.printNextToken(18, this.scribe.printComment());
                break;
            }
            case 3: {
                this.scribe.printNextToken(21, this.scribe.printComment());
                operand.accept(this);
                break;
            }
            case 2: {
                this.scribe.printNextToken(16, this.scribe.printComment());
                operand.accept(this);
                break;
            }
            case 7: {
                this.scribe.printNextToken(36, this.scribe.printComment());
                operand.accept(this);
                break;
            }
            case 5: {
                this.scribe.printNextToken(30, this.scribe.printComment());
                operand.accept(this);
                break;
            }
            case 4: {
                this.scribe.printNextToken(23, this.scribe.printComment());
                operand.accept(this);
                break;
            }
            case 6: {
                this.scribe.printNextToken(34, this.scribe.printComment());
                operand.accept(this);
                break;
            }
            case 8: {
                this.scribe.printNextToken(105, this.scribe.printComment());
                if (this.peekNextToken() != 8) {
                    this.scribe.space();
                }
                operand.accept(this);
                break;
            }
            default: {
                this.formatNode(node);
            }
        }
        return 1;
    }

    private int visit(IASTBinaryExpression node) {
        IASTExpression op1 = node.getOperand1();
        op1.accept(this);
        Alignment expressionAlignment = this.scribe.createAlignment("binaryExpression", 16, 1, this.scribe.scanner.getCurrentPosition());
        this.scribe.enterAlignment(expressionAlignment);
        boolean ok = false;
        do {
            try {
                this.scribe.alignFragment(expressionAlignment, 0);
                this.scribe.printNextToken(this.peekNextToken(), this.scribe.printComment());
                if (this.scribe.printComment()) {
                    this.scribe.space();
                }
                IASTExpression op2 = node.getOperand2();
                op2.accept(this);
                ok = true;
            }
            catch (AlignmentException e) {
                this.scribe.redoAlignment(e);
            }
        } while (!ok);
        this.scribe.exitAlignment(expressionAlignment, true);
        return 1;
    }

    /*
     * Exception decompiling
     */
    private int visit(IASTLiteralExpression node) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 133->139)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int visit(IASTContinueStatement node) {
        this.scribe.printNextToken(70);
        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(IASTDoStatement node) {
        this.scribe.printNextToken(73);
        int line = this.scribe.line;
        IASTStatement action = node.getBody();
        if (action != null) {
            if (action instanceof IASTCompoundStatement) {
                this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_block);
                this.visit((IASTCompoundStatement)action);
            } else if (action instanceof IASTNullStatement) {
                this.scribe.indent();
                this.visit((IASTNullStatement)((Object)this));
                this.scribe.unIndent();
            } else {
                this.scribe.startNewLine();
                this.scribe.indent();
                action.accept(this);
                this.scribe.unIndent();
                this.scribe.startNewLine();
            }
        }
        if (this.preferences.insert_new_line_before_while_in_do_statement) {
            this.scribe.startNewLine();
        }
        this.scribe.printNextToken(126, this.preferences.insert_space_after_closing_brace_in_block);
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_while);
        if (this.preferences.insert_space_after_opening_paren_in_while) {
            this.scribe.space();
        }
        node.getCondition().accept(this);
        this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_while);
        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(IASTNullStatement node) {
        if (this.peekNextToken() == 1) {
            this.skipToNode(node);
        }
        if (!this.fInsideFor) {
            this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
            this.scribe.printTrailingComment();
        }
        return 1;
    }

    private int visit(IASTDeclarationStatement node) {
        node.getDeclaration().accept(this);
        if (!this.fInsideFor) {
            this.scribe.startNewLine();
        }
        return 1;
    }

    private int visit(IASTExpressionStatement node) {
        node.getExpression().accept(this);
        if (!this.fInsideFor) {
            this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
            this.scribe.printTrailingComment();
        }
        return 1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int visit(IASTForStatement node) {
        this.scribe.printNextToken(83);
        int line = this.scribe.line;
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_for);
        this.fInsideFor = true;
        try {
            IASTExpression iterationExpr;
            IASTExpression condition;
            if (this.preferences.insert_space_after_opening_paren_in_for) {
                this.scribe.space();
            }
            IASTStatement initializerStmt = node.getInitializerStatement();
            initializerStmt.accept(this);
            if (this.peekNextToken() == 5) {
                this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon_in_for);
            }
            if ((condition = node.getConditionExpression()) != null) {
                if (this.preferences.insert_space_after_semicolon_in_for) {
                    this.scribe.space();
                }
                condition.accept(this);
            }
            if (this.peekNextToken() == 5) {
                this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon_in_for);
            }
            if ((iterationExpr = node.getIterationExpression()) != null) {
                if (this.preferences.insert_space_after_semicolon_in_for) {
                    this.scribe.space();
                }
                iterationExpr.accept(this);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fInsideFor = false;
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.fInsideFor = false;
            this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_for);
            this.formatAction(line, node.getBody(), this.preferences.brace_position_for_block, this.preferences.insert_space_before_opening_brace_in_block);
            return 1;
        }
    }

    private int visit(IASTIfStatement node) {
        IASTExpression condExpr;
        this.scribe.printNextToken(86);
        int line = this.scribe.line;
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_if);
        if (this.preferences.insert_space_after_opening_paren_in_if) {
            this.scribe.space();
        }
        if ((condExpr = node.getConditionExpression()) instanceof IASTProblemExpression) {
            this.scribe.skipToToken(9);
        } else {
            condExpr.accept(this);
        }
        this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_if);
        IASTStatement thenStatement = node.getThenClause();
        IASTStatement elseStatement = node.getElseClause();
        boolean thenStatementIsBlock = false;
        if (thenStatement != null) {
            if (thenStatement instanceof IASTCompoundStatement) {
                IASTCompoundStatement block = (IASTCompoundStatement)thenStatement;
                thenStatementIsBlock = true;
                List<IASTStatement> statements = Arrays.asList(block.getStatements());
                if (this.isGuardClause(block, statements) && elseStatement == null && this.preferences.keep_guardian_clause_on_one_line) {
                    this.scribe.printNextToken(12, this.preferences.insert_space_before_opening_brace_in_block);
                    this.scribe.space();
                    statements.get(0).accept(this);
                    this.scribe.printNextToken(13, true);
                    this.scribe.printTrailingComment();
                } else {
                    this.formatLeftCurlyBrace(line, this.preferences.brace_position_for_block);
                    thenStatement.accept(this);
                    if (elseStatement != null && this.preferences.insert_new_line_before_else_in_if_statement) {
                        this.scribe.startNewLine();
                    }
                }
            } else if (elseStatement == null && this.preferences.keep_simple_if_on_one_line) {
                Alignment compactIfAlignment = this.scribe.createAlignment("compactIf", this.preferences.alignment_for_compact_if, 1, 1, this.scribe.scanner.getCurrentPosition(), 1, false);
                this.scribe.enterAlignment(compactIfAlignment);
                boolean ok = false;
                do {
                    try {
                        this.scribe.alignFragment(compactIfAlignment, 0);
                        this.scribe.space();
                        thenStatement.accept(this);
                        ok = true;
                    }
                    catch (AlignmentException e) {
                        this.scribe.redoAlignment(e);
                    }
                } while (!ok);
                this.scribe.exitAlignment(compactIfAlignment, true);
            } else if (this.preferences.keep_then_statement_on_same_line) {
                this.scribe.space();
                thenStatement.accept(this);
                if (elseStatement != null) {
                    this.scribe.startNewLine();
                }
            } else {
                this.scribe.printTrailingComment();
                this.scribe.startNewLine();
                this.scribe.indent();
                thenStatement.accept(this);
                if (elseStatement != null) {
                    this.scribe.startNewLine();
                }
                this.scribe.unIndent();
            }
        }
        if (elseStatement != null) {
            if (thenStatementIsBlock) {
                this.scribe.printNextToken(76, this.preferences.insert_space_after_closing_brace_in_block);
            } else {
                this.scribe.printNextToken(76, true);
            }
            if (elseStatement instanceof IASTCompoundStatement) {
                elseStatement.accept(this);
            } else if (elseStatement instanceof IASTIfStatement) {
                if (!this.preferences.compact_else_if) {
                    this.scribe.startNewLine();
                    this.scribe.indent();
                }
                this.scribe.space();
                elseStatement.accept(this);
                if (!this.preferences.compact_else_if) {
                    this.scribe.unIndent();
                }
            } else if (this.preferences.keep_else_statement_on_same_line) {
                this.scribe.space();
                elseStatement.accept(this);
            } else {
                this.scribe.startNewLine();
                this.scribe.indent();
                elseStatement.accept(this);
                this.scribe.unIndent();
            }
        }
        return 1;
    }

    private int visit(ICPPASTQualifiedName node) {
        IASTName[] names = node.getNames();
        int i = 0;
        while (i < names.length - 1) {
            names[i].accept(this);
            this.scribe.printNextToken(3);
            ++i;
        }
        if (this.peekNextToken() == 34) {
            this.scribe.printNextToken(34, false);
        }
        this.scribe.printNextToken(1, false);
        return 1;
    }

    private int visit(ICPPASTTemplateId node) {
        IASTNode[] templateArguments;
        IASTName name = node.getTemplateName();
        name.accept(this);
        this.scribe.printNextToken(42, this.scribe.printComment());
        if (this.scribe.printComment()) {
            this.scribe.space();
        }
        if ((templateArguments = node.getTemplateArguments()).length > 0) {
            ListAlignment align = new ListAlignment(16);
            this.formatList(Arrays.asList(templateArguments), align, false, false);
        }
        this.scribe.printNextToken(46, this.scribe.printComment());
        return 1;
    }

    private int visit(IASTReturnStatement node) {
        this.scribe.printNextToken(103);
        IASTExpression expression = node.getReturnValue();
        if (expression != null) {
            this.scribe.space();
            expression.accept(this);
        }
        if (expression == null && 5 != this.peekNextToken()) {
            this.scribe.skipToToken(5);
        }
        this.scribe.printNextToken(5, this.preferences.insert_space_before_semicolon);
        this.scribe.printTrailingComment();
        return 1;
    }

    private int visit(IASTLabelStatement node) {
        node.getName().accept(this);
        this.scribe.printNextToken(4, false);
        this.scribe.space();
        node.getNestedStatement().accept(this);
        return 1;
    }

    private int visit(IASTCaseStatement node) {
        IASTExpression constant = node.getExpression();
        if (constant == null) {
            this.scribe.printNextToken(71);
            this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_default);
        } else {
            this.scribe.printNextToken(62);
            this.scribe.space();
            constant.accept(this);
            this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_case);
        }
        return 1;
    }

    private int visit(IASTDefaultStatement node) {
        this.scribe.printNextToken(71);
        this.scribe.printNextToken(4, this.preferences.insert_space_before_colon_in_default);
        return 1;
    }

    private int visit(IASTSwitchStatement node) {
        IASTStatement bodyStmt;
        int headerIndent = this.scribe.numberOfIndentations;
        this.scribe.printNextToken(110);
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_switch);
        if (this.preferences.insert_space_after_opening_paren_in_switch) {
            this.scribe.space();
        }
        node.getControllerExpression().accept(this);
        this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_switch);
        String switch_brace = this.preferences.brace_position_for_switch;
        this.formatOpeningBrace(switch_brace, this.preferences.insert_space_before_opening_brace_in_switch);
        this.scribe.startNewLine();
        int braceIndent = this.scribe.numberOfIndentations;
        if (braceIndent > headerIndent) {
            this.scribe.unIndent();
        }
        if (this.preferences.indent_switchstatements_compare_to_switch) {
            this.scribe.indent();
        }
        List<IASTStatement> statements = (bodyStmt = node.getBody()) instanceof IASTCompoundStatement ? Arrays.asList(((IASTCompoundStatement)bodyStmt).getStatements()) : Collections.singletonList(bodyStmt);
        int statementsLength = statements.size();
        boolean wasACase = false;
        boolean wasAStatement = false;
        if (statementsLength != 0) {
            int i = 0;
            while (i < statementsLength) {
                IASTStatement statement = statements.get(i);
                if (statement instanceof IASTCaseStatement || statement instanceof IASTDefaultStatement) {
                    if (wasACase) {
                        this.scribe.startNewLine();
                    }
                    if ((wasACase || wasAStatement) && this.preferences.indent_switchstatements_compare_to_cases) {
                        this.scribe.unIndent();
                    }
                    statement.accept(this);
                    this.scribe.printTrailingComment();
                    wasACase = true;
                    wasAStatement = false;
                    if (this.preferences.indent_switchstatements_compare_to_cases) {
                        this.scribe.indent();
                    }
                } else if (statement instanceof IASTBreakStatement) {
                    if (this.preferences.indent_breaks_compare_to_cases) {
                        if (!this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.indent();
                        }
                    } else if ((wasACase || wasAStatement) && this.preferences.indent_switchstatements_compare_to_cases) {
                        this.scribe.unIndent();
                    }
                    if (wasACase) {
                        this.scribe.startNewLine();
                    }
                    statement.accept(this);
                    if (this.preferences.indent_breaks_compare_to_cases) {
                        if (!this.preferences.indent_switchstatements_compare_to_cases) {
                            this.scribe.unIndent();
                        }
                    } else if (this.preferences.indent_switchstatements_compare_to_cases) {
                        this.scribe.indent();
                    }
                    wasACase = false;
                    wasAStatement = true;
                } else if (statement instanceof IASTCompoundStatement) {
                    block38: {
                        IASTStatement nextStatement;
                        String bracePosition;
                        if (wasACase) {
                            block37: {
                                if (this.preferences.indent_switchstatements_compare_to_cases) {
                                    this.scribe.unIndent();
                                }
                                bracePosition = this.preferences.brace_position_for_block_in_case;
                                try {
                                    this.formatBlock((IASTCompoundStatement)statement, bracePosition, this.preferences.insert_space_after_colon_in_case, this.preferences.indent_statements_compare_to_block);
                                }
                                catch (ASTProblemException aSTProblemException) {
                                    if (i >= statementsLength - 1) break block37;
                                    nextStatement = statements.get(i + 1);
                                    this.skipToNode(nextStatement);
                                }
                            }
                            if (this.preferences.indent_switchstatements_compare_to_cases) {
                                this.scribe.indent();
                            }
                        } else {
                            bracePosition = this.preferences.brace_position_for_block;
                            try {
                                this.formatBlock((IASTCompoundStatement)statement, bracePosition, this.preferences.insert_space_before_opening_brace_in_block, this.preferences.indent_statements_compare_to_block);
                            }
                            catch (ASTProblemException aSTProblemException) {
                                if (i >= statementsLength - 1) break block38;
                                nextStatement = statements.get(i + 1);
                                this.skipToNode(nextStatement);
                            }
                        }
                    }
                    wasAStatement = true;
                    wasACase = false;
                } else {
                    block39: {
                        this.scribe.startNewLine();
                        try {
                            statement.accept(this);
                        }
                        catch (ASTProblemException aSTProblemException) {
                            if (i >= statementsLength - 1) break block39;
                            IASTStatement nextStatement = statements.get(i + 1);
                            this.skipToNode(nextStatement);
                        }
                    }
                    wasAStatement = true;
                    wasACase = false;
                }
                if (!wasACase) {
                    this.scribe.startNewLine();
                }
                this.scribe.printComment();
                ++i;
            }
        }
        if ((wasACase || wasAStatement) && this.preferences.indent_switchstatements_compare_to_cases) {
            this.scribe.unIndent();
        }
        if (this.preferences.indent_switchstatements_compare_to_switch) {
            this.scribe.unIndent();
        }
        if (this.scribe.numberOfIndentations < braceIndent) {
            this.scribe.indent();
        }
        this.scribe.startNewLine();
        this.formatClosingBrace(switch_brace);
        return 1;
    }

    private int visit(IASTWhileStatement node) {
        this.scribe.printNextToken(126);
        int line = this.scribe.line;
        this.scribe.printNextToken(8, this.preferences.insert_space_before_opening_paren_in_while);
        if (this.preferences.insert_space_after_opening_paren_in_while) {
            this.scribe.space();
        }
        node.getCondition().accept(this);
        this.scribe.printNextToken(9, this.preferences.insert_space_before_closing_paren_in_while);
        this.formatAction(line, node.getBody(), this.preferences.brace_position_for_block, this.preferences.insert_space_before_opening_brace_in_block);
        return 1;
    }

    private int visit(IASTProblemStatement node) {
        throw new ASTProblemException(node.getProblem());
    }

    private int visit(IASTProblemExpression node) {
        throw new ASTProblemException(node.getProblem());
    }

    private int visit(IASTProblemDeclaration node) {
        throw new ASTProblemException(node.getProblem());
    }

    private void formatNode(IASTNode node) {
        IASTFileLocation maxLocation;
        IASTNodeLocation[] locations = node.getNodeLocations();
        IASTFileLocation minLocation = CodeFormatterVisitor.getMinFileLocation(locations);
        if (minLocation != null && (maxLocation = CodeFormatterVisitor.getMaxFileLocation(locations)) != null) {
            int startOffset = minLocation.getNodeOffset();
            int endOffset = maxLocation.getNodeOffset() + maxLocation.getNodeLength();
            this.scribe.printRaw(startOffset, endOffset - startOffset);
        }
    }

    private static IASTFileLocation getMaxFileLocation(IASTNodeLocation[] locations) {
        if (locations == null || locations.length == 0) {
            return null;
        }
        IASTNodeLocation nodeLocation = locations[locations.length - 1];
        if (nodeLocation instanceof IASTFileLocation) {
            return (IASTFileLocation)nodeLocation;
        }
        if (nodeLocation instanceof IASTMacroExpansion) {
            IASTNodeLocation[] macroLocations = ((IASTMacroExpansion)nodeLocation).getExpansionLocations();
            return CodeFormatterVisitor.getMaxFileLocation(macroLocations);
        }
        return null;
    }

    private static IASTFileLocation getMinFileLocation(IASTNodeLocation[] locations) {
        if (locations == null || locations.length == 0) {
            return null;
        }
        IASTNodeLocation nodeLocation = locations[0];
        if (nodeLocation instanceof IASTFileLocation) {
            return (IASTFileLocation)nodeLocation;
        }
        if (nodeLocation instanceof IASTMacroExpansion) {
            IASTNodeLocation[] macroLocations = ((IASTMacroExpansion)nodeLocation).getExpansionLocations();
            return CodeFormatterVisitor.getMinFileLocation(macroLocations);
        }
        return null;
    }

    private void exitAlignments() {
        while (this.scribe.currentAlignment != null) {
            this.scribe.exitAlignment(this.scribe.currentAlignment, true);
        }
    }

    private void skipNode(IASTNode node) {
        int currentOffset;
        int endOffset;
        int restLength;
        IASTNodeLocation[] locations = node.getNodeLocations();
        IASTFileLocation maxLocation = CodeFormatterVisitor.getMaxFileLocation(locations);
        if (maxLocation != null && (restLength = (endOffset = maxLocation.getNodeOffset() + maxLocation.getNodeLength()) - (currentOffset = this.scribe.scanner.getCurrentTokenEndPosition() + 1)) > 0) {
            this.scribe.printRaw(currentOffset, restLength);
        }
    }

    private void skipToNode(IASTNode node) {
        int currentOffset;
        int startOffset;
        int restLength;
        IASTNodeLocation[] locations = node.getNodeLocations();
        IASTFileLocation minLocation = CodeFormatterVisitor.getMinFileLocation(locations);
        if (minLocation != null && (restLength = (startOffset = minLocation.getNodeOffset()) - (currentOffset = this.scribe.scanner.getCurrentTokenEndPosition() + 1)) > 0) {
            this.scribe.printRaw(currentOffset, restLength);
        }
    }

    private void formatAction(int line, IASTStatement stmt, String brace_position, boolean insertLineForSingleStatement) {
        if (stmt != null) {
            if (stmt instanceof IASTCompoundStatement) {
                this.formatLeftCurlyBrace(line, brace_position);
                this.formatBlock((IASTCompoundStatement)stmt, brace_position, this.preferences.insert_space_before_opening_brace_in_block, this.preferences.indent_statements_compare_to_block);
            } else if (stmt instanceof IASTNullStatement) {
                this.scribe.indent();
                if (this.preferences.put_empty_statement_on_new_line) {
                    this.scribe.startNewLine();
                }
                this.visit((IASTNullStatement)stmt);
                this.scribe.unIndent();
            } else {
                this.scribe.startNewLine();
                this.scribe.indent();
                stmt.accept(this);
                this.scribe.unIndent();
                if (insertLineForSingleStatement) {
                    this.scribe.startNewLine();
                }
            }
        }
    }

    private void formatBlock(IASTCompoundStatement block, String block_brace_position, boolean insertSpaceBeforeOpeningBrace, boolean indentStatements) {
        IASTNodeLocation[] locations = block.getNodeLocations();
        if (locations.length == 0) {
            return;
        }
        if (locations[0] instanceof IASTMacroExpansion) {
            this.formatNode(block);
            return;
        }
        this.formatOpeningBrace(block_brace_position, insertSpaceBeforeOpeningBrace);
        IASTStatement[] statements = block.getStatements();
        int statementsLength = statements.length;
        if (statementsLength != 0) {
            this.scribe.startNewLine();
            if (indentStatements) {
                this.scribe.indent();
            }
            this.formatStatements(Arrays.asList(statements), true);
            this.scribe.printComment();
            if (indentStatements) {
                this.scribe.unIndent();
            }
        } else {
            if (this.preferences.insert_new_line_in_empty_block) {
                this.scribe.startNewLine();
            }
            if (indentStatements) {
                this.scribe.indent();
            }
            this.scribe.printComment();
            if (indentStatements) {
                this.scribe.unIndent();
            }
        }
        this.formatClosingBrace(block_brace_position);
    }

    private void formatLeftCurlyBrace(int line, String bracePosition) {
        this.scribe.printComment();
        if ("next_line_on_wrap".equals(bracePosition) && (this.scribe.line > line || this.scribe.column >= this.preferences.page_width)) {
            this.scribe.startNewLine();
        }
    }

    private void formatOpeningBrace(String bracePosition, boolean insertSpaceBeforeBrace) {
        if ("next_line".equals(bracePosition)) {
            this.scribe.startNewLine();
        } else if ("next_line_shifted".equals(bracePosition)) {
            this.scribe.startNewLine();
            this.scribe.indent();
        }
        this.scribe.printNextToken(12, insertSpaceBeforeBrace);
        this.scribe.printTrailingComment();
    }

    private void formatClosingBrace(String brace_position) {
        this.scribe.printNextToken(13);
        this.scribe.printTrailingComment();
        if ("next_line_shifted".equals(brace_position)) {
            this.scribe.unIndent();
        }
    }

    private void formatStatements(List statements, boolean insertNewLineAfterLastStatement) {
        int statementsLength = statements.size();
        if (statementsLength > 1) {
            IASTStatement previousStatement = (IASTStatement)statements.get(0);
            try {
                previousStatement.accept(this);
            }
            catch (ASTProblemException aSTProblemException) {
                this.skipToNode((IASTStatement)statements.get(1));
            }
            boolean previousStatementIsNullStmt = previousStatement instanceof IASTNullStatement;
            int i = 1;
            while (i < statementsLength - 1) {
                IASTStatement statement = (IASTStatement)statements.get(i);
                boolean statementIsNullStmt = statement instanceof IASTNullStatement;
                if (previousStatementIsNullStmt && !statementIsNullStmt || !previousStatementIsNullStmt && !statementIsNullStmt) {
                    this.scribe.startNewLine();
                }
                try {
                    statement.accept(this);
                }
                catch (ASTProblemException aSTProblemException) {
                    this.skipToNode((IASTStatement)statements.get(i + 1));
                }
                previousStatement = statement;
                ++i;
            }
            IASTStatement statement = (IASTStatement)statements.get(statementsLength - 1);
            boolean statementIsNullStmt = statement instanceof IASTNullStatement;
            if (previousStatementIsNullStmt && !statementIsNullStmt || !previousStatementIsNullStmt && !statementIsNullStmt) {
                this.scribe.startNewLine();
            }
            statement.accept(this);
        } else {
            IASTStatement statement = (IASTStatement)statements.get(0);
            statement.accept(this);
        }
        if (insertNewLineAfterLastStatement) {
            this.scribe.startNewLine();
        }
    }

    private boolean commentStartsBlock(int start, int end) {
        this.localScanner.resetTo(start, end);
        if (this.localScanner.getNextToken() == 12) {
            switch (this.localScanner.getNextToken()) {
                case 1001: 
                case 1002: {
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean hasComments() {
        this.localScanner.resetTo(this.scribe.scanner.startPosition, this.scribe.scannerEndPosition - 1);
        int token = this.localScanner.getNextToken();
        switch (token) {
            case 1001: 
            case 1002: {
                return true;
            }
        }
        return false;
    }

    protected int peekNextToken() {
        this.localScanner.resetTo(this.scribe.scanner.getCurrentPosition(), this.scribe.scannerEndPosition - 1);
        int token = this.localScanner.getNextToken();
        block3: while (true) {
            switch (token) {
                case 1001: 
                case 1002: {
                    token = this.localScanner.getNextToken();
                    continue block3;
                }
            }
            break;
        }
        return token;
    }

    protected boolean isClosingTemplateToken() {
        this.localScanner.resetTo(this.scribe.scanner.getCurrentPosition(), this.scribe.scannerEndPosition - 1);
        int token = this.localScanner.getNextToken();
        block6: while (true) {
            switch (token) {
                case 1001: 
                case 1002: {
                    token = this.localScanner.getNextToken();
                    continue block6;
                }
            }
            break;
        }
        switch (token) {
            case 44: 
            case 46: {
                return true;
            }
        }
        return false;
    }

    private boolean isGuardClause(IASTCompoundStatement block, List statements) {
        int blockLength;
        IASTNodeLocation[] locations = block.getNodeLocations();
        if (locations.length == 0) {
            return false;
        }
        if (locations[0] instanceof IASTMacroExpansion) {
            return false;
        }
        IASTFileLocation fileLocation = block.getFileLocation();
        if (fileLocation == null) {
            return false;
        }
        int blockStartPosition = block.getFileLocation().getNodeOffset();
        if (this.commentStartsBlock(blockStartPosition, blockLength = block.getFileLocation().getNodeLength())) {
            return false;
        }
        int statementsLength = statements.size();
        if (statementsLength != 1) {
            return false;
        }
        return statements.get(0) instanceof IASTReturnStatement;
    }

    private static List collectInactiveCodePositions(IASTTranslationUnit translationUnit) {
        if (translationUnit == null) {
            return Collections.EMPTY_LIST;
        }
        String fileName = translationUnit.getFilePath();
        if (fileName == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Position> positions = new ArrayList<Position>();
        int inactiveCodeStart = -1;
        boolean inInactiveCode = false;
        Stack<Boolean> inactiveCodeStack = new Stack<Boolean>();
        IASTPreprocessorStatement[] preprocStmts = translationUnit.getAllPreprocessorStatements();
        int i = 0;
        while (i < preprocStmts.length) {
            IASTFileLocation nodeLocation;
            IASTPreprocessorStatement statement = preprocStmts[i];
            if (fileName.equals(statement.getContainingFilename()) && (nodeLocation = statement.getFileLocation()) != null) {
                int inactiveCodeEnd;
                if (statement instanceof IASTPreprocessorIfStatement) {
                    IASTPreprocessorIfStatement ifStmt = (IASTPreprocessorIfStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfdefStatement) {
                    IASTPreprocessorIfdefStatement ifdefStmt = (IASTPreprocessorIfdefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifdefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfndefStatement) {
                    IASTPreprocessorIfndefStatement ifndefStmt = (IASTPreprocessorIfndefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifndefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorElseStatement) {
                    IASTPreprocessorElseStatement elseStmt = (IASTPreprocessorElseStatement)statement;
                    if (!elseStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    } else if (elseStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = nodeLocation.getNodeOffset();
                        positions.add(new Position(inactiveCodeStart, inactiveCodeEnd - inactiveCodeStart));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorElifStatement) {
                    IASTPreprocessorElifStatement elifStmt = (IASTPreprocessorElifStatement)statement;
                    if (!elifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = nodeLocation.getNodeOffset() + nodeLocation.getNodeLength();
                        inInactiveCode = true;
                    } else if (elifStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = nodeLocation.getNodeOffset();
                        positions.add(new Position(inactiveCodeStart, inactiveCodeEnd - inactiveCodeStart));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorEndifStatement) {
                    try {
                        boolean wasInInactiveCode = (Boolean)inactiveCodeStack.pop();
                        if (inInactiveCode && !wasInInactiveCode) {
                            inactiveCodeEnd = nodeLocation.getNodeOffset();
                            positions.add(new Position(inactiveCodeStart, inactiveCodeEnd - inactiveCodeStart));
                        }
                        inInactiveCode = wasInInactiveCode;
                    }
                    catch (EmptyStackException emptyStackException) {}
                }
            }
            ++i;
        }
        return positions;
    }

    private static class ASTProblemException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private IASTProblem fProblem;

        ASTProblemException(IASTProblem problem) {
            this.fProblem = problem;
        }

        public String getMessage() {
            String message = this.fProblem.getMessage();
            if (this.fProblem.getFileLocation() != null) {
                int line = this.fProblem.getFileLocation().getStartingLineNumber();
                message = String.valueOf(message) + " (line " + line + ')';
            }
            return message;
        }
    }

    private static class ListAlignment {
        public int fMode;
        public boolean fSpaceBeforeComma;
        public boolean fSpaceAfterComma = true;
        public boolean fSpaceAfterOpeningParen;
        public boolean fSpaceBeforeClosingParen;
        public boolean fSpaceBeforeOpeningParen;
        public int fContinuationIndentation = -1;

        public ListAlignment(int mode) {
            this.fMode = mode;
        }
    }
}

