/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConstants;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIMemoryChangedEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIResumedEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIObject;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegister;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDITargetConfiguration3;
import org.eclipse.cdt.debug.core.cdi.model.ICDIValue;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIArrayValue;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.core.model.CVariableFormat;
import org.eclipse.cdt.debug.core.model.ICRegister;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.IRegisterDescriptor;
import org.eclipse.cdt.debug.internal.core.model.AbstractCValue;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CRegisterDescriptor;
import org.eclipse.cdt.debug.internal.core.model.CRegisterGroup;
import org.eclipse.cdt.debug.internal.core.model.CStackFrame;
import org.eclipse.cdt.debug.internal.core.model.CType;
import org.eclipse.cdt.debug.internal.core.model.CValueFactory;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;

public class CRegister
extends CVariable
implements ICRegister {
    protected CRegister(CRegisterGroup parent, IRegisterDescriptor descriptor) {
        super(parent, ((CRegisterDescriptor)descriptor).getCDIDescriptor());
        this.setFormat(CVariableFormat.getFormat(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_REGISTER_FORMAT)));
    }

    protected CRegister(CRegisterGroup parent, IRegisterDescriptor descriptor, String message) {
        super(parent, ((CRegisterDescriptor)descriptor).getCDIDescriptor(), message);
        this.setFormat(CVariableFormat.getFormat(CDebugCorePlugin.getDefault().getPluginPreferences().getInt(ICDebugConstants.PREF_DEFAULT_REGISTER_FORMAT)));
    }

    public IRegisterGroup getRegisterGroup() throws DebugException {
        return (IRegisterGroup)this.getParent();
    }

    protected boolean isBookkeepingEnabled() {
        boolean result = false;
        try {
            result = this.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.cdt.launch.ENABLE_REGISTER_BOOKKEEPING", false);
        }
        catch (CoreException coreException) {}
        return result;
    }

    public boolean canEnableDisable() {
        return true;
    }

    public void handleDebugEvents(ICDIEvent[] events) {
        int i = 0;
        while (i < events.length) {
            ICDIEvent event = events[i];
            ICDIObject source = event.getSource();
            if (source != null) {
                ICDITarget cdiTarget = source.getTarget();
                if (event instanceof ICDIResumedEvent) {
                    if (this.getCDITarget().equals(cdiTarget)) {
                        this.setChanged(false);
                    }
                } else if (event instanceof ICDIMemoryChangedEvent && cdiTarget.getConfiguration() instanceof ICDITargetConfiguration3 && ((ICDITargetConfiguration3)cdiTarget.getConfiguration()).needsRegistersUpdated(event)) {
                    this.resetValue();
                    return;
                }
            }
            ++i;
        }
        super.handleDebugEvents(events);
    }

    public void dispose() {
        this.internalDispose(true);
        this.setDisposed(true);
    }

    protected ICStackFrame getStackFrame() {
        ICStackFrame frame = super.getStackFrame();
        if (frame == null) {
            frame = this.getCurrentStackFrame();
        }
        return frame;
    }

    protected CStackFrame getCurrentStackFrame() {
        return ((CDebugTarget)this.getDebugTarget()).getRegisterManager().getCurrentFrame();
    }

    protected void createOriginal(ICDIVariableDescriptor vo) {
        if (vo != null) {
            this.setName(vo.getName());
            this.setOriginal(new InternalVariable(this, vo));
        }
    }

    private class InternalVariable
    implements CVariable.IInternalVariable {
        private CVariable fVariable;
        private ICDIVariableDescriptor fCDIVariableObject;
        private ICDIRegister fCDIRegister;
        private CType fType;
        private String fQualifiedName;
        private ICValue fValue = CValueFactory.NULL_VALUE;
        private boolean fChanged = false;

        InternalVariable(CVariable var, ICDIVariableDescriptor varObject) {
            this.setVariable(var);
            this.setCDIVariableObject(varObject);
            this.setCDIRegister(varObject instanceof ICDIRegister ? (ICDIRegister)varObject : null);
        }

        public CVariable.IInternalVariable createShadow(int start, int length) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getCDIVariableObject().getVariableDescriptorAsArray(start, length));
            }
            catch (CDIException e) {
                CRegister.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        public CVariable.IInternalVariable createShadow(String type) throws DebugException {
            InternalVariable iv = null;
            try {
                iv = new InternalVariable(this.getVariable(), this.getCDIVariableObject().getVariableDescriptorAsType(type));
            }
            catch (CDIException e) {
                CRegister.requestFailed(e.getMessage(), null);
            }
            return iv;
        }

        private synchronized ICDIRegister getCDIRegister() throws DebugException {
            if (this.fCDIRegister == null) {
                try {
                    this.fCDIRegister = CRegister.this.getCDITarget().createRegister((ICDIRegisterDescriptor)this.getCDIVariableObject());
                }
                catch (CDIException e) {
                    CRegister.requestFailed(e.getMessage(), null);
                }
            }
            return this.fCDIRegister;
        }

        private void setCDIRegister(ICDIRegister register) {
            this.fCDIRegister = register;
        }

        private ICDIVariableDescriptor getCDIVariableObject() {
            if (this.fCDIRegister != null) {
                return this.fCDIRegister;
            }
            return this.fCDIVariableObject;
        }

        private void setCDIVariableObject(ICDIVariableDescriptor variableObject) {
            this.fCDIVariableObject = variableObject;
        }

        public String getQualifiedName() throws DebugException {
            if (this.fQualifiedName == null) {
                try {
                    this.fQualifiedName = this.fCDIVariableObject != null ? this.fCDIVariableObject.getQualifiedName() : null;
                }
                catch (CDIException e) {
                    CRegister.requestFailed(e.getMessage(), null);
                }
            }
            return this.fQualifiedName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CType getType() throws DebugException {
            ICDIVariableDescriptor varObject;
            if (this.fType == null && (varObject = this.getCDIVariableObject()) != null) {
                InternalVariable internalVariable = this;
                synchronized (internalVariable) {
                    if (this.fType == null) {
                        try {
                            this.fType = new CType(varObject.getType());
                        }
                        catch (CDIException e) {
                            CRegister.requestFailed(e.getMessage(), null);
                        }
                    }
                }
            }
            return this.fType;
        }

        private synchronized void invalidate(boolean destroy) {
            try {
                if (destroy && this.fCDIRegister != null) {
                    this.fCDIRegister.dispose();
                }
            }
            catch (CDIException e) {
                CRegister.this.logError(e.getMessage());
            }
            this.invalidateValue();
            this.setCDIRegister(null);
            if (this.fType != null) {
                this.fType.dispose();
            }
            this.fType = null;
        }

        public void dispose(boolean destroy) {
            this.invalidate(destroy);
        }

        public boolean isSameVariable(ICDIVariable cdiVar) {
            return this.fCDIRegister != null ? this.fCDIRegister.equals(cdiVar) : false;
        }

        public int sizeof() {
            if (this.getCDIVariableObject() != null) {
                try {
                    return this.getCDIVariableObject().sizeof();
                }
                catch (CDIException cDIException) {}
            }
            return 0;
        }

        public boolean isArgument() {
            return this.getCDIVariableObject() instanceof ICDIArgumentDescriptor;
        }

        public void setValue(String expression) throws DebugException {
            ICDIRegister cdiRegister = null;
            try {
                cdiRegister = this.getCDIRegister();
                if (cdiRegister != null) {
                    cdiRegister.setValue(expression);
                } else {
                    CRegister.requestFailed(CoreModelMessages.getString("CModificationVariable.0"), null);
                }
            }
            catch (CDIException e) {
                CRegister.targetRequestFailed(e.getMessage(), null);
            }
        }

        public synchronized ICValue getValue() throws DebugException {
            ICDIRegister reg;
            if (this.fValue.equals(CValueFactory.NULL_VALUE) && (reg = this.getCDIRegister()) != null) {
                try {
                    ICDIValue cdiValue = reg.getValue(CRegister.this.getCurrentStackFrame().getCDIStackFrame());
                    if (cdiValue != null) {
                        ICDIType cdiType = cdiValue.getType();
                        if (cdiValue instanceof ICDIArrayValue && cdiType != null) {
                            int[] dims;
                            CType type = new CType(cdiType);
                            if (type.isArray() && (dims = type.getArrayDimensions()).length > 0 && dims[0] > 0) {
                                this.fValue = CValueFactory.createIndexedValue(this.getVariable(), (ICDIArrayValue)cdiValue, 0, dims[0]);
                            }
                        } else {
                            this.fValue = CValueFactory.createValue(this.getVariable(), cdiValue);
                        }
                    }
                }
                catch (CDIException e) {
                    CRegister.requestFailed(e.getMessage(), e);
                }
            }
            return this.fValue;
        }

        public void invalidateValue() {
            if (this.fValue instanceof AbstractCValue) {
                ((AbstractCValue)this.fValue).dispose();
                this.fValue = CValueFactory.NULL_VALUE;
            }
        }

        public boolean isChanged() {
            return this.fChanged;
        }

        public synchronized void setChanged(boolean changed) {
            if (changed) {
                this.invalidateValue();
            }
            if (this.fValue instanceof AbstractCValue) {
                ((AbstractCValue)this.fValue).setChanged(changed);
            }
            this.fChanged = changed;
        }

        public synchronized void preserve() {
            this.setChanged(false);
            if (this.fValue instanceof AbstractCValue) {
                ((AbstractCValue)this.fValue).preserve();
            }
        }

        CVariable getVariable() {
            return this.fVariable;
        }

        private void setVariable(CVariable variable) {
            this.fVariable = variable;
        }

        public void resetValue() {
            if (this.fValue instanceof AbstractCValue) {
                ((AbstractCValue)this.fValue).reset();
            }
        }

        public boolean isEditable() throws DebugException {
            ICDIRegister reg = this.getCDIRegister();
            if (reg != null && reg.getTarget().getConfiguration().supportsRegisterModification()) {
                try {
                    return reg.isEditable();
                }
                catch (CDIException cDIException) {}
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof InternalVariable) {
                return this.getCDIVariableObject().equals(((InternalVariable)obj).getCDIVariableObject());
            }
            return false;
        }

        public boolean isSameDescriptor(ICDIVariableDescriptor desc) {
            return this.getCDIVariableObject().equals(desc);
        }
    }
}

