/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.gdbjtag.ui;

import java.io.File;
import org.eclipse.cdt.debug.gdbjtag.ui.Activator;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.debug.mi.core.MIPlugin;
import org.eclipse.cdt.debug.mi.core.command.factories.CommandFactoryDescriptor;
import org.eclipse.cdt.debug.mi.core.command.factories.CommandFactoryManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GDBJtagDebuggerTab
extends AbstractLaunchConfigurationTab {
    private CommandFactoryDescriptor[] cfDescs;
    private Text gdbCommand;
    private Text gdbinitFile;
    private Combo commandFactory;
    private Combo miProtocol;
    private Button verboseMode;
    private Button useRemote;
    private Text ipAddress;
    private Text portNumber;

    public String getName() {
        return "Debugger";
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.setControl((Control)sc);
        Composite comp = new Composite((Composite)sc, 0);
        sc.setContent((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        Group group = new Group(comp, 0);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText("GDB Setup");
        this.createCommandControl((Composite)group);
        this.createInitFileControl((Composite)group);
        this.createCommandFactoryControl((Composite)group);
        this.createProtocolControl((Composite)group);
        this.createVerboseModeControl((Composite)group);
        this.createRemoteControl(comp);
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        dialog.open();
        text.append(dialog.getVariableExpression());
    }

    private void createCommandControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText("GDB Command:");
        gd = new GridData();
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.gdbCommand = new Text(comp, 2052);
        gd = new GridData(768);
        this.gdbCommand.setLayoutData((Object)gd);
        this.gdbCommand.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button button = new Button(comp, 0);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDebuggerTab.this.browseButtonSelected("Select gdb", GDBJtagDebuggerTab.this.gdbCommand);
            }
        });
        button = new Button(comp, 0);
        button.setText("Variables...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDebuggerTab.this.variablesButtonSelected(GDBJtagDebuggerTab.this.gdbCommand);
            }
        });
    }

    private void createInitFileControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText("GDB Init File:");
        gd = new GridData();
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.gdbinitFile = new Text(comp, 2052);
        gd = new GridData(768);
        this.gdbinitFile.setLayoutData((Object)gd);
        this.gdbinitFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button button = new Button(comp, 0);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDebuggerTab.this.browseButtonSelected("Select .gdbinit file", GDBJtagDebuggerTab.this.gdbinitFile);
            }
        });
        button = new Button(comp, 0);
        button.setText("Variables...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDebuggerTab.this.variablesButtonSelected(GDBJtagDebuggerTab.this.gdbinitFile);
            }
        });
    }

    private void createCommandFactoryControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText("Command Set:");
        this.commandFactory = new Combo(comp, 12);
        CommandFactoryManager cfManager = MIPlugin.getDefault().getCommandFactoryManager();
        this.cfDescs = cfManager.getDescriptors("org.eclipse.cdt.debug.mi.core.CDebuggerNew");
        int i = 0;
        while (i < this.cfDescs.length) {
            this.commandFactory.add(this.cfDescs[i].getName());
            ++i;
        }
        this.commandFactory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDebuggerTab.this.commandFactoryChanged();
                GDBJtagDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createProtocolControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText("Protocol Version:");
        this.miProtocol = new Combo(comp, 12);
        this.miProtocol.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void commandFactoryChanged() {
        int currsel = this.miProtocol.getSelectionIndex();
        String currProt = null;
        if (currsel >= 0) {
            currProt = this.miProtocol.getItem(currsel);
        }
        this.miProtocol.removeAll();
        int cfsel = this.commandFactory.getSelectionIndex();
        if (cfsel >= 0) {
            String[] protocols = this.cfDescs[cfsel].getMIVersions();
            int i = 0;
            while (i < protocols.length) {
                this.miProtocol.add(protocols[i]);
                if (currProt != null && protocols[i].equals(currProt)) {
                    this.miProtocol.select(i);
                }
                ++i;
            }
        }
        if (this.miProtocol.getSelectionIndex() < 0 && this.miProtocol.getItemCount() > 0) {
            this.miProtocol.select(0);
        }
    }

    private void createVerboseModeControl(Composite parent) {
        this.verboseMode = new Button(parent, 32);
        this.verboseMode.setText("Verbose console mode");
        this.verboseMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createRemoteControl(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText("Remote Target");
        this.useRemote = new Button((Composite)group, 32);
        this.useRemote.setText("Use remote target");
        this.useRemote.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GDBJtagDebuggerTab.this.useRemoteChanged();
                GDBJtagDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        comp.setLayout((Layout)layout);
        Label label = new Label(comp, 0);
        label.setText("Host name or IP address:");
        this.ipAddress = new Text(comp, 2048);
        gd = new GridData();
        gd.widthHint = 100;
        this.ipAddress.setLayoutData((Object)gd);
        this.ipAddress.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
        label = new Label(comp, 0);
        label.setText("Port number:");
        this.portNumber = new Text(comp, 2048);
        gd = new GridData();
        gd.widthHint = 100;
        this.portNumber.setLayoutData((Object)gd);
        this.portNumber.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        });
        this.portNumber.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GDBJtagDebuggerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void useRemoteChanged() {
        boolean enabled = this.useRemote.getSelection();
        this.ipAddress.setEnabled(enabled);
        this.portNumber.setEnabled(enabled);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String gdbCommandAttr = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
            this.gdbCommand.setText(gdbCommandAttr);
            String gdbinitFileAttr = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
            this.gdbinitFile.setText(gdbinitFileAttr);
            CommandFactoryManager cfManager = MIPlugin.getDefault().getCommandFactoryManager();
            CommandFactoryDescriptor defDesc = cfManager.getDefaultDescriptor("org.eclipse.cdt.debug.mi.core.CDebuggerNew");
            String commandFactoryAttr = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, defDesc.getName());
            int cfid = 0;
            int i = 0;
            while (i < this.cfDescs.length) {
                if (this.cfDescs[i].getName().equals(commandFactoryAttr)) {
                    cfid = i;
                    break;
                }
                ++i;
            }
            this.commandFactory.select(cfid);
            String miProtocolAttr = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_PROTOCOL, defDesc.getMIVersions()[0]);
            int n = this.miProtocol.getItemCount();
            int i2 = 0;
            while (i2 < n) {
                if (this.miProtocol.getItem(i2).equals(miProtocolAttr)) {
                    this.miProtocol.select(i2);
                }
                ++i2;
            }
            boolean verboseModeAttr = configuration.getAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, false);
            this.verboseMode.setSelection(verboseModeAttr);
            boolean useRemoteAttr = configuration.getAttribute("org.eclipse.cdt.debug.gdbremote.core.useRemoteTarget", true);
            this.useRemote.setSelection(useRemoteAttr);
            this.useRemoteChanged();
            String ipAddressAttr = configuration.getAttribute("org.eclipse.cdt.debug.gdbremote.core.ipAddress", "localhost");
            this.ipAddress.setText(ipAddressAttr);
            int portNumberAttr = configuration.getAttribute("org.eclipse.cdt.debug.gdbremote.core.portNumber", 10000);
            this.portNumber.setText(String.valueOf(portNumberAttr));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, this.gdbCommand.getText().trim());
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, this.gdbinitFile.getText().trim());
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, this.commandFactory.getText());
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_PROTOCOL, this.miProtocol.getText());
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, this.verboseMode.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.useRemoteTarget", this.useRemote.getSelection());
        configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.ipAddress", this.ipAddress.getText().trim());
        try {
            configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.portNumber", Integer.parseInt(this.portNumber.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.portNumber", 0);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, "gdb");
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_GDB_INIT, ".gdbinit");
        CommandFactoryManager cfManager = MIPlugin.getDefault().getCommandFactoryManager();
        CommandFactoryDescriptor defDesc = cfManager.getDefaultDescriptor("org.eclipse.cdt.debug.mi.core.CDebuggerNew");
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_COMMAND_FACTORY, defDesc.getName());
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_PROTOCOL, defDesc.getMIVersions()[0]);
        configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_VERBOSE_MODE, false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.useRemoteTarget", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.ipAddress", "localhost");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbremote.core.portNumber", 10000);
    }
}

