/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.output;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.mi.core.output.MIConsoleStreamOutput;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;
import org.eclipse.cdt.debug.mi.core.output.MIOOBRecord;
import org.eclipse.cdt.debug.mi.core.output.MIOutput;
import org.eclipse.cdt.debug.mi.core.output.MIStreamRecord;

public class CLIInfoLineInfo
extends MIInfo {
    private int lineNumber;
    private BigInteger startAddress;
    private BigInteger endAddress;
    private String startLocation;
    private String endLocation;
    private String fileName;

    public CLIInfoLineInfo(MIOutput out) {
        super(out);
        this.parse();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public BigInteger getStartAddress() {
        return this.startAddress;
    }

    public BigInteger getEndAddress() {
        return this.endAddress;
    }

    public String getStartLocation() {
        return this.startLocation;
    }

    public String getEndLocation() {
        return this.endLocation;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected void parse() {
        ArrayList aList = new ArrayList();
        if (this.isDone()) {
            MIOutput out = this.getMIOutput();
            MIOOBRecord[] oobs = out.getMIOOBRecords();
            int i = 0;
            while (i < oobs.length) {
                if (oobs[i] instanceof MIConsoleStreamOutput) {
                    MIStreamRecord cons = (MIStreamRecord)oobs[i];
                    String str = cons.getString();
                    this.parseLineInfo(str.trim(), aList);
                }
                ++i;
            }
        }
    }

    protected void parseLineInfo(String str, List aList) {
        String[] strbits = str.split("\\s");
        int i = 0;
        while (i < strbits.length) {
            if (strbits[i].equals("Line")) {
                this.lineNumber = Integer.parseInt(strbits[i + 1]);
            } else if (strbits[i].equals("starts")) {
                this.startAddress = new BigInteger(strbits[i + 3].substring(2), 16);
                this.startLocation = strbits[i + 4];
            } else if (strbits[i].equals("ends")) {
                this.endAddress = new BigInteger(strbits[i + 2].substring(2), 16);
                this.endLocation = strbits[i + 3];
            }
            ++i;
        }
        strbits = str.split("\"");
        i = 0;
        while (i < strbits.length) {
            this.fileName = strbits[1];
            ++i;
        }
    }
}

