/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIRegisterGroup;
import org.eclipse.cdt.debug.core.cdi.model.type.ICDIType;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.Manager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.model.Register;
import org.eclipse.cdt.debug.mi.core.cdi.model.RegisterDescriptor;
import org.eclipse.cdt.debug.mi.core.cdi.model.RegisterGroup;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.Thread;
import org.eclipse.cdt.debug.mi.core.cdi.model.Variable;
import org.eclipse.cdt.debug.mi.core.cdi.model.VariableDescriptor;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIDataListChangedRegisters;
import org.eclipse.cdt.debug.mi.core.command.MIDataListRegisterNames;
import org.eclipse.cdt.debug.mi.core.command.MIVarCreate;
import org.eclipse.cdt.debug.mi.core.command.MIVarDelete;
import org.eclipse.cdt.debug.mi.core.command.MIVarUpdate;
import org.eclipse.cdt.debug.mi.core.event.MIChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIEvent;
import org.eclipse.cdt.debug.mi.core.event.MIRegisterChangedEvent;
import org.eclipse.cdt.debug.mi.core.event.MIVarChangedEvent;
import org.eclipse.cdt.debug.mi.core.output.MIDataListChangedRegistersInfo;
import org.eclipse.cdt.debug.mi.core.output.MIDataListRegisterNamesInfo;
import org.eclipse.cdt.debug.mi.core.output.MIVar;
import org.eclipse.cdt.debug.mi.core.output.MIVarChange;
import org.eclipse.cdt.debug.mi.core.output.MIVarUpdateInfo;

public class RegisterManager
extends Manager {
    final int MAX_ENTRIES = 150;
    Map regsMap;
    Map varsMap;
    MIVarChange[] noChanges = new MIVarChange[0];
    HashMap fTypeCache;

    public RegisterManager(Session session) {
        super(session, true);
        this.regsMap = new Hashtable();
        this.varsMap = new Hashtable();
        this.setAutoUpdate(true);
        this.fTypeCache = new HashMap();
    }

    public ICDIType getFromTypeCache(String typeName) {
        return (ICDIType)this.fTypeCache.get(typeName);
    }

    public void addToTypeCache(String typeName, ICDIType type) {
        this.fTypeCache.put(typeName, type);
    }

    synchronized List getRegistersList(Target target) {
        List regsList = (List)this.regsMap.get(target);
        if (regsList == null) {
            regsList = Collections.synchronizedList(new ArrayList());
            this.regsMap.put(target, regsList);
        }
        return regsList;
    }

    synchronized Map getVariableMap(Target target) {
        Map varMap = (Map)this.varsMap.get(target);
        if (varMap == null) {
            varMap = Collections.synchronizedMap(new LRUMap());
            this.varsMap.put(target, varMap);
        }
        return varMap;
    }

    public ICDIRegisterGroup[] getRegisterGroups(Target target) throws CDIException {
        RegisterGroup group = new RegisterGroup(target, "Main");
        return new ICDIRegisterGroup[]{group};
    }

    public ICDIRegisterDescriptor[] getRegisterDescriptors(RegisterGroup group) throws CDIException {
        Target target = (Target)group.getTarget();
        return this.getRegisterDescriptors(target);
    }

    public ICDIRegisterDescriptor[] getRegisterDescriptors(Target target) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataListRegisterNames registers = factory.createMIDataListRegisterNames();
        try {
            mi.postCommand(registers);
            MIDataListRegisterNamesInfo info = registers.getMIDataListRegisterNamesInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            String[] names = info.getRegisterNames();
            ArrayList<RegisterDescriptor> regsList = new ArrayList<RegisterDescriptor>(names.length);
            int i = 0;
            while (i < names.length) {
                if (names[i].length() > 0) {
                    regsList.add(new RegisterDescriptor(target, null, null, names[i], null, i, 0));
                }
                ++i;
            }
            return regsList.toArray(new ICDIRegisterDescriptor[0]);
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    public Register createRegister(RegisterDescriptor regDesc) throws CDIException {
        Register reg = this.findRegister(regDesc);
        if (reg == null) {
            try {
                String name = regDesc.getQualifiedName();
                Target target = (Target)regDesc.getTarget();
                MISession mi = target.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIVarCreate var = factory.createMIVarCreate(name);
                mi.postCommand(var, -1L);
                reg = new Register(regDesc, var);
                List regList = this.getRegistersList(target);
                regList.add(reg);
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        return reg;
    }

    public void destroyRegister(Register reg) {
        Target target = (Target)reg.getTarget();
        List regList = (List)this.regsMap.get(target);
        if (regList != null && regList.remove(reg)) {
            MISession miSession = target.getMISession();
            try {
                this.removeMIVar(miSession, reg.getMIVar());
            }
            catch (CDIException cDIException) {}
        }
    }

    void removeMIVar(MISession miSession, MIVar miVar) throws CDIException {
        CommandFactory factory = miSession.getCommandFactory();
        MIVarDelete var = factory.createMIVarDelete(miVar.getVarName());
        try {
            miSession.postCommand(var);
            var.getMIInfo();
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MIVar createMiVar(StackFrame frame, String regName) throws CDIException {
        target = (Target)frame.getTarget();
        currentThread = (Thread)target.getCurrentThread();
        currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            try {
                target.setCurrentThread(frame.getThread(), false);
                ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
                mi = target.getMISession();
                factory = mi.getCommandFactory();
                var = factory.createMIVarCreate(regName);
                mi.postCommand(var);
                info = var.getMIVarCreateInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                var12_11 = info.getMIVar();
                var10_12 = null;
                ** GOTO lbl-1000
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable var11_18) {
            var10_13 = null;
            try {
                target.setCurrentThread(currentThread, false);
                currentThread.setCurrentStackFrame(currentFrame, false);
                ** GOTO lbl47
            }
            catch (Throwable var14_15) {
                v0 = null;
lbl31:
                // 2 sources

                while (true) {
                    var13_17 = v0;
                    target.releaseTarget();
                    throw var11_18;
                }
            }
lbl-1000:
            // 1 sources

            try {}
            catch (Throwable var14_14) {
                v1 = null;
lbl38:
                // 2 sources

                while (true) {
                    var13_16 = v1;
                    target.releaseTarget();
                    return var12_11;
                }
            }
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            {
                v1 = null;
                ** continue;
lbl47:
                // 1 sources

                v0 = null;
                ** continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public MIVarChange[] updateMiVar(StackFrame frame, String varName) throws CDIException {
        Target target = (Target)frame.getTarget();
        Thread currentThread = (Thread)target.getCurrentThread();
        StackFrame currentFrame = currentThread.getCurrentStackFrame();
        target.lockTarget();
        try {
            MIVarChange[] mIVarChangeArray;
            try {
                target.setCurrentThread(frame.getThread(), false);
                ((Thread)frame.getThread()).setCurrentStackFrame(frame, false);
                MISession mi = target.getMISession();
                CommandFactory factory = mi.getCommandFactory();
                MIVarUpdate var = factory.createMIVarUpdate(varName);
                mi.postCommand(var);
                MIVarUpdateInfo info = var.getMIVarUpdateInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                mIVarChangeArray = info.getMIVarChanges();
                Object var10_12 = null;
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            try {
                target.setCurrentThread(currentThread, false);
                currentThread.setCurrentStackFrame(currentFrame, false);
                Object var13_17 = null;
                target.releaseTarget();
                return mIVarChangeArray;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                target.releaseTarget();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            try {}
            catch (Throwable throwable2) {
                Object var13_18 = null;
                target.releaseTarget();
                throw throwable2;
            }
            target.setCurrentThread(currentThread, false);
            currentThread.setCurrentStackFrame(currentFrame, false);
            Object var13_19 = null;
            target.releaseTarget();
            throw throwable;
        }
    }

    public Variable createShadowRegister(Register register, StackFrame frame, String regName) throws CDIException {
        Target target = (Target)frame.getTarget();
        Map varMap = this.getVariableMap(target);
        ShadowRegister variable = null;
        if (varMap.containsKey(regName)) {
            variable = (ShadowRegister)varMap.get(regName);
            this.updateMiVar(frame, variable.getMIVar().getVarName());
        } else {
            MIVar miVar = this.createMiVar(frame, regName);
            variable = new ShadowRegister(register, frame, regName, miVar);
            varMap.put(regName, variable);
        }
        return variable;
    }

    public Register getRegister(MISession miSession, String varName) {
        Target target = ((Session)this.getSession()).getTarget(miSession);
        Register[] regs = this.getRegisters(target);
        int i = 0;
        while (i < regs.length) {
            try {
                if (regs[i].getMIVar().getVarName().equals(varName)) {
                    return regs[i];
                }
                try {
                    Register r = (Register)regs[i].getChild(varName);
                    if (r != null) {
                        return r;
                    }
                }
                catch (ClassCastException classCastException) {}
            }
            catch (CDIException cDIException) {}
            ++i;
        }
        return null;
    }

    public Register getRegister(MISession miSession, int regno) {
        Target target = ((Session)this.getSession()).getTarget(miSession);
        return this.getRegister(target, regno);
    }

    public Register getRegister(Target target, int regno) {
        Register[] regs = this.getRegisters(target);
        int i = 0;
        while (i < regs.length) {
            if (regs[i].getPosition() == regno) {
                return regs[i];
            }
            ++i;
        }
        return null;
    }

    public void update(Target target) throws CDIException {
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        MIDataListChangedRegisters changed = factory.createMIDataListChangedRegisters();
        try {
            mi.postCommand(changed);
            MIDataListChangedRegistersInfo info = changed.getMIDataListChangedRegistersInfo();
            if (info == null) {
                throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
            }
            int[] regnos = info.getRegisterNumbers();
            ArrayList<MIChangedEvent> eventList = new ArrayList<MIChangedEvent>(regnos.length);
            int i = 0;
            while (i < regnos.length) {
                Register reg = this.getRegister(target, regnos[i]);
                if (reg != null) {
                    String varName = reg.getMIVar().getVarName();
                    MIVarChange[] changes = this.noChanges;
                    MIVarUpdate update = factory.createMIVarUpdate(varName);
                    try {
                        mi.postCommand(update);
                        MIVarUpdateInfo updateInfo = update.getMIVarUpdateInfo();
                        if (updateInfo == null) {
                            throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                        }
                        changes = updateInfo.getMIVarChanges();
                    }
                    catch (MIException mIException) {}
                    if (changes.length != 0) {
                        int j = 0;
                        while (j < changes.length) {
                            String n = changes[j].getVarName();
                            if (changes[j].isInScope()) {
                                eventList.add(new MIVarChangedEvent(mi, n));
                            }
                            ++j;
                        }
                    } else {
                        eventList.add(new MIRegisterChangedEvent(mi, update.getToken(), reg.getName(), regnos[i]));
                    }
                }
                ++i;
            }
            MIEvent[] events = eventList.toArray(new MIEvent[0]);
            mi.fireEvents(events);
        }
        catch (MIException e) {
            throw new MI2CDIException(e);
        }
    }

    private Register[] getRegisters(Target target) {
        List regsList = (List)this.regsMap.get(target);
        if (regsList != null) {
            return regsList.toArray(new Register[regsList.size()]);
        }
        return new Register[0];
    }

    private Register findRegister(RegisterDescriptor rd) throws CDIException {
        Target target = (Target)rd.getTarget();
        String name = rd.getName();
        int position = rd.getPosition();
        Register[] regs = this.getRegisters(target);
        int i = 0;
        while (i < regs.length) {
            if (regs[i].getName().equals(name) && regs[i].getCastingArrayStart() == rd.getCastingArrayStart() && regs[i].getCastingArrayEnd() == rd.getCastingArrayEnd() && VariableDescriptor.equalsCasting(regs[i], rd) && regs[i].getPosition() == position) {
                return regs[i];
            }
            ++i;
        }
        return null;
    }

    class LRUMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;

        LRUMap() {
            super(151, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            boolean toRemove;
            boolean bl = toRemove = this.size() > 150;
            if (toRemove) {
                ShadowRegister v = (ShadowRegister)eldest.getValue();
                try {
                    Target target = (Target)v.getTarget();
                    RegisterManager.this.removeMIVar(target.getMISession(), v.getMIVar());
                }
                catch (Exception exception) {}
                v.setMIVar(null);
            }
            return toRemove;
        }
    }

    class ShadowRegister
    extends Register {
        public ShadowRegister(Register reg, StackFrame frame, String n, MIVar v) {
            super((Target)reg.getTarget(), (Thread)frame.getThread(), frame, n, null, 0, 0, v);
            try {
                this.fTypename = reg.getTypeName();
            }
            catch (CDIException cDIException) {}
            try {
                this.fType = reg.getType();
            }
            catch (CDIException cDIException) {}
        }

        public MIVar getMIVar() throws CDIException {
            if (this.fMIVar == null) {
                this.fMIVar = RegisterManager.this.createMiVar((StackFrame)this.getStackFrame(), this.getName());
            }
            return this.fMIVar;
        }

        public void setMIVar(MIVar newMIVar) {
            this.fMIVar = newMIVar;
        }
    }
}

