/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDICondition;
import org.eclipse.cdt.debug.core.cdi.ICDILocation;
import org.eclipse.cdt.debug.core.cdi.model.ICDIBreakpoint;
import org.eclipse.cdt.debug.core.cdi.model.ICDISignal;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThreadStorage;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThreadStorageDescriptor;
import org.eclipse.cdt.debug.mi.core.MIException;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.CdiResources;
import org.eclipse.cdt.debug.mi.core.cdi.MI2CDIException;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.Session;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.model.CObject;
import org.eclipse.cdt.debug.mi.core.cdi.model.StackFrame;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;
import org.eclipse.cdt.debug.mi.core.cdi.model.ThreadStorageDescriptor;
import org.eclipse.cdt.debug.mi.core.command.CommandFactory;
import org.eclipse.cdt.debug.mi.core.command.MIStackSelectFrame;
import org.eclipse.cdt.debug.mi.core.output.MIInfo;

public class Thread
extends CObject
implements ICDIThread {
    static ICDIStackFrame[] noStack = new ICDIStackFrame[0];
    int id;
    String name;
    StackFrame currentFrame;
    List currentFrames;
    int stackdepth = 0;
    public static final int STACKFRAME_DEFAULT_DEPTH = 200;

    public Thread(Target target, int threadId) {
        this(target, threadId, null);
    }

    public Thread(Target target, int threadId, String threadName) {
        super(target);
        this.id = threadId;
        this.name = threadName;
    }

    public int getId() {
        return this.id;
    }

    public void clearState() {
        this.stackdepth = 0;
        this.currentFrame = null;
        this.currentFrames = null;
    }

    public String toString() {
        String str = Integer.toString(this.id);
        if (this.name != null) {
            str = String.valueOf(str) + " " + this.name;
        }
        return str;
    }

    public void updateState() {
        try {
            this.getCurrentStackFrame();
        }
        catch (CDIException cDIException) {}
    }

    public StackFrame getCurrentStackFrame() throws CDIException {
        ICDIStackFrame[] frames;
        if (this.currentFrame == null && (frames = this.getStackFrames(0, 0)).length > 0) {
            this.currentFrame = (StackFrame)frames[0];
        }
        return this.currentFrame;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIStackFrame[] getStackFrames() throws CDIException {
        depth = this.getStackFrameCount();
        if (this.currentFrames != null) {
            if (this.currentFrames.size() >= depth) return this.currentFrames.toArray(Thread.noStack);
        }
        this.currentFrames = new ArrayList<E>();
        target = (Target)this.getTarget();
        currentThread = target.getCurrentThread();
        target.lockTarget();
        try {
            try {
                target.setCurrentThread(this, false);
                mi = target.getMISession();
                factory = mi.getCommandFactory();
                frames = factory.createMIStackListFrames();
                mi.postCommand(frames);
                info = frames.getMIStackListFramesInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                miFrames = info.getMIFrames();
                i = 0;
                while (i < miFrames.length) {
                    this.currentFrames.add(new StackFrame(this, miFrames[i], depth - miFrames[i].getLevel()));
                    ++i;
                }
            }
            catch (MIException v0) {
            }
            catch (CDIException v1) {}
            var10_13 = null;
        }
        catch (Throwable var11_11) {
            var10_12 = null;
            try {
                target.setCurrentThread(currentThread, false);
                v2 = null;
            }
            catch (Throwable var13_14) {
                v2 = null;
            }
            var12_16 = v2;
            target.releaseTarget();
            throw var11_11;
        }
        ** try [egrp 2[TRYBLOCK] [5 : 189->198)] { 
lbl47:
        // 1 sources

        target.setCurrentThread(currentThread, false);
        v3 = null;
        ** GOTO lbl52
lbl50:
        // 1 sources

        catch (Throwable var13_15) {
            v3 = null;
lbl52:
            // 2 sources

            var12_17 = v3;
            target.releaseTarget();
        }
        if (this.currentFrame != null) return this.currentFrames.toArray(Thread.noStack);
        i = 0;
        while (i < this.currentFrames.size()) {
            stack = (ICDIStackFrame)this.currentFrames.get(i);
            if (stack.getLevel() == depth) {
                this.currentFrame = (StackFrame)stack;
            }
            ++i;
        }
        return this.currentFrames.toArray(Thread.noStack);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getStackFrameCount() throws CDIException {
        if (this.stackdepth != 0) return this.stackdepth;
        target = (Target)this.getTarget();
        currentThread = target.getCurrentThread();
        target.lockTarget();
        try {
            try {
                target.setCurrentThread(this, false);
                mi = target.getMISession();
                factory = mi.getCommandFactory();
                depth = factory.createMIStackInfoDepth();
                mi.postCommand(depth);
                info = null;
                try {
                    info = depth.getMIStackInfoDepthInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                    this.stackdepth = info.getDepth();
                }
                catch (MIException v0) {
                    depth = factory.createMIStackInfoDepth();
                    mi.postCommand(depth);
                    info = depth.getMIStackInfoDepthInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                    this.stackdepth = info.getDepth();
                    if (this.stackdepth > 0) {
                        --this.stackdepth;
                    }
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
            var7_10 = null;
        }
        catch (Throwable var8_8) {
            var7_9 = null;
            try {
                try {
                    target.setCurrentThread(currentThread, false);
                }
                catch (MI2CDIException e) {
                    target.releaseTarget();
                    throw e;
                }
                v1 = null;
            }
            catch (Throwable var11_13) {
                v1 = null;
            }
            var10_15 = v1;
            target.releaseTarget();
            throw var8_8;
        }
        try {}
        catch (Throwable var11_14) {
            v2 = null;
lbl55:
            // 2 sources

            var10_16 = v2;
            target.releaseTarget();
            return this.stackdepth;
        }
        try {}
        catch (MI2CDIException e) {
            target.releaseTarget();
            throw e;
        }
        target.setCurrentThread(currentThread, false);
        v2 = null;
        ** GOTO lbl55
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICDIStackFrame[] getStackFrames(int low, int high) throws CDIException {
        block15: {
            if (this.currentFrames != null && this.currentFrames.size() >= high) break block15;
            this.currentFrames = new ArrayList<E>();
            target = (Target)this.getTarget();
            currentThread = target.getCurrentThread();
            target.lockTarget();
            try {
                try {
                    target.setCurrentThread(this, false);
                    depth = this.getStackFrameCount();
                    upperBound = high < depth ? Math.min(depth, 200) : depth;
                    mi = target.getMISession();
                    factory = mi.getCommandFactory();
                    frames = factory.createMIStackListFrames(0, upperBound);
                    mi.postCommand(frames);
                    info = frames.getMIStackListFramesInfo();
                    if (info == null) {
                        throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                    }
                    miFrames = info.getMIFrames();
                    i = 0;
                    while (i < miFrames.length) {
                        this.currentFrames.add(new StackFrame(this, miFrames[i], depth - miFrames[i].getLevel()));
                        ++i;
                    }
                }
                catch (MIException v0) {
                }
                catch (CDIException v1) {}
                var13_16 = null;
            }
            catch (Throwable var14_14) {
                var13_15 = null;
                try {
                    target.setCurrentThread(currentThread, false);
                    var15_20 = null;
                    target.releaseTarget();
                    throw var14_14;
                }
                catch (Throwable var16_17) {
                    var15_19 = null;
                    target.releaseTarget();
                    throw var16_17;
                }
            }
            try {}
            catch (Throwable var16_18) {
                var15_21 = null;
                target.releaseTarget();
                throw var16_18;
            }
            target.setCurrentThread(currentThread, false);
            var15_22 = null;
            target.releaseTarget();
            if (this.currentFrame != null) break block15;
            i = 0;
            if (true) ** GOTO lbl64
            do {
                if ((f = (StackFrame)this.currentFrames.get(i)).getMIFrame().getLevel() == 0) {
                    this.currentFrame = f;
                }
                ++i;
lbl64:
                // 2 sources

            } while (i < this.currentFrames.size());
        }
        list = high - low + 1 <= this.currentFrames.size() ? this.currentFrames.subList(low, high + 1) : this.currentFrames;
        return list.toArray(Thread.noStack);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCurrentStackFrame(StackFrame stackframe, boolean doUpdate) throws CDIException {
        Thread aThread;
        int frameLevel = 0;
        if (stackframe != null) {
            frameLevel = stackframe.getLevel();
        }
        if (this.currentFrame != null && this.currentFrame.getLevel() == frameLevel && stackframe != null && (aThread = (Thread)stackframe.getThread()) != null && aThread.getId() == this.getId()) {
            return;
        }
        Target target = (Target)this.getTarget();
        MISession mi = target.getMISession();
        CommandFactory factory = mi.getCommandFactory();
        int miLevel = this.getStackFrameCount() - frameLevel;
        MIStackSelectFrame frame = factory.createMIStackSelectFrame(miLevel);
        target.lockTarget();
        try {
            try {
                target.setCurrentThread(this, doUpdate);
                mi.postCommand(frame);
                MIInfo info = frame.getMIInfo();
                if (info == null) {
                    throw new CDIException(CdiResources.getString("cdi.Common.No_answer"));
                }
                this.currentFrame = stackframe;
                if (doUpdate) {
                    VariableManager varMgr;
                    Session session = (Session)target.getSession();
                    RegisterManager regMgr = session.getRegisterManager();
                    if (regMgr.isAutoUpdate()) {
                        regMgr.update(target);
                    }
                    if ((varMgr = session.getVariableManager()).isAutoUpdate()) {
                        varMgr.update(target);
                    }
                }
            }
            catch (MIException e) {
                throw new MI2CDIException(e);
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            target.releaseTarget();
            throw throwable;
        }
        {
            Object var13_16 = null;
            target.releaseTarget();
            return;
        }
    }

    public void stepInto() throws CDIException {
        this.stepInto(1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stepInto(int count) throws CDIException {
        ((Target)this.getTarget()).lockTarget();
        try {
            ((Target)this.getTarget()).setCurrentThread(this);
            this.getTarget().stepInto(count);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            ((Target)this.getTarget()).releaseTarget();
            throw throwable;
        }
        {
            Object var2_4 = null;
            ((Target)this.getTarget()).releaseTarget();
            return;
        }
    }

    public void stepIntoInstruction() throws CDIException {
        this.stepIntoInstruction(1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stepIntoInstruction(int count) throws CDIException {
        ((Target)this.getTarget()).lockTarget();
        try {
            ((Target)this.getTarget()).setCurrentThread(this);
            this.getTarget().stepIntoInstruction(count);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            ((Target)this.getTarget()).releaseTarget();
            throw throwable;
        }
        {
            Object var2_4 = null;
            ((Target)this.getTarget()).releaseTarget();
            return;
        }
    }

    public void stepOver() throws CDIException {
        this.stepOver(1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stepOver(int count) throws CDIException {
        ((Target)this.getTarget()).lockTarget();
        try {
            ((Target)this.getTarget()).setCurrentThread(this);
            this.getTarget().stepOver(count);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            ((Target)this.getTarget()).releaseTarget();
            throw throwable;
        }
        {
            Object var2_4 = null;
            ((Target)this.getTarget()).releaseTarget();
            return;
        }
    }

    public void stepOverInstruction() throws CDIException {
        this.stepOverInstruction(1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stepOverInstruction(int count) throws CDIException {
        ((Target)this.getTarget()).lockTarget();
        try {
            ((Target)this.getTarget()).setCurrentThread(this);
            this.getTarget().stepOverInstruction(count);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            ((Target)this.getTarget()).releaseTarget();
            throw throwable;
        }
        {
            Object var2_4 = null;
            ((Target)this.getTarget()).releaseTarget();
            return;
        }
    }

    public void stepReturn() throws CDIException {
        this.getCurrentStackFrame().stepReturn();
    }

    public void runUntil(ICDILocation location) throws CDIException {
        this.stepUntil(location);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stepUntil(ICDILocation location) throws CDIException {
        ((Target)this.getTarget()).lockTarget();
        try {
            ((Target)this.getTarget()).setCurrentThread(this);
            this.getTarget().stepUntil(location);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            ((Target)this.getTarget()).releaseTarget();
            throw throwable;
        }
        {
            Object var2_4 = null;
            ((Target)this.getTarget()).releaseTarget();
            return;
        }
    }

    public boolean isSuspended() {
        return this.getTarget().isSuspended();
    }

    public void suspend() throws CDIException {
        this.getTarget().suspend();
    }

    public void resume() throws CDIException {
        this.resume(false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resume(boolean passSignal) throws CDIException {
        ((Target)this.getTarget()).lockTarget();
        try {
            ((Target)this.getTarget()).setCurrentThread(this);
            this.getTarget().resume(passSignal);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            ((Target)this.getTarget()).releaseTarget();
            throw throwable;
        }
        {
            Object var2_4 = null;
            ((Target)this.getTarget()).releaseTarget();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resume(ICDILocation location) throws CDIException {
        ((Target)this.getTarget()).lockTarget();
        try {
            ((Target)this.getTarget()).setCurrentThread(this);
            this.getTarget().resume(location);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            ((Target)this.getTarget()).releaseTarget();
            throw throwable;
        }
        {
            Object var2_4 = null;
            ((Target)this.getTarget()).releaseTarget();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resume(ICDISignal signal) throws CDIException {
        ((Target)this.getTarget()).lockTarget();
        try {
            ((Target)this.getTarget()).setCurrentThread(this);
            this.getTarget().resume(signal);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            ((Target)this.getTarget()).releaseTarget();
            throw throwable;
        }
        {
            Object var2_4 = null;
            ((Target)this.getTarget()).releaseTarget();
            return;
        }
    }

    public void jump(ICDILocation location) throws CDIException {
        this.resume(location);
    }

    public void signal() throws CDIException {
        this.resume(false);
    }

    public void signal(ICDISignal signal) throws CDIException {
        this.resume(signal);
    }

    public boolean equals(ICDIThread thread) {
        if (thread instanceof Thread) {
            Thread cthread = (Thread)thread;
            return this.id == cthread.getId();
        }
        return super.equals(thread);
    }

    public ICDIBreakpoint[] getBreakpoints() throws CDIException {
        Target target = (Target)this.getTarget();
        ICDIBreakpoint[] bps = target.getBreakpoints();
        ArrayList<ICDIBreakpoint> list = new ArrayList<ICDIBreakpoint>(bps.length);
        int i = 0;
        while (i < bps.length) {
            ICDICondition condition = bps[i].getCondition();
            if (condition != null) {
                String[] threadIds = condition.getThreadIds();
                int j = 0;
                while (j < threadIds.length) {
                    int tid = 0;
                    try {
                        tid = Integer.parseInt(threadIds[j]);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    if (tid == this.getId()) {
                        list.add(bps[i]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new ICDIBreakpoint[list.size()]);
    }

    public ICDIThreadStorageDescriptor[] getThreadStorageDescriptors() throws CDIException {
        Session session = (Session)this.getTarget().getSession();
        VariableManager varMgr = session.getVariableManager();
        return varMgr.getThreadStorageDescriptors(this);
    }

    public ICDIThreadStorage createThreadStorage(ICDIThreadStorageDescriptor varDesc) throws CDIException {
        if (varDesc instanceof ThreadStorageDescriptor) {
            Session session = (Session)this.getTarget().getSession();
            VariableManager varMgr = session.getVariableManager();
            return varMgr.createThreadStorage((ThreadStorageDescriptor)varDesc);
        }
        return null;
    }
}

