/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.internal.ui;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.mi.internal.ui.StandardGDBDebuggerPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;

public class MinGWDebuggerPage
extends StandardGDBDebuggerPage {
    protected String defaultGdbCommand(ILaunchConfiguration configuration) {
        try {
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (projectName.length() > 0) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                ICProjectDescription projDesc = CoreModel.getDefault().getProjectDescription(project);
                ICConfigurationDescription configDesc = projDesc.getActiveConfiguration();
                IEnvironmentVariableManager envVarMgr = CCorePlugin.getDefault().getBuildEnvironmentManager();
                IEnvironmentVariable pathvar = envVarMgr.getVariable("PATH", configDesc, true);
                String path = pathvar.getValue();
                String[] dirs = path.split(pathvar.getDelimiter());
                int i = 0;
                while (i < dirs.length) {
                    IPath gdbPath = new Path(dirs[i]).append("gdb.exe");
                    File gdbFile = gdbPath.toFile();
                    if (gdbFile.exists()) {
                        return gdbPath.toOSString();
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return super.defaultGdbCommand(configuration);
    }
}

