/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui;

import java.text.MessageFormat;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.ICDebugElementStatus;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.ICType;
import org.eclipse.cdt.debug.core.model.ICValue;
import org.eclipse.cdt.debug.core.model.IEnableDisableTarget;
import org.eclipse.cdt.debug.internal.ui.CDebugUIMessages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class CDebugUIUtils {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static IRegion findWord(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        try {
            char c;
            int pos = offset;
            while (pos >= 0) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                --pos;
            }
            start = pos;
            pos = offset;
            int length = document.getLength();
            while (pos < length) {
                c = document.getChar(pos);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++pos;
            }
            end = pos;
        }
        catch (BadLocationException badLocationException) {}
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            if (start == offset) {
                return new Region(start, end - start);
            }
            return new Region(start + 1, end - start - 1);
        }
        return null;
    }

    public static ICStackFrame getCurrentStackFrame() {
        ICStackFrame iCStackFrame;
        IAdaptable context = DebugUITools.getDebugContext();
        if (context != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.ICStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iCStackFrame = (ICStackFrame)context.getAdapter((Class)clazz);
        } else {
            iCStackFrame = null;
        }
        return iCStackFrame;
    }

    public static String getValueText(IValue value) {
        StringBuffer label = new StringBuffer();
        if (value instanceof ICDebugElementStatus && !((ICDebugElementStatus)value).isOK()) {
            label.append(MessageFormat.format(CDebugUIMessages.getString("CDTDebugModelPresentation.4"), ((ICDebugElementStatus)value).getMessage()));
        } else if (value instanceof ICValue) {
            ICType type = null;
            try {
                type = ((ICValue)value).getType();
            }
            catch (DebugException debugException) {}
            try {
                String valueString = value.getValueString();
                if (valueString != null) {
                    valueString = valueString.trim();
                    if (type != null && type.isCharacter()) {
                        if (valueString.length() == 0) {
                            valueString = ".";
                        }
                        label.append(valueString);
                    } else if (type != null && type.isFloatingPointType()) {
                        Number floatingPointValue = CDebugUtils.getFloatingPointValue((ICValue)((ICValue)value));
                        if (CDebugUtils.isNaN((Number)floatingPointValue)) {
                            valueString = "NAN";
                        }
                        if (CDebugUtils.isPositiveInfinity((Number)floatingPointValue)) {
                            valueString = CDebugUIMessages.getString("CDTDebugModelPresentation.23");
                        }
                        if (CDebugUtils.isNegativeInfinity((Number)floatingPointValue)) {
                            valueString = CDebugUIMessages.getString("CDTDebugModelPresentation.24");
                        }
                        label.append(valueString);
                    } else if (!(type != null && type.isStructure() || valueString.length() <= 0)) {
                        label.append(valueString);
                    }
                }
            }
            catch (DebugException debugException) {}
        }
        return label.toString();
    }

    public static String getVariableTypeName(ICType type) {
        StringBuffer result = new StringBuffer();
        if (type != null) {
            int index;
            String typeName = type.getName();
            if (typeName != null) {
                typeName = typeName.trim();
            }
            if (type.isArray() && typeName != null && (index = typeName.indexOf(91)) != -1) {
                typeName = typeName.substring(0, index).trim();
            }
            if (typeName != null && typeName.length() > 0) {
                result.append(typeName);
                if (type.isArray()) {
                    int[] dims = type.getArrayDimensions();
                    int i = 0;
                    while (i < dims.length) {
                        result.append('[');
                        result.append(dims[i]);
                        result.append(']');
                        ++i;
                    }
                }
            }
        }
        return result.toString();
    }

    public static String getVariableName(IVariable variable) throws DebugException {
        return CDebugUIUtils.decorateText(variable, variable.getName());
    }

    public static String decorateText(Object element, String text) {
        if (text == null) {
            return null;
        }
        StringBuffer baseText = new StringBuffer(text);
        if (element instanceof ICDebugElementStatus && !((ICDebugElementStatus)element).isOK()) {
            baseText.append(MessageFormat.format(" <{0}>", ((ICDebugElementStatus)element).getMessage()));
        }
        if (element instanceof IAdaptable) {
            IEnableDisableTarget target;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IEnableDisableTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = (IEnableDisableTarget)iAdaptable.getAdapter((Class)clazz)) != null && !target.isEnabled()) {
                baseText.append(' ');
                baseText.append(CDebugUIMessages.getString("CDTDebugModelPresentation.25"));
            }
        }
        return baseText.toString();
    }
}

