/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IRunToAddress;
import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyEditorInput;
import org.eclipse.cdt.debug.internal.ui.views.disassembly.DisassemblyView;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineAdapter
implements IRunToLineTarget {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        String errorMessage = null;
        if (part instanceof ITextEditor) {
            IRunToLine runToLine;
            ITextEditor textEditor = (ITextEditor)part;
            IEditorInput input = textEditor.getEditorInput();
            if (input == null) {
                errorMessage = ActionMessages.getString("RunToLineAdapter.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                errorMessage = ActionMessages.getString("RunToLineAdapter.Missing_document_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            String fileName = this.getFileName(input);
            IDebugTarget debugTarget = null;
            if (target instanceof CDebugElement) {
                debugTarget = ((CDebugElement)target).getDebugTarget();
            }
            final IPath path = this.convertPath(fileName, debugTarget);
            ITextSelection textSelection = (ITextSelection)selection;
            final int lineNumber = textSelection.getStartLine() + 1;
            if (!(target instanceof IAdaptable)) return;
            IAdaptable iAdaptable = (IAdaptable)target;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToLine");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((runToLine = (IRunToLine)iAdaptable.getAdapter((Class)clazz)) == null || !runToLine.canRunToLine(path.toPortableString(), lineNumber)) return;
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        runToLine.runToLine(path.toPortableString(), lineNumber, DebugUITools.getPreferenceStore().getBoolean("org.eclipse.debug.ui.skip_breakpoints_during_run_to_line"));
                    }
                    catch (DebugException e) {
                        RunToLineAdapter.this.failed(e);
                    }
                }
            };
            this.runInBackground(r);
            return;
        }
        if (part instanceof DisassemblyView) {
            IRunToAddress runToAddress;
            IEditorInput input = ((DisassemblyView)part).getInput();
            if (!(input instanceof DisassemblyEditorInput)) {
                errorMessage = ActionMessages.getString("RunToLineAdapter.Empty_editor_1");
                throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
            }
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine() + 1;
            final IAddress address = ((DisassemblyEditorInput)input).getAddress(lineNumber);
            if (address == null || !(target instanceof IAdaptable)) return;
            IAdaptable iAdaptable = (IAdaptable)target;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToAddress");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((runToAddress = (IRunToAddress)iAdaptable.getAdapter((Class)clazz)) == null || !runToAddress.canRunToAddress(address)) return;
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        runToAddress.runToAddress(address, DebugUITools.getPreferenceStore().getBoolean("org.eclipse.debug.ui.skip_breakpoints_during_run_to_line"));
                    }
                    catch (DebugException e) {
                        RunToLineAdapter.this.failed(e);
                    }
                }
            };
            this.runInBackground(r);
            return;
        }
        errorMessage = ActionMessages.getString("RunToLineAdapter.Operation_is_not_supported_1");
        throw new CoreException((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IAdaptable) {
            if (part instanceof IEditorPart) {
                String fileName;
                IRunToLine runToLine;
                IAdaptable iAdaptable = (IAdaptable)target;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((runToLine = (IRunToLine)iAdaptable.getAdapter((Class)clazz)) == null) {
                    return false;
                }
                IEditorPart editorPart = (IEditorPart)part;
                IEditorInput input = editorPart.getEditorInput();
                if (input == null) {
                    return false;
                }
                if (!(editorPart instanceof ITextEditor)) {
                    return false;
                }
                ITextEditor textEditor = (ITextEditor)editorPart;
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
                if (document == null) {
                    return false;
                }
                try {
                    fileName = this.getFileName(input);
                }
                catch (CoreException coreException) {
                    return false;
                }
                IDebugTarget debugTarget = null;
                if (target instanceof CDebugElement) {
                    debugTarget = ((CDebugElement)target).getDebugTarget();
                }
                IPath path = this.convertPath(fileName, debugTarget);
                ITextSelection textSelection = (ITextSelection)selection;
                int lineNumber = textSelection.getStartLine() + 1;
                return runToLine.canRunToLine(path.toPortableString(), lineNumber);
            }
            if (part instanceof DisassemblyView) {
                IRunToAddress runToAddress;
                IAdaptable iAdaptable = (IAdaptable)target;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IRunToAddress");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((runToAddress = (IRunToAddress)iAdaptable.getAdapter((Class)clazz)) == null) {
                    return false;
                }
                IEditorInput input = ((DisassemblyView)part).getInput();
                if (!(input instanceof DisassemblyEditorInput)) {
                    return false;
                }
                ITextSelection textSelection = (ITextSelection)selection;
                int lineNumber = textSelection.getStartLine() + 1;
                IAddress address = ((DisassemblyEditorInput)input).getAddress(lineNumber);
                return runToAddress.canRunToAddress(address);
            }
        }
        return false;
    }

    private String getFileName(IEditorInput input) throws CoreException {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getLocation().toOSString();
        }
        if (input instanceof IStorageEditorInput) {
            return ((IStorageEditorInput)input).getStorage().getFullPath().toOSString();
        }
        return null;
    }

    private void runInBackground(Runnable r) {
        DebugPlugin.getDefault().asyncExec(r);
    }

    protected void failed(Throwable e) {
        MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10002, ActionMessages.getString("RunToLineAdapter.0"), null);
        ms.add((IStatus)new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, e.getMessage(), e));
        CDebugUtils.error((IStatus)ms, (Object)this);
    }

    private IPath convertPath(String sourceHandle, IDebugTarget debugTarget) {
        Path path = null;
        if (Path.EMPTY.isValidPath(sourceHandle)) {
            ISourceLocator sl;
            if (debugTarget != null && (sl = debugTarget.getLaunch().getSourceLocator()) instanceof CSourceLookupDirector) {
                path = ((CSourceLookupDirector)sl).getCompilationPath(sourceHandle);
            }
            if (path == null) {
                path = new Path(sourceHandle);
            }
        }
        return path;
    }
}

