/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.sourcelookup;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceNotFoundElement;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.sourcelookup.SourceLookupUIMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CSourceNotFoundEditor
extends CommonSourceNotFoundEditor {
    public final String foundMappingsContainerName = "Found Mappings";
    private String missingFile;
    private ILaunch launch;
    private IDebugElement context;
    static /* synthetic */ Class class$0;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, ICDebugHelpContextIds.SOURCE_NOT_FOUND);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        Object artifact = this.getArtifact();
        if (artifact instanceof CSourceNotFoundElement) {
            CSourceNotFoundElement element = (CSourceNotFoundElement)artifact;
            this.missingFile = element.getFile();
            this.launch = element.getLaunch();
            this.context = element.getElement();
        } else {
            this.missingFile = "";
        }
    }

    protected String getText() {
        if (this.missingFile.length() > 0) {
            return MessageFormat.format(SourceLookupUIMessages.getString("CSourceNotFoundEditor.0"), this.missingFile);
        }
        return super.getText();
    }

    protected void createButtons(Composite parent) {
        if (this.missingFile.length() > 0) {
            Button button = new Button(parent, 8);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = false;
            data.grabExcessVerticalSpace = false;
            button.setLayoutData((Object)data);
            button.setText(SourceLookupUIMessages.getString("CSourceNotFoundEditor.1"));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    CSourceNotFoundEditor.this.locateFile();
                }
            });
        }
        super.createButtons(parent);
    }

    private void addSourceMapping(IPath missingPath, IPath newSourcePath) throws CoreException {
        ILaunchManager launchManager;
        IPersistableSourceLocator locator;
        String memento = null;
        String type = null;
        ILaunchConfigurationWorkingCopy configuration = this.launch.getLaunchConfiguration().getWorkingCopy();
        memento = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        type = configuration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
        if (type == null) {
            type = configuration.getType().getSourceLocatorId();
        }
        if ((locator = (launchManager = DebugPlugin.getDefault().getLaunchManager()).newSourceLocator(type)) instanceof AbstractSourceLookupDirector) {
            AbstractSourceLookupDirector director = (AbstractSourceLookupDirector)locator;
            if (memento == null) {
                director.initializeDefaults((ILaunchConfiguration)configuration);
            } else {
                director.initializeFromMemento(memento, (ILaunchConfiguration)configuration);
            }
            ArrayList<ISourceContainer> containerList = new ArrayList<ISourceContainer>(Arrays.asList(director.getSourceContainers()));
            boolean hasFoundMappings = false;
            MappingSourceContainer foundMappings = null;
            Iterator<ISourceContainer> iter = containerList.iterator();
            while (iter.hasNext() && !hasFoundMappings) {
                ISourceContainer container = iter.next();
                if (!(container instanceof MappingSourceContainer) || !(hasFoundMappings = container.getName().equals("Found Mappings"))) continue;
                foundMappings = (MappingSourceContainer)container;
            }
            if (!hasFoundMappings) {
                foundMappings = new MappingSourceContainer("Found Mappings");
                foundMappings.init((ISourceLookupDirector)director);
                containerList.add((ISourceContainer)foundMappings);
                director.setSourceContainers(containerList.toArray(new ISourceContainer[containerList.size()]));
            }
            foundMappings.addMapEntry(new MapEntrySourceContainer(missingPath, newSourcePath));
            configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, director.getMemento());
            configuration.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, director.getId());
            configuration.doSave();
        }
    }

    protected void locateFile() {
        Path newPath;
        FileDialog dialog = new FileDialog(this.getEditorSite().getShell(), 0);
        Path missingPath = new Path(this.missingFile);
        dialog.setFilterNames(new String[]{SourceLookupUIMessages.getString("CSourceNotFoundEditor.2")});
        dialog.setFilterExtensions(new String[]{"*." + missingPath.getFileExtension()});
        String res = dialog.open();
        if (res != null && (newPath = new Path(res)).lastSegment().equalsIgnoreCase(missingPath.lastSegment())) {
            ISourceDisplay adapter;
            if (missingPath.segmentCount() > 1) {
                int missingPathSegCount = missingPath.segmentCount() - 2;
                int newPathSegCount = newPath.segmentCount() - 2;
                while (missingPathSegCount >= 0 && newPathSegCount >= 0) {
                    if (!newPath.segment(newPathSegCount).equalsIgnoreCase(missingPath.segment(missingPathSegCount))) break;
                    --newPathSegCount;
                    --missingPathSegCount;
                }
                IPath compPath = missingPath.removeLastSegments(missingPath.segmentCount() - missingPathSegCount - 1);
                IPath newSourcePath = newPath.removeLastSegments(newPath.segmentCount() - newPathSegCount - 1);
                try {
                    this.addSourceMapping(compPath, newSourcePath);
                }
                catch (CoreException coreException) {}
            }
            IWorkbenchPage page = this.getEditorSite().getPage();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.sourcelookup.ISourceDisplay");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISourceDisplay)this.context.getAdapter((Class)clazz)) != null) {
                adapter.displaySource((Object)this.context, page, true);
            }
            this.closeEditor();
        }
    }
}

