/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICBreakpointListener;
import org.eclipse.cdt.debug.internal.ui.CBreakpointUpdater;
import org.eclipse.cdt.debug.internal.ui.CDebugImageDescriptorRegistry;
import org.eclipse.cdt.debug.internal.ui.CDebugModelPresentation;
import org.eclipse.cdt.debug.internal.ui.CDebuggerPageAdapter;
import org.eclipse.cdt.debug.internal.ui.ColorManager;
import org.eclipse.cdt.debug.internal.ui.EvaluationContextManager;
import org.eclipse.cdt.debug.internal.ui.elements.adapters.CDebugElementAdapterFactory;
import org.eclipse.cdt.debug.internal.ui.elements.adapters.CDebugElementLabelProviderFactory;
import org.eclipse.cdt.debug.internal.ui.elements.adapters.CMemoryAdapterFactory;
import org.eclipse.cdt.debug.internal.ui.elements.adapters.CWatchExpressionFactoryAdapterFactory;
import org.eclipse.cdt.debug.ui.ICDebuggerPage;
import org.eclipse.cdt.debug.ui.UIMessages;
import org.eclipse.cdt.debug.ui.sourcelookup.DefaultSourceLocator;
import org.eclipse.cdt.debug.ui.sourcelookup.OldDefaultSourceLocator;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CDebugUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.debug.ui";
    public static final String CDEBUGGER_PAGE_EXTENSION_POINT_ID = "CDebuggerPage";
    public static final String DEBUGGER_PAGE_ELEMENT = "debuggerPage";
    private static CDebugUIPlugin plugin;
    protected Map fDebuggerPageMap;
    private CDebugImageDescriptorRegistry fImageDescriptorRegistry;
    private ISharedTextColors fSharedTextColors;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public CDebugUIPlugin() {
        plugin = this;
    }

    public static CDebugUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getUniqueIdentifier() {
        if (CDebugUIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return CDebugUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static Color getPreferenceColor(String type) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)CDebugUIPlugin.getDefault().getPreferenceStore(), (String)type));
    }

    public static CDebugModelPresentation getDebugModelPresentation() {
        return CDebugModelPresentation.getDefault();
    }

    public static void log(IStatus status) {
        CDebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, "Internal Error", e));
    }

    public static void logErrorMessage(String message) {
        CDebugUIPlugin.log((IStatus)new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, message, null));
    }

    public ICDebuggerPage getDebuggerPage(String debuggerID) throws CoreException {
        if (this.fDebuggerPageMap == null) {
            this.initializeDebuggerPageMap();
        }
        IConfigurationElement configElement = (IConfigurationElement)this.fDebuggerPageMap.get(debuggerID);
        ICDebuggerPage tab = null;
        if (configElement != null) {
            Object o = configElement.createExecutableExtension("class");
            if (o instanceof ICDebuggerPage) {
                tab = (ICDebuggerPage)o;
                tab.init(debuggerID);
            } else if (o instanceof ILaunchConfigurationTab) {
                tab = new CDebuggerPageAdapter((ILaunchConfigurationTab)o);
                tab.init(debuggerID);
            }
        }
        return tab;
    }

    protected void initializeDebuggerPageMap() {
        this.fDebuggerPageMap = new HashMap(10);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PLUGIN_ID, CDEBUGGER_PAGE_EXTENSION_POINT_ID);
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            String id;
            IConfigurationElement info = infos[i];
            if (info.getName().equals(DEBUGGER_PAGE_ELEMENT) && (id = info.getAttribute("debuggerID")) != null) {
                this.fDebuggerPageMap.put(id, info);
            }
            ++i;
        }
    }

    public static void errorDialog(String message, IStatus status) {
        CDebugUIPlugin.log(status);
        Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)UIMessages.getString("CDebugUIPlugin.0"), (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        CDebugUIPlugin.log(t);
        Shell shell = CDebugUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, t.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)UIMessages.getString("CDebugUIPlugin.0"), (String)message, (IStatus)status);
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return CDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = CDebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static CDebugImageDescriptorRegistry getImageDescriptorRegistry() {
        if (CDebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            CDebugUIPlugin.getDefault().fImageDescriptorRegistry = new CDebugImageDescriptorRegistry();
        }
        return CDebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public static IPersistableSourceLocator createDefaultSourceLocator() {
        return new DefaultSourceLocator();
    }

    public static String getDefaultSourceLocatorID() {
        return OldDefaultSourceLocator.ID_DEFAULT_SOURCE_LOCATOR;
    }

    public static String getDefaultSourceLocatorOldID() {
        return "org.eclipse.cdt.launch.DefaultSourceLocator";
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        EvaluationContextManager.startup();
        CDebugCorePlugin.getDefault().addCBreakpointListener((ICBreakpointListener)CBreakpointUpdater.getInstance());
        IAdapterManager manager = Platform.getAdapterManager();
        CDebugElementAdapterFactory elementAdapterFactory = new CDebugElementAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.IModuleRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)elementAdapterFactory, (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.ICModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)elementAdapterFactory, (Class)clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)elementAdapterFactory, (Class)clazz3);
        CDebugElementLabelProviderFactory labelProviderFactory = new CDebugElementLabelProviderFactory();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.cdt.debug.core.model.ICVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)labelProviderFactory, (Class)clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.cdt.debug.core.model.ICRegister");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)labelProviderFactory, (Class)clazz5);
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.ICModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)labelProviderFactory, (Class)clazz6);
        Class<?> clazz7 = class$2;
        if (clazz7 == null) {
            try {
                clazz7 = class$2 = Class.forName("org.eclipse.cdt.core.model.ICElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)labelProviderFactory, (Class)clazz7);
        CWatchExpressionFactoryAdapterFactory watchExpressionAdapterFactory = new CWatchExpressionFactoryAdapterFactory();
        Class<?> clazz8 = class$3;
        if (clazz8 == null) {
            try {
                clazz8 = class$3 = Class.forName("org.eclipse.cdt.debug.core.model.ICVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)watchExpressionAdapterFactory, (Class)clazz8);
        CMemoryAdapterFactory memoryAdapterFactory = new CMemoryAdapterFactory();
        Class<?> clazz9 = class$5;
        if (clazz9 == null) {
            try {
                clazz9 = class$5 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)memoryAdapterFactory, (Class)clazz9);
        Class<?> clazz10 = class$6;
        if (clazz10 == null) {
            try {
                clazz10 = class$6 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockExtension");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)memoryAdapterFactory, (Class)clazz10);
    }

    public void stop(BundleContext context) throws Exception {
        CDebugCorePlugin.getDefault().removeCBreakpointListener((ICBreakpointListener)CBreakpointUpdater.getInstance());
        if (this.fSharedTextColors != null) {
            this.fSharedTextColors.dispose();
            this.fSharedTextColors = null;
        }
        if (this.fImageDescriptorRegistry != null) {
            this.fImageDescriptorRegistry.dispose();
        }
        super.stop(context);
    }

    public ISharedTextColors getSharedTextColors() {
        if (this.fSharedTextColors == null) {
            this.fSharedTextColors = CUIPlugin.getDefault().getSharedTextColors();
        }
        return this.fSharedTextColors;
    }
}

