/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.modules;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.debug.core.model.ICDebugTarget;
import org.eclipse.cdt.debug.core.model.ICModule;
import org.eclipse.cdt.debug.core.model.IModuleRetrieval;
import org.eclipse.cdt.debug.internal.ui.ICDebugHelpContextIds;
import org.eclipse.cdt.debug.internal.ui.IInternalCDebugUIConstants;
import org.eclipse.cdt.debug.internal.ui.actions.ToggleDetailPaneAction;
import org.eclipse.cdt.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.cdt.debug.internal.ui.views.modules.ModulesMessages;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.ICDebugUIConstants;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.texteditor.IUpdate;

public class ModulesView
extends AbstractDebugView
implements IDebugContextListener,
IDebugExceptionHandler,
IPropertyChangeListener,
IPerspectiveListener,
IModelChangedListener,
IViewerUpdateListener {
    protected String PREF_STATE_MEMENTO = "pref_state_memento.";
    protected static final String SASH_VIEW_PART = String.valueOf(CDebugUIPlugin.getUniqueIdentifier()) + ".SASH_VIEW_PART";
    protected static final String SASH_DETAILS_PART = String.valueOf(CDebugUIPlugin.getUniqueIdentifier()) + ".SASH_DETAILS_PART";
    private SashForm fSashForm;
    private ISourceViewer fDetailViewer;
    private IDocument fDetailDocument;
    private boolean fTreeHasFocus = true;
    private Viewer fFocusViewer = null;
    private ISelectionChangedListener fTreeSelectionChangedListener;
    private ISelectionChangedListener fDetailSelectionChangedListener;
    private IDocumentListener fDetailDocumentListener;
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{13, 6};
    private int[] fLastSashWeights;
    private boolean fToggledDetailOnce;
    private ToggleDetailPaneAction[] fToggleDetailPaneActions;
    private String fCurrentDetailPaneOrientation = "Modules.detail.orientation.hidden";
    protected static final String SASH_WEIGHTS = String.valueOf(CDebugUIPlugin.getUniqueIdentifier()) + ".modulesView.SASH_WEIGHTS";
    private ICursorListener fCursorListener;
    private HashMap fSelectionStates = new HashMap(10);
    private HashMap fImageCache = new HashMap(10);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected Viewer createViewer(Composite parent) {
        this.setSashForm(new SashForm(parent, 0));
        CDebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        TreeModelViewer viewer = this.createTreeViewer((Composite)this.getSashForm());
        this.createDetailsViewer();
        this.getSashForm().setMaximizedControl(viewer.getControl());
        this.createOrientationActions();
        IPreferenceStore prefStore = CDebugUIPlugin.getDefault().getPreferenceStore();
        String orientation = prefStore.getString(this.getDetailPanePreferenceKey());
        int i = 0;
        while (i < this.fToggleDetailPaneActions.length) {
            this.fToggleDetailPaneActions[i].setChecked(this.fToggleDetailPaneActions[i].getOrientation().equals(orientation));
            ++i;
        }
        this.setDetailPaneOrientation(orientation);
        viewer.addModelChangedListener((IModelChangedListener)this);
        viewer.addViewerUpdateListener((IViewerUpdateListener)this);
        return viewer;
    }

    protected void createActions() {
        TextViewerAction textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 7);
        textAction.configureAction(ModulesMessages.getString("ModulesView.13"), "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.setAction(ActionFactory.SELECT_ALL.getId(), (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 4);
        textAction.configureAction(ModulesMessages.getString("ModulesView.16"), "", "");
        textAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.setAction(ActionFactory.COPY.getId(), (IAction)textAction);
    }

    protected String getHelpContextId() {
        return ICDebugHelpContextIds.MODULES_VIEW;
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyModulesGroup"));
        menu.add((IContributionItem)new Separator("modulesGroup"));
        menu.add((IContributionItem)new Separator("emptyRefreshGroup"));
        menu.add((IContributionItem)new Separator("refreshGroup"));
        menu.add((IContributionItem)new Separator("additions"));
        this.updateObjects();
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("modulesGroup"));
        tbm.add((IContributionItem)new Separator("refreshGroup"));
    }

    public void handleException(DebugException e) {
        this.showMessage(e.getMessage());
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals(IInternalCDebugUIConstants.DETAIL_PANE_FONT)) {
            this.getDetailViewer().getTextWidget().setFont(JFaceResources.getFont((String)IInternalCDebugUIConstants.DETAIL_PANE_FONT));
        }
    }

    protected void setViewerInput(Object context) {
        Object current;
        IModuleRetrieval mr = null;
        if (context instanceof IAdaptable) {
            ICDebugTarget target;
            IAdaptable iAdaptable = (IAdaptable)context;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.debug.core.model.ICDebugTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((target = (ICDebugTarget)iAdaptable.getAdapter((Class)clazz)) != null) {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.cdt.debug.core.model.IModuleRetrieval");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                mr = (IModuleRetrieval)target.getAdapter((Class)clazz2);
            }
        }
        if (context == null) {
            this.clearDetails();
        }
        if ((current = this.getViewer().getInput()) == null && mr == null) {
            return;
        }
        if (current != null && current.equals(mr)) {
            return;
        }
        this.showViewer();
        this.getViewer().setInput(mr);
    }

    protected TreeModelViewer createTreeViewer(Composite parent) {
        final TreeModelViewer modulesViewer = new TreeModelViewer(parent, 268501762, this.getPresentationContext());
        modulesViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ModulesView.this.fTreeHasFocus = true;
                ModulesView.this.getSite().setSelectionProvider((ISelectionProvider)modulesViewer);
            }

            public void focusLost(FocusEvent e) {
                ModulesView.this.getSite().setSelectionProvider(null);
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)modulesViewer);
        modulesViewer.addPostSelectionChangedListener(this.getTreeSelectionChangedListener());
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).addDebugContextListener((IDebugContextListener)this);
        return modulesViewer;
    }

    protected void createDetailsViewer() {
        SourceViewer detailsViewer = new SourceViewer((Composite)this.getSashForm(), null, 768);
        Listener activateListener = new Listener(){

            public void handleEvent(Event event) {
                ModulesView.this.fTreeHasFocus = false;
            }
        };
        detailsViewer.getControl().addListener(26, activateListener);
        this.setDetailViewer((ISourceViewer)detailsViewer);
        detailsViewer.setDocument(this.getDetailDocument());
        detailsViewer.getTextWidget().setFont(JFaceResources.getFont((String)IInternalCDebugUIConstants.DETAIL_PANE_FONT));
        this.getDetailDocument().addDocumentListener(this.getDetailDocumentListener());
        detailsViewer.configure(new SourceViewerConfiguration());
        detailsViewer.setEditable(false);
        Control control = detailsViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        detailsViewer.getSelectionProvider().addSelectionChangedListener(this.getDetailSelectionChangedListener());
        detailsViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ModulesView.this.setFocusViewer((Viewer)ModulesView.this.getDetailViewer());
            }
        });
        this.createDetailContextMenu((Control)detailsViewer.getTextWidget());
        detailsViewer.getTextWidget().addMouseListener((MouseListener)this.getCursorListener());
        detailsViewer.getTextWidget().addKeyListener((KeyListener)this.getCursorListener());
    }

    private void setDetailViewer(ISourceViewer viewer) {
        this.fDetailViewer = viewer;
    }

    protected ISourceViewer getDetailViewer() {
        return this.fDetailViewer;
    }

    protected SashForm getSashForm() {
        return this.fSashForm;
    }

    private void setSashForm(SashForm sashForm) {
        this.fSashForm = sashForm;
    }

    protected TreeModelViewer getModulesViewer() {
        return (TreeModelViewer)this.getViewer();
    }

    protected void setFocusViewer(Viewer viewer) {
        this.fFocusViewer = viewer;
    }

    protected Viewer getFocusViewer() {
        return this.fFocusViewer;
    }

    protected ISelectionChangedListener getTreeSelectionChangedListener() {
        if (this.fTreeSelectionChangedListener == null) {
            this.fTreeSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelectionProvider().equals(ModulesView.this.getModulesViewer())) {
                        ModulesView.this.clearStatusLine();
                        if (ModulesView.this.getSashForm().getMaximizedControl() == ModulesView.this.getViewer().getControl()) {
                            return;
                        }
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        ModulesView.this.populateDetailPaneFromSelection(selection);
                        ModulesView.this.treeSelectionChanged(event);
                    }
                }
            };
        }
        return this.fTreeSelectionChangedListener;
    }

    protected void treeSelectionChanged(SelectionChangedEvent event) {
    }

    public void populateDetailPane() {
        Viewer viewer;
        if (this.isDetailPaneVisible() && (viewer = this.getViewer()) != null) {
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            this.populateDetailPaneFromSelection(selection);
        }
    }

    protected void populateDetailPaneFromSelection(IStructuredSelection selection) {
        this.getDetailDocument().set("");
        if (!selection.isEmpty()) {
            this.computeDetail(selection.getFirstElement());
        }
    }

    protected ISelectionChangedListener getDetailSelectionChangedListener() {
        if (this.fDetailSelectionChangedListener == null) {
            this.fDetailSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                }
            };
        }
        return this.fDetailSelectionChangedListener;
    }

    protected IDocumentListener getDetailDocumentListener() {
        if (this.fDetailDocumentListener == null) {
            this.fDetailDocumentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                }
            };
        }
        return this.fDetailDocumentListener;
    }

    protected IDocument getDetailDocument() {
        if (this.fDetailDocument == null) {
            this.fDetailDocument = new Document();
        }
        return this.fDetailDocument;
    }

    protected void updateSelectionDependentActions() {
    }

    protected void updateAction(String actionId) {
        IAction action = this.getAction(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected void createDetailContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ModulesView.this.fillDetailContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.getSite().registerContextMenu(ICDebugUIConstants.MODULES_VIEW_DETAIL_ID, menuMgr, this.getDetailViewer().getSelectionProvider());
        this.addContextMenuManager((IMenuManager)menuMgr);
    }

    protected void fillDetailContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("modulesGroup"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(ActionFactory.COPY.getId()));
        menu.add(this.getAction(ActionFactory.SELECT_ALL.getId()));
        menu.add((IContributionItem)new Separator("additions"));
        this.updateObjects();
    }

    private ICursorListener getCursorListener() {
        if (this.fCursorListener == null) {
            this.fCursorListener = new ICursorListener(){

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                }
            };
        }
        return this.fCursorListener;
    }

    public void setDetailPaneOrientation(String orientation) {
        if (orientation.equals(this.fCurrentDetailPaneOrientation)) {
            return;
        }
        if (orientation.equals("Modules.detail.orientation.hidden")) {
            this.hideDetailPane();
        } else {
            int vertOrHoriz = orientation.equals("Modules.detail.orientation.underneath") ? 512 : 256;
            this.getSashForm().setOrientation(vertOrHoriz);
            if ("Modules.detail.orientation.hidden".equals(this.fCurrentDetailPaneOrientation)) {
                this.showDetailPane();
            }
        }
        this.fCurrentDetailPaneOrientation = orientation;
        CDebugUIPlugin.getDefault().getPreferenceStore().setValue(this.getDetailPanePreferenceKey(), orientation);
    }

    private void hideDetailPane() {
        if (this.fToggledDetailOnce) {
            this.setLastSashWeights(this.getSashForm().getWeights());
        }
        this.getSashForm().setMaximizedControl(this.getViewer().getControl());
    }

    private void showDetailPane() {
        this.getSashForm().setMaximizedControl(null);
        this.getSashForm().setWeights(this.getLastSashWeights());
        this.populateDetailPane();
        this.revealTreeSelection();
        this.fToggledDetailOnce = true;
    }

    protected String getDetailPanePreferenceKey() {
        return "Modules.detail.orientation";
    }

    protected int[] getLastSashWeights() {
        if (this.fLastSashWeights == null) {
            this.fLastSashWeights = DEFAULT_SASH_WEIGHTS;
        }
        return this.fLastSashWeights;
    }

    protected void setLastSashWeights(int[] weights) {
        this.fLastSashWeights = weights;
    }

    private void createOrientationActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fToggleDetailPaneActions = new ToggleDetailPaneAction[3];
        this.fToggleDetailPaneActions[0] = new ToggleDetailPaneAction(this, "Modules.detail.orientation.underneath", null);
        this.fToggleDetailPaneActions[1] = new ToggleDetailPaneAction(this, "Modules.detail.orientation.right", null);
        this.fToggleDetailPaneActions[2] = new ToggleDetailPaneAction(this, "Modules.detail.orientation.hidden", this.getToggleActionLabel());
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)this.fToggleDetailPaneActions[0]);
        viewMenu.add((IAction)this.fToggleDetailPaneActions[1]);
        viewMenu.add((IAction)this.fToggleDetailPaneActions[2]);
        viewMenu.add((IContributionItem)new Separator());
    }

    protected String getToggleActionLabel() {
        return ModulesMessages.getString("ModulesView.0");
    }

    protected boolean isDetailPaneVisible() {
        return !this.fToggleDetailPaneActions[2].isChecked();
    }

    protected void revealTreeSelection() {
        Object selected;
        ISelection selection;
        StructuredViewer viewer = (StructuredViewer)this.getViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) != null) {
            viewer.reveal(selected);
        }
    }

    public void toggleDetailPaneWordWrap(boolean on) {
        this.fDetailViewer.getTextWidget().setWordWrap(on);
    }

    public void saveViewerState(IMemento memento) {
        if (this.fSashForm != null && !this.fSashForm.isDisposed()) {
            int[] weights = this.fSashForm.getWeights();
            memento.putInteger(SASH_VIEW_PART, weights[0]);
            memento.putInteger(SASH_DETAILS_PART, weights[1]);
        }
        this.getModulesViewer().saveState(memento);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(IViewSite site, IMemento memento) throws PartInitException {
        Integer sw;
        super.init(site, memento);
        this.PREF_STATE_MEMENTO = String.valueOf(this.PREF_STATE_MEMENTO) + site.getId();
        IPreferenceStore store = CDebugUIPlugin.getDefault().getPreferenceStore();
        String string = store.getString(this.PREF_STATE_MEMENTO);
        if (string.length() > 0) {
            ByteArrayInputStream bin = new ByteArrayInputStream(string.getBytes());
            InputStreamReader reader = new InputStreamReader(bin);
            try {
                try {
                    XMLMemento stateMemento = XMLMemento.createReadRoot((Reader)reader);
                    this.setMemento((IMemento)stateMemento);
                }
                catch (WorkbenchException workbenchException) {}
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    reader.close();
                    bin.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var8_11 = null;
            }
            try {}
            catch (IOException iOException) {}
            reader.close();
            bin.close();
        }
        IMemento mem = this.getMemento();
        this.setLastSashWeights(DEFAULT_SASH_WEIGHTS);
        this.setLastSashWeights(DEFAULT_SASH_WEIGHTS);
        if (mem != null && (sw = mem.getInteger(SASH_VIEW_PART)) != null) {
            int details;
            int view = sw;
            sw = mem.getInteger(SASH_DETAILS_PART);
            if (sw != null && view > -1 & (details = sw.intValue()) > -1) {
                this.setLastSashWeights(new int[]{view, details});
            }
        }
        site.getWorkbenchWindow().addPerspectiveListener((IPerspectiveListener)this);
    }

    protected Control getDefaultControl() {
        return this.getSashForm();
    }

    protected void becomesHidden() {
        this.setViewerInput(new StructuredSelection());
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        ISelection selection = DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).getActiveContext();
        this.contextActivated(selection);
    }

    private void computeDetail(final Object element) {
        if (element != null) {
            DebugPlugin.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ModulesView.this.detailComputed(element, ModulesView.this.doComputeDetail(element));
                }
            });
        }
    }

    protected String doComputeDetail(Object element) {
        if (element instanceof ICModule) {
            return this.getModuleDetail((ICModule)element);
        }
        if (element instanceof ICElement) {
            return element.toString();
        }
        return "";
    }

    private String getModuleDetail(ICModule module) {
        long size;
        IAddress baseAddress;
        StringBuffer sb = new StringBuffer();
        String type = null;
        switch (module.getType()) {
            case 1: {
                type = ModulesMessages.getString("ModulesView.1");
                break;
            }
            case 2: {
                type = ModulesMessages.getString("ModulesView.2");
            }
        }
        if (type != null) {
            sb.append(ModulesMessages.getString("ModulesView.3"));
            sb.append(type);
            sb.append('\n');
        }
        sb.append(ModulesMessages.getString("ModulesView.4"));
        sb.append(module.areSymbolsLoaded() ? ModulesMessages.getString("ModulesView.5") : ModulesMessages.getString("ModulesView.6"));
        sb.append('\n');
        sb.append(ModulesMessages.getString("ModulesView.7"));
        sb.append(module.getSymbolsFileName().toOSString());
        sb.append('\n');
        String cpu = module.getCPU();
        if (cpu != null) {
            sb.append(ModulesMessages.getString("ModulesView.8"));
            sb.append(cpu);
            sb.append('\n');
        }
        if (!(baseAddress = module.getBaseAddress()).isZero()) {
            sb.append(ModulesMessages.getString("ModulesView.9"));
            sb.append(baseAddress.toHexAddressString());
            sb.append('\n');
        }
        if ((size = module.getSize()) > 0L) {
            sb.append(ModulesMessages.getString("ModulesView.10"));
            sb.append(size);
            sb.append('\n');
        }
        return sb.toString();
    }

    protected void detailComputed(Object element, final String result) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (ModulesView.this.isAvailable()) {
                    ModulesView.this.getDetailDocument().set(result);
                }
            }
        };
        this.asyncExec(runnable);
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this);
        this.getSite().getWorkbenchWindow().removePerspectiveListener((IPerspectiveListener)this);
        CDebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        TreeModelViewer viewer = this.getModulesViewer();
        if (viewer != null) {
            viewer.removeModelChangedListener((IModelChangedListener)this);
            viewer.removeViewerUpdateListener((IViewerUpdateListener)this);
        }
        if (viewer != null) {
            this.getDetailDocument().removeDocumentListener(this.getDetailDocumentListener());
        }
        this.disposeImageCache();
        super.dispose();
    }

    protected Image getImage(ImageDescriptor desc) {
        Image image = (Image)this.fImageCache.get(desc);
        if (image == null) {
            image = desc.createImage();
            this.fImageCache.put(desc, image);
        }
        return image;
    }

    private void disposeImageCache() {
        Iterator it = this.fImageCache.values().iterator();
        while (it.hasNext()) {
            ((Image)it.next()).dispose();
        }
        this.fImageCache.clear();
    }

    public void contextActivated(ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection instanceof IStructuredSelection) {
            this.setViewerInput(((IStructuredSelection)selection).getFirstElement());
        }
        this.showViewer();
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext());
        }
    }

    private IPresentationContext getPresentationContext() {
        return new ModulesViewPresentationContext(CDebugUIPlugin.getDebugModelPresentation());
    }

    private void clearDetails() {
        this.getDetailDocument().set("");
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (changeId.equals("reset")) {
            this.setLastSashWeights(DEFAULT_SASH_WEIGHTS);
            this.fSashForm.setWeights(DEFAULT_SASH_WEIGHTS);
        }
    }

    public void modelChanged(IModelDelta delta, IModelProxy proxy) {
    }

    public void updateComplete(IViewerUpdate update) {
        IStatus status = update.getStatus();
        if (!update.isCanceled()) {
            if (status != null && status.getCode() != 0) {
                this.showMessage(status.getMessage());
            } else {
                this.showViewer();
            }
        }
    }

    public void updateStarted(IViewerUpdate update) {
    }

    public void viewerUpdatesBegin() {
    }

    public void viewerUpdatesComplete() {
    }

    protected void clearStatusLine() {
        IStatusLineManager manager = this.getViewSite().getActionBars().getStatusLineManager();
        manager.setErrorMessage(null);
        manager.setMessage(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void partDeactivated(IWorkbenchPart part) {
        String id = part.getSite().getId();
        if (id.equals(this.getSite().getId())) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(bout);
            try {
                try {
                    XMLMemento memento = XMLMemento.createWriteRoot((String)"ModulesViewMemento");
                    this.saveViewerState((IMemento)memento);
                    memento.save((Writer)writer);
                    IPreferenceStore store = CDebugUIPlugin.getDefault().getPreferenceStore();
                    String xmlString = bout.toString();
                    store.putValue(this.PREF_STATE_MEMENTO, xmlString);
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    writer.close();
                    bout.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var8_10 = null;
            }
            try {}
            catch (IOException iOException) {}
            writer.close();
            bout.close();
        }
        super.partDeactivated(part);
    }

    static interface ICursorListener
    extends MouseListener,
    KeyListener {
    }

    public class ModulesViewPresentationContext
    extends PresentationContext {
        private IDebugModelPresentation fModelPresentation;

        public ModulesViewPresentationContext(IDebugModelPresentation modelPresentation) {
            super(ICDebugUIConstants.ID_MODULES_VIEW);
            this.fModelPresentation = modelPresentation;
        }

        public IDebugModelPresentation getModelPresentation() {
            return this.fModelPresentation;
        }
    }
}

