/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.actions;

import java.math.BigInteger;
import org.eclipse.cdt.debug.internal.core.model.CMemoryBlockExtension;
import org.eclipse.cdt.debug.internal.ui.actions.AddWatchpointActionDelegate;
import org.eclipse.cdt.debug.internal.ui.actions.AddWatchpointDialog;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.ICMemorySelection;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.memory.provisional.AbstractAsyncTableRendering;
import org.eclipse.debug.ui.memory.AbstractMemoryRendering;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class AddWatchpointOnMemoryActionDelegate
extends AddWatchpointActionDelegate {
    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IStructuredSelection selection = this.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (obj != null) {
            AbstractAsyncTableRendering r;
            String memorySpace = null;
            String address = "";
            String range = "1";
            if (obj instanceof AbstractAsyncTableRendering) {
                r = (AbstractAsyncTableRendering)obj;
                memorySpace = this.getMemorySpace(r.getMemoryBlock(), memorySpace);
                address = this.getSelectedAddress(r.getSelectedAddress(), address);
                range = this.getRange(r.getSelectedAsBytes(), range);
            } else if (obj instanceof ICMemorySelection) {
                ICMemorySelection sel = (ICMemorySelection)obj;
                memorySpace = this.getMemorySpace((IMemoryBlock)sel.getContainingBlock(), memorySpace);
                address = this.getSelectedAddress(sel.getAddress(), address);
                range = sel.getUnits().toString();
            } else if (obj instanceof AbstractMemoryRendering) {
                r = (AbstractMemoryRendering)obj;
                address = this.getSelectedAddress(BigInteger.valueOf(r.getMemoryBlock().getStartAddress()), address);
            }
            AddWatchpointDialog dlg = new AddWatchpointDialog(CDebugUIPlugin.getActiveWorkbenchShell(), AddWatchpointOnMemoryActionDelegate.getMemorySpaceManagement());
            dlg.initializeMemorySpace(memorySpace);
            dlg.setExpression(address);
            dlg.initializeRange(true, range);
            if (dlg.open() == 0) {
                this.addWatchpoint(dlg.getWriteAccess(), dlg.getReadAccess(), dlg.getExpression(), dlg.getMemorySpace(), dlg.getRange());
            }
        }
    }

    private String getMemorySpace(IMemoryBlock memBlock, String def) {
        if (memBlock != null && memBlock instanceof CMemoryBlockExtension) {
            return ((CMemoryBlockExtension)memBlock).getMemorySpaceID();
        }
        return def;
    }

    private String getSelectedAddress(BigInteger selectedAddress, String def) {
        if (selectedAddress != null) {
            return "0x" + selectedAddress.toString(16);
        }
        return def;
    }

    private String getRange(MemoryByte[] selectedBytes, String def) {
        if (selectedBytes != null && selectedBytes.length > 0) {
            return Integer.toString(selectedBytes.length);
        }
        return def;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getView().getViewSite().getSelectionProvider().getSelection();
    }
}

