/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.make.internal.core.scannerconfig2.SCProfileInstance;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfile;
import org.eclipse.cdt.make.internal.core.scannerconfig2.ScannerConfigProfileManager;
import org.eclipse.core.resources.IProject;

public abstract class AbstractGCCBOPConsoleParser
implements IScannerInfoConsoleParser {
    private static final String[] COMPILER_INVOCATION = new String[]{"gcc", "g++", "cc", "c++"};
    private IProject project;
    private IScannerInfoCollector collector;
    private boolean bMultiline = false;
    private String sMultiline = "";

    protected IProject getProject() {
        return this.project;
    }

    protected IScannerInfoCollector getCollector() {
        return this.collector;
    }

    public void startup(IProject project, IScannerInfoCollector collector) {
        this.project = project;
        this.collector = collector;
    }

    public String[] getCompilerCommands() {
        String[] compilerCommands;
        String compilerCommandsString;
        SCProfileInstance profileInstance;
        ScannerConfigProfile.BuildOutputProvider boProvider;
        if (this.project != null && (boProvider = (profileInstance = ScannerConfigProfileManager.getInstance().getSCProfileInstance(this.project, "")).getProfile().getBuildOutputProviderElement()) != null && (compilerCommandsString = boProvider.getScannerInfoConsoleParser().getCompilerCommands()) != null && compilerCommandsString.length() > 0 && (compilerCommands = compilerCommandsString.split(",\\s+")).length > 0) {
            String[] compilerInvocation = new String[COMPILER_INVOCATION.length + compilerCommands.length];
            System.arraycopy(COMPILER_INVOCATION, 0, compilerInvocation, 0, COMPILER_INVOCATION.length);
            System.arraycopy(compilerCommands, 0, compilerInvocation, COMPILER_INVOCATION.length, compilerCommands.length);
            return compilerInvocation;
        }
        return COMPILER_INVOCATION;
    }

    public boolean processLine(String line) {
        boolean rc = false;
        int lineBreakPos = line.length() - 1;
        char[] lineChars = line.toCharArray();
        while (lineBreakPos >= 0 && Character.isWhitespace(lineChars[lineBreakPos])) {
            --lineBreakPos;
        }
        if (lineBreakPos >= 0 && (lineChars[lineBreakPos] != '\\' || lineBreakPos > 0 && lineChars[lineBreakPos - 1] == '\\')) {
            lineBreakPos = -1;
        }
        if (lineBreakPos >= 0) {
            this.sMultiline = String.valueOf(this.sMultiline) + line.substring(0, lineBreakPos);
            this.bMultiline = true;
            return rc;
        }
        if (this.bMultiline) {
            line = String.valueOf(this.sMultiline) + line;
            this.bMultiline = false;
            this.sMultiline = "";
        }
        TraceUtil.outputTrace("AbstractGCCBOPConsoleParser parsing line: [", line, "]");
        int firstColon = line.indexOf(58);
        String make = line.substring(0, firstColon + 1);
        if (firstColon != -1 && make.indexOf("make") != -1) {
            boolean enter = false;
            String msg = line.substring(firstColon + 1).trim();
            enter = msg.startsWith("Entering directory");
            if (enter || msg.startsWith("Leaving directory")) {
                int s = msg.indexOf(96);
                int e = msg.indexOf(39);
                if (s != -1 && e != -1) {
                    String dir = msg.substring(s + 1, e);
                    if (this.getUtility() != null) {
                        this.getUtility().changeMakeDirectory(dir, this.getDirectoryLevel(line), enter);
                    }
                    return rc;
                }
            }
        }
        return this.processSingleLine(line);
    }

    private int getDirectoryLevel(String line) {
        int s = line.indexOf(91);
        int num = 0;
        if (s != -1) {
            int e = line.indexOf(93);
            String number = line.substring(s + 1, e).trim();
            try {
                num = Integer.parseInt(number);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return num;
    }

    protected abstract boolean processSingleLine(String var1);

    protected abstract AbstractGCCBOPConsoleParserUtility getUtility();

    public void shutdown() {
        if (this.getUtility() != null) {
            this.getUtility().reportProblems();
        }
    }
}

