/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParser;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.AbstractGCCBOPConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.GCCPerFileBOPConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CCommandDSC;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class GCCPerFileBOPConsoleParser
extends AbstractGCCBOPConsoleParser {
    private static final String[] FILE_EXTENSIONS = new String[]{".c", ".cc", ".cpp", ".cxx", ".C", ".CC", ".CPP", ".CXX"};
    private static final List FILE_EXTENSIONS_LIST = Arrays.asList(FILE_EXTENSIONS);
    private String[] compilerInvocation;
    private GCCPerFileBOPConsoleParserUtility fUtil;

    public void startup(IProject project, IPath workingDirectory, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        this.fUtil = project != null && workingDirectory != null && markerGenerator != null ? new GCCPerFileBOPConsoleParserUtility(project, workingDirectory, markerGenerator) : null;
        super.startup(project, collector);
        this.compilerInvocation = this.getCompilerCommands();
    }

    protected AbstractGCCBOPConsoleParserUtility getUtility() {
        return this.fUtil;
    }

    protected boolean processSingleLine(String line) {
        boolean rc = false;
        int compilerInvocationIndex = -1;
        int cii = 0;
        while (cii < this.compilerInvocation.length) {
            compilerInvocationIndex = line.indexOf(this.compilerInvocation[cii]);
            if (compilerInvocationIndex != -1) break;
            ++cii;
        }
        if (compilerInvocationIndex == -1) {
            return rc;
        }
        ArrayList split = this.splitLine(line, compilerInvocationIndex);
        compilerInvocationIndex = 0;
        while (compilerInvocationIndex < split.size()) {
            String command = (String)split.get(compilerInvocationIndex);
            int idx = this.lastIndexOfCompilerCommand(command);
            if (idx >= 0) break;
            ++compilerInvocationIndex;
        }
        if (compilerInvocationIndex >= split.size()) {
            TraceUtil.outputTrace("Error identifying compiler command", line, TraceUtil.EOL);
            return rc;
        }
        int extensionsIndex = -1;
        boolean found = false;
        String filePath = null;
        int i = compilerInvocationIndex + 1;
        while (i < split.size()) {
            String fileExtension;
            String segment = (String)split.get(i);
            int k = segment.lastIndexOf(46);
            if (k != -1 && segment.length() - k < 5 && (extensionsIndex = FILE_EXTENSIONS_LIST.indexOf(fileExtension = segment.substring(k))) != -1) {
                filePath = segment;
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            TraceUtil.outputTrace("Error identifying file name :1", line, TraceUtil.EOL);
            return rc;
        }
        if (filePath.indexOf(FILE_EXTENSIONS[extensionsIndex]) == -1) {
            TraceUtil.outputTrace("Error identifying file name :2", line, TraceUtil.EOL);
            return rc;
        }
        if (this.fUtil != null) {
            IPath pFilePath = this.fUtil.getAbsolutePath(filePath);
            String shortFileName = pFilePath.removeFileExtension().lastSegment();
            int i2 = 0;
            while (i2 < split.size()) {
                String token = (String)split.get(i2);
                if (token.equals("-include")) {
                    ++i2;
                } else if (token.equals("-imacros")) {
                    ++i2;
                } else if (token.equals(filePath)) {
                    split.set(i2, "LONG_NAME");
                } else if (token.startsWith(shortFileName)) {
                    split.set(i2, token.replaceFirst(shortFileName, "SHORT_NAME"));
                }
                ++i2;
            }
            CCommandDSC cmd = this.fUtil.getNewCCommandDSC(split.toArray(new String[split.size()]), extensionsIndex > 0);
            IPath baseDirectory = this.fUtil.getBaseDirectory();
            if (baseDirectory.isPrefixOf(pFilePath)) {
                ArrayList<CCommandDSC> cmdList = new ArrayList<CCommandDSC>();
                cmdList.add(cmd);
                HashMap<ScannerInfoTypes, ArrayList<CCommandDSC>> sc = new HashMap<ScannerInfoTypes, ArrayList<CCommandDSC>>(1);
                sc.put(ScannerInfoTypes.COMPILER_COMMAND, cmdList);
                IPath relPath = pFilePath.removeFirstSegments(baseDirectory.segmentCount());
                IFile file = this.getProject().getFile(relPath);
                this.getCollector().contributeToScannerConfig(file, sc);
            } else {
                TraceUtil.outputError("Build command for file outside project: " + pFilePath.toString(), line);
            }
        }
        return rc;
    }

    private int lastIndexOfCompilerCommand(String command) {
        int cii2 = -1;
        int cii = 0;
        while (cii < this.compilerInvocation.length) {
            cii2 = command.lastIndexOf(this.compilerInvocation[cii]);
            if (cii2 >= 0) break;
            ++cii;
        }
        return cii2;
    }

    private ArrayList splitLine(String line, int compilerInvocationIndex) {
        ArrayList<String> split = new ArrayList<String>();
        boolean bSingleQuotes = false;
        boolean bIgnoreSingleQuotes = false;
        boolean bDoubleQuotes = false;
        boolean bIgnoreDoubleQuotes = false;
        char[] chars = line.toCharArray();
        int charPos = 0;
        int length = line.length();
        boolean quit = false;
        boolean acceptExtraSingleQuote = false;
        boolean acceptExtraDoubleQuote = false;
        while (charPos < length) {
            char ch = chars[charPos];
            if (!Character.isWhitespace(ch)) break;
            ++charPos;
        }
        while (charPos < length && !quit) {
            int idx;
            int startPos = -1;
            int endPos = -1;
            while (charPos < length && !quit) {
                char prevch;
                char ch = chars[charPos];
                if (ch == '\'') {
                    if (charPos <= compilerInvocationIndex) {
                        bIgnoreSingleQuotes = !bIgnoreSingleQuotes;
                    } else if (bIgnoreSingleQuotes) {
                        bIgnoreSingleQuotes = false;
                        if (startPos >= 0) {
                            endPos = charPos;
                        }
                        quit = true;
                    } else {
                        boolean bl = bSingleQuotes = !bSingleQuotes;
                    }
                    if (startPos >= 0) {
                        char c = prevch = charPos > 0 ? chars[charPos - 1] : (char)'\u0000';
                        if (acceptExtraSingleQuote) {
                            acceptExtraSingleQuote = false;
                        } else if (prevch != '=' && prevch != '\\') {
                            endPos = charPos;
                        } else {
                            acceptExtraSingleQuote = true;
                        }
                    }
                } else if (ch == '\"') {
                    if (charPos <= compilerInvocationIndex) {
                        bIgnoreDoubleQuotes = !bIgnoreDoubleQuotes;
                    } else if (bIgnoreDoubleQuotes) {
                        bIgnoreDoubleQuotes = false;
                        if (startPos >= 0) {
                            endPos = charPos;
                        }
                        quit = true;
                    } else {
                        boolean bl = bDoubleQuotes = !bDoubleQuotes;
                    }
                    if (startPos >= 0) {
                        char c = prevch = charPos > 0 ? chars[charPos - 1] : (char)'\u0000';
                        if (acceptExtraDoubleQuote) {
                            acceptExtraDoubleQuote = false;
                        } else if (prevch != '=' && prevch != '\\') {
                            endPos = charPos;
                        } else {
                            acceptExtraDoubleQuote = true;
                        }
                    }
                } else if (Character.isWhitespace(ch) || ch == ';') {
                    if (startPos < 0 && (bSingleQuotes || bDoubleQuotes)) {
                        startPos = charPos;
                    } else if (startPos >= 0 && !bSingleQuotes && !bDoubleQuotes) {
                        endPos = charPos;
                    }
                } else {
                    if (startPos < 0) {
                        startPos = charPos;
                    }
                    if (charPos == length - 1) {
                        endPos = charPos + 1;
                    }
                }
                ++charPos;
                if (startPos >= 0 && endPos > startPos) break;
            }
            if (startPos < 0 || endPos < 0) continue;
            String cmdFragment = line.substring(startPos, endPos);
            if (startPos >= compilerInvocationIndex) {
                split.add(cmdFragment);
                continue;
            }
            if (endPos <= compilerInvocationIndex || (idx = this.lastIndexOfCompilerCommand(cmdFragment)) != 0 && (idx <= 0 || cmdFragment.charAt(idx - 1) != '\\' && cmdFragment.charAt(idx - 1) != '/')) continue;
            split.add(cmdFragment);
        }
        return split;
    }
}

