/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.utils.CygPath;
import org.eclipse.cdt.utils.ICygwinToolsFactroy;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class CygpathTranslator {
    private CygPath cygPath = null;
    private boolean isAvailable = false;
    static /* synthetic */ Class class$0;

    public CygpathTranslator(IProject project) {
        try {
            ICExtensionReference[] parserRef = CCorePlugin.getDefault().getBinaryParserExtensions(project);
            int i = 0;
            while (i < parserRef.length) {
                try {
                    ICygwinToolsFactroy cygwinToolFactory;
                    IBinaryParser parser = (IBinaryParser)parserRef[i].createExtension();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.cdt.utils.ICygwinToolsFactroy");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((cygwinToolFactory = (ICygwinToolsFactroy)parser.getAdapter((Class)clazz)) != null) {
                        this.cygPath = cygwinToolFactory.getCygPath();
                        if (this.cygPath != null) {
                            this.isAvailable = true;
                            break;
                        }
                    }
                }
                catch (ClassCastException classCastException) {}
                ++i;
            }
            if (this.cygPath == null && Platform.getOS().equals("win32")) {
                this.cygPath = new CygPath("cygpath");
                this.isAvailable = true;
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {
            this.isAvailable = false;
        }
    }

    public static List translateIncludePaths(IProject project, List sumIncludes) {
        boolean translationNeeded = false;
        if (Platform.getOS().equals("win32")) {
            Iterator i = sumIncludes.iterator();
            while (i.hasNext()) {
                String include = (String)i.next();
                if (!include.startsWith("/")) continue;
                translationNeeded = true;
                break;
            }
        }
        if (!translationNeeded) {
            return sumIncludes;
        }
        CygpathTranslator cygpath = new CygpathTranslator(project);
        if (cygpath.cygPath == null) {
            return sumIncludes;
        }
        ArrayList<String> translatedIncludePaths = new ArrayList<String>();
        Iterator i = sumIncludes.iterator();
        while (i.hasNext()) {
            String includePath = (String)i.next();
            Path realPath = new Path(includePath);
            if (realPath.toFile().exists()) {
                translatedIncludePaths.add(includePath);
                continue;
            }
            String translatedPath = includePath;
            if (cygpath.isAvailable) {
                try {
                    translatedPath = cygpath.cygPath.getFileName(includePath);
                }
                catch (IOException iOException) {
                    TraceUtil.outputError("CygpathTranslator unable to translate path: ", includePath);
                }
            }
            if (!translatedPath.equals(includePath)) {
                Path transPath = new Path(translatedPath);
                if (transPath.toFile().exists()) {
                    translatedIncludePaths.add(transPath.toPortableString());
                    continue;
                }
                translatedIncludePaths.add(translatedPath);
                continue;
            }
            translatedIncludePaths.add(translatedPath);
        }
        cygpath.cygPath.dispose();
        return translatedIncludePaths;
    }
}

