/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class GCCSpecsConsoleParser
implements IScannerInfoConsoleParser {
    private final String INCLUDE = "#include";
    private final String DEFINE = "#define";
    private IProject fProject = null;
    private IScannerInfoCollector fCollector = null;
    private boolean expectingIncludes = false;
    private List symbols = new ArrayList();
    private List includes = new ArrayList();

    public void startup(IProject project, IPath workingDirectory, IScannerInfoCollector collector, IMarkerGenerator markerGenerator) {
        this.fProject = project;
        this.fCollector = collector;
    }

    public boolean processLine(String line) {
        boolean rc = false;
        line = line.trim();
        TraceUtil.outputTrace("GCCSpecsConsoleParser parsing line: [", line, "]");
        if (line.startsWith("#define")) {
            String[] defineParts = line.split("\\s+", 3);
            if (defineParts[0].equals("#define")) {
                String symbol = null;
                switch (defineParts.length) {
                    case 2: {
                        symbol = defineParts[1];
                        break;
                    }
                    case 3: {
                        symbol = String.valueOf(defineParts[1]) + "=" + defineParts[2];
                    }
                }
                if (symbol != null && !this.symbols.contains(symbol)) {
                    this.symbols.add(symbol);
                }
            }
        } else if (line.startsWith("#include") && line.endsWith("search starts here:")) {
            this.expectingIncludes = true;
        } else if (line.startsWith("End of search list.")) {
            this.expectingIncludes = false;
        } else if (this.expectingIncludes && !this.includes.contains(line)) {
            this.includes.add(line);
        }
        return rc;
    }

    public void shutdown() {
        HashMap<ScannerInfoTypes, List> scannerInfo = new HashMap<ScannerInfoTypes, List>();
        scannerInfo.put(ScannerInfoTypes.INCLUDE_PATHS, this.includes);
        scannerInfo.put(ScannerInfoTypes.SYMBOL_DEFINITIONS, this.symbols);
        if (this.fCollector != null) {
            this.fCollector.contributeToScannerConfig(this.fProject, scannerInfo);
        }
        TraceUtil.outputTrace("Scanner info from 'specs' file", "Include paths", this.includes, new ArrayList(), "Defined symbols", this.symbols);
    }
}

