/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.editor;

import org.eclipse.cdt.make.internal.ui.editor.MakefileEditor;
import org.eclipse.cdt.make.internal.ui.text.ColorManager;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileAnnotationHover;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileCodeScanner;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileCompletionProcessor;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileReconcilingStrategy;
import org.eclipse.cdt.make.internal.ui.text.makefile.MakefileTextHover;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

public class MakefileSourceConfiguration
extends TextSourceViewerConfiguration {
    private ColorManager colorManager;
    MakefileCodeScanner codeScanner;
    private MakefileEditor fEditor;

    public MakefileSourceConfiguration(IPreferenceStore preferenceStore, MakefileEditor editor) {
        super(preferenceStore);
        this.fEditor = editor;
        this.colorManager = ColorManager.getDefault();
    }

    public String[] getConfiguredContentTypes(ISourceViewer v) {
        return new String[]{"__dftl_partition_content_type", "makefile_comment", "makefile_if_block", "makefile_def_block", "makefile_include_block", "makefile_macro_assignement"};
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.fEditor != null && this.fEditor.isEditable()) {
            ContentAssistant assistant = new ContentAssistant();
            assistant.setContentAssistProcessor((IContentAssistProcessor)new MakefileCompletionProcessor((IEditorPart)this.fEditor), "__dftl_partition_content_type");
            assistant.setContentAssistProcessor((IContentAssistProcessor)new MakefileCompletionProcessor((IEditorPart)this.fEditor), "makefile_comment");
            assistant.setContentAssistProcessor((IContentAssistProcessor)new MakefileCompletionProcessor((IEditorPart)this.fEditor), "makefile_def_block");
            assistant.setContentAssistProcessor((IContentAssistProcessor)new MakefileCompletionProcessor((IEditorPart)this.fEditor), "makefile_if_block");
            assistant.setContentAssistProcessor((IContentAssistProcessor)new MakefileCompletionProcessor((IEditorPart)this.fEditor), "makefile_include_block");
            assistant.setContentAssistProcessor((IContentAssistProcessor)new MakefileCompletionProcessor((IEditorPart)this.fEditor), "makefile_macro_assignement");
            assistant.enableAutoActivation(true);
            assistant.setAutoActivationDelay(500);
            assistant.setProposalPopupOrientation(21);
            assistant.setContextInformationPopupOrientation(21);
            assistant.setContextInformationPopupBackground(this.colorManager.getColor(new RGB(0, 191, 255)));
            return assistant;
        }
        return null;
    }

    protected MakefileCodeScanner getCodeScanner() {
        if (this.codeScanner == null) {
            this.codeScanner = new MakefileCodeScanner();
        }
        return this.codeScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer v) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "makefile_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "makefile_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "makefile_macro_assignement");
        reconciler.setRepairer((IPresentationRepairer)dr, "makefile_macro_assignement");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "makefile_include_block");
        reconciler.setRepairer((IPresentationRepairer)dr, "makefile_include_block");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "makefile_if_block");
        reconciler.setRepairer((IPresentationRepairer)dr, "makefile_if_block");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "makefile_def_block");
        reconciler.setRepairer((IPresentationRepairer)dr, "makefile_def_block");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "makefile_other");
        reconciler.setRepairer((IPresentationRepairer)dr, "makefile_other");
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fEditor != null && this.fEditor.isEditable()) {
            MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)new MakefileReconcilingStrategy(this.fEditor), false);
            reconciler.setDelay(1000);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            return reconciler;
        }
        return null;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"#"};
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.fEditor != null) {
            return new MakefileTextHover((IEditorPart)this.fEditor);
        }
        return super.getTextHover(sourceViewer, contentType);
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        if (this.fEditor != null) {
            return new MakefileAnnotationHover((IEditorPart)this.fEditor);
        }
        return super.getAnnotationHover(sourceViewer);
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        MakefileCodeScanner scanner = this.getCodeScanner();
        return scanner.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        MakefileCodeScanner scanner = this.getCodeScanner();
        scanner.adaptToPreferenceChange(event);
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

