/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.ListIterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.cdt.managedbuilder.testplugin.CTestPlugin;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class ManagedProject30MakefileTests
extends TestCase {
    public static final String MBS_TEMP_DIR = "MBSTemp";
    static boolean pathVariableCreated = false;
    static /* synthetic */ Class class$0;

    public ManagedProject30MakefileTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ManagedProject30MakefileTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        suite.addTest((Test)new ManagedProject30MakefileTests("test30SingleFileExe"));
        suite.addTest((Test)new ManagedProject30MakefileTests("test30TwoFileSO"));
        suite.addTest((Test)new ManagedProject30MakefileTests("test30MultiResConfig"));
        suite.addTest((Test)new ManagedProject30MakefileTests("test30LinkedLib"));
        suite.addTest((Test)new ManagedProject30MakefileTests("test30CopyandDeploy"));
        suite.addTest((Test)new ManagedProject30MakefileTests("test30DeleteFile"));
        suite.addTest((Test)new ManagedProject30MakefileTests("test30NoFilesToBuild"));
        suite.addTest((Test)new ManagedProject30MakefileTests("testFileWithNoExtension"));
        suite.addTest((Test)new ManagedProject30MakefileTests("testPreAndPostProcessBuildSteps"));
        suite.addTest((Test)new ManagedProject30MakefileTests("testResourceCustomBuildStep"));
        suite.addTest((Test)new ManagedProject30MakefileTests("test30_1"));
        suite.addTest((Test)new ManagedProject30MakefileTests("test30_2"));
        suite.addTest((Test)new ManagedProject30MakefileTests("testTopTC"));
        suite.addTest((Test)new ManagedProject30MakefileTests("CDTFortranTest1"));
        suite.addTest((Test)new ManagedProject30MakefileTests("CDTFortranTest2"));
        suite.addTest((Test)new ManagedProject30MakefileTests("TestATO"));
        suite.addTest((Test)new ManagedProject30MakefileTests("testMacroSupportInBuildDefinitions"));
        suite.addTest((Test)new ManagedProject30MakefileTests("testSpaces"));
        if (File.separatorChar == '\\') {
            suite.addTest((Test)new ManagedProject30MakefileTests("testInputTypeOption"));
        }
        return suite;
    }

    private IProject[] createProject(String projName, IPath location, String projectTypeId, boolean containsZip) {
        ArrayList<IProject> projectList = null;
        if (containsZip) {
            File testDir = CTestPlugin.getFileInPlugin((IPath)new Path("resources/test30Projects/" + projName));
            if (testDir == null) {
                ManagedProject30MakefileTests.fail((String)("Test project directory " + projName + " is missing."));
                return null;
            }
            File[] projectZips = testDir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return !pathname.isDirectory();
                }
            });
            projectList = new ArrayList(projectZips.length);
            int i = 0;
            while (i < projectZips.length) {
                try {
                    IProject project;
                    String projectName = projectZips[i].getName();
                    if (projectName.endsWith(".zip") && (projectName = projectName.substring(0, projectName.length() - ".zip".length())).length() != 0 && (project = ManagedBuildTestHelper.createProject(projectName, projectZips[i], location, projectTypeId)) != null) {
                        projectList.add(project);
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
            if (projectList.size() == 0) {
                ManagedProject30MakefileTests.fail((String)("No projects found in test project directory " + testDir.getName() + ".  The .zip file may be missing or corrupt."));
                return null;
            }
        } else {
            try {
                IProject project = ManagedBuildTestHelper.createProject(projName, null, location, projectTypeId);
                if (project != null) {
                    projectList = new ArrayList<IProject>(1);
                }
                projectList.add(project);
            }
            catch (Exception exception) {}
        }
        return projectList.toArray(new IProject[projectList.size()]);
    }

    private IProject[] createProjects(String projName, IPath location, String projectTypeId, boolean containsZip) {
        IOverwriteQuery queryALL = new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "ALL";
            }
        };
        new IOverwriteQuery(){

            public String queryOverwrite(String file) {
                return "NOALL";
            }
        };
        UpdateManagedProjectManager.setBackupFileOverwriteQuery((IOverwriteQuery)queryALL);
        UpdateManagedProjectManager.setUpdateProjectQuery((IOverwriteQuery)queryALL);
        IProject[] projects = this.createProject(projName, location, projectTypeId, containsZip);
        return projects;
    }

    private void buildProjectsWorker(IProject[] projects, IPath[] files, boolean compareBenchmark) {
        if (projects == null || projects.length == 0) {
            return;
        }
        boolean succeeded = true;
        int i = 0;
        while (i < projects.length) {
            IProject curProject = projects[i];
            IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)curProject);
            boolean isCompatible = UpdateManagedProjectManager.isCompatibleProject((IManagedBuildInfo)info);
            ManagedProject30MakefileTests.assertTrue((boolean)isCompatible);
            if (isCompatible) {
                try {
                    curProject.build(10, null);
                }
                catch (CoreException e) {
                    ManagedProject30MakefileTests.fail((String)e.getStatus().getMessage());
                }
                catch (OperationCanceledException e) {
                    ManagedProject30MakefileTests.fail((String)("the project \"" + curProject.getName() + "\" build was cancelled, exception message: " + e.getMessage()));
                }
                if (files != null && files.length > 0 && i == 0) {
                    String configName = info.getDefaultConfiguration().getName();
                    IPath buildDir = Path.fromOSString((String)configName);
                    succeeded = compareBenchmark ? ManagedBuildTestHelper.compareBenchmarks(curProject, buildDir, files) : ManagedBuildTestHelper.verifyFilesDoNotExist(curProject, buildDir, files);
                }
            }
            ++i;
        }
        if (succeeded) {
            i = 0;
            while (i < projects.length) {
                ManagedBuildTestHelper.removeProject(projects[i].getName());
                ++i;
            }
        }
    }

    private void buildProjects(IProject[] projects, IPath[] files) {
        this.buildProjectsWorker(projects, files, true);
    }

    private void buildDegenerativeProjects(IProject[] projects, IPath[] files) {
        this.buildProjectsWorker(projects, files, false);
    }

    private void createPathVariable(IPath tmpDir) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace = ResourcesPlugin.getWorkspace();
        IPathVariableManager pathMan = workspace.getPathVariableManager();
        String name = MBS_TEMP_DIR;
        try {
            if (pathMan.validateName(name).isOK() && pathMan.validateValue(tmpDir).isOK()) {
                pathMan.setValue(name, tmpDir);
                ManagedProject30MakefileTests.assertTrue((boolean)pathMan.isDefined(name));
            } else {
                ManagedProject30MakefileTests.fail((String)("could not create the path variable " + name));
            }
        }
        catch (Exception exception) {
            ManagedProject30MakefileTests.fail((String)("could not create the path variable " + name));
        }
    }

    private void createFileLink(IProject project, IPath tmpDir, String linkName, String fileName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String name = MBS_TEMP_DIR;
        if (!pathVariableCreated) {
            this.createPathVariable(tmpDir);
            pathVariableCreated = true;
        }
        try {
            IFile linkF1 = project.getFile(linkName);
            Path location = new Path("MBSTemp/" + fileName);
            if (workspace.validateLinkLocation((IResource)linkF1, (IPath)location).isOK()) {
                linkF1.createLink((IPath)location, 0, null);
            } else {
                ManagedProject30MakefileTests.fail((String)("could not create the link to " + name));
            }
        }
        catch (Exception exception) {
            ManagedProject30MakefileTests.fail((String)("could not create the link to " + name));
        }
    }

    public void test30SingleFileExe() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] projects = this.createProjects("singleFileExe", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    public void test30TwoFileSO() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] projects = this.createProjects("twoFileSO", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    public void test30MultiResConfig() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"main.d"), Path.fromOSString((String)"source1/subdir.mk"), Path.fromOSString((String)"source1/Class1.d"), Path.fromOSString((String)"source2/subdir.mk"), Path.fromOSString((String)"source2/Class2.d"), Path.fromOSString((String)"source2/source21/Class21.d"), Path.fromOSString((String)"source2/source21/subdir.mk")};
        IProject[] projects = this.createProjects("multiResConfig", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test30LinkedLib() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk")};
        IPath[] linkedFiles = new IPath[]{Path.fromOSString((String)"f1_30.c"), Path.fromOSString((String)"f2_30.c"), Path.fromOSString((String)"test_ar_30.h")};
        File srcDirFile = CTestPlugin.getFileInPlugin((IPath)new Path("resources/test30Projects/linkedLib30/"));
        IPath srcDir = Path.fromOSString((String)srcDirFile.toString());
        IPath tmpSubDir = Path.fromOSString((String)"CDTMBSTest");
        IPath tmpDir = ManagedBuildTestHelper.copyFilesToTempDir(srcDir, tmpSubDir, linkedFiles);
        try {
            IProject[] projects = this.createProjects("linkedLib30", null, "cdt.managedbuild.target.gnu30.lib", true);
            IProject project = projects[0];
            this.createFileLink(project, tmpDir, "f1_30.c", "f1_30.c");
            this.createFileLink(project, tmpDir, "f2link_30.c", "f2_30.c");
            this.createFileLink(project, tmpDir, "test_ar_30.h", "test_ar_30.h");
            this.buildProjects(projects, makefiles);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            ManagedBuildTestHelper.deleteTempDir(tmpSubDir, linkedFiles);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        ManagedBuildTestHelper.deleteTempDir(tmpSubDir, linkedFiles);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test30LinkedFolder() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"sources.mk")};
        IPath[] linkedFiles = new IPath[]{Path.fromOSString((String)"f1.c"), Path.fromOSString((String)"f2.c"), Path.fromOSString((String)"test_ar.h"), Path.fromOSString((String)"Benchmarks/makefile"), Path.fromOSString((String)"Benchmarks/objects.mk"), Path.fromOSString((String)"Benchmarks/subdir.mk"), Path.fromOSString((String)"Benchmarks/sources.mk")};
        File srcDirFile = CTestPlugin.getFileInPlugin((IPath)new Path("resources/test30Projects/linkedFolder/"));
        IPath srcDir = Path.fromOSString((String)srcDirFile.toString());
        IPath tmpSubDir = Path.fromOSString((String)"CDTMBSTest");
        IPath tmpDir = ManagedBuildTestHelper.copyFilesToTempDir(srcDir, tmpSubDir, linkedFiles);
        if (!pathVariableCreated) {
            this.createPathVariable(tmpDir);
            pathVariableCreated = true;
        }
        try {
            IPath location = Path.fromOSString((String)MBS_TEMP_DIR);
            IProject[] projects = this.createProjects("linkedFolder", location, "cdt.managedbuild.target.gnu30.lib", false);
            this.buildProjects(projects, makefiles);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            ManagedBuildTestHelper.deleteTempDir(tmpSubDir, linkedFiles);
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        ManagedBuildTestHelper.deleteTempDir(tmpSubDir, linkedFiles);
    }

    public void test30CopyandDeploy() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"main.d"), Path.fromOSString((String)"Functions/subdir.mk"), Path.fromOSString((String)"Functions/Func1.d")};
        IProject[] projects = this.createProjects("copyandDeploy", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    public void test30DeleteFile() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"sources.mk")};
        IProject[] projects = this.createProjects("deleteFile", null, null, true);
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        ArrayList<IFile> resourceList = new ArrayList<IFile>(1);
        IProject project = projects[0];
        IFile projfile = project.getFile("filetobedeleted.cxx");
        resourceList.add(projfile);
        final IResource[] fileResource = resourceList.toArray(new IResource[resourceList.size()]);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                workspace.delete(fileResource, false, null);
            }
        };
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            workspace.run(runnable, (ISchedulingRule)workspace.getRoot(), 1, (IProgressMonitor)monitor);
        }
        catch (Exception exception) {
            ManagedProject30MakefileTests.fail((String)("could not delete file in project " + project.getName()));
        }
        this.buildProjects(projects, makefiles);
    }

    public void test30NoFilesToBuild() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"sources.mk")};
        IProject[] projects = this.createProjects("noFilesToBuild", null, null, true);
        IProject project = projects[0];
        IFile projfile = project.getFile("filetobeexcluded.cxx");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration config = info.getDefaultConfiguration();
        IResourceConfiguration rconfig = config.createResourceConfiguration(projfile);
        rconfig.setExclude(true);
        this.buildDegenerativeProjects(projects, makefiles);
    }

    public void testFileWithNoExtension() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] projects = this.createProjects("testFileWithNoExtension", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    public void testPreAndPostProcessBuildSteps() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"sources.mk")};
        IProject[] projects = this.createProjects("preAndPostBuildSteps", null, null, true);
        IProject project = projects[0];
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration config = info.getDefaultConfiguration();
        project.getFile("main.cxx");
        config.setPreannouncebuildStep("Pre-announce Build Step");
        config.setPrebuildStep("echo 'executing Pre-Build Step' ");
        config.setPostannouncebuildStep("Post-announce Build Step");
        config.setPostbuildStep("echo 'executing Post-Build Step' ");
        this.buildProjects(projects, makefiles);
    }

    public void testResourceCustomBuildStep() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"sources.mk")};
        IProject[] projects = this.createProjects("rcbsBasicTest", null, null, true);
        IProject project = projects[0];
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration config = info.getDefaultConfiguration();
        IFile projfile = project.getFile("rcbsBasicTest.c");
        IResourceConfiguration rconfig = config.createResourceConfiguration(projfile);
        ITool rcbsTool = rconfig.createTool(null, "rcbsBasicTestTool", "rcbs Basic Test Tool", false);
        IInputType rcbsToolInputType = rcbsTool.createInputType(null, "rcbsToolInputTypeId", "rcbsToolInputTypeName", false);
        IAdditionalInput rcbsToolInputTypeAdditionalInput = rcbsToolInputType.createAdditionalInput("");
        rcbsToolInputTypeAdditionalInput.setKind(3);
        IOutputType rcbsToolOutputType = rcbsTool.createOutputType(null, "rcbsToolOutputTypeId", "rcbsToolOutputTypeName", false);
        rcbsToolOutputType.setOutputNames("rcbsBasicTest.o");
        rcbsTool.setCustomBuildStep(true);
        rcbsTool.setToolCommand("gcc -g -c ../rcbsBasicTest.c -o ./rcbsBasicTest.o");
        rcbsTool.setAnnouncement("Now executing custom build step for rcbsBasicTest debug config");
        rconfig.setRcbsApplicability(1);
        this.buildProjects(projects, makefiles);
    }

    public void test30_1() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] projects = this.createProjects("test30_1", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    public void test30_2() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] projects = this.createProjects("test30_2", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    public void testTopTC() {
        IProject[] projects = this.createProjects("TopTC", null, "TopTC.target.exe", false);
        ManagedProject30MakefileTests.assertNotNull((Object)projects);
        ManagedProject30MakefileTests.assertEquals((int)1, (int)projects.length);
        IProject project = projects[0];
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        ManagedProject30MakefileTests.assertNotNull((Object)info);
        IManagedProject managedProj = info.getManagedProject();
        ManagedProject30MakefileTests.assertNotNull((Object)managedProj);
        IConfiguration[] configs = managedProj.getConfigurations();
        ManagedProject30MakefileTests.assertNotNull((Object)configs);
        ManagedProject30MakefileTests.assertEquals((int)2, (int)configs.length);
        int i = 0;
        while (i < configs.length) {
            IConfiguration config = configs[i];
            ToolChain tc = (ToolChain)config.getToolChain();
            ListIterator iter = tc.getToolList().listIterator();
            int j = 0;
            while (iter.hasNext()) {
                Tool cfr_ignored_0 = (Tool)iter.next();
                ++j;
            }
            ManagedProject30MakefileTests.assertEquals((int)5, (int)j);
            ++i;
        }
        this.buildDegenerativeProjects(projects, null);
    }

    public void CDTFortranTest1() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] projects = this.createProjects("CDTFortranTest1", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    public void CDTFortranTest2() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"module/subdir.mk"), Path.fromOSString((String)"Sources/subdir.mk")};
        IProject[] projects = this.createProjects("CDTFortranTest2", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    public void TestATO() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] projects = this.createProjects("TestATO", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    public void testMacroSupportInBuildDefinitions() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] projects = this.createProjects("testMacroSupportInBuildDefinitions", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    public void testSpaces() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk"), Path.fromOSString((String)"main with spaces.d"), Path.fromOSString((String)"sub folder with spaces/subdir.mk"), Path.fromOSString((String)"sub folder with spaces/foo with spaces.d")};
        IProject[] projects = this.createProjects("test with spaces", null, null, true);
        this.buildProjects(projects, makefiles);
    }

    public void testInputTypeOption() {
        IPath[] makefiles = new IPath[]{Path.fromOSString((String)"makefile"), Path.fromOSString((String)"objects.mk"), Path.fromOSString((String)"sources.mk"), Path.fromOSString((String)"subdir.mk")};
        IProject[] projects = this.createProjects("inputTypeOption", null, null, true);
        this.buildProjects(projects, makefiles);
    }
}

