/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.ManagedCProjectNature;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ResourceBuildCoreTests
extends TestCase {
    private static final boolean boolVal = true;
    private static IProjectType exeType;
    private static IProjectType libType;
    private static IProjectType dllType;
    private static final String projectName = "T1";
    private static final String renamedProjectName1 = "T1_1";
    private static final String renamedProjectName2 = "T1_2";
    static /* synthetic */ Class class$0;

    public ResourceBuildCoreTests(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.ResourceBuildCoreTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        suite.addTest((Test)new ResourceBuildCoreTests("testResourceConfigurations"));
        suite.addTest((Test)new ResourceBuildCoreTests("testResourceConfigurationReset"));
        return suite;
    }

    public void testResourceConfigurations() throws Exception {
        IFile barFile;
        IProject project = null;
        try {
            project = this.createProject(projectName);
            ManagedBuildTestHelper.addManagedBuildNature(project);
            IProjectDescription description = project.getDescription();
            if (description != null) {
                ResourceBuildCoreTests.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ResourceBuildCoreTests.fail((String)("Test failed on project creation: " + e.getLocalizedMessage()));
        }
        ManagedBuildManager.getDefinedProjectTypes();
        IProjectType projType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.exe");
        ResourceBuildCoreTests.assertNotNull((Object)projType);
        IManagedProject newProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)projType);
        ResourceBuildCoreTests.assertEquals((String)newProject.getName(), (String)projType.getName());
        ResourceBuildCoreTests.assertFalse((boolean)newProject.equals(projType));
        ManagedBuildManager.setNewProjectVersion((IProject)project);
        IFile mainFile = project.getProject().getFile("main.c");
        if (!mainFile.exists()) {
            mainFile.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n extern void bar(); \n int main() { \nprintf(\"Hello, World!!\"); \n bar();\n return 0; }".getBytes()), false, null);
        }
        if (!(barFile = project.getProject().getFile("bar.c")).exists()) {
            barFile.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n void bar() { \nprintf(\"Hello, bar()!!\");\n return; }".getBytes()), false, null);
        }
        IConfiguration defaultConfig = null;
        IConfiguration[] configs = projType.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            if (i == 0) {
                defaultConfig = newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
            } else {
                newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
            }
            ++i;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)project, defaultConfig);
        IResourceConfiguration resMainConfig = defaultConfig.createResourceConfiguration(mainFile);
        IResourceConfiguration resBarConfig = defaultConfig.createResourceConfiguration(barFile);
        IResourceConfiguration[] resConfigs = defaultConfig.getResourceConfigurations();
        ResourceBuildCoreTests.assertEquals((int)2, (int)resConfigs.length);
        ITool[] resMainTools = resMainConfig.getTools();
        ResourceBuildCoreTests.assertNotNull((Object)resMainTools);
        ResourceBuildCoreTests.assertEquals((int)1, (int)resMainTools.length);
        ITool[] resBarTools = resBarConfig.getTools();
        ResourceBuildCoreTests.assertNotNull((Object)resBarTools);
        ResourceBuildCoreTests.assertEquals((int)1, (int)resBarTools.length);
        ITool resMainTool = resMainTools[0];
        String resMainBuildProps = resMainTool.getToolFlags();
        ITool resBarTool = resBarTools[0];
        String resBarBuildProps = resBarTool.getToolFlags();
        String extString = mainFile.getFileExtension();
        ITool[] tools = defaultConfig.getFilteredTools();
        Tool projTool = null;
        String projBuildProps = new String();
        int i2 = 0;
        while (i2 < tools.length) {
            if (tools[i2].buildsFileType(extString)) {
                projTool = (Tool)tools[i2];
                projBuildProps = projTool.getToolFlags();
                break;
            }
            ++i2;
        }
        ResourceBuildCoreTests.assertEquals((String)resMainBuildProps, (String)projBuildProps);
        ResourceBuildCoreTests.assertEquals((String)resMainBuildProps, (String)resBarBuildProps);
        IOption projDebugOption = projTool.getOptionById("testgnu.c.compiler.exe.debug.option.debugging.level");
        ResourceBuildCoreTests.assertNotNull((Object)projDebugOption);
        IOption newProjDebugOption = ManagedBuildManager.setOption((IConfiguration)defaultConfig, (IHoldsOptions)projTool, (IOption)projDebugOption, (String)"testgnu.c.debugging.level.default");
        String newProjDebugOptionId = newProjDebugOption.getId();
        String newProjDebugOptionValue = newProjDebugOption.getStringValue();
        ResourceBuildCoreTests.assertNotSame((Object)projDebugOption.getStringValue(), (Object)newProjDebugOptionValue);
        IOption resMainDebugOption = null;
        IOption[] resMainOptions = resMainTool.getOptions();
        int i3 = 0;
        while (i3 < resMainOptions.length) {
            IOption opt = resMainOptions[i3];
            if (opt != null) {
                if (opt.getId().equals(newProjDebugOptionId)) {
                    resMainDebugOption = opt;
                    break;
                }
                if (opt.getSuperClass() != null && opt.getSuperClass().getId().equals(newProjDebugOptionId)) {
                    resMainDebugOption = opt;
                    break;
                }
            }
            ++i3;
        }
        String resMainDebugOptionValue = resMainDebugOption.getStringValue();
        ResourceBuildCoreTests.assertEquals((String)newProjDebugOptionValue, (String)resMainDebugOptionValue);
        IOption newResMainDebugOption = ManagedBuildManager.setOption((IResourceInfo)resMainConfig, (IHoldsOptions)resMainTool, resMainDebugOption, (String)"gnu.c.debugging.level.minimal");
        tools = defaultConfig.getFilteredTools();
        projTool = null;
        int i4 = 0;
        while (i4 < tools.length) {
            if (tools[i4].buildsFileType(extString)) {
                projTool = (Tool)tools[i4];
                break;
            }
            ++i4;
        }
        projDebugOption = projTool.getOptionById(newProjDebugOptionId);
        String projDebugOptionValue = projDebugOption.getStringValue();
        String newResMainDebugOptionValue = newResMainDebugOption.getStringValue();
        ResourceBuildCoreTests.assertNotSame((Object)projDebugOptionValue, (Object)newResMainDebugOptionValue);
        project.close(null);
        this.removeProject(projectName);
    }

    public void testResourceConfigurationReset() throws Exception {
        IProject project = null;
        try {
            project = this.createProject(projectName);
            ManagedBuildTestHelper.addManagedBuildNature(project);
            IProjectDescription description = project.getDescription();
            if (description != null) {
                ResourceBuildCoreTests.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ResourceBuildCoreTests.fail((String)("Test failed on project creation: " + e.getLocalizedMessage()));
        }
        ManagedBuildManager.getDefinedProjectTypes();
        IProjectType projType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.exe");
        ResourceBuildCoreTests.assertNotNull((Object)projType);
        IManagedProject newProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)projType);
        ResourceBuildCoreTests.assertEquals((String)newProject.getName(), (String)projType.getName());
        ResourceBuildCoreTests.assertFalse((boolean)newProject.equals(projType));
        ManagedBuildManager.setNewProjectVersion((IProject)project);
        IFile helloFile = project.getProject().getFile("hello.c");
        if (!helloFile.exists()) {
            helloFile.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n\n int main() { \nprintf(\"Hello, World!!\"); \n bar();\n return 0; }".getBytes()), false, null);
        }
        IConfiguration defaultConfig = null;
        IConfiguration[] configs = projType.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            if (i == 0) {
                defaultConfig = newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
            } else {
                newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
            }
            ++i;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)project, defaultConfig);
        IResourceConfiguration resConfig = defaultConfig.createResourceConfiguration(helloFile);
        IResourceConfiguration[] resConfigs = defaultConfig.getResourceConfigurations();
        ResourceBuildCoreTests.assertEquals((int)1, (int)resConfigs.length);
        ITool[] resTools = resConfig.getTools();
        ResourceBuildCoreTests.assertNotNull((Object)resTools);
        ResourceBuildCoreTests.assertEquals((int)1, (int)resTools.length);
        ITool resTool = resTools[0];
        String defaultResToolFlags = resTool.getToolFlags();
        IOption resDebugOption = resTool.getOptionById("testgnu.c.compiler.exe.debug.option.debugging.level");
        String defaultResDebugOptVal = resDebugOption.getStringValue();
        IOption newResDebugOption = ManagedBuildManager.setOption((IResourceInfo)resConfig, (IHoldsOptions)resTool, (IOption)resDebugOption, (String)"gnu.c.debugging.level.minimal");
        String newResDebugOptVal = newResDebugOption.getStringValue();
        String newResToolFlags = resTool.getToolFlags();
        ResourceBuildCoreTests.assertNotSame((Object)defaultResDebugOptVal, (Object)newResDebugOptVal);
        ManagedBuildManager.resetResourceConfiguration((IProject)project, (IResourceConfiguration)resConfig);
        String resetResToolFlags = resTool.getToolFlags();
        ResourceBuildCoreTests.assertNotSame((Object)resetResToolFlags, (Object)newResToolFlags);
        ResourceBuildCoreTests.assertEquals((String)defaultResToolFlags, (String)resetResToolFlags);
        project.close(null);
        this.removeProject(projectName);
    }

    public void testResourceConfigurationBuildInfo() throws Exception {
        IFile barFile;
        IProject project = null;
        try {
            project = this.createProject(projectName);
            ManagedBuildTestHelper.addManagedBuildNature(project);
            IProjectDescription description = project.getDescription();
            if (description != null) {
                ResourceBuildCoreTests.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ResourceBuildCoreTests.fail((String)("Test failed on project creation: " + e.getLocalizedMessage()));
        }
        ManagedBuildManager.getDefinedProjectTypes();
        IProjectType projType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.exe");
        ResourceBuildCoreTests.assertNotNull((Object)projType);
        IManagedProject newProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)projType);
        ResourceBuildCoreTests.assertEquals((String)newProject.getName(), (String)projType.getName());
        ResourceBuildCoreTests.assertFalse((boolean)newProject.equals(projType));
        ManagedBuildManager.setNewProjectVersion((IProject)project);
        IFile mainFile = project.getProject().getFile("main.c");
        if (!mainFile.exists()) {
            mainFile.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n extern void bar(); \n int main() { \nprintf(\"Hello, World!!\"); \n bar();\n return 0; }".getBytes()), false, null);
        }
        if (!(barFile = project.getProject().getFile("bar.c")).exists()) {
            barFile.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n void bar() { \nprintf(\"Hello, bar()!!\");\n return; }".getBytes()), false, null);
        }
        IConfiguration defaultConfig = null;
        IConfiguration[] configs = projType.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            if (i == 0) {
                defaultConfig = newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
            } else {
                newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
            }
            ++i;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)project, defaultConfig);
        String defaultConfigId = defaultConfig.getId();
        IResourceConfiguration resMainConfig = defaultConfig.createResourceConfiguration(mainFile);
        IResourceConfiguration resBarConfig = defaultConfig.createResourceConfiguration(barFile);
        IResourceConfiguration[] resConfigs = defaultConfig.getResourceConfigurations();
        ResourceBuildCoreTests.assertEquals((int)2, (int)resConfigs.length);
        String resMainPath = resMainConfig.getResourcePath();
        String resBarPath = resBarConfig.getResourcePath();
        ITool[] resMainTools = resMainConfig.getTools();
        ResourceBuildCoreTests.assertNotNull((Object)resMainTools);
        ResourceBuildCoreTests.assertEquals((int)1, (int)resMainTools.length);
        ITool[] resBarTools = resBarConfig.getTools();
        ResourceBuildCoreTests.assertNotNull((Object)resBarTools);
        ResourceBuildCoreTests.assertEquals((int)1, (int)resBarTools.length);
        ITool resMainTool = resMainTools[0];
        resMainTool.getToolFlags();
        ITool resBarTool = resBarTools[0];
        resBarTool.getToolFlags();
        IOption defaultResMainOptOption = resMainTool.getOptionById("testgnu.c.compiler.exe.debug.option.optimization.level");
        String defaultResMainOptVal = defaultResMainOptOption.getStringValue();
        IOption resMainOptOption = ManagedBuildManager.setOption((IResourceInfo)resMainConfig, (IHoldsOptions)resMainTool, (IOption)defaultResMainOptOption, (String)"gnu.c.optimization.level.optimize");
        String resMainOptVal = resMainOptOption.getStringValue();
        IOption defaultResMainDebugOption = resMainTool.getOptionById("testgnu.c.compiler.exe.debug.option.debugging.level");
        String defaultResMainDebugVal = defaultResMainDebugOption.getStringValue();
        IOption resMainDebugOption = ManagedBuildManager.setOption((IResourceInfo)resMainConfig, (IHoldsOptions)resMainTool, (IOption)defaultResMainDebugOption, (String)"gnu.c.debugging.level.minimal");
        String resMainDebugVal = resMainDebugOption.getStringValue();
        IOption defaultResBarOptOption = resBarTool.getOptionById("testgnu.c.compiler.exe.debug.option.optimization.level");
        String defaultResBarOptVal = defaultResBarOptOption.getStringValue();
        IOption resBarOptOption = ManagedBuildManager.setOption((IResourceInfo)resBarConfig, (IHoldsOptions)resBarTool, (IOption)defaultResBarOptOption, (String)"gnu.c.optimization.level.more");
        String resBarOptVal = resBarOptOption.getStringValue();
        IOption defaultResBarDebugOption = resBarTool.getOptionById("testgnu.c.compiler.exe.debug.option.debugging.level");
        String defaultResBarDebugVal = defaultResBarDebugOption.getStringValue();
        IOption resBarDebugOption = ManagedBuildManager.setOption((IResourceInfo)resBarConfig, (IHoldsOptions)resBarTool, (IOption)defaultResBarDebugOption, (String)"gnu.c.debugging.level.default");
        String resBarDebugVal = resBarDebugOption.getStringValue();
        ResourceBuildCoreTests.assertNotSame((Object)defaultResMainOptVal, (Object)resMainOptVal);
        ResourceBuildCoreTests.assertNotSame((Object)defaultResMainDebugVal, (Object)resMainDebugVal);
        ResourceBuildCoreTests.assertNotSame((Object)defaultResBarOptVal, (Object)resBarOptVal);
        ResourceBuildCoreTests.assertNotSame((Object)defaultResBarDebugVal, (Object)resBarDebugVal);
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)false);
        ManagedBuildManager.removeBuildInfo((IResource)project);
        project.close(null);
        project.open(null);
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IManagedProject newManagedProj = info.getManagedProject();
        IConfiguration[] definedConfigs = newManagedProj.getConfigurations();
        ResourceBuildCoreTests.assertEquals((int)2, (int)definedConfigs.length);
        IConfiguration newDefaultConfig = info.getDefaultConfiguration();
        ResourceBuildCoreTests.assertEquals((String)defaultConfigId, (String)newDefaultConfig.getId());
        IResourceConfiguration[] newResConfigs = newDefaultConfig.getResourceConfigurations();
        ResourceBuildCoreTests.assertEquals((int)2, (int)newResConfigs.length);
        IResourceConfiguration newResMainConfig = newDefaultConfig.getResourceConfiguration(resMainPath);
        ResourceBuildCoreTests.assertNotNull((Object)newResMainConfig);
        ITool[] newResMainTools = newResMainConfig.getTools();
        ResourceBuildCoreTests.assertEquals((int)1, (int)newResMainTools.length);
        ITool newResMainTool = newResMainTools[0];
        IOption newResMainOptOption = newResMainTool.getOptionById(resMainOptOption.getId());
        ResourceBuildCoreTests.assertNotNull((Object)newResMainOptOption);
        String newResMainOptVal = newResMainOptOption.getStringValue();
        IOption newResMainDebugOption = newResMainTool.getOptionById(resMainDebugOption.getId());
        ResourceBuildCoreTests.assertNotNull((Object)newResMainDebugOption);
        String newResMainDebugVal = newResMainDebugOption.getStringValue();
        ResourceBuildCoreTests.assertEquals((String)resMainOptVal, (String)newResMainOptVal);
        ResourceBuildCoreTests.assertEquals((String)resMainDebugVal, (String)newResMainDebugVal);
        IResourceConfiguration newResBarConfig = newDefaultConfig.getResourceConfiguration(resBarPath);
        ResourceBuildCoreTests.assertNotNull((Object)newResBarConfig);
        ITool[] newResBarTools = newResBarConfig.getTools();
        ResourceBuildCoreTests.assertEquals((int)1, (int)newResBarTools.length);
        ITool newResBarTool = newResBarTools[0];
        IOption newResBarOptOption = newResBarTool.getOptionById(resBarOptOption.getId());
        ResourceBuildCoreTests.assertNotNull((Object)newResBarOptOption);
        String newResBarOptVal = newResBarOptOption.getStringValue();
        IOption newResBarDebugOption = newResBarTool.getOptionById(resBarDebugOption.getId());
        ResourceBuildCoreTests.assertNotNull((Object)newResBarDebugOption);
        String newResBarDebugVal = newResBarDebugOption.getStringValue();
        ResourceBuildCoreTests.assertEquals((String)resBarOptVal, (String)newResBarOptVal);
        ResourceBuildCoreTests.assertEquals((String)resBarDebugVal, (String)newResBarDebugVal);
        project.close(null);
        this.removeProject(projectName);
    }

    private IProject createProject(String name) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        final IProject newProjectHandle = root.getProject(name);
        IProject project = null;
        if (!newProjectHandle.exists()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceDescription workspaceDesc = workspace.getDescription();
            workspaceDesc.setAutoBuilding(false);
            workspace.setDescription(workspaceDesc);
            IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
            project = CCorePlugin.getDefault().createCProject(description, newProjectHandle, (IProgressMonitor)new NullProgressMonitor(), ManagedBuilderCorePlugin.MANAGED_MAKE_PROJECT_ID);
        } else {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    newProjectHandle.refreshLocal(2, monitor);
                }
            };
            NullProgressMonitor monitor = new NullProgressMonitor();
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)monitor);
            project = newProjectHandle;
        }
        if (!project.isOpen()) {
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        return project;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeProject(String name) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(name);
        if (!project.exists()) return;
        try {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                System.gc();
                System.runFinalization();
                project.delete(true, true, null);
                throw throwable;
            }
            catch (CoreException coreException) {
                ResourceBuildCoreTests.assertTrue((boolean)false);
            }
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (CoreException coreException) {
            ResourceBuildCoreTests.assertTrue((boolean)false);
            return;
        }
        System.gc();
        System.runFinalization();
        project.delete(true, true, null);
    }

    public void testProjectCreation() throws BuildException {
        IProject project = null;
        try {
            project = this.createProject(projectName);
            ManagedBuildTestHelper.addManagedBuildNature(project);
            IProjectDescription description = project.getDescription();
            if (description != null) {
                ResourceBuildCoreTests.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ResourceBuildCoreTests.fail((String)("Test failed on project creation: " + e.getLocalizedMessage()));
        }
        ManagedBuildManager.getDefinedProjectTypes();
        IProjectType projType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.exe");
        ResourceBuildCoreTests.assertNotNull((Object)projType);
        IManagedProject newProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)projType);
        ResourceBuildCoreTests.assertEquals((String)newProject.getName(), (String)projType.getName());
        ResourceBuildCoreTests.assertFalse((boolean)newProject.equals(projType));
        ManagedBuildManager.setNewProjectVersion((IProject)project);
        IConfiguration defaultConfig = null;
        IConfiguration[] configs = projType.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            if (i == 0) {
                defaultConfig = newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
            } else {
                newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
            }
            ++i;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)project, defaultConfig);
        IStatus initResult = ManagedBuildManager.initBuildInfoContainer((IResource)project);
        if (initResult.getCode() != 0) {
            ResourceBuildCoreTests.fail((String)("Initializing build information failed for: " + project.getName() + " because: " + initResult.getMessage()));
        }
        configs = newProject.getConfigurations();
        ITool[] tools = configs[0].getTools();
        IOptionCategory topCategory = tools[0].getTopOptionCategory();
        IOptionCategory[] categories = topCategory.getChildCategories();
        Object[][] options = categories[0].getOptions(configs[0]);
        ITool tool = (ITool)options[0][0];
        IOption option = (IOption)options[0][1];
        configs[0].setOption((IHoldsOptions)tool, option, "1");
        options = categories[0].getOptions(null);
        tool = (ITool)options[0][0];
        option = (IOption)options[0][1];
        ResourceBuildCoreTests.assertEquals((String)"x", (String)option.getStringValue());
        options = categories[0].getOptions(configs[0]);
        tool = (ITool)options[0][0];
        option = (IOption)options[0][1];
        ResourceBuildCoreTests.assertEquals((String)"z", (String)option.getStringValue());
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        ManagedBuildManager.removeBuildInfo((IResource)project);
        try {
            project.close(null);
        }
        catch (CoreException e) {
            ResourceBuildCoreTests.fail((String)("Failed on project close: " + e.getLocalizedMessage()));
        }
        try {
            project.open(null);
        }
        catch (CoreException e) {
            ResourceBuildCoreTests.fail((String)("Failed on project open: " + e.getLocalizedMessage()));
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        ResourceBuildCoreTests.assertEquals((String)defaultConfig.getId(), (String)info.getDefaultConfiguration().getId());
        ManagedBuildManager.removeBuildInfo((IResource)project);
    }

    public void testResourceRename() throws Exception {
        IFile bFile;
        IFolder dirFolder;
        IFile aFile;
        IProject project = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            project = this.createProject(projectName);
            ManagedBuildTestHelper.addManagedBuildNature(project);
            IProjectDescription description = project.getDescription();
            if (description != null) {
                ResourceBuildCoreTests.assertTrue((boolean)description.hasNature(ManagedCProjectNature.MNG_NATURE_ID));
            }
        }
        catch (CoreException e) {
            ResourceBuildCoreTests.fail((String)("Test failed on project creation: " + e.getLocalizedMessage()));
        }
        ManagedBuildManager.getDefinedProjectTypes();
        IProjectType projType = ManagedBuildManager.getProjectType((String)"cdt.managedbuild.target.testgnu21.exe");
        ResourceBuildCoreTests.assertNotNull((Object)projType);
        IManagedProject newProject = ManagedBuildManager.createManagedProject((IResource)project, (IProjectType)projType);
        ResourceBuildCoreTests.assertEquals((String)newProject.getName(), (String)projType.getName());
        ResourceBuildCoreTests.assertFalse((boolean)newProject.equals(projType));
        ManagedBuildManager.setNewProjectVersion((IProject)project);
        IFile mainFile = project.getProject().getFile("main.c");
        if (!mainFile.exists()) {
            mainFile.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n extern void bar(); \n int main() { \nprintf(\"Hello, World!!\"); \n bar();\n return 0; }".getBytes()), false, null);
        }
        if (!(aFile = project.getProject().getFile("a.c")).exists()) {
            aFile.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n void bar() { \nprintf(\"Hello, bar()!!\");\n return; }".getBytes()), false, null);
        }
        if (!(dirFolder = project.getProject().getFolder("dir")).exists()) {
            dirFolder.create(true, true, null);
        }
        if (!(bFile = dirFolder.getFile("b.c")).exists()) {
            bFile.create((InputStream)new ByteArrayInputStream("#include <stdio.h>\n void bar1() { \nprintf(\"Hello, bar1()!!\");\n return; }".getBytes()), false, null);
        }
        IConfiguration defaultConfig = null;
        IConfiguration[] configs = projType.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            if (i == 0) {
                defaultConfig = newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
            } else {
                newProject.createConfiguration(configs[i], String.valueOf(projType.getId()) + "." + i);
            }
            ++i;
        }
        ManagedBuildManager.setDefaultConfiguration((IProject)project, defaultConfig);
        IResourceConfiguration resMainConfig = defaultConfig.createResourceConfiguration(mainFile);
        IResourceConfiguration resAConfig = defaultConfig.createResourceConfiguration(aFile);
        IResourceConfiguration resBConfig = defaultConfig.createResourceConfiguration(bFile);
        IResourceConfiguration[] resConfigs = defaultConfig.getResourceConfigurations();
        ResourceBuildCoreTests.assertEquals((Object)resMainConfig, (Object)defaultConfig.getResourceConfiguration(mainFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((Object)resAConfig, (Object)defaultConfig.getResourceConfiguration(aFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((Object)resBConfig, (Object)defaultConfig.getResourceConfiguration(bFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((int)3, (int)resConfigs.length);
        mainFile.move(mainFile.getFullPath().removeLastSegments(1).append("main1.c"), true, false, null);
        mainFile = (IFile)project.findMember("main1.c");
        ResourceBuildCoreTests.assertEquals((Object)resMainConfig, (Object)defaultConfig.getResourceConfiguration(mainFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((Object)resAConfig, (Object)defaultConfig.getResourceConfiguration(aFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((Object)resBConfig, (Object)defaultConfig.getResourceConfiguration(bFile.getFullPath().toString()));
        resConfigs = defaultConfig.getResourceConfigurations();
        ResourceBuildCoreTests.assertEquals((int)3, (int)resConfigs.length);
        dirFolder.move(dirFolder.getFullPath().removeLastSegments(1).append("dir1"), true, false, null);
        dirFolder = (IFolder)project.findMember("dir1");
        bFile = (IFile)dirFolder.findMember("b.c");
        ResourceBuildCoreTests.assertEquals((Object)resMainConfig, (Object)defaultConfig.getResourceConfiguration(mainFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((Object)resAConfig, (Object)defaultConfig.getResourceConfiguration(aFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((Object)resBConfig, (Object)defaultConfig.getResourceConfiguration(bFile.getFullPath().toString()));
        resConfigs = defaultConfig.getResourceConfigurations();
        ResourceBuildCoreTests.assertEquals((int)3, (int)resConfigs.length);
        bFile.move(bFile.getFullPath().removeLastSegments(1).append("b1.c"), true, false, null);
        bFile = (IFile)dirFolder.findMember("b1.c");
        ResourceBuildCoreTests.assertEquals((Object)resMainConfig, (Object)defaultConfig.getResourceConfiguration(mainFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((Object)resAConfig, (Object)defaultConfig.getResourceConfiguration(aFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((Object)resBConfig, (Object)defaultConfig.getResourceConfiguration(bFile.getFullPath().toString()));
        resConfigs = defaultConfig.getResourceConfigurations();
        ResourceBuildCoreTests.assertEquals((int)3, (int)resConfigs.length);
        IProjectDescription des = project.getDescription();
        des.setName(renamedProjectName1);
        project.move(des, true, null);
        project = (IProject)root.findMember(renamedProjectName1);
        mainFile = (IFile)project.findMember("main1.c");
        aFile = (IFile)project.findMember("a.c");
        dirFolder = (IFolder)project.findMember("dir1");
        bFile = (IFile)dirFolder.findMember("b1.c");
        ResourceBuildCoreTests.assertEquals((Object)resMainConfig, (Object)defaultConfig.getResourceConfiguration(mainFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((Object)resAConfig, (Object)defaultConfig.getResourceConfiguration(aFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((Object)resBConfig, (Object)defaultConfig.getResourceConfiguration(bFile.getFullPath().toString()));
        resConfigs = defaultConfig.getResourceConfigurations();
        ResourceBuildCoreTests.assertEquals((int)3, (int)resConfigs.length);
        final IResource[] rcBuf = new IResource[]{project, mainFile, aFile, dirFolder, bFile};
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProject project = (IProject)rcBuf[0];
                IFile mainFile = (IFile)rcBuf[1];
                IFile aFile = (IFile)rcBuf[2];
                IFolder dirFolder = (IFolder)rcBuf[3];
                IFile bFile = (IFile)rcBuf[4];
                mainFile.move(mainFile.getFullPath().removeLastSegments(1).append("main2.c"), true, false, null);
                mainFile = (IFile)project.findMember("main2.c");
                dirFolder.move(dirFolder.getFullPath().removeLastSegments(1).append("dir2"), true, false, null);
                dirFolder = (IFolder)project.findMember("dir2");
                bFile = (IFile)dirFolder.findMember("b1.c");
                bFile.move(bFile.getFullPath().removeLastSegments(1).append("b2.c"), true, false, null);
                bFile = (IFile)dirFolder.findMember("b2.c");
                IProjectDescription des = project.getDescription();
                des.setName(ResourceBuildCoreTests.renamedProjectName2);
                project.move(des, true, null);
                project = (IProject)ResourcesPlugin.getWorkspace().getRoot().findMember(ResourceBuildCoreTests.renamedProjectName2);
                mainFile = (IFile)project.findMember("main2.c");
                aFile = (IFile)project.findMember("a.c");
                dirFolder = (IFolder)project.findMember("dir2");
                bFile = (IFile)dirFolder.findMember("b2.c");
                rcBuf[0] = project;
                rcBuf[1] = mainFile;
                rcBuf[2] = aFile;
                rcBuf[3] = dirFolder;
                rcBuf[4] = bFile;
            }
        }, (ISchedulingRule)root, 1, null);
        project = (IProject)rcBuf[0];
        mainFile = (IFile)rcBuf[1];
        aFile = (IFile)rcBuf[2];
        dirFolder = (IFolder)rcBuf[3];
        bFile = (IFile)rcBuf[4];
        ResourceBuildCoreTests.assertEquals((Object)resMainConfig, (Object)defaultConfig.getResourceConfiguration(mainFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((Object)resAConfig, (Object)defaultConfig.getResourceConfiguration(aFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((Object)resBConfig, (Object)defaultConfig.getResourceConfiguration(bFile.getFullPath().toString()));
        resConfigs = defaultConfig.getResourceConfigurations();
        ResourceBuildCoreTests.assertEquals((int)3, (int)resConfigs.length);
        aFile.delete(true, null);
        ResourceBuildCoreTests.assertEquals((Object)resMainConfig, (Object)defaultConfig.getResourceConfiguration(mainFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals(null, (Object)defaultConfig.getResourceConfiguration(aFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals((Object)resBConfig, (Object)defaultConfig.getResourceConfiguration(bFile.getFullPath().toString()));
        resConfigs = defaultConfig.getResourceConfigurations();
        ResourceBuildCoreTests.assertEquals((int)2, (int)resConfigs.length);
        dirFolder.delete(true, null);
        ResourceBuildCoreTests.assertEquals((Object)resMainConfig, (Object)defaultConfig.getResourceConfiguration(mainFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals(null, (Object)defaultConfig.getResourceConfiguration(aFile.getFullPath().toString()));
        ResourceBuildCoreTests.assertEquals(null, (Object)defaultConfig.getResourceConfiguration(bFile.getFullPath().toString()));
        resConfigs = defaultConfig.getResourceConfigurations();
        ResourceBuildCoreTests.assertEquals((int)1, (int)resConfigs.length);
        project.close(null);
        this.removeProject(renamedProjectName2);
    }
}

