/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DefaultFortranDependencyCalculator
implements IManagedDependencyGenerator,
IManagedOutputNameProvider {
    public static final String MODULE_EXTENSION = "mod";

    private String[] findUsedModuleNames(File file) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            StreamTokenizer st = new StreamTokenizer(r);
            st.commentChar(33);
            st.eolIsSignificant(false);
            st.slashSlashComments(false);
            st.slashStarComments(false);
            st.wordChars(95, 95);
            while (st.nextToken() != -1) {
                if (st.ttype != -3 || !st.sval.equalsIgnoreCase("use")) continue;
                st.nextToken();
                if (st.ttype == -3) {
                    names.add(st.sval);
                    continue;
                }
                st.pushBack();
            }
        }
        catch (Exception exception) {
            return new String[0];
        }
        return names.toArray(new String[names.size()]);
    }

    private String[] findModuleNames(File file) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            StreamTokenizer st = new StreamTokenizer(r);
            st.commentChar(33);
            st.eolIsSignificant(false);
            st.slashSlashComments(false);
            st.slashStarComments(false);
            st.wordChars(95, 95);
            while (st.nextToken() != -1) {
                if (st.ttype != -3 || !st.sval.equalsIgnoreCase("module")) continue;
                st.nextToken();
                if (st.ttype == -3) {
                    names.add(st.sval);
                    continue;
                }
                st.pushBack();
            }
        }
        catch (Exception exception) {
            return new String[0];
        }
        return names.toArray(new String[names.size()]);
    }

    private boolean isFortranFile(ITool tool, IResource resource) {
        String ext = resource.getFileExtension();
        if (ext != null) {
            if (ext.equalsIgnoreCase("f")) {
                return true;
            }
            if (ext.equalsIgnoreCase("for")) {
                return true;
            }
            if (ext.equalsIgnoreCase("f90")) {
                return true;
            }
        }
        return false;
    }

    private IResource[] FindModulesInResources(IProject project, ITool tool, IResource resource, IResource[] resourcesToSearch, String topBuildDir, String[] usedNames) {
        ArrayList<Object> modRes = new ArrayList<Object>();
        int ir = 0;
        while (ir < resourcesToSearch.length) {
            if (!resourcesToSearch[ir].equals((Object)resource)) {
                if (resourcesToSearch[ir].getType() == 1) {
                    String[] modules;
                    File projectFile = resourcesToSearch[ir].getLocation().toFile();
                    if (this.isFortranFile(tool, resourcesToSearch[ir]) && (modules = this.findModuleNames(projectFile)) != null) {
                        int iu = 0;
                        while (iu < usedNames.length) {
                            boolean foundDependency = false;
                            int im = 0;
                            while (im < modules.length) {
                                if (usedNames[iu].equalsIgnoreCase(modules[im])) {
                                    IPath modName = Path.fromOSString((String)(String.valueOf(topBuildDir) + '/' + modules[im] + "." + MODULE_EXTENSION));
                                    modRes.add(project.getFile(modName));
                                    modRes.add(resourcesToSearch[ir]);
                                    foundDependency = true;
                                    break;
                                }
                                ++im;
                            }
                            if (!foundDependency) {
                                ++iu;
                                continue;
                            }
                            break;
                        }
                    }
                } else if (resourcesToSearch[ir].getType() == 2) {
                    try {
                        IResource[] modFound = this.FindModulesInResources(project, tool, resource, ((IFolder)resourcesToSearch[ir]).members(), topBuildDir, usedNames);
                        if (modFound != null) {
                            int i = 0;
                            while (i < modFound.length) {
                                modRes.add(modFound[i]);
                                ++i;
                            }
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            ++ir;
        }
        return modRes.toArray(new IResource[modRes.size()]);
    }

    public IResource[] findDependencies(IResource resource, IProject project) {
        String[] usedNames;
        ITool tool;
        IConfiguration config;
        ArrayList<IResource> dependencies;
        block9: {
            File file;
            block8: {
                dependencies = new ArrayList<IResource>();
                IManagedBuildInfo mngInfo = ManagedBuildManager.getBuildInfo((IResource)project);
                config = mngInfo.getDefaultConfiguration();
                tool = null;
                ITool[] tools = config.getTools();
                int i = 0;
                while (i < tools.length) {
                    if (tools[i].getName().equals("Fortran (ifort) Compiler for Win32")) {
                        tool = tools[i];
                        break;
                    }
                    ++i;
                }
                file = resource.getLocation().toFile();
                if (this.isFortranFile(tool, resource)) break block8;
                return null;
            }
            usedNames = this.findUsedModuleNames(file);
            if (usedNames.length != 0) break block9;
            return null;
        }
        try {
            IResource[] resources = project.members();
            IResource[] modRes = this.FindModulesInResources(project, tool, resource, resources, config.getName(), usedNames);
            if (modRes != null) {
                int i = 0;
                while (i < modRes.length) {
                    dependencies.add(modRes[i]);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return dependencies.toArray(new IResource[dependencies.size()]);
    }

    public int getCalculatorType() {
        return 3;
    }

    public String getDependencyCommand(IResource resource, IManagedBuildInfo info) {
        return null;
    }

    public IPath[] getOutputNames(ITool tool, IPath[] primaryInputNames) {
        String[] modules;
        ArrayList<IPath> outs = new ArrayList<IPath>();
        if (primaryInputNames.length > 0 && (modules = this.findModuleNames(primaryInputNames[0].toFile())) != null) {
            int i = 0;
            while (i < modules.length) {
                IPath modName = new Path("./").append(Path.fromOSString((String)(String.valueOf(modules[i]) + "." + MODULE_EXTENSION)));
                outs.add(modName);
                ++i;
            }
        }
        return outs.toArray(new IPath[outs.size()]);
    }
}

