/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOptionValueHandler;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.testplugin.ManagedBuildTestHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class OptionEnablementTests
extends TestCase
implements IManagedOptionValueHandler,
IOptionApplicability {
    private static boolean fEnUiVisible;
    private static boolean fEnUiEnabled;
    private static boolean fEnCmdUsed;
    private static boolean fHandleValueCalled;
    private static final String[] thisEnumIds;
    private static final String[] thisStrings;
    static /* synthetic */ Class class$0;

    static {
        thisEnumIds = new String[]{"testgnu.enablement.c.optimization.level.optimize", "testgnu.enablement.c.optimization.level.more"};
        thisStrings = new String[]{"start 1.2.3 stop"};
    }

    public boolean handleValue(IBuildObject configuration, IHoldsOptions holder, IOption option, String extraArgument, int event) {
        return false;
    }

    public boolean isDefaultValue(IBuildObject configuration, IHoldsOptions holder, IOption option, String extraArgument) {
        return false;
    }

    public boolean isEnumValueAppropriate(IBuildObject configuration, IHoldsOptions holder, IOption option, String extraArgument, String enumValue) {
        return false;
    }

    public boolean isOptionUsedInCommandLine(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return fEnCmdUsed;
    }

    public boolean isOptionVisible(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return fEnUiVisible;
    }

    public boolean isOptionEnabled(IBuildObject configuration, IHoldsOptions holder, IOption option) {
        return fEnUiEnabled;
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.tests.OptionEnablementTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    private void resetValueHandler() {
        fHandleValueCalled = false;
    }

    private void setEnablement(boolean cmdUs, boolean uiVis, boolean uiEn) {
        fEnUiVisible = uiVis;
        fEnUiEnabled = uiEn;
        fEnCmdUsed = cmdUs;
    }

    public void testEnablement() {
        this.resetValueHandler();
        IProject project = ManagedBuildTestHelper.createProject("en", "cdt.managedbuild.target.enablement.exe");
        ManagedBuildTestHelper.createFile(project, "a.c");
        ManagedBuildTestHelper.createFile(project, "b.c");
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration cfg = info.getManagedProject().getConfigurations()[0];
        OptionEnablementTests.assertFalse((boolean)fHandleValueCalled);
        this.doTestEnablement((IBuildObject)cfg);
        this.doEnumAllValues((IBuildObject)cfg);
        ManagedBuildTestHelper.removeProject("en");
    }

    private void doEnumAllValues(IBuildObject cfgBo) {
        ITool thisTool = this.getTool(cfgBo, "enablement.this.child_1.2.3");
        ITool otherTool = this.getTool(cfgBo, "enablement.other");
        thisTool.getParent();
        otherTool.getParent();
        int i = 0;
        while (i < thisStrings.length) {
            String strVal = thisStrings[i];
            this.setOption(cfgBo, (IHoldsOptions)thisTool, "this.string", strVal);
            this.doTestEnablement(cfgBo);
            ++i;
        }
        this.setOption(cfgBo, (IHoldsOptions)thisTool, "this.boolean", false);
        this.doTestEnablement(cfgBo);
        this.setOption(cfgBo, (IHoldsOptions)thisTool, "this.boolean", true);
        this.doTestEnablement(cfgBo);
    }

    private ITool getTool(IBuildObject cfgBo, String id) {
        Object rcCfg = null;
        IConfiguration cfg = null;
        ITool tool = null;
        if (cfgBo instanceof IResourceConfiguration) {
            cfg = rcCfg.getParent();
            ITool[] tools = rcCfg.getTools();
            int i = 0;
            while (i < tools.length) {
                ITool tmp = tools[i];
                while (tmp != null) {
                    if (tmp.getId().equals(id)) {
                        tool = tools[i];
                        break;
                    }
                    tmp = tmp.getSuperClass();
                }
                ++i;
            }
        } else if (cfgBo instanceof IConfiguration) {
            cfg = (IConfiguration)cfgBo;
            tool = cfg.getToolsBySuperClassId(id)[0];
        } else {
            OptionEnablementTests.fail((String)"wrong argument");
        }
        return tool;
    }

    private IOption setOption(IBuildObject cfg, IHoldsOptions holder, String id, boolean value) {
        return this.setOption(cfg, holder, holder.getOptionBySuperClassId(id), value);
    }

    private IOption setOption(IBuildObject cfg, IHoldsOptions holder, IOption option, boolean value) {
        try {
            if (cfg instanceof IConfiguration) {
                return ((IConfiguration)cfg).setOption(holder, option, value);
            }
            if (cfg instanceof IResourceConfiguration) {
                return ((IResourceConfiguration)cfg).setOption(holder, option, value);
            }
        }
        catch (BuildException e) {
            OptionEnablementTests.fail((String)e.getLocalizedMessage());
        }
        OptionEnablementTests.fail((String)"wrong arg");
        return null;
    }

    private IOption setOption(IBuildObject cfg, IHoldsOptions holder, String id, String value) {
        return this.setOption(cfg, holder, holder.getOptionBySuperClassId(id), value);
    }

    private IOption setOption(IBuildObject cfg, IHoldsOptions holder, IOption option, String value) {
        try {
            if (cfg instanceof IConfiguration) {
                return ((IConfiguration)cfg).setOption(holder, option, value);
            }
            if (cfg instanceof IResourceConfiguration) {
                return ((IResourceConfiguration)cfg).setOption(holder, option, value);
            }
        }
        catch (BuildException e) {
            OptionEnablementTests.fail((String)e.getLocalizedMessage());
        }
        OptionEnablementTests.fail((String)"wrong arg");
        return null;
    }

    private IOption setOption(IBuildObject cfg, IHoldsOptions holder, String id, String[] value) {
        return this.setOption(cfg, holder, holder.getOptionBySuperClassId(id), value);
    }

    private IOption setOption(IBuildObject cfg, IHoldsOptions holder, IOption option, String[] value) {
        try {
            if (cfg instanceof IConfiguration) {
                return ((IConfiguration)cfg).setOption(holder, option, value);
            }
            if (cfg instanceof IResourceConfiguration) {
                return ((IResourceConfiguration)cfg).setOption(holder, option, value);
            }
        }
        catch (BuildException e) {
            OptionEnablementTests.fail((String)e.getLocalizedMessage());
        }
        OptionEnablementTests.fail((String)"wrong arg");
        return null;
    }

    private void doTestEnablement(IBuildObject cfg) {
        ITool tool = this.getTool(cfg, "enablement.this.child_1.2.3");
        ITool otherTool = this.getTool(cfg, "enablement.other");
        ITool tool2 = this.getTool(cfg, "enablement.this.child.2_1.2.3");
        IOption thisBoolean = tool.getOptionBySuperClassId("this.boolean");
        IOption thisString = tool.getOptionBySuperClassId("this.string");
        IOption thisEnum = tool.getOptionBySuperClassId("this.enum");
        IOption otherString = otherTool.getOptionBySuperClassId("other.string");
        otherTool.getOptionBySuperClassId("other.boolean");
        try {
            IOption option = tool.getOptionBySuperClassId("enablement.command.c1");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"c1");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.command.c2");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"c2");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.commandFalse.c1");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"c1");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.commandFalse.c2");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"c2");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.command.c1.commandFalse.cF1");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"c1");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.command.cmd.commandFalse.cmdF");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.command.c1.commandFalse.cmdF");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"c1");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.command.cmd.commandFalse.cF1");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.ui.en");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.ui.vis");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.cmd.us");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.cmdUs.or.uiVis");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.uiEn.or.uiVis");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.all");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.all.ac.vh");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cF1");
            this.setEnablement(false, false, false);
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            this.setEnablement(false, true, false);
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            this.setEnablement(false, false, true);
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            this.setEnablement(true, false, false);
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            this.setEnablement(false, false, false);
            option = tool.getOptionBySuperClassId("enablement.all.cF1.ac.vh");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            this.setEnablement(true, false, true);
            option = tool.getOptionBySuperClassId("enablement.all.cF.cmdF");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.all.cF.cF1");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cF1");
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("this.boolean");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.boolean.True");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)thisBoolean.getBooleanValue(), (boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)thisBoolean.getBooleanValue(), (boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)thisBoolean.getBooleanValue(), (boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.boolean.False");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((!thisBoolean.getBooleanValue() ? 1 : 0) != 0, (boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((!thisBoolean.getBooleanValue() ? 1 : 0) != 0, (boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((!thisBoolean.getBooleanValue() ? 1 : 0) != 0, (boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.empty");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals(""), (boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals(""), (boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals(""), (boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.test a b c");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals("test a b c"), (boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals("test a b c"), (boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals("test a b c"), (boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.enum.Q.testgnu.enablement.c.optimization.level.optimize");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            String id = thisEnum.getEnumeratedId(thisEnum.getStringValue());
            if (id == null) {
                id = "";
            }
            OptionEnablementTests.assertEquals((boolean)id.equals("testgnu.enablement.c.optimization.level.optimize"), (boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)id.equals("testgnu.enablement.c.optimization.level.optimize"), (boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)id.equals("testgnu.enablement.c.optimization.level.optimize"), (boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.Q.true");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)option.getBooleanValue(), (boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)option.getBooleanValue(), (boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)option.getBooleanValue(), (boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.start ${ParentVersion} stop");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals("start 1.2.3 stop"), (boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals("start 1.2.3 stop"), (boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals("start 1.2.3 stop"), (boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.other.string");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals(otherString.getStringValue()), (boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals(otherString.getStringValue()), (boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals(otherString.getStringValue()), (boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkOpt.all.Q.this.string.Q.other.string");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals(otherString.getStringValue()), (boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals(otherString.getStringValue()), (boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertEquals((boolean)thisString.getStringValue().equals(otherString.getStringValue()), (boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkString");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkString.2");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkString.3");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkFalse.false");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkNot.false");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkOr.true");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkAnd.false");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool.getOptionBySuperClassId("enablement.checkHolder.true.1.false.2");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool, option));
            OptionEnablementTests.assertTrue((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool, option));
            option = tool2.getOptionBySuperClassId("enablement.checkHolder.true.1.false.2");
            OptionEnablementTests.assertEquals((String)option.getCommand(), (String)"cmd");
            OptionEnablementTests.assertEquals((String)option.getCommandFalse(), (String)"cmdF");
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionUsedInCommandLine(cfg, (IHoldsOptions)tool2, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionVisible(cfg, (IHoldsOptions)tool2, option));
            OptionEnablementTests.assertFalse((boolean)option.getApplicabilityCalculator().isOptionEnabled(cfg, (IHoldsOptions)tool2, option));
        }
        catch (BuildException e) {
            OptionEnablementTests.fail((String)e.getLocalizedMessage());
        }
    }
}

