/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.core.scannerconfig;

import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.core.resources.IProject;

public final class CfgInfoContext {
    private static final String DELIMITER = ";";
    private static final int NULL_OBJ_CODE = 29;
    private Configuration fCfg;
    private IResourceInfo fRcInfo;
    private ITool fTool;
    private IInputType fInType;
    private InfoContext fContext;

    public CfgInfoContext(IResourceInfo rcInfo, ITool tool, IInputType inType) {
        this(rcInfo, tool, inType, null);
    }

    private CfgInfoContext(IResourceInfo rcInfo, ITool tool, IInputType inType, InfoContext baseContext) {
        this.fRcInfo = rcInfo;
        this.fTool = tool;
        this.fInType = inType;
        this.fCfg = (Configuration)this.fRcInfo.getParent();
        this.fContext = baseContext;
    }

    public CfgInfoContext(IConfiguration cfg) {
        this(cfg, null);
    }

    private CfgInfoContext(IConfiguration cfg, InfoContext baseContext) {
        this.fCfg = (Configuration)cfg;
        this.fContext = baseContext;
    }

    public IConfiguration getConfiguration() {
        return this.fCfg;
    }

    public IResourceInfo getResourceInfo() {
        return this.fRcInfo;
    }

    public ITool getTool() {
        return this.fTool;
    }

    public IInputType getInputType() {
        return this.fInType;
    }

    public InfoContext toInfoContext() {
        if (this.fContext == null) {
            IProject project = this.fCfg.isPreference() ? null : this.fCfg.getOwner().getProject();
            StringBuffer buf = new StringBuffer();
            buf.append(this.fCfg.getId());
            if (this.fRcInfo != null) {
                buf.append(DELIMITER);
                buf.append(this.fRcInfo.getId());
            }
            if (this.fTool != null) {
                buf.append(DELIMITER);
                buf.append(this.fTool.getId());
            }
            if (this.fInType != null) {
                buf.append(DELIMITER);
                buf.append(this.fInType.getId());
            }
            String instanceId = buf.toString();
            this.fContext = new InfoContext(project, instanceId);
        }
        return this.fContext;
    }

    public static CfgInfoContext fromInfoContext(IConfiguration cfg, InfoContext context) {
        IProject project = context.getProject();
        if (project == null) {
            return null;
        }
        String instanceId = context.getInstanceId();
        if (instanceId.length() == 0) {
            return null;
        }
        String[] ids = CDataUtil.stringToArray((String)instanceId, (String)DELIMITER);
        String cfgId = ids[0];
        if (!cfgId.equals(cfg.getId())) {
            return null;
        }
        String rcInfoId = null;
        String toolId = null;
        String inTypeId = null;
        IResourceInfo rcInfo = null;
        ITool tool = null;
        IInputType inType = null;
        switch (ids.length) {
            case 4: {
                inTypeId = ids[3];
            }
            case 3: {
                toolId = ids[2];
            }
            case 2: {
                rcInfoId = ids[1];
            }
        }
        if (rcInfoId != null && (rcInfo = (IResourceInfo)CfgInfoContext.find(cfg.getResourceInfos(), rcInfoId)) == null) {
            return null;
        }
        if (toolId != null && (tool = (ITool)CfgInfoContext.find(rcInfo.getTools(), toolId)) == null) {
            return null;
        }
        if (inTypeId != null && (inType = (IInputType)CfgInfoContext.find(tool.getInputTypes(), inTypeId)) == null) {
            return null;
        }
        if (rcInfo != null) {
            return new CfgInfoContext(rcInfo, tool, inType, context);
        }
        return new CfgInfoContext(cfg, context);
    }

    private static IBuildObject find(IBuildObject[] objs, String id) {
        int i = 0;
        while (i < objs.length) {
            if (objs[i].getId().equals(id)) {
                return objs[i];
            }
            ++i;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CfgInfoContext)) {
            return false;
        }
        CfgInfoContext other = (CfgInfoContext)obj;
        if (!this.checkBuildObjects(other.fCfg, this.fCfg)) {
            return false;
        }
        if (!this.checkBuildObjects(other.fRcInfo, this.fRcInfo)) {
            return false;
        }
        if (!this.checkBuildObjects(other.fTool, this.fTool)) {
            return false;
        }
        return this.checkBuildObjects(other.fInType, this.fInType);
    }

    public int hashCode() {
        int code = this.getCode(this.fCfg);
        code += this.getCode(this.fRcInfo);
        code += this.getCode(this.fTool);
        return code += this.getCode(this.fInType);
    }

    private boolean checkBuildObjects(IBuildObject bo1, IBuildObject bo2) {
        if (bo1 == null) {
            return bo2 == null;
        }
        if (bo2 == null) {
            return false;
        }
        return bo1.getId().equals(bo2.getId());
    }

    private int getCode(IBuildObject bo) {
        if (bo == null) {
            return 29;
        }
        return bo.getId().hashCode();
    }
}

