/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.core.runtime.IConfigurationElement;

public class ConverterInfo {
    private IBuildObject fFromObject;
    private IBuildObject fConvertedFromObject;
    private IBuildObject fToObject;
    private IConfigurationElement fConverterElement;
    private boolean fIsConversionPerformed;
    private IResourceInfo fRcInfo;

    public ConverterInfo(IResourceInfo rcInfo, IBuildObject fromObject, IBuildObject toObject, IConfigurationElement el) {
        this.fFromObject = fromObject;
        this.fToObject = toObject;
        this.fConverterElement = el;
        this.fRcInfo = rcInfo;
    }

    public IBuildObject getFromObject() {
        return this.fFromObject;
    }

    public IBuildObject getToObject() {
        return this.fToObject;
    }

    public IConfigurationElement getConverterElement() {
        return this.fConverterElement;
    }

    public IBuildObject getConvertedFromObject() {
        if (!this.fIsConversionPerformed) {
            Iterator iter;
            ManagedProject mProj = this.getManagedProject();
            IConfiguration[] cfgs = mProj.getConfigurations();
            this.fConvertedFromObject = ManagedBuildManager.convert(this.fFromObject, this.fToObject.getId(), true);
            IConfiguration[] updatedCfgs = mProj.getConfigurations();
            HashSet<IConfiguration> oldSet = new HashSet<IConfiguration>(Arrays.asList(cfgs));
            HashSet<IConfiguration> updatedSet = new HashSet<IConfiguration>(Arrays.asList(updatedCfgs));
            HashSet<IConfiguration> oldSetCopy = new HashSet<IConfiguration>(oldSet);
            oldSet.removeAll(updatedSet);
            updatedSet.removeAll(oldSetCopy);
            if (updatedSet.size() != 0) {
                iter = updatedSet.iterator();
                while (iter.hasNext()) {
                    Configuration cfg = (Configuration)iter.next();
                    mProj.removeConfiguration(cfg.getId());
                }
            }
            if (oldSet.size() != 0) {
                iter = oldSet.iterator();
                while (iter.hasNext()) {
                    mProj.applyConfiguration((Configuration)iter.next());
                }
            }
            this.fIsConversionPerformed = true;
        }
        return this.fConvertedFromObject;
    }

    private ManagedProject getManagedProject() {
        if (this.fRcInfo != null) {
            return (ManagedProject)this.fRcInfo.getParent().getManagedProject();
        }
        return null;
    }
}

