/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.Arrays;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CResourceData;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.OptionStringValue;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.NotificationManager;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfoContainer;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class ResourceInfo
extends BuildObject
implements IResourceInfo {
    private Configuration config;
    private IPath path;
    boolean isDirty;
    boolean needsRebuild;
    private ResourceInfoContainer rcInfo;
    private CResourceData resourceData;

    ResourceInfo(IConfiguration cfg, IManagedConfigElement element, boolean hasBody) {
        this.config = (Configuration)cfg;
        if (hasBody) {
            this.loadFromManifest(element);
        }
    }

    ResourceInfo(IConfiguration cfg, ResourceInfo base, String id) {
        this.config = (Configuration)cfg;
        this.path = ResourceInfo.normalizePath(base.path);
        this.setId(id);
        this.setName(base.getName());
        if (id.equals(base.getId())) {
            this.isDirty = base.isDirty;
            this.needsRebuild = base.needsRebuild;
        } else {
            this.needsRebuild = true;
            this.isDirty = true;
        }
    }

    public boolean isRoot() {
        return this.path.segmentCount() == 0;
    }

    ResourceInfo(IConfiguration cfg, IPath path, String id, String name) {
        this.config = (Configuration)cfg;
        this.path = path = ResourceInfo.normalizePath(path);
        this.setId(id);
        this.setName(name);
    }

    ResourceInfo(IFileInfo base, IPath path, String id, String name) {
        this.config = (Configuration)base.getParent();
        this.setId(id);
        this.setName(name);
        this.path = path = ResourceInfo.normalizePath(path);
        this.needsRebuild = true;
        this.isDirty = true;
    }

    ResourceInfo(FolderInfo base, IPath path, String id, String name) {
        this.config = (Configuration)base.getParent();
        this.setId(id);
        this.setName(name);
        this.path = path = ResourceInfo.normalizePath(path);
        this.needsRebuild = true;
        this.isDirty = true;
    }

    ResourceInfo(IConfiguration cfg, ICStorageElement element, boolean hasBody) {
        this.config = (Configuration)cfg;
        if (hasBody) {
            this.loadFromProject(element);
        }
    }

    private void loadFromManifest(IManagedConfigElement element) {
        String excludeStr;
        this.setId(element.getAttribute("id"));
        this.setName(element.getAttribute("name"));
        String tmp = element.getAttribute("resourcePath");
        if (tmp != null) {
            this.path = new Path(tmp);
            if ("resourceConfiguration".equals(element.getName())) {
                this.path = this.path.removeFirstSegments(1);
            }
            this.path = ResourceInfo.normalizePath(this.path);
        }
        if ((excludeStr = element.getAttribute("exclude")) != null) {
            this.config.setExcluded(this.getPath(), this.isFolderInfo(), "true".equals(excludeStr));
        }
    }

    private void loadFromProject(ICStorageElement element) {
        String excludeStr;
        String tmp;
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(element.getAttribute("name"));
        }
        if (element.getAttribute("resourcePath") != null && (tmp = element.getAttribute("resourcePath")) != null) {
            this.path = new Path(tmp);
            if ("resourceConfiguration".equals(element.getName())) {
                this.path = this.path.removeFirstSegments(1);
            }
            this.path = ResourceInfo.normalizePath(this.path);
        }
        if (element.getAttribute("exclude") != null && (excludeStr = element.getAttribute("exclude")) != null) {
            this.config.setExcluded(this.getPath(), this.isFolderInfo(), "true".equals(excludeStr));
        }
    }

    public IConfiguration getParent() {
        return this.config;
    }

    public IPath getPath() {
        return ResourceInfo.normalizePath(this.path);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isExcluded() {
        return this.config.isExcluded(this.getPath());
    }

    public boolean needsRebuild() {
        return this.needsRebuild;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public void setExclude(boolean excluded) {
        if (this.isExcluded() == excluded) {
            return;
        }
        this.config.setExcluded(this.getPath(), this.isFolderInfo(), excluded);
        this.setDirty(true);
        this.setRebuildState(true);
    }

    public boolean canExclude(boolean exclude) {
        return this.config.canExclude(this.getPath(), this.isFolderInfo(), exclude);
    }

    public abstract boolean isFolderInfo();

    public void setPath(IPath p) {
        p = ResourceInfo.normalizePath(p);
        if (this.path == null) {
            this.path = p;
        } else if (!p.equals((Object)ResourceInfo.normalizePath(this.path))) {
            ResourceInfoContainer info = this.getRcInfo();
            info.changeCurrentPath(p, true);
            this.path = p;
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    private ResourceInfoContainer getRcInfo() {
        if (this.rcInfo == null) {
            this.rcInfo = this.config.getRcInfoContainer(this);
        }
        return this.rcInfo;
    }

    public void setRebuildState(boolean rebuild) {
        this.needsRebuild = rebuild;
    }

    void serialize(ICStorageElement element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.path != null) {
            element.setAttribute("resourcePath", this.path.toString());
        }
    }

    void resolveReferences() {
    }

    public CResourceData getResourceData() {
        return this.resourceData;
    }

    protected void setResourceData(CResourceData data) {
        this.resourceData = data;
    }

    void removed() {
        this.config = null;
    }

    public boolean isValid() {
        return this.config != null;
    }

    public IOption setOption(IHoldsOptions parent, IOption option, boolean value) throws BuildException {
        IOption retOpt = option;
        boolean oldVal = option.getBooleanValue();
        if (oldVal != value) {
            retOpt = parent.getOptionToSet(option, false);
            retOpt.setValue(value);
            NotificationManager.getInstance().optionChanged(this, parent, option, new Boolean(oldVal));
        }
        return retOpt;
    }

    public IOption setOption(IHoldsOptions parent, IOption option, String value) throws BuildException {
        IOption retOpt = option;
        String oldValue = option.getStringValue();
        if (oldValue != null && !oldValue.equals(value)) {
            retOpt = parent.getOptionToSet(option, false);
            retOpt.setValue(value);
            NotificationManager.getInstance().optionChanged(this, parent, option, oldValue);
        }
        return retOpt;
    }

    public IOption setOption(IHoldsOptions parent, IOption option, String[] value) throws BuildException {
        Object[] oldValue;
        IOption retOpt = option;
        switch (option.getBasicValueType()) {
            case 3: {
                oldValue = option.getBasicStringListValue();
                break;
            }
            default: {
                oldValue = new String[]{};
            }
        }
        if (!Arrays.equals(value, oldValue)) {
            retOpt = parent.getOptionToSet(option, false);
            retOpt.setValue(value);
            NotificationManager.getInstance().optionChanged(this, parent, option, oldValue);
        }
        return retOpt;
    }

    public IOption setOption(IHoldsOptions parent, IOption option, OptionStringValue[] value) throws BuildException {
        Object[] oldValue;
        IOption retOpt = option;
        switch (option.getBasicValueType()) {
            case 3: {
                oldValue = ((Option)option).getBasicStringListValueElements();
                break;
            }
            default: {
                oldValue = new OptionStringValue[]{};
            }
        }
        if (!Arrays.equals(value, oldValue)) {
            retOpt = parent.getOptionToSet(option, false);
            ((Option)retOpt).setValue(value);
            NotificationManager.getInstance().optionChanged(this, parent, option, oldValue);
        }
        return retOpt;
    }

    public void propertiesChanged() {
        if (this.isExtensionElement()) {
            return;
        }
        ITool[] tools = this.getTools();
        int i = 0;
        while (i < tools.length) {
            ((Tool)tools[i]).propertiesChanged();
            ++i;
        }
    }

    public abstract boolean isExtensionElement();

    public abstract Set contributeErrorParsers(Set var1);

    protected Set contributeErrorParsers(ITool[] tools, Set set) {
        int i = 0;
        while (i < tools.length) {
            Tool tool = (Tool)tools[i];
            set = tool.contributeErrorParsers(set);
            ++i;
        }
        return set;
    }

    public abstract void resetErrorParsers();

    protected void resetErrorParsers(ITool[] tools) {
        int i = 0;
        while (i < tools.length) {
            Tool tool = (Tool)tools[i];
            tool.resetErrorParsers();
            ++i;
        }
    }

    abstract void removeErrorParsers(Set var1);

    protected void removeErrorParsers(ITool[] tools, Set set) {
        int i = 0;
        while (i < tools.length) {
            Tool tool = (Tool)tools[i];
            tool.removeErrorParsers(set);
            ++i;
        }
    }

    public ITool getToolById(String id) {
        ITool[] tools = this.getTools();
        int i = 0;
        while (i < tools.length) {
            if (id.equals(tools[i].getId())) {
                return tools[i];
            }
            ++i;
        }
        return null;
    }

    public static IPath normalizePath(IPath path) {
        return path.makeRelative();
    }

    public ResourceInfo getParentResourceInfo() {
        if (this.isRoot()) {
            return null;
        }
        IPath path = this.getPath();
        path = path.removeLastSegments(1);
        return (ResourceInfo)this.getParent().getResourceInfo(path, false);
    }

    protected IFolderInfo getParentFolderInfo() {
        ResourceInfo parentRc = this.getParentResourceInfo();
        while (parentRc != null && !parentRc.isFolderInfo()) {
            parentRc = parentRc.getParentResourceInfo();
        }
        return (IFolderInfo)((Object)parentRc);
    }

    abstract void resolveProjectReferences(boolean var1);

    public abstract boolean hasCustomSettings();
}

