/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoChangeListener;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.util.XmlStorageElement;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyManager;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuildObjectProperties;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IConvertManagedBuildObject;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildDefinitionsStartup;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElementProvider;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITarget;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.IToolReference;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.core.OptionStringValue;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentBuildPathsChangeListener;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.buildproperties.BuildPropertyManager;
import org.eclipse.cdt.managedbuilder.internal.core.BooleanExpressionApplicabilityCalculator;
import org.eclipse.cdt.managedbuilder.internal.core.BuildDbgUtil;
import org.eclipse.cdt.managedbuilder.internal.core.BuildSettingsUtil;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.BuilderFactory;
import org.eclipse.cdt.managedbuilder.internal.core.CommonBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.DefaultManagedConfigElement;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.IMatchKeyProvider;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.OptionCategory;
import org.eclipse.cdt.managedbuilder.internal.core.OutputType;
import org.eclipse.cdt.managedbuilder.internal.core.ProjectType;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Target;
import org.eclipse.cdt.managedbuilder.internal.core.TargetPlatform;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildConfigurationData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.ConfigurationDataProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroProvider;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.cdt.managedbuilder.projectconverter.UpdateManagedProjectManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class ManagedBuildManager
extends AbstractCExtension
implements IScannerInfoProvider {
    private static final String ROOT_NODE_NAME = "ManagedProjectBuildInfo";
    public static final String SETTINGS_FILE_NAME = ".cdtbuild";
    private static final ITarget[] emptyTargets = new ITarget[0];
    public static final String INTERFACE_IDENTITY = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ManagedBuildManager";
    public static final String EXTENSION_POINT_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".buildDefinitions";
    public static final String EXTENSION_POINT_ID_V2 = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".ManagedBuildInfo";
    private static final String REVISION_ELEMENT_NAME = "managedBuildRevision";
    private static final String VERSION_ELEMENT_NAME = "fileVersion";
    private static final String MANIFEST_VERSION_ERROR = "ManagedBuildManager.error.manifest.version.error";
    private static final String PROJECT_VERSION_ERROR = "ManagedBuildManager.error.project.version.error";
    private static final String PROJECT_FILE_ERROR = "ManagedBuildManager.error.project.file.missing";
    private static final String MANIFEST_ERROR_HEADER = "ManagedBuildManager.error.manifest.header";
    public static final String MANIFEST_ERROR_RESOLVING = "ManagedBuildManager.error.manifest.resolving";
    public static final String MANIFEST_ERROR_DUPLICATE = "ManagedBuildManager.error.manifest.duplicate";
    public static final String MANIFEST_ERROR_ICON = "ManagedBuildManager.error.manifest.icon";
    private static final String MANIFEST_ERROR_OPTION_CATEGORY = "ManagedBuildManager.error.manifest.option.category";
    private static final String MANIFEST_ERROR_OPTION_FILTER = "ManagedBuildManager.error.manifest.option.filter";
    private static final String MANIFEST_ERROR_OPTION_VALUEHANDLER = "ManagedBuildManager.error.manifest.option.valuehandler";
    private static final String MANIFEST_ERROR_READ_ONLY = "ManagedBuildManager.error.read_only";
    private static final String MANIFEST_ERROR_WRITE_FAILED = "ManagedBuildManager.error.write_failed";
    public static final int ERROR_CATEGORY = 0;
    public static final int ERROR_FILTER = 1;
    public static final String BUILD_TYPE_PROPERTY_ID = "org.eclipse.cdt.build.core.buildType";
    public static final String BUILD_ARTEFACT_TYPE_PROPERTY_ID = "org.eclipse.cdt.build.core.buildArtefactType";
    public static final String BUILD_TYPE_PROPERTY_DEBUG = "org.eclipse.cdt.build.core.buildType.debug";
    public static final String BUILD_TYPE_PROPERTY_RELEASE = "org.eclipse.cdt.build.core.buildType.release";
    public static final String BUILD_ARTEFACT_TYPE_PROPERTY_EXE = "org.eclipse.cdt.build.core.buildArtefactType.exe";
    public static final String BUILD_ARTEFACT_TYPE_PROPERTY_STATICLIB = "org.eclipse.cdt.build.core.buildArtefactType.staticLib";
    public static final String BUILD_ARTEFACT_TYPE_PROPERTY_SHAREDLIB = "org.eclipse.cdt.build.core.buildArtefactType.sharedLib";
    public static final String CFG_DATA_PROVIDER_ID = String.valueOf(ManagedBuilderCorePlugin.getUniqueIdentifier()) + ".configurationDataProvider";
    private static final String NEWLINE = System.getProperty("line.separator");
    public static final String INTERNAL_BUILDER_ID = "org.eclipse.cdt.build.core.internal.builder";
    private static final PluginVersionIdentifier buildInfoVersion = new PluginVersionIdentifier(4, 0, 0);
    private static final Version version = new Version(4, 0, 0);
    private static Map depCalculatorsMap;
    private static boolean projectTypesLoaded;
    private static boolean projectTypesLoading;
    public static SortedMap projectTypeMap;
    private static List projectTypes;
    private static List startUpConfigElements;
    private static Map extensionConfigurationMap;
    private static Map extensionResourceConfigurationMap;
    private static SortedMap extensionToolChainMap;
    private static SortedMap extensionToolMap;
    private static Map extensionTargetPlatformMap;
    private static SortedMap extensionBuilderMap;
    private static Map extensionOptionMap;
    private static Map extensionOptionCategoryMap;
    private static Map extensionInputTypeMap;
    private static Map extensionOutputTypeMap;
    private static Map extensionTargetMap;
    private static Map configElementMap;
    private static Map buildModelListeners;
    private static Random randomNumber;
    private static IEnvironmentBuildPathsChangeListener fEnvironmentBuildPathsChangeListener;
    private static HashMap fSortedToolChains;
    private static HashMap fSortedTools;
    private static HashMap fSortedBuilders;
    private static Map fInfoMap;
    private static ISorter fToolChainSorter;
    private static ISorter fToolSorter;
    private static ISorter fBuilderSorter;
    private static final boolean TEST_CONSISTANCE = false;

    static {
        projectTypesLoaded = false;
        projectTypesLoading = false;
        fInfoMap = new HashMap();
        fToolChainSorter = new ISorter(){

            public void sort() {
                ManagedBuildManager.resortToolChains();
            }
        };
        fToolSorter = new ISorter(){

            public void sort() {
                ManagedBuildManager.resortTools();
            }
        };
        fBuilderSorter = new ISorter(){

            public void sort() {
                ManagedBuildManager.resortBuilders();
            }
        };
        fEnvironmentBuildPathsChangeListener = new IEnvironmentBuildPathsChangeListener(){

            public void buildPathsChanged(IConfiguration configuration, int buildPathType) {
            }
        };
        ManagedBuildManager.getEnvironmentVariableProvider().subscribe(fEnvironmentBuildPathsChangeListener);
    }

    public static int getRandomNumber() {
        int i;
        if (randomNumber == null) {
            randomNumber = new Random();
            randomNumber.setSeed(System.currentTimeMillis());
        }
        if ((i = randomNumber.nextInt()) < 0) {
            i *= -1;
        }
        return i;
    }

    public static IProjectType[] getDefinedProjectTypes() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        List definedTypes = null;
        int size = projectTypes != null ? projectTypes.size() + (definedTypes != null ? definedTypes.size() : 0) : 0;
        IProjectType[] types = new IProjectType[size];
        int n = 0;
        int i = 0;
        while (i < projectTypes.size()) {
            types[n++] = (IProjectType)projectTypes.get(i);
            ++i;
        }
        if (definedTypes != null) {
            i = 0;
            while (i < definedTypes.size()) {
                types[n++] = (IProjectType)definedTypes.get(i);
                ++i;
            }
        }
        return types;
    }

    public static IProjectType getProjectType(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IProjectType)ManagedBuildManager.getExtensionProjectTypeMap().get(id);
    }

    public static Version getVersion() {
        return version;
    }

    protected static Map getExtensionDepCalcMap() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException buildException) {}
        if (depCalculatorsMap == null) {
            depCalculatorsMap = new HashMap();
        }
        return depCalculatorsMap;
    }

    public static SortedMap getExtensionProjectTypeMap() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException buildException) {}
        if (projectTypeMap == null) {
            projectTypeMap = new TreeMap();
        }
        return projectTypeMap;
    }

    protected static Map getExtensionConfigurationMap() {
        if (extensionConfigurationMap == null) {
            extensionConfigurationMap = new HashMap();
        }
        return extensionConfigurationMap;
    }

    protected static Map getExtensionResourceConfigurationMap() {
        if (extensionResourceConfigurationMap == null) {
            extensionResourceConfigurationMap = new HashMap();
        }
        return extensionResourceConfigurationMap;
    }

    public static SortedMap getExtensionToolChainMap() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException buildException) {}
        if (extensionToolChainMap == null) {
            extensionToolChainMap = new TreeMap();
        }
        return extensionToolChainMap;
    }

    public static SortedMap getExtensionToolMap() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException buildException) {}
        if (extensionToolMap == null) {
            extensionToolMap = new TreeMap();
        }
        return extensionToolMap;
    }

    protected static Map getExtensionTargetPlatformMap() {
        if (extensionTargetPlatformMap == null) {
            extensionTargetPlatformMap = new HashMap();
        }
        return extensionTargetPlatformMap;
    }

    public static SortedMap getExtensionBuilderMap() {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException buildException) {}
        if (extensionBuilderMap == null) {
            extensionBuilderMap = new TreeMap();
        }
        return extensionBuilderMap;
    }

    protected static Map getExtensionOptionMap() {
        if (extensionOptionMap == null) {
            extensionOptionMap = new HashMap();
        }
        return extensionOptionMap;
    }

    protected static Map getExtensionOptionCategoryMap() {
        if (extensionOptionCategoryMap == null) {
            extensionOptionCategoryMap = new HashMap();
        }
        return extensionOptionCategoryMap;
    }

    protected static Map getExtensionInputTypeMap() {
        if (extensionInputTypeMap == null) {
            extensionInputTypeMap = new HashMap();
        }
        return extensionInputTypeMap;
    }

    protected static Map getExtensionOutputTypeMap() {
        if (extensionOutputTypeMap == null) {
            extensionOutputTypeMap = new HashMap();
        }
        return extensionOutputTypeMap;
    }

    protected static Map getExtensionTargetMap() {
        if (extensionTargetMap == null) {
            extensionTargetMap = new HashMap();
        }
        return extensionTargetMap;
    }

    public static ITarget[] getTargets(IResource resource) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo(resource);
        if (buildInfo != null) {
            List targets = buildInfo.getTargets();
            return targets.toArray(new ITarget[targets.size()]);
        }
        return emptyTargets;
    }

    public static IProjectType getExtensionProjectType(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IProjectType)ManagedBuildManager.getExtensionProjectTypeMap().get(id);
    }

    public static IConfiguration getExtensionConfiguration(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IConfiguration)ManagedBuildManager.getExtensionConfigurationMap().get(id);
    }

    public static IResourceConfiguration getExtensionResourceConfiguration(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IResourceConfiguration)ManagedBuildManager.getExtensionResourceConfigurationMap().get(id);
    }

    public static IToolChain getExtensionToolChain(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IToolChain)ManagedBuildManager.getExtensionToolChainMap().get(id);
    }

    public static ITool getExtensionTool(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (ITool)ManagedBuildManager.getExtensionToolMap().get(id);
    }

    public static ITargetPlatform getExtensionTargetPlatform(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (ITargetPlatform)ManagedBuildManager.getExtensionTargetPlatformMap().get(id);
    }

    public static IBuilder getExtensionBuilder(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IBuilder)ManagedBuildManager.getExtensionBuilderMap().get(id);
    }

    public static IBuilder getExtensionBuilder(IBuilder builder) {
        while (builder != null && !builder.isExtensionElement()) {
            builder = builder.getSuperClass();
        }
        return builder;
    }

    public static IOption getExtensionOption(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IOption)ManagedBuildManager.getExtensionOptionMap().get(id);
    }

    public static IInputType getExtensionInputType(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IInputType)ManagedBuildManager.getExtensionInputTypeMap().get(id);
    }

    public static IOutputType getExtensionOutputType(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (IOutputType)ManagedBuildManager.getExtensionOutputTypeMap().get(id);
    }

    public static ITarget getExtensionTarget(String id) {
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return (ITarget)ManagedBuildManager.getExtensionTargetMap().get(id);
    }

    public static ITarget getTarget(IResource resource, String id) {
        IManagedBuildInfo buildInfo;
        ITarget target = null;
        if (resource != null && (buildInfo = ManagedBuildManager.getBuildInfo(resource)) != null) {
            target = buildInfo.getTarget(id);
        }
        if (target == null) {
            target = (ITarget)ManagedBuildManager.getExtensionTargetMap().get(id);
        }
        return target;
    }

    public static void setDefaultConfiguration(IProject project, IConfiguration newDefault) {
        if (project == null || newDefault == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            info.setDefaultConfiguration(newDefault);
        }
    }

    public static void setSelectedConfiguration(IProject project, IConfiguration config) {
        if (project == null) {
            return;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            info.setSelectedConfiguration(config);
        }
    }

    public static IManagedBuilderMakefileGenerator getBuildfileGenerator(IConfiguration config) {
        IBuilder builder;
        IToolChain toolChain = config.getToolChain();
        if (toolChain != null && (builder = toolChain.getBuilder()) != null) {
            return builder.getBuildFileGenerator();
        }
        return new GnuMakefileGenerator();
    }

    public static IManagedCommandLineGenerator getCommandLineGenerator(IConfiguration config, String toolId) {
        ITool tool = config.getTool(toolId);
        if (tool != null) {
            return tool.getCommandLineGenerator();
        }
        return ManagedCommandLineGenerator.getCommandLineGenerator();
    }

    public static String getScannerInfoProfileId(IConfiguration config) {
        IToolChain toolChain = config.getToolChain();
        return toolChain.getScannerConfigDiscoveryProfileId();
    }

    public static IConfiguration getSelectedConfiguration(IProject project) {
        if (project == null) {
            return null;
        }
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null) {
            return info.getSelectedConfiguration();
        }
        return null;
    }

    private static void notifyListeners(IConfiguration config, IOption option) {
        try {
            if (config.isTemporary() || option != null && option.getValueType() != 4 && option.getValueType() != 5 && option.getValueType() != 8 && option.getValueType() != 9 && option.getValueType() != 10 && option.getValueType() != 11 && option.getValueType() != -4 && option.getValueType() != -5 && option.getValueType() != -8 && option.getValueType() != -9 && option.getValueType() != -10 && option.getValueType() != -11) {
                return;
            }
        }
        catch (BuildException buildException) {
            return;
        }
        IResource resource = config.getOwner();
        List listeners = (List)ManagedBuildManager.getBuildModelListeners().get(resource);
        if (listeners == null) {
            return;
        }
        ListIterator iter = listeners.listIterator();
        while (iter.hasNext()) {
            ((IScannerInfoChangeListener)iter.next()).changeNotification(resource, (IScannerInfo)ManagedBuildManager.getBuildInfo(resource));
        }
    }

    public static void initializePathEntries(IConfiguration config, IOption option) {
        try {
            if (config.isTemporary() || option != null && option.getValueType() != 4 && option.getValueType() != 5 && option.getValueType() != 8 && option.getValueType() != 9 && option.getValueType() != 10 && option.getValueType() != 11 && option.getValueType() != -4 && option.getValueType() != -5 && option.getValueType() != -8 && option.getValueType() != -9 && option.getValueType() != -10 && option.getValueType() != -11) {
                return;
            }
        }
        catch (BuildException buildException) {
            return;
        }
        try {
            ManagedBuildManager.updateCoreSettings(config);
        }
        catch (CoreException coreException) {}
    }

    public static void initializePathEntries(IResourceConfiguration resConfig, IOption option) {
        IConfiguration cfg = resConfig.getParent();
        if (cfg != null) {
            ManagedBuildManager.initializePathEntries(cfg, option);
        }
    }

    private static void notifyListeners(IResourceInfo resConfig, IOption option) {
        try {
            if (resConfig.getParent().isTemporary() || option != null && option.getValueType() != 4 && option.getValueType() != 5 && option.getValueType() != 8 && option.getValueType() != 9 && option.getValueType() != 10 && option.getValueType() != 11 && option.getValueType() != -4 && option.getValueType() != -5 && option.getValueType() != -8 && option.getValueType() != -9 && option.getValueType() != -10 && option.getValueType() != -11) {
                return;
            }
        }
        catch (BuildException buildException) {
            return;
        }
        IResource resource = resConfig.getParent().getOwner();
        List listeners = (List)ManagedBuildManager.getBuildModelListeners().get(resource);
        if (listeners == null) {
            return;
        }
        ListIterator iter = listeners.listIterator();
        while (iter.hasNext()) {
            ((IScannerInfoChangeListener)iter.next()).changeNotification(resource, (IScannerInfo)ManagedBuildManager.getBuildInfo(resource));
        }
    }

    public static void setNewProjectVersion(IProject newProject) {
        ManagedBuildInfo info = ManagedBuildManager.findBuildInfo((IResource)newProject, true);
        if (info != null) {
            info.setVersion(buildInfoVersion.toString());
        }
    }

    public static IOption setOption(IConfiguration config, IHoldsOptions holder, IOption option, boolean value) {
        IOption retOpt;
        try {
            retOpt = config.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(config, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceInfo resConfig, IHoldsOptions holder, IOption option, boolean value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(resConfig, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            ManagedBuildManager.notifyListeners(resConfig, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IConfiguration config, IHoldsOptions holder, IOption option, String value) {
        IOption retOpt;
        try {
            retOpt = config.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(config, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceInfo resConfig, IHoldsOptions holder, IOption option, String value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(resConfig, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            ManagedBuildManager.notifyListeners(resConfig, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IConfiguration config, IHoldsOptions holder, IOption option, String[] value) {
        IOption retOpt;
        try {
            retOpt = config.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(config, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceInfo resConfig, IHoldsOptions holder, IOption option, String[] value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(resConfig, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            ManagedBuildManager.notifyListeners(resConfig, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static IOption setOption(IResourceInfo resConfig, IHoldsOptions holder, IOption option, OptionStringValue[] value) {
        IOption retOpt;
        try {
            retOpt = resConfig.setOption(holder, option, value);
            retOpt.getValueHandler().handleValue(resConfig, holder, retOpt, retOpt.getValueHandlerExtraArgument(), 4);
            ManagedBuildManager.notifyListeners(resConfig, retOpt);
        }
        catch (BuildException buildException) {
            return null;
        }
        return retOpt;
    }

    public static void setToolCommand(IConfiguration config, ITool tool, String command) {
        if (tool instanceof IToolReference) {
            ((IToolReference)tool).setToolCommand(command);
        } else {
            config.setToolCommand(tool, command);
        }
    }

    public static void setToolCommand(IResourceConfiguration resConfig, ITool tool, String command) {
        if (tool instanceof IToolReference) {
            ((IToolReference)tool).setToolCommand(command);
        } else {
            resConfig.setToolCommand(tool, command);
        }
    }

    public static boolean saveBuildInfoLegacy(IProject project, boolean force) {
        Throwable err = null;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            ManagedBuildInfo buildInfo = (ManagedBuildInfo)ManagedBuildManager.getBuildInfo((IResource)project);
            if (buildInfo != null && !buildInfo.isReadOnly() && buildInfo.isValid() && (force || buildInfo.isDirty())) {
                String projectVersion = buildInfo.getVersion();
                if (projectVersion != null) {
                    ProcessingInstruction instruction = doc.createProcessingInstruction(VERSION_ELEMENT_NAME, projectVersion);
                    doc.appendChild(instruction);
                }
                Element rootElement = doc.createElement(ROOT_NODE_NAME);
                doc.appendChild(rootElement);
                buildInfo.serializeLegacy(doc, rootElement);
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(stream);
                transformer.transform(source, result);
                IFile projectFile = project.getFile(SETTINGS_FILE_NAME);
                String utfString = stream.toString("UTF-8");
                if (projectFile.exists()) {
                    if (projectFile.isReadOnly()) {
                        IStatus status;
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null) {
                            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                            window = windows[0];
                        }
                        Shell shell = null;
                        if (window != null) {
                            shell = window.getShell();
                        }
                        if (!(status = projectFile.getWorkspace().validateEdit(new IFile[]{projectFile}, (Object)shell)).isOK() && status.getCode() == 279) {
                            stream.close();
                            throw new IOException(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_READ_ONLY, projectFile.getFullPath().toString()));
                        }
                    }
                    projectFile.setContents((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    projectFile.create((InputStream)new ByteArrayInputStream(utfString.getBytes("UTF-8")), 1, (IProgressMonitor)new NullProgressMonitor());
                }
                stream.close();
            }
        }
        catch (ParserConfigurationException e) {
            err = e;
        }
        catch (FactoryConfigurationError e) {
            err = e.getException();
        }
        catch (TransformerConfigurationException e) {
            err = e;
        }
        catch (TransformerFactoryConfigurationError e) {
            err = e.getException();
        }
        catch (TransformerException e) {
            err = e;
        }
        catch (IOException e) {
            err = e;
        }
        catch (CoreException e) {
            err = e;
        }
        if (err != null) {
            Shell shell;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                window = windows[0];
            }
            if ((shell = window.getShell()) != null) {
                final String exceptionMsg = err.getMessage();
                shell.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)shell, (String)ManagedMakeMessages.getResourceString("ManagedBuildManager.error.write_failed_title"), (String)ManagedMakeMessages.getFormattedString(ManagedBuildManager.MANIFEST_ERROR_WRITE_FAILED, exceptionMsg));
                    }
                });
            }
        }
        return true;
    }

    public static boolean saveBuildInfo(final IProject project, final boolean force) {
        try {
            return ManagedBuildManager.updateBuildInfo(project, force);
        }
        catch (CoreException e) {
            Throwable cause = e.getStatus().getException();
            if (cause instanceof IllegalArgumentException) {
                Job j = new Job("save build info job"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ManagedBuildManager.updateBuildInfo(project, force);
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                };
                j.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
                j.setSystem(true);
                j.schedule();
                return true;
            }
            ManagedBuilderCorePlugin.log(e);
            return false;
        }
    }

    private static boolean updateBuildInfo(IProject project, boolean force) throws CoreException {
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project, false);
        if (info == null) {
            return true;
        }
        ICProjectDescription projDes = CoreModel.getDefault().getProjectDescription(project);
        projDes = BuildSettingsUtil.synchBuildInfo(info, projDes, force);
        BuildSettingsUtil.checkApplyDescription(project, projDes);
        return true;
    }

    public static void updateCoreSettings(IProject project) throws CoreException {
        ManagedBuildManager.updateBuildInfo(project, true);
    }

    public static void updateCoreSettings(IConfiguration cfg) throws CoreException {
        IProject project = cfg.getOwner().getProject();
        ICProjectDescription projDes = CoreModel.getDefault().getProjectDescription(project);
        if (projDes != null && BuildSettingsUtil.applyConfiguration(cfg, projDes, true)) {
            BuildSettingsUtil.checkApplyDescription(project, projDes);
        }
    }

    public static void updateCoreSettings(IProject project, IConfiguration[] cfgs) throws CoreException {
        ManagedBuildManager.updateCoreSettings(project, cfgs, false);
    }

    public static void updateCoreSettings(IProject project, IConfiguration[] cfgs, boolean avoidSerialization) throws CoreException {
        IManagedBuildInfo info;
        if (cfgs == null && (info = ManagedBuildManager.getBuildInfo((IResource)project)) != null && info.isValid() && info.getManagedProject() != null) {
            cfgs = info.getManagedProject().getConfigurations();
        }
        if (cfgs == null || cfgs.length == 0) {
            return;
        }
        ICProjectDescription projDes = CoreModel.getDefault().getProjectDescription(project);
        boolean updated = false;
        if (projDes != null) {
            int i = 0;
            while (i < cfgs.length) {
                if (BuildSettingsUtil.applyConfiguration(cfgs[i], projDes, true)) {
                    updated = true;
                }
                ++i;
            }
            if (updated) {
                BuildSettingsUtil.checkApplyDescription(project, projDes, avoidSerialization);
            }
        }
    }

    public static void removeBuildInfo(IResource resource) {
    }

    public static void resetConfiguration(IProject project, IConfiguration configuration) {
        ((Configuration)configuration).reset();
        ManagedBuildManager.performValueHandlerEvent(configuration, 3, false);
    }

    public static void resetResourceConfiguration(IProject project, IResourceConfiguration resConfig) {
        ((ResourceConfiguration)resConfig).reset();
        ManagedBuildManager.performValueHandlerEvent(resConfig, 3);
    }

    public static void resetOptionSettings(IResourceInfo rcInfo) {
        if (rcInfo instanceof IFileInfo) {
            Configuration cfg = (Configuration)rcInfo.getParent();
            IProject project = cfg.isExtensionElement() || cfg.isPreference() ? null : cfg.getOwner().getProject();
            ManagedBuildManager.resetResourceConfiguration(project, (IFileInfo)rcInfo);
        } else {
            FolderInfo fo = (FolderInfo)rcInfo;
            fo.resetOptionSettings();
        }
    }

    public static void addExtensionProjectType(ProjectType projectType) {
        if (projectTypes == null) {
            projectTypes = new ArrayList();
        }
        projectTypes.add(projectType);
        ProjectType previous = ManagedBuildManager.getExtensionProjectTypeMap().put(projectType.getId(), projectType);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("ProjectType", projectType.getId());
        }
    }

    public static void addExtensionConfiguration(Configuration configuration) {
        Configuration previous = ManagedBuildManager.getExtensionConfigurationMap().put(configuration.getId(), configuration);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("Configuration", configuration.getId());
        }
    }

    public static void addExtensionResourceConfiguration(ResourceConfiguration resourceConfiguration) {
        ResourceConfiguration previous = ManagedBuildManager.getExtensionResourceConfigurationMap().put(resourceConfiguration.getId(), resourceConfiguration);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("ResourceConfiguration", resourceConfiguration.getId());
        }
    }

    public static void addExtensionToolChain(ToolChain toolChain) {
        ToolChain previous = ManagedBuildManager.getExtensionToolChainMap().put(toolChain.getId(), toolChain);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("ToolChain", toolChain.getId());
        }
    }

    public static void addExtensionTool(Tool tool) {
        Tool previous = ManagedBuildManager.getExtensionToolMap().put(tool.getId(), tool);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("Tool", tool.getId());
        }
    }

    public static void addExtensionTargetPlatform(TargetPlatform targetPlatform) {
        TargetPlatform previous = ManagedBuildManager.getExtensionTargetPlatformMap().put(targetPlatform.getId(), targetPlatform);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("TargetPlatform", targetPlatform.getId());
        }
    }

    public static void addExtensionBuilder(Builder builder) {
        Builder previous = ManagedBuildManager.getExtensionBuilderMap().put(builder.getId(), builder);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("Builder", builder.getId());
        }
    }

    public static void addExtensionOption(Option option) {
        Option previous = ManagedBuildManager.getExtensionOptionMap().put(option.getId(), option);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("Option", option.getId());
        }
    }

    public static void addExtensionOptionCategory(OptionCategory optionCategory) {
        OptionCategory previous = ManagedBuildManager.getExtensionOptionCategoryMap().put(optionCategory.getId(), optionCategory);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("OptionCategory", optionCategory.getId());
        }
    }

    public static void addExtensionInputType(InputType inputType) {
        InputType previous = ManagedBuildManager.getExtensionInputTypeMap().put(inputType.getId(), inputType);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("InputType", inputType.getId());
        }
    }

    public static void addExtensionOutputType(OutputType outputType) {
        OutputType previous = ManagedBuildManager.getExtensionOutputTypeMap().put(outputType.getId(), outputType);
        if (previous != null) {
            ManagedBuildManager.OutputDuplicateIdError("OutputType", outputType.getId());
        }
    }

    public static void addExtensionTarget(Target target) {
        ManagedBuildManager.getExtensionTargetMap().put(target.getId(), target);
    }

    public static IManagedProject createManagedProject(IResource resource, IProjectType parent) throws BuildException {
        return new ManagedProject(resource, parent);
    }

    public static ITarget createTarget(IResource resource, ITarget parentTarget) throws BuildException {
        IResource owner = parentTarget.getOwner();
        if (owner != null && owner.equals((Object)resource)) {
            return parentTarget;
        }
        if (resource instanceof IProject) {
            if (owner != null) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.owner_not_null"));
            }
        } else {
            if (owner == null) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.null_owner"));
            }
            if (!owner.equals((Object)resource.getProject())) {
                throw new BuildException(ManagedMakeMessages.getResourceString("ManagedBuildManager.error.owner_not_project"));
            }
        }
        return new Target(resource, parentTarget);
    }

    public static IStatus initBuildInfoContainer(IResource resource) {
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initBuildInfoContainer(ManagedBuildInfo info) throws CoreException {
        ICProject cProject;
        if (info == null) {
            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), 4, new String(), null));
        }
        if (info.isContainerInited()) {
            return;
        }
        ICProject iCProject = cProject = info.getCProject();
        synchronized (iCProject) {
            IPathEntry[] entries = cProject.getRawPathEntries();
            ArrayList<IPathEntry> newEntries = new ArrayList<IPathEntry>(Arrays.asList(entries));
            if (!newEntries.contains(ManagedBuildInfo.containerEntry)) {
                newEntries.add((IPathEntry)ManagedBuildInfo.containerEntry);
                cProject.setRawPathEntries(newEntries.toArray(new IPathEntry[newEntries.size()]), (IProgressMonitor)new NullProgressMonitor());
            }
            info.setContainerInited(true);
        }
    }

    private static boolean isVersionCompatible(IExtension extension) {
        PluginVersionIdentifier version = null;
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int index = 0;
        while (index < elements.length) {
            IConfigurationElement element = elements[index];
            if (element.getName().equals(REVISION_ELEMENT_NAME)) {
                version = new PluginVersionIdentifier(element.getAttribute(VERSION_ELEMENT_NAME));
                break;
            }
            ++index;
        }
        if (version == null) {
            return true;
        }
        return buildInfoVersion.isGreaterOrEqualTo(version);
    }

    private static boolean canLoadBuildInfo(IProject project) {
        IFile file = project.getFile(SETTINGS_FILE_NAME);
        if (file == null) {
            return false;
        }
        File cdtbuild = file.getLocation().toFile();
        if (cdtbuild == null) {
            return false;
        }
        return cdtbuild.exists();
    }

    private static ManagedBuildInfo loadOldStyleBuildInfo(IProject project) throws Exception {
        PluginVersionIdentifier version;
        ManagedBuildInfo buildInfo = null;
        IFile file = project.getFile(SETTINGS_FILE_NAME);
        File cdtbuild = file.getLocation().toFile();
        if (!cdtbuild.exists()) {
            throw new BuildException(ManagedMakeMessages.getFormattedString(PROJECT_FILE_ERROR, project.getName()));
        }
        FileInputStream stream = new FileInputStream(cdtbuild);
        DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = parser.parse(stream);
        String fileVersion = null;
        Node rootElement = document.getFirstChild();
        if (rootElement.getNodeType() == 7 && !buildInfoVersion.isGreaterThan(version = new PluginVersionIdentifier(fileVersion = rootElement.getNodeValue())) && !buildInfoVersion.isCompatibleWith(version)) {
            throw new BuildException(ManagedMakeMessages.getFormattedString(PROJECT_VERSION_ERROR, project.getName()));
        }
        NodeList nodes = document.getElementsByTagName(ROOT_NODE_NAME);
        if (nodes.getLength() > 0) {
            PluginVersionIdentifier version21;
            PluginVersionIdentifier version2;
            Node node = nodes.item(0);
            buildInfo = new ManagedBuildInfo((IResource)project, (ICStorageElement)new XmlStorageElement((Element)node), true, fileVersion);
            if (fileVersion != null && (version2 = new PluginVersionIdentifier(fileVersion)).isGreaterOrEqualTo(version21 = new PluginVersionIdentifier("2.1"))) {
                if (buildInfo.getManagedProject() == null || !buildInfo.getManagedProject().isValid()) {
                    throw new Exception(ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.id.nomatch", project.getName()));
                }
                if (!(ManagedBuildManager.checkForMigrationSupport(buildInfo, false) || buildInfo.getManagedProject() != null && buildInfo.getManagedProject().isValid())) {
                    throw new Exception(ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.id.nomatch", project.getName()));
                }
            }
            if (!UpdateManagedProjectManager.isCompatibleProject(buildInfo)) {
                UpdateManagedProjectManager.updateProject(project, buildInfo);
            }
            if (buildInfo.getManagedProject() == null || !buildInfo.getManagedProject().isValid()) {
                throw new Exception(ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.id.nomatch", project.getName()));
            }
            if (!(ManagedBuildManager.checkForMigrationSupport(buildInfo, true) || buildInfo.getManagedProject() != null && buildInfo.getManagedProject().isValid())) {
                throw new Exception(ManagedMakeMessages.getFormattedString("ManagedBuildManager.error.id.nomatch", project.getName()));
            }
            IConfiguration[] configs = buildInfo.getManagedProject().getConfigurations();
            int i = 0;
            while (i < configs.length) {
                ManagedBuildManager.performValueHandlerEvent(configs[i], 1);
                ++i;
            }
            ManagedBuildManager.setLoaddedBuildInfo(project, buildInfo);
        }
        buildInfo.setValid(true);
        return buildInfo;
    }

    private static void loadExtensions() throws BuildException {
        if (projectTypesLoaded) {
            return;
        }
        ManagedBuildManager.loadExtensionsSynchronized();
    }

    private static synchronized void loadExtensionsSynchronized() throws BuildException {
        IConfigurationElement element;
        IExtension[] extensions;
        if (projectTypesLoaded) {
            return;
        }
        if (projectTypesLoading) {
            return;
        }
        projectTypesLoading = true;
        ArrayList<IManagedBuildDefinitionsStartup> buildDefStartupList = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null) {
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                if (!ManagedBuildManager.isVersionCompatible(extension)) {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window == null) {
                        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                        window = windows[0];
                    }
                    final Shell shell = window.getShell();
                    final String errMsg = ManagedMakeMessages.getFormattedString(MANIFEST_VERSION_ERROR, extension.getUniqueIdentifier());
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)shell, (String)ManagedMakeMessages.getResourceString("ManagedBuildManager.error.manifest_load_failed_title"), (String)errMsg);
                        }
                    });
                } else {
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    String revision = null;
                    int j = 0;
                    while (j < elements.length) {
                        element = elements[j];
                        if (element.getName().equals(REVISION_ELEMENT_NAME)) {
                            revision = element.getAttribute(VERSION_ELEMENT_NAME);
                            break;
                        }
                        ++j;
                    }
                    ManagedBuildManager.loadConfigElements(DefaultManagedConfigElement.convertArray(elements, extension), revision);
                }
                ++i;
            }
            if (startUpConfigElements != null) {
                buildDefStartupList = new ArrayList<IManagedBuildDefinitionsStartup>(startUpConfigElements.size());
                Iterator iter = startUpConfigElements.iterator();
                while (iter.hasNext()) {
                    try {
                        IManagedBuildDefinitionsStartup customConfigLoader = ManagedBuildManager.createStartUpConfigLoader((DefaultManagedConfigElement)iter.next());
                        buildDefStartupList.add(customConfigLoader);
                        customConfigLoader.buildDefsLoaded();
                    }
                    catch (CoreException coreException) {}
                }
            }
            Iterator projectTypeIter = ManagedBuildManager.getExtensionProjectTypeMap().values().iterator();
            while (projectTypeIter.hasNext()) {
                try {
                    ProjectType projectType = (ProjectType)projectTypeIter.next();
                    projectType.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator configurationIter = ManagedBuildManager.getExtensionConfigurationMap().values().iterator();
            while (configurationIter.hasNext()) {
                try {
                    Configuration configuration = (Configuration)configurationIter.next();
                    configuration.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator resConfigIter = ManagedBuildManager.getExtensionResourceConfigurationMap().values().iterator();
            while (resConfigIter.hasNext()) {
                try {
                    ResourceConfiguration resConfig = (ResourceConfiguration)resConfigIter.next();
                    resConfig.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator toolChainIter = ManagedBuildManager.getExtensionToolChainMap().values().iterator();
            while (toolChainIter.hasNext()) {
                try {
                    ToolChain toolChain = (ToolChain)toolChainIter.next();
                    toolChain.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator toolIter = ManagedBuildManager.getExtensionToolMap().values().iterator();
            while (toolIter.hasNext()) {
                try {
                    Tool tool = (Tool)toolIter.next();
                    tool.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator targetPlatformIter = ManagedBuildManager.getExtensionTargetPlatformMap().values().iterator();
            while (targetPlatformIter.hasNext()) {
                try {
                    TargetPlatform targetPlatform = (TargetPlatform)targetPlatformIter.next();
                    targetPlatform.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator builderIter = ManagedBuildManager.getExtensionBuilderMap().values().iterator();
            while (builderIter.hasNext()) {
                try {
                    Builder builder = (Builder)builderIter.next();
                    builder.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator optionIter = ManagedBuildManager.getExtensionOptionMap().values().iterator();
            while (optionIter.hasNext()) {
                try {
                    Option option = (Option)optionIter.next();
                    option.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Iterator optionCatIter = ManagedBuildManager.getExtensionOptionCategoryMap().values().iterator();
            while (optionCatIter.hasNext()) {
                try {
                    OptionCategory optionCat = (OptionCategory)optionCatIter.next();
                    optionCat.resolveReferences();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID_V2)) != null) {
            extensions = extensionPoint.getExtensions();
            String revision = null;
            if (extensions != null && extensions.length > 0) {
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    if (!ManagedBuildManager.isVersionCompatible(extension)) {
                        throw new BuildException(ManagedMakeMessages.getResourceString(MANIFEST_VERSION_ERROR));
                    }
                    IConfigurationElement[] elements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < elements.length) {
                        element = elements[j];
                        if (element.getName().equals(REVISION_ELEMENT_NAME)) {
                            revision = element.getAttribute(VERSION_ELEMENT_NAME);
                            break;
                        }
                        ++j;
                    }
                    if (revision == null) {
                        revision = "1.2.0";
                    }
                    ManagedBuildManager.loadConfigElementsV2(DefaultManagedConfigElement.convertArray(elements, extension), revision);
                    ++i;
                }
                Iterator targetIter = ManagedBuildManager.getExtensionTargetMap().values().iterator();
                while (targetIter.hasNext()) {
                    try {
                        Target target = (Target)targetIter.next();
                        target.resolveReferences();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Iterator toolIter = ManagedBuildManager.getExtensionToolMap().values().iterator();
                while (toolIter.hasNext()) {
                    try {
                        Tool tool = (Tool)toolIter.next();
                        tool.resolveReferences();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                targetIter = ManagedBuildManager.getExtensionTargetMap().values().iterator();
                while (targetIter.hasNext()) {
                    try {
                        Target target = (Target)targetIter.next();
                        if (target.getCreatedProjectType() != null) continue;
                        target.convertToProjectType(revision);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                Iterator projTypeIter = ManagedBuildManager.getExtensionProjectTypeMap().values().iterator();
                while (projTypeIter.hasNext()) {
                    try {
                        ProjectType projType = (ProjectType)projTypeIter.next();
                        projType.resolveReferences();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        if (buildDefStartupList != null) {
            Iterator iter = buildDefStartupList.iterator();
            while (iter.hasNext()) {
                IManagedBuildDefinitionsStartup customConfigLoader = (IManagedBuildDefinitionsStartup)iter.next();
                customConfigLoader.buildDefsResolved();
            }
        }
        ManagedBuildManager.performAdjustments();
        projectTypesLoading = false;
        projectTypesLoaded = true;
    }

    private static void performAdjustments() {
        int j;
        IConfiguration[] cfgs;
        IProjectType[] types = ManagedBuildManager.getDefinedProjectTypes();
        int i = 0;
        while (i < types.length) {
            cfgs = types[i].getConfigurations();
            j = 0;
            while (j < cfgs.length) {
                ManagedBuildManager.adjustConfig(cfgs[j]);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < types.length) {
            cfgs = types[i].getConfigurations();
            j = 0;
            while (j < cfgs.length) {
                ManagedBuildManager.performValueHandlerEvent(cfgs[j], 5);
                ++j;
            }
            ++i;
        }
    }

    private static void adjustConfig(IConfiguration cfg) {
        IResourceInfo[] rcInfos = cfg.getResourceInfos();
        int i = 0;
        while (i < rcInfos.length) {
            IResourceInfo info;
            if (rcInfos[i] instanceof IFolderInfo) {
                info = (IFolderInfo)rcInfos[i];
                IToolChain tc = info.getToolChain();
                ManagedBuildManager.adjustHolder(info, tc);
                ITool[] tools = tc.getTools();
                int j = 0;
                while (j < tools.length) {
                    ManagedBuildManager.adjustHolder(info, tools[j]);
                    ++j;
                }
            } else if (rcInfos[i] instanceof IFileInfo) {
                info = (IFileInfo)rcInfos[i];
                ITool[] rcTools = info.getTools();
                int j = 0;
                while (j < rcTools.length) {
                    ManagedBuildManager.adjustHolder(info, rcTools[j]);
                    ++j;
                }
            }
            ++i;
        }
        IResourceConfiguration[] rcCfgs = cfg.getResourceConfigurations();
        int i2 = 0;
        while (i2 < rcCfgs.length) {
            ++i2;
        }
    }

    private static void adjustHolder(IResourceInfo rcInfo, IHoldsOptions holder) {
        IOption[] options = holder.getOptions();
        int i = 0;
        while (i < options.length) {
            Option option = (Option)options[i];
            BooleanExpressionApplicabilityCalculator calc = option.getBooleanExpressionCalculator(true);
            if (calc != null) {
                calc.adjustOption(rcInfo, holder, option, true);
            }
            ++i;
        }
    }

    private static void loadConfigElements(IManagedConfigElement[] elements, String revision) {
        int toolIndex = 0;
        while (toolIndex < elements.length) {
            try {
                IManagedConfigElement element = elements[toolIndex];
                if (element.getName().equals("projectType")) {
                    new ProjectType(element, revision);
                } else if (element.getName().equals("configuration")) {
                    new Configuration(null, element, revision);
                } else if (element.getName().equals("toolChain")) {
                    new ToolChain(null, element, revision);
                } else if (element.getName().equals("tool")) {
                    new Tool(null, element, revision);
                } else if (element.getName().equals("targetPlatform")) {
                    new TargetPlatform(null, element, revision);
                } else if (element.getName().equals("builder")) {
                    new Builder(null, element, revision);
                } else if (element.getName().equals("dynamicElementProvider")) {
                    if (element instanceof DefaultManagedConfigElement) {
                        IManagedConfigElementProvider provider = ManagedBuildManager.createConfigProvider((DefaultManagedConfigElement)element);
                        IManagedConfigElement[] providedConfigs = provider.getConfigElements();
                        ManagedBuildManager.loadConfigElements(providedConfigs, revision);
                    }
                } else if (element.getName().equals("buildDefinitionStartup") && element instanceof DefaultManagedConfigElement) {
                    if (startUpConfigElements == null) {
                        startUpConfigElements = new ArrayList();
                    }
                    startUpConfigElements.add(element);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++toolIndex;
        }
    }

    private static void loadConfigElementsV2(IManagedConfigElement[] elements, String revision) {
        int toolIndex = 0;
        while (toolIndex < elements.length) {
            try {
                IManagedConfigElement element = elements[toolIndex];
                if (element.getName().equals("tool")) {
                    new Tool(element, revision);
                } else if (element.getName().equals("target")) {
                    new Target(element, revision);
                } else if (element.getName().equals("dynamicElementProvider") && element instanceof DefaultManagedConfigElement) {
                    IManagedConfigElementProvider provider = ManagedBuildManager.createConfigProvider((DefaultManagedConfigElement)element);
                    IManagedConfigElement[] providedConfigs = provider.getConfigElements();
                    ManagedBuildManager.loadConfigElementsV2(providedConfigs, revision);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++toolIndex;
        }
    }

    public static ManagedBuildInfo createBuildInfo(IResource resource) {
        IProject proj = resource.getProject();
        ManagedBuildInfo buildInfo = new ManagedBuildInfo((IResource)proj);
        try {
            ManagedBuildManager.setLoaddedBuildInfo(proj, buildInfo);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
            buildInfo = null;
        }
        return buildInfo;
    }

    public static void setLoaddedBuildInfo(IProject project, IManagedBuildInfo info) throws CoreException {
        ManagedBuildManager.doSetLoaddedInfo(project, info, true);
    }

    private static synchronized void doSetLoaddedInfo(IProject project, IManagedBuildInfo info, boolean overwrite) {
        if (!overwrite && fInfoMap.get(project) != null) {
            return;
        }
        if (info != null) {
            fInfoMap.put(project, info);
            if (BuildDbgUtil.DEBUG) {
                BuildDbgUtil.getInstance().traceln(1, "build info load: build info set for project " + project.getName());
            }
        } else {
            fInfoMap.remove(project);
            if (BuildDbgUtil.DEBUG) {
                BuildDbgUtil.getInstance().traceln(1, "build info load: build info CLEARED for project " + project.getName());
            }
        }
    }

    private static IManagedConfigElementProvider createConfigProvider(DefaultManagedConfigElement element) throws CoreException {
        return (IManagedConfigElementProvider)element.getConfigurationElement().createExecutableExtension("class");
    }

    private static IManagedBuildDefinitionsStartup createStartUpConfigLoader(DefaultManagedConfigElement element) throws CoreException {
        return (IManagedBuildDefinitionsStartup)element.getConfigurationElement().createExecutableExtension("class");
    }

    public static boolean manages(IResource resource) {
        ICProjectDescription des = CoreModel.getDefault().getProjectDescription(resource.getProject(), false);
        if (des == null) {
            return false;
        }
        ICConfigurationDescription cfgDes = des.getActiveConfiguration();
        IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription(cfgDes);
        return cfg != null;
    }

    private static ManagedBuildInfo findBuildInfo(IResource rc, boolean forceLoad) {
        if (rc == null) {
            if (BuildDbgUtil.DEBUG) {
                BuildDbgUtil.getInstance().traceln(1, "build info load: null resource");
            }
            return null;
        }
        ManagedBuildInfo buildInfo = null;
        IProject proj = rc.getProject();
        if (buildInfo == null) {
            if (BuildDbgUtil.DEBUG) {
                BuildDbgUtil.getInstance().traceln(1, "build info load: info is null, querying the update mngr");
            }
            buildInfo = UpdateManagedProjectManager.getConvertedManagedBuildInfo(proj);
        }
        if (buildInfo != null) {
            return buildInfo;
        }
        try {
            buildInfo = ManagedBuildManager.getLoaddedBuildInfo(proj);
        }
        catch (CoreException e) {
            if (BuildDbgUtil.DEBUG) {
                BuildDbgUtil.getInstance().traceln(1, "build info load: core exception while getting the loaded info: " + e.getLocalizedMessage());
            }
            return null;
        }
        if (buildInfo == null) {
            ICProjectDescription projDes;
            int flags;
            int n = flags = forceLoad ? 0 : 8;
            if (BuildDbgUtil.DEBUG) {
                BuildDbgUtil.getInstance().traceln(1, "build info load: build info is NOT loadded" + (forceLoad ? " forceload" : ""));
            }
            if ((projDes = CoreModel.getDefault().getProjectDescriptionManager().getProjectDescription(proj, flags)) != null) {
                if (BuildDbgUtil.DEBUG) {
                    BuildDbgUtil.getInstance().traceln(1, "build info load: project description is obtained, qwerying the loaded build info");
                }
                try {
                    buildInfo = ManagedBuildManager.getLoaddedBuildInfo(proj);
                }
                catch (CoreException e) {
                    if (BuildDbgUtil.DEBUG) {
                        BuildDbgUtil.getInstance().traceln(1, "build info load: core exception while getting the loaded info (2): " + e.getLocalizedMessage());
                    }
                    return null;
                }
                if (buildInfo == null) {
                    if (BuildDbgUtil.DEBUG) {
                        BuildDbgUtil.getInstance().traceln(1, "build info load: info is null, trying the cfg data provider");
                    }
                    if ((buildInfo = ConfigurationDataProvider.getLoaddedBuildInfo(projDes)) != null) {
                        if (BuildDbgUtil.DEBUG) {
                            BuildDbgUtil.getInstance().traceln(1, "build info load: info found, setting as loadded");
                        }
                        try {
                            ManagedBuildManager.setLoaddedBuildInfo(proj, buildInfo);
                        }
                        catch (CoreException e) {
                            if (BuildDbgUtil.DEBUG) {
                                BuildDbgUtil.getInstance().traceln(1, "build info load: core exception while setting loaded description, ignoring; : " + e.getLocalizedMessage());
                            }
                        }
                    }
                }
            } else if (BuildDbgUtil.DEBUG) {
                BuildDbgUtil.getInstance().traceln(1, "build info load: project description in null");
            }
        }
        if (buildInfo != null) {
            buildInfo.updateOwner((IResource)proj);
        }
        if (BuildDbgUtil.DEBUG && buildInfo == null) {
            BuildDbgUtil.getInstance().traceln(1, "build info load: build info is null");
        }
        return buildInfo;
    }

    static synchronized ManagedBuildInfo getLoaddedBuildInfo(IProject project) throws CoreException {
        ManagedBuildInfo buildInfo = (ManagedBuildInfo)fInfoMap.get(project);
        if (buildInfo != null) {
            buildInfo.updateOwner((IResource)project);
        }
        return buildInfo;
    }

    private static boolean canFindBuildInfo(IResource resource) {
        if (resource == null) {
            return false;
        }
        try {
            ManagedBuildManager.loadExtensions();
        }
        catch (BuildException e) {
            e.printStackTrace();
            return false;
        }
        ManagedBuildInfo buildInfo = null;
        try {
            buildInfo = ManagedBuildManager.getLoaddedBuildInfo(resource.getProject());
        }
        catch (CoreException coreException) {}
        if (buildInfo == null && resource instanceof IProject) {
            buildInfo = UpdateManagedProjectManager.getConvertedManagedBuildInfo((IProject)resource);
            if (buildInfo != null) {
                return true;
            }
            return ManagedBuildManager.canLoadBuildInfo((IProject)resource);
        }
        return buildInfo != null;
    }

    public static IManagedBuildInfo getBuildInfo(IResource resource) {
        return ManagedBuildManager.getBuildInfo(resource, true);
    }

    public static IManagedBuildInfo getOldStyleBuildInfo(IProject project) throws CoreException {
        ManagedBuildInfo info = null;
        try {
            info = ManagedBuildManager.getLoaddedBuildInfo(project);
        }
        catch (CoreException coreException) {}
        if (info == null) {
            try {
                info = ManagedBuildManager.loadOldStyleBuildInfo(project);
                if (info != null) {
                    ManagedBuildManager.doSetLoaddedInfo(project, info, false);
                }
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e));
            }
        }
        return info;
    }

    public static synchronized IManagedBuildInfo getBuildInfoLegacy(IProject project) {
        try {
            return ManagedBuildManager.getOldStyleBuildInfo(project);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
            return null;
        }
    }

    public static IManagedBuildInfo getBuildInfo(IResource resource, boolean forceLoad) {
        return ManagedBuildManager.findBuildInfo((IResource)resource.getProject(), forceLoad);
    }

    public static boolean canGetBuildInfo(IResource resource) {
        return ManagedBuildManager.canFindBuildInfo((IResource)resource.getProject());
    }

    public static PluginVersionIdentifier getBuildInfoVersion() {
        return buildInfoVersion;
    }

    public static URL getURLInBuildDefinitions(DefaultManagedConfigElement element, IPath path) {
        IExtension[] extensions;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null) {
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                if (element.getExtension().getExtensionPointUniqueIdentifier() == extension.getExtensionPointUniqueIdentifier()) {
                    Bundle bundle = Platform.getBundle((String)extension.getNamespace());
                    URL url = Platform.find((Bundle)bundle, (IPath)path);
                    if (url != null) {
                        try {
                            return Platform.asLocalURL((URL)url);
                        }
                        catch (IOException iOException) {
                            return null;
                        }
                    }
                    ManagedBuildManager.OutputIconError(path.toString());
                }
                ++i;
            }
        }
        return null;
    }

    private static Map getBuildModelListeners() {
        if (buildModelListeners == null) {
            buildModelListeners = new HashMap();
        }
        return buildModelListeners;
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        return (IScannerInfo)ManagedBuildManager.getBuildInfo((IResource)resource.getProject());
    }

    public synchronized void subscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        ArrayList<IScannerInfoChangeListener> list = (ArrayList<IScannerInfoChangeListener>)map.get(project);
        if (list == null) {
            list = new ArrayList<IScannerInfoChangeListener>();
        }
        if (!list.contains(listener)) {
            list.add(listener);
            map.put(project, list);
        }
    }

    public synchronized void unsubscribe(IResource resource, IScannerInfoChangeListener listener) {
        IResource project = null;
        if (resource instanceof IProject) {
            project = resource;
        } else if (resource instanceof IFile) {
            project = ((IFile)resource).getProject();
        } else {
            return;
        }
        Map map = ManagedBuildManager.getBuildModelListeners();
        List list = (List)map.get(project);
        if (list != null && !list.isEmpty()) {
            list.remove(listener);
            map.put(project, list);
        }
    }

    private static Map getConfigElementMap() {
        if (configElementMap == null) {
            configElementMap = new HashMap();
        }
        return configElementMap;
    }

    public static void putConfigElement(IBuildObject buildObj, IManagedConfigElement configElement) {
        ManagedBuildManager.getConfigElementMap().put(buildObj, configElement);
    }

    private static void removeConfigElement(IBuildObject buildObj) {
        ManagedBuildManager.getConfigElementMap().remove(buildObj);
    }

    public static IManagedConfigElement getConfigElement(IBuildObject buildObj) {
        return (IManagedConfigElement)ManagedBuildManager.getConfigElementMap().get(buildObj);
    }

    public static void OptionValidError(int errorId, String id) {
        String[] msgs = new String[]{id};
        switch (errorId) {
            case 0: {
                ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_OPTION_CATEGORY, msgs));
                break;
            }
            case 1: {
                ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_OPTION_FILTER, msgs));
            }
        }
    }

    public static void OptionValueHandlerError(String attribute, String id) {
        String[] msgs = new String[]{attribute, id};
        ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_OPTION_VALUEHANDLER, msgs));
    }

    public static void OutputResolveError(String attribute, String lookupId, String type, String id) {
        String[] msgs = new String[]{attribute, lookupId, type, id};
        ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_RESOLVING, msgs));
    }

    public static void OutputDuplicateIdError(String type, String id) {
        String[] msgs = new String[]{type, id};
        ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_DUPLICATE, msgs));
    }

    public static void OutputManifestError(String message) {
        System.err.println(String.valueOf(ManagedMakeMessages.getResourceString(MANIFEST_ERROR_HEADER)) + message + NEWLINE);
    }

    public static void OutputIconError(String iconLocation) {
        String[] msgs = new String[]{iconLocation};
        ManagedBuildManager.OutputManifestError(ManagedMakeMessages.getFormattedString(MANIFEST_ERROR_ICON, msgs));
    }

    public static IEnvironmentVariableProvider getEnvironmentVariableProvider() {
        return EnvironmentVariableProvider.getDefault();
    }

    public static String getVersionFromIdAndVersion(String idAndVersion) {
        String version;
        IStatus status;
        int index = idAndVersion.lastIndexOf(95);
        if (index != -1 && (status = PluginVersionIdentifier.validateVersion((String)(version = idAndVersion.substring(index + 1)))).isOK()) {
            return version;
        }
        return null;
    }

    public static String getIdFromIdAndVersion(String idAndVersion) {
        if (ManagedBuildManager.getVersionFromIdAndVersion(idAndVersion) != null) {
            int index = idAndVersion.lastIndexOf(95);
            return idAndVersion.substring(0, index);
        }
        return idAndVersion;
    }

    public static IBuildMacroProvider getBuildMacroProvider() {
        return BuildMacroProvider.getDefault();
    }

    public static void performValueHandlerEvent(IConfiguration config, int event) {
        ManagedBuildManager.performValueHandlerEvent(config, event, true);
    }

    public static void performValueHandlerEvent(IConfiguration config, int event, boolean doChildren) {
        IToolChain toolChain = config.getToolChain();
        if (toolChain == null) {
            return;
        }
        IOption[] options = toolChain.getOptions();
        int i = 0;
        while (i < options.length) {
            if (options[i].isValid()) {
                options[i].getValueHandler().handleValue(config, toolChain, options[i], options[i].getValueHandlerExtraArgument(), event);
            }
            ++i;
        }
        ITool[] tools = config.getFilteredTools();
        int i2 = 0;
        while (i2 < tools.length) {
            IOption[] toolOptions = tools[i2].getOptions();
            int j = 0;
            while (j < toolOptions.length) {
                if (toolOptions[j].isValid()) {
                    toolOptions[j].getValueHandler().handleValue(config, tools[i2], toolOptions[j], toolOptions[j].getValueHandlerExtraArgument(), event);
                }
                ++j;
            }
            ++i2;
        }
        if (doChildren) {
            IResourceConfiguration[] resConfigs = config.getResourceConfigurations();
            int j = 0;
            while (j < resConfigs.length) {
                ManagedBuildManager.performValueHandlerEvent(resConfigs[j], event);
                ++j;
            }
        }
    }

    public static void performValueHandlerEvent(IResourceInfo config, int event) {
        ITool[] tools = config instanceof IFileInfo ? ((IFileInfo)config).getToolsToInvoke() : ((IFolderInfo)config).getFilteredTools();
        int i = 0;
        while (i < tools.length) {
            IOption[] toolOptions = tools[i].getOptions();
            int j = 0;
            while (j < toolOptions.length) {
                if (toolOptions[j].isValid()) {
                    toolOptions[j].getValueHandler().handleValue(config, tools[i], toolOptions[j], toolOptions[j].getValueHandlerExtraArgument(), event);
                }
                ++j;
            }
            ++i;
        }
    }

    private static boolean checkForMigrationSupport(ManagedBuildInfo buildInfo, boolean forCurrentMbsVersion) {
        IConfigurationElement element = null;
        IManagedProject managedProject = buildInfo.getManagedProject();
        IProjectType projectType = managedProject.getProjectType();
        element = forCurrentMbsVersion ? ((ProjectType)projectType).getCurrentMbsVersionConversionElement() : ((ProjectType)projectType).getPreviousMbsVersionConversionElement();
        if (element != null) {
            if (ManagedBuildManager.invokeConverter(managedProject, element) == null) {
                buildInfo.getManagedProject().setValid(false);
                return false;
            }
        } else {
            IConfiguration[] configs = managedProject.getConfigurations();
            int i = 0;
            while (i < configs.length) {
                IResourceConfiguration[] resourceConfigs;
                IConfiguration configuration = configs[i];
                IToolChain toolChain = configuration.getToolChain();
                element = forCurrentMbsVersion ? ((ToolChain)toolChain).getCurrentMbsVersionConversionElement() : ((ToolChain)toolChain).getPreviousMbsVersionConversionElement();
                if (element != null) {
                    if (ManagedBuildManager.invokeConverter(toolChain, element) == null) {
                        buildInfo.getManagedProject().setValid(false);
                        return false;
                    }
                } else {
                    ITool[] tools = toolChain.getTools();
                    int j = 0;
                    while (j < tools.length) {
                        ITool tool = tools[j];
                        element = forCurrentMbsVersion ? ((Tool)tool).getCurrentMbsVersionConversionElement() : ((Tool)tool).getPreviousMbsVersionConversionElement();
                        if (element != null && ManagedBuildManager.invokeConverter(tool, element) == null) {
                            buildInfo.getManagedProject().setValid(false);
                            return false;
                        }
                        ++j;
                    }
                    IBuilder builder = toolChain.getBuilder();
                    if (builder != null && (element = forCurrentMbsVersion ? ((Builder)builder).getCurrentMbsVersionConversionElement() : ((Builder)builder).getPreviousMbsVersionConversionElement()) != null && ManagedBuildManager.invokeConverter(builder, element) == null) {
                        buildInfo.getManagedProject().setValid(false);
                        return false;
                    }
                }
                if ((resourceConfigs = configuration.getResourceConfigurations()) != null && resourceConfigs.length > 0) {
                    int j = 0;
                    while (j < resourceConfigs.length) {
                        IResourceConfiguration resConfig = resourceConfigs[j];
                        ITool[] resTools = resConfig.getTools();
                        int k = 0;
                        while (k < resTools.length) {
                            ITool resTool = resTools[k];
                            element = forCurrentMbsVersion ? ((Tool)resTool).getCurrentMbsVersionConversionElement() : ((Tool)resTool).getPreviousMbsVersionConversionElement();
                            if (element != null && ManagedBuildManager.invokeConverter(resTool, element) == null) {
                                buildInfo.getManagedProject().setValid(false);
                                return false;
                            }
                            ++k;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    private static IBuildObject invokeConverter(IBuildObject buildObject, IConfigurationElement element) {
        if (element != null) {
            IConvertManagedBuildObject convertBuildObject = null;
            String toId = element.getAttribute("toId");
            String fromId = element.getAttribute("fromId");
            try {
                convertBuildObject = (IConvertManagedBuildObject)element.createExecutableExtension("class");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (convertBuildObject != null) {
                return convertBuildObject.convert(buildObject, fromId, toId, false);
            }
        }
        return null;
    }

    public static IBuildObject convert(IBuildObject buildObj, String toId, boolean userhasConfirmed) {
        String tmpToId = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter") && ManagedBuildManager.isBuildObjectApplicableForConversion(buildObj, element) && (tmpToId = element.getAttribute("toId")).equals(toId)) {
                        return ManagedBuildManager.invokeConverter(buildObj, element);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean hasTargetConversionElements(IBuildObject buildObj) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter") && ManagedBuildManager.isBuildObjectApplicableForConversion(buildObj, element)) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return false;
    }

    public static Map getConversionElements(IBuildObject buildObj) {
        HashMap<String, IConfigurationElement> conversionTargets = new HashMap<String, IConfigurationElement>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.managedbuilder.core", "projectConverter");
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement element = configElements[j];
                    if (element.getName().equals("converter") && ManagedBuildManager.isBuildObjectApplicableForConversion(buildObj, element)) {
                        conversionTargets.put(element.getAttribute("name"), element);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return conversionTargets;
    }

    private static boolean isBuildObjectApplicableForConversion(IBuildObject buildObj, IConfigurationElement element) {
        block9: {
            String fromId;
            String id;
            block11: {
                block10: {
                    block8: {
                        id = null;
                        fromId = element.getAttribute("fromId");
                        if (!(buildObj instanceof IProjectType)) break block8;
                        IProjectType projType = (IProjectType)buildObj;
                        while (projType != null) {
                            id = projType.getId();
                            if (fromId.equals(id)) {
                                return true;
                            }
                            projType = projType.getSuperClass();
                        }
                        break block9;
                    }
                    if (!(buildObj instanceof IToolChain)) break block10;
                    IToolChain toolChain = (IToolChain)buildObj;
                    while (toolChain != null) {
                        id = toolChain.getId();
                        if (fromId.equals(id)) {
                            return true;
                        }
                        toolChain = toolChain.getSuperClass();
                    }
                    break block9;
                }
                if (!(buildObj instanceof ITool)) break block11;
                ITool tool = (ITool)buildObj;
                while (tool != null) {
                    id = tool.getId();
                    if (fromId.equals(id)) {
                        return true;
                    }
                    tool = tool.getSuperClass();
                }
                break block9;
            }
            if (!(buildObj instanceof IBuilder)) break block9;
            IBuilder builder = (IBuilder)buildObj;
            while (builder != null) {
                id = builder.getId();
                if (fromId.equals(id)) {
                    return true;
                }
                builder = builder.getSuperClass();
            }
        }
        return false;
    }

    public static String calculateChildId(String superId, String suffix) {
        String version;
        if (suffix == null) {
            suffix = new Integer(ManagedBuildManager.getRandomNumber()).toString();
        }
        if ((version = ManagedBuildManager.getVersionFromIdAndVersion(superId)) != null) {
            return String.valueOf(ManagedBuildManager.getIdFromIdAndVersion(superId)) + "." + suffix + "_" + version;
        }
        return String.valueOf(superId) + "." + suffix;
    }

    public static IPath calculateRelativePath(IPath container, IPath contents) {
        IPath path = contents;
        if (container.isPrefixOf(contents)) {
            path = contents.setDevice(null).removeFirstSegments(container.segmentCount());
        } else {
            String file = null;
            container = container.addTrailingSeparator();
            if (!contents.hasTrailingSeparator()) {
                file = contents.lastSegment();
                contents = contents.removeLastSegments(1);
                contents = contents.addTrailingSeparator();
            }
            IPath prefix = contents;
            while (prefix.segmentCount() > 0 && !prefix.isPrefixOf(container)) {
                prefix = prefix.removeLastSegments(1);
            }
            if (prefix.segmentCount() > 0) {
                int diff = container.segmentCount() - prefix.segmentCount();
                StringBuffer buff = new StringBuffer();
                while (diff-- > 0) {
                    buff.append("../");
                }
                path = new Path(buff.toString()).append(contents.removeFirstSegments(prefix.segmentCount()));
                if (file != null) {
                    path = path.append(file);
                }
            }
        }
        return path;
    }

    public static IConfiguration getConfigurationForDescription(ICConfigurationDescription cfgDes) {
        return ManagedBuildManager.getConfigurationForDescription(cfgDes, false);
    }

    private static IConfiguration getConfigurationForDescription(ICConfigurationDescription cfgDes, boolean checkConsistance) {
        if (cfgDes == null) {
            return null;
        }
        CConfigurationData cfgData = cfgDes.getConfigurationData();
        if (cfgData instanceof BuildConfigurationData) {
            IConfiguration cfg = ((BuildConfigurationData)cfgData).getConfiguration();
            if (checkConsistance && cfgDes != ManagedBuildManager.getDescriptionForConfiguration(cfg, false)) {
                throw new IllegalStateException();
            }
            return cfg;
        }
        return null;
    }

    public static int optionTypeToEntryKind(int type) {
        switch (type) {
            case 4: {
                return 1;
            }
            case 5: {
                return 4;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 16;
            }
            case 10: {
                return 32;
            }
            case 11: {
                return 8;
            }
        }
        return 0;
    }

    public static int optionUndefTypeToEntryKind(int type) {
        switch (type) {
            case -4: {
                return 1;
            }
            case -5: {
                return 4;
            }
            case -8: {
                return 2;
            }
            case -9: {
                return 16;
            }
            case -10: {
                return 32;
            }
            case -11: {
                return 8;
            }
        }
        return 0;
    }

    public static int entryKindToOptionType(int kind) {
        switch (kind) {
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 4: {
                return 5;
            }
            case 8: {
                return 11;
            }
            case 16: {
                return 9;
            }
            case 32: {
                return 10;
            }
        }
        return 0;
    }

    public static int entryKindToUndefOptionType(int kind) {
        switch (kind) {
            case 1: {
                return -4;
            }
            case 2: {
                return -8;
            }
            case 4: {
                return -5;
            }
            case 8: {
                return -11;
            }
            case 16: {
                return -9;
            }
            case 32: {
                return -10;
            }
        }
        return 0;
    }

    public static ICConfigurationDescription getDescriptionForConfiguration(IConfiguration cfg) {
        return ManagedBuildManager.getDescriptionForConfiguration(cfg, false);
    }

    private static ICConfigurationDescription getDescriptionForConfiguration(IConfiguration cfg, boolean checkConsistance) {
        if (cfg.isExtensionElement()) {
            return null;
        }
        ICConfigurationDescription des = ((Configuration)cfg).getConfigurationDescription();
        if (des == null) {
            if (checkConsistance) {
                throw new IllegalStateException();
            }
            if (((Configuration)cfg).isPreference()) {
                try {
                    des = CCorePlugin.getDefault().getPreferenceConfiguration(CFG_DATA_PROVIDER_ID);
                }
                catch (CoreException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
            } else {
                IProject project = cfg.getOwner().getProject();
                ICProjectDescription projDes = CoreModel.getDefault().getProjectDescription(project, false);
                if (projDes != null) {
                    des = projDes.getConfigurationById(cfg.getId());
                }
            }
        }
        if (checkConsistance && cfg != ManagedBuildManager.getConfigurationForDescription(des, false)) {
            throw new IllegalStateException();
        }
        return des;
    }

    public static IPath getBuildFullPath(IConfiguration cfg, IBuilder builder) {
        IProject project = cfg.getOwner().getProject();
        IPath buildDirectory = builder.getBuildLocation();
        IPath fullPath = null;
        if (buildDirectory != null && !buildDirectory.isEmpty()) {
            IResource res = project.getParent().findMember(buildDirectory);
            if (res instanceof IContainer && res.exists()) {
                fullPath = res.getFullPath();
            } else {
                IContainer[] crs = ((IWorkspaceRoot)project.getParent()).findContainersForLocation(buildDirectory);
                if (crs.length != 0) {
                    String projName = project.getName();
                    int i = 0;
                    while (i < crs.length) {
                        IPath path = crs[i].getFullPath();
                        if (path.segmentCount() != 0 && path.segment(0).equals(projName)) {
                            fullPath = path;
                            break;
                        }
                        ++i;
                    }
                    if (fullPath == null) {
                        fullPath = crs[0].getFullPath();
                    }
                }
            }
        } else {
            fullPath = cfg.getOwner().getProject().getFullPath();
            if (builder.isManagedBuildOn()) {
                fullPath = fullPath.append(cfg.getName());
            }
        }
        return fullPath;
    }

    public static String locationToFullPath(String path) {
        if (!path.startsWith("${")) {
            return null;
        }
        int index = path.lastIndexOf(125);
        if (index == -1) {
            return null;
        }
        String varName = "workspace_loc";
        String str1 = path.substring(2, index);
        String result = null;
        if (str1.startsWith(varName)) {
            if ((str1 = str1.substring(varName.length())).length() != 0) {
                if (str1.startsWith(":")) {
                    result = str1.substring(1);
                }
            } else {
                result = "/";
            }
        }
        return result;
    }

    public static String fullPathToLocation(String path) {
        StringBuffer buf = new StringBuffer();
        return buf.append("${").append("workspace_loc:").append(path).append("}").toString();
    }

    public static IPath getBuildLocation(IConfiguration cfg, IBuilder builder) {
        if (cfg.getOwner() == null) {
            return Path.EMPTY;
        }
        IProject project = cfg.getOwner().getProject();
        IPath buildDirectory = builder.getBuildLocation();
        if (buildDirectory != null && !buildDirectory.isEmpty()) {
            IResource res = project.getParent().findMember(buildDirectory);
            if (res instanceof IContainer && res.exists()) {
                buildDirectory = res.getLocation();
            }
        } else {
            buildDirectory = project.getLocation();
            if (builder.isManagedBuildOn()) {
                buildDirectory = buildDirectory.append(cfg.getName());
            }
        }
        return buildDirectory;
    }

    public static IBuilder[] createBuilders(IProject project, Map args) {
        return ManagedBuilderCorePlugin.createBuilders(project, args);
    }

    public static IBuilder createCustomBuilder(IConfiguration cfg, String builderId) throws CoreException {
        return ManagedBuilderCorePlugin.createCustomBuilder(cfg, builderId);
    }

    public static IBuilder createCustomBuilder(IConfiguration cfg, IBuilder base) {
        return ManagedBuilderCorePlugin.createCustomBuilder(cfg, base);
    }

    public static IBuilder createBuilderForEclipseBuilder(IConfiguration cfg, String eclipseBuilderID) throws CoreException {
        return ManagedBuilderCorePlugin.createBuilderForEclipseBuilder(cfg, eclipseBuilderID);
    }

    public static IToolChain[] getExtensionToolChains(IProjectType type) {
        ArrayList<IToolChain> result = new ArrayList<IToolChain>();
        IConfiguration[] cfgs = type.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            IToolChain tc = cfgs[i].getToolChain();
            if (tc != null) {
                List list = ManagedBuildManager.findIdenticalElements((ToolChain)tc, fToolChainSorter);
                int k = 0;
                while (k < result.size()) {
                    if (ManagedBuildManager.findIdenticalElements((ToolChain)result.get(k), fToolChainSorter) == list) break;
                    ++k;
                }
                if (k == result.size()) {
                    result.add(tc);
                }
            }
            ++i;
        }
        return result.toArray(new IToolChain[result.size()]);
    }

    public static IConfiguration[] getExtensionConfigurations(IToolChain tChain, IProjectType type) {
        ArrayList<IConfiguration> list = new ArrayList<IConfiguration>();
        IConfiguration[] cfgs = type.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            IToolChain cur = cfgs[i].getToolChain();
            if (cur != null && ManagedBuildManager.findIdenticalElements((ToolChain)cur, fToolChainSorter) == ManagedBuildManager.findIdenticalElements((ToolChain)tChain, fToolChainSorter)) {
                list.add(cfgs[i]);
            }
            ++i;
        }
        return list.toArray(new Configuration[list.size()]);
    }

    public static IConfiguration getFirstExtensionConfiguration(IToolChain tChain) {
        if (tChain.getParent() != null) {
            return tChain.getParent();
        }
        List list = ManagedBuildManager.findIdenticalElements((ToolChain)tChain, fToolChainSorter);
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                ToolChain cur = (ToolChain)list.get(i);
                if (cur.getParent() != null) {
                    return cur.getParent();
                }
                ++i;
            }
        }
        return null;
    }

    public static IConfiguration[] getExtensionConfigurations(IToolChain tChain, String propertyType, String propertyValue) {
        IBuildObjectProperties props;
        IConfiguration cfg;
        List list = ManagedBuildManager.findIdenticalElements((ToolChain)tChain, fToolChainSorter);
        LinkedHashSet<IConfiguration> result = new LinkedHashSet<IConfiguration>();
        boolean tcFound = false;
        if (list != null) {
            int i = 0;
            while (i < list.size()) {
                IBuildObjectProperties props2;
                IConfiguration cfg2;
                ToolChain cur = (ToolChain)list.get(i);
                if (cur == tChain) {
                    tcFound = true;
                }
                if ((cfg2 = cur.getParent()) != null && (props2 = cfg2.getBuildProperties()).containsValue(propertyType, propertyValue)) {
                    result.add(cfg2);
                }
                ++i;
            }
        }
        if (!tcFound && (cfg = tChain.getParent()) != null && (props = cfg.getBuildProperties()).containsValue(propertyType, propertyValue)) {
            result.add(cfg);
        }
        return result.toArray(new IConfiguration[result.size()]);
    }

    private static HashMap getSortedToolChains() {
        if (fSortedToolChains == null) {
            fSortedToolChains = ManagedBuildManager.getSortedElements(ManagedBuildManager.getExtensionToolChainMap().values());
        }
        return fSortedToolChains;
    }

    private static HashMap getSortedTools() {
        if (fSortedTools == null) {
            fSortedTools = ManagedBuildManager.getSortedElements(ManagedBuildManager.getExtensionToolMap().values());
        }
        return fSortedTools;
    }

    private static HashMap getSortedBuilders() {
        if (fSortedBuilders == null) {
            fSortedBuilders = ManagedBuildManager.getSortedElements(ManagedBuildManager.getExtensionBuilderMap().values());
        }
        return fSortedBuilders;
    }

    private static HashMap getSortedElements(Collection elements) {
        HashMap<Object, ArrayList<IMatchKeyProvider>> map = new HashMap<Object, ArrayList<IMatchKeyProvider>>();
        Iterator<Object> iter = elements.iterator();
        while (iter.hasNext()) {
            IMatchKeyProvider p = (IMatchKeyProvider)iter.next();
            Object key = p.getMatchKey();
            if (key == null) continue;
            ArrayList<IMatchKeyProvider> list = (ArrayList<IMatchKeyProvider>)map.get(key);
            if (list == null) {
                list = new ArrayList<IMatchKeyProvider>();
                map.put(key, list);
            }
            list.add(p);
            p.setIdenticalList(list);
        }
        iter = map.values().iterator();
        while (iter.hasNext()) {
            Collections.sort((List)iter.next());
        }
        return map;
    }

    public static IToolChain[] getRealToolChains() {
        HashMap map = ManagedBuildManager.getSortedToolChains();
        IToolChain[] tcs = new ToolChain[map.size()];
        int i = 0;
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            tcs[i++] = (ToolChain)list.get(0);
        }
        return tcs;
    }

    public static ITool[] getRealTools() {
        HashMap map = ManagedBuildManager.getSortedTools();
        ITool[] ts = new Tool[map.size()];
        int i = 0;
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            ts[i++] = (Tool)list.get(0);
        }
        return ts;
    }

    public static IBuilder[] getRealBuilders() {
        HashMap map = ManagedBuildManager.getSortedBuilders();
        IBuilder[] bs = new Builder[map.size()];
        int i = 0;
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            bs[i++] = (Builder)list.get(0);
        }
        return bs;
    }

    public static IBuilder getRealBuilder(IBuilder builder) {
        IBuilder extBuilder = builder;
        IBuilder realBuilder = null;
        while (extBuilder != null && !extBuilder.isExtensionElement()) {
            extBuilder = extBuilder.getSuperClass();
        }
        if (extBuilder != null) {
            List list = ManagedBuildManager.findIdenticalElements((Builder)extBuilder, fBuilderSorter);
            if (list.size() == 0) {
                realBuilder = extBuilder;
            } else {
                IBuilder[] realBs = ManagedBuildManager.getRealBuilders();
                int i = 0;
                while (i < realBs.length) {
                    List rList = ManagedBuildManager.findIdenticalElements((Builder)realBs[i], fBuilderSorter);
                    if (rList == list) {
                        realBuilder = realBs[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        return realBuilder;
    }

    public static ITool getRealTool(ITool tool) {
        ITool extTool = tool;
        ITool realTool = null;
        while (extTool != null && !extTool.isExtensionElement()) {
            extTool = extTool.getSuperClass();
        }
        if (extTool != null) {
            List list = ManagedBuildManager.findIdenticalElements((Tool)extTool, fToolSorter);
            if (list.size() == 0) {
                realTool = extTool;
            } else {
                ITool[] realTs = ManagedBuildManager.getRealTools();
                int i = 0;
                while (i < realTs.length) {
                    List rList = ManagedBuildManager.findIdenticalElements((Tool)realTs[i], fToolSorter);
                    if (rList == list) {
                        realTool = realTs[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        return realTool;
    }

    public static IToolChain getExtensionToolChain(IToolChain tc) {
        IToolChain extTc = tc;
        while (extTc != null && !extTc.isExtensionElement()) {
            extTc = extTc.getSuperClass();
        }
        return extTc;
    }

    public static IToolChain getRealToolChain(IToolChain tc) {
        IToolChain extTc = tc;
        IToolChain realTc = null;
        while (extTc != null && !extTc.isExtensionElement()) {
            extTc = extTc.getSuperClass();
        }
        if (extTc != null) {
            List list = ManagedBuildManager.findIdenticalElements((ToolChain)extTc, fToolChainSorter);
            if (list.size() == 0) {
                realTc = extTc;
            } else {
                IToolChain[] realTcs = ManagedBuildManager.getRealToolChains();
                int i = 0;
                while (i < realTcs.length) {
                    List rList = ManagedBuildManager.findIdenticalElements((ToolChain)realTcs[i], fToolChainSorter);
                    if (rList == list) {
                        realTc = realTcs[i];
                        break;
                    }
                    ++i;
                }
            }
        }
        return realTc;
    }

    public static IToolChain[] findIdenticalToolChains(IToolChain tc) {
        List list = ManagedBuildManager.findIdenticalElements((ToolChain)tc, fToolChainSorter);
        return list.toArray(new ToolChain[list.size()]);
    }

    public static ITool[] findIdenticalTools(ITool tool) {
        List list = ManagedBuildManager.findIdenticalElements((Tool)tool, fToolSorter);
        return list.toArray(new Tool[list.size()]);
    }

    public static IBuilder[] findIdenticalBuilders(IBuilder b) {
        List list = ManagedBuildManager.findIdenticalElements((Builder)b, fBuilderSorter);
        return list.toArray(new Builder[list.size()]);
    }

    public static IToolChain[] getExtensionsToolChains(String propertyType, String propertyValue) {
        return ManagedBuildManager.getExtensionsToolChains(propertyType, propertyValue, true);
    }

    public static IToolChain[] getExtensionsToolChains(String propertyType, String propertyValue, boolean supportedPropsOnly) {
        HashMap all = ManagedBuildManager.getSortedToolChains();
        ArrayList<IToolChain> result = new ArrayList<IToolChain>();
        Iterator iter = all.values().iterator();
        while (iter.hasNext()) {
            List list = (List)iter.next();
            IToolChain tc = ManagedBuildManager.findToolChain(list, propertyType, propertyValue, supportedPropsOnly);
            if (tc == null) continue;
            result.add(tc);
        }
        return result.toArray(new ToolChain[result.size()]);
    }

    public static void resortToolChains() {
        fSortedToolChains = null;
        ManagedBuildManager.getSortedToolChains();
    }

    public static void resortTools() {
        fSortedTools = null;
        ManagedBuildManager.getSortedTools();
    }

    public static void resortBuilders() {
        fSortedBuilders = null;
        ManagedBuildManager.getSortedBuilders();
    }

    private static IToolChain findToolChain(List list, String propertyType, String propertyValue, boolean supportedOnly) {
        ToolChain bestMatch = null;
        IConfiguration cfg = null;
        IProjectType type = null;
        boolean valueSupported = false;
        int i = 0;
        while (i < list.size()) {
            block16: {
                IConfiguration tcCfg;
                ToolChain tc;
                block15: {
                    block14: {
                        tc = (ToolChain)list.get(i);
                        if (!tc.supportsValue(propertyType, propertyValue)) break block14;
                        valueSupported = true;
                        break block15;
                    }
                    if (valueSupported) break block16;
                }
                if (!tc.supportsBuild(true)) {
                    return null;
                }
                if (bestMatch == null && valueSupported) {
                    bestMatch = tc;
                }
                if ((tcCfg = tc.getParent()) != null) {
                    IProjectType tcType;
                    if (cfg == null && valueSupported) {
                        bestMatch = tc;
                        cfg = tcCfg;
                    }
                    IBuildObjectProperties props = tcCfg.getBuildProperties();
                    IBuildProperty prop = props.getProperty(propertyType);
                    if (valueSupported && prop != null && propertyValue.equals(prop.getValue().getId())) {
                        bestMatch = tc;
                        cfg = tcCfg;
                    }
                    if ((tcType = tcCfg.getProjectType()) != null) {
                        if (type == null && valueSupported) {
                            type = tcType;
                            bestMatch = tc;
                        }
                        if ((prop = (props = tcType.getBuildProperties()).getProperty(propertyType)) != null && propertyValue.equals(prop.getValue().getId())) {
                            bestMatch = tc;
                            if (valueSupported) {
                                type = tcType;
                                break;
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (valueSupported || !supportedOnly) {
            return bestMatch;
        }
        return null;
    }

    private static List findIdenticalElements(IMatchKeyProvider p, ISorter sorter) {
        ArrayList list = p.getIdenticalList();
        if (list == null) {
            sorter.sort();
            list = p.getIdenticalList();
            if (list == null) {
                list = new ArrayList(0);
                p.setIdenticalList(list);
            }
        }
        return list;
    }

    public static IBuildPropertyManager getBuildPropertyManager() {
        return BuildPropertyManager.getInstance();
    }

    public static IConfiguration[] getReferencedConfigurations(IConfiguration config) {
        ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(config);
        if (cfgDes != null) {
            ICConfigurationDescription[] descs = CoreModelUtil.getReferencedConfigurationDescriptions((ICConfigurationDescription)cfgDes, (boolean)false);
            ArrayList<IConfiguration> result = new ArrayList<IConfiguration>();
            int i = 0;
            while (i < descs.length) {
                IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription(descs[i]);
                if (cfg != null) {
                    result.add(cfg);
                }
                ++i;
            }
            return result.toArray(new IConfiguration[result.size()]);
        }
        return new Configuration[0];
    }

    public static void buildConfigurations(IConfiguration[] configs, IProgressMonitor monitor) throws CoreException {
        ManagedBuildManager.buildConfigurations(configs, null, monitor);
    }

    public static void buildConfigurations(IConfiguration[] configs, IBuilder builder, IProgressMonitor monitor) throws CoreException {
        Map map = ManagedBuildManager.sortConfigs(configs);
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IProject proj = (IProject)entry.getKey();
            IConfiguration[] cfgs = (IConfiguration[])entry.getValue();
            ManagedBuildManager.buildConfigurations(proj, cfgs, builder, monitor);
        }
    }

    private static Map sortConfigs(IConfiguration[] cfgs) {
        HashMap<IProject, HashSet<IConfiguration>> cfgMap = new HashMap<IProject, HashSet<IConfiguration>>();
        int i = 0;
        while (i < cfgs.length) {
            IConfiguration cfg = cfgs[i];
            IProject proj = cfg.getOwner().getProject();
            HashSet<IConfiguration> set = (HashSet<IConfiguration>)cfgMap.get(proj);
            if (set == null) {
                set = new HashSet<IConfiguration>();
                cfgMap.put(proj, set);
            }
            set.add(cfg);
            ++i;
        }
        if (cfgMap.size() != 0) {
            Iterator iter = cfgMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Set set = (Set)entry.getValue();
                entry.setValue(set.toArray(new Configuration[set.size()]));
            }
        }
        return cfgMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void buildConfigurations(final IProject project, IConfiguration[] configs, IBuilder builder, IProgressMonitor monitor) throws CoreException {
        final Map map = builder != null ? BuilderFactory.createBuildArgs(configs, builder) : BuilderFactory.createBuildArgs(configs);
        IWorkspaceRunnable op = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                project.build(6, CommonBuilder.BUILDER_ID, map, monitor);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(op, monitor);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        monitor.done();
    }

    public static IBuilder getInternalBuilder() {
        return ManagedBuildManager.getExtensionBuilder(INTERNAL_BUILDER_ID);
    }

    public static ITool getExtensionTool(ITool tool) {
        ITool extTool = tool;
        while (extTool != null && !extTool.isExtensionElement()) {
            extTool = extTool.getSuperClass();
        }
        return extTool;
    }

    public static IInputType getExtensionInputType(IInputType inType) {
        IInputType extIT = inType;
        while (extIT != null && !extIT.isExtensionElement()) {
            extIT = extIT.getSuperClass();
        }
        return extIT;
    }

    public static IConfiguration getPreferenceConfiguration(boolean write) {
        try {
            ICConfigurationDescription des = CCorePlugin.getDefault().getPreferenceConfiguration(CFG_DATA_PROVIDER_ID, write);
            if (des != null) {
                return ManagedBuildManager.getConfigurationForDescription(des);
            }
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
        }
        return null;
    }

    public static void setPreferenceConfiguration(IConfiguration cfg) throws CoreException {
        ICConfigurationDescription des = ManagedBuildManager.getDescriptionForConfiguration(cfg);
        if (des != null) {
            CCorePlugin.getDefault().setPreferenceConfiguration(CFG_DATA_PROVIDER_ID, des);
        }
    }

    static synchronized void updateLoaddedInfo(IProject fromProject, IProject toProject, IManagedBuildInfo info) {
        try {
            ManagedBuildManager.setLoaddedBuildInfo(fromProject, null);
            ManagedBuildManager.setLoaddedBuildInfo(toProject, info);
        }
        catch (CoreException coreException) {}
    }

    private static interface ISorter {
        public void sort();
    }
}

