/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.managedbuilder.buildmodel.BuildDescriptionManager;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildDescription;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildIOType;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildResource;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildStep;
import org.eclipse.cdt.managedbuilder.buildmodel.IStepVisitor;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedOutputNameProvider;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildGroup;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildIOType;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildResource;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.BuildStep;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IConfigurationBuildState;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedBuilderMakefileGenerator2;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyCalculator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyCommands;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGenerator2;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyGeneratorType;
import org.eclipse.cdt.managedbuilder.makegen.IManagedDependencyInfo;
import org.eclipse.cdt.managedbuilder.pdomdepgen.PDOMDependencyGenerator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class BuildDescription
implements IBuildDescription {
    private static final String DOT = ".";
    private static final String WILDCARD = "%";
    private static final String VAR_USER_OBJS = "USER_OBJS";
    private static final String VAR_LIBS = "LIBS";
    private Configuration fCfg;
    private IResourceDelta fDelta;
    private IConfigurationBuildState fBuildState;
    private Map fToolToMultiStepMap = new HashMap();
    private BuildStep[] fOrderedMultiActions;
    private Map fLocationToRcMap = new HashMap();
    private Map fVarToAddlInSetMap = new HashMap();
    private List fStepList = new ArrayList();
    private BuildStep fTargetStep;
    private IManagedBuilderMakefileGenerator fMakeGen;
    private IProject fProject;
    private IManagedBuildInfo fInfo;
    private IPath fTopBuildDirFullPath;
    private IPath[] fGeneratedPaths;
    private int fFlags;
    private BuildStep fInputStep;
    private BuildStep fOutputStep;
    private Map fToolOrderMap = new HashMap();
    private Set fToolInProcesSet = new HashSet();
    private ITool[] fOrderedTools;
    private ICSourceEntry[] fSourceEntries;
    private Map fEnvironment;
    private PDOMDependencyGenerator fPdomDepGen;
    private PathSettingsContainer fToolInfos;
    private BuildStep fCleanStep;

    protected IPath calcResourceLocation(IResource rc) {
        IPath rcLocation = rc.getLocation();
        if (rcLocation == null) {
            IPath fullPath = rc.getFullPath();
            rcLocation = this.calcLocationForFullPath(fullPath);
        }
        return rcLocation;
    }

    protected BuildDescription() {
    }

    public BuildDescription(IConfiguration cfg) {
        this.initBase(cfg, null, null, 0);
    }

    public void synchRebuildState() throws CoreException {
        if (DbgUtil.DEBUG) {
            DbgUtil.trace("--->Synch started");
        }
        BuildDescriptionManager.accept(new RebuildStateSynchronizer(), this, true);
        if (this.fOutputStep.needsRebuild()) {
            this.fInputStep.setRebuildState(true);
        }
        if (DbgUtil.DEBUG) {
            DbgUtil.trace("<---Synch stopped");
        }
    }

    private BuildIOType findTypeForExtension(BuildStep step, boolean input, String ext) {
        if (ext == null) {
            return null;
        }
        BuildIOType[] types = input ? (BuildIOType[])step.getInputIOTypes() : (BuildIOType[])step.getOutputIOTypes();
        int i = 0;
        while (i < types.length) {
            IBuildResource[] rcs = types[i].getResources();
            int j = 0;
            while (j < rcs.length) {
                String e = rcs[j].getLocation().getFileExtension();
                if (e == null ? ext.length() == 0 : ext.equals(e)) {
                    return types[i];
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private Map initToolAndTypeMap(IFolderInfo foInfo) {
        HashMap<String, ArrayList<ToolAndType>> extToToolAndTypeListMap = new HashMap<String, ArrayList<ToolAndType>>();
        ITool[] tools = foInfo.getFilteredTools();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            IInputType[] types = tool.getInputTypes();
            if (types.length != 0) {
                int j = 0;
                while (j < types.length) {
                    IInputType type = types[j];
                    String[] exts = type.getSourceExtensions(tool);
                    int k = 0;
                    while (k < exts.length) {
                        String ext = exts[k];
                        if (tool.buildsFileType(ext)) {
                            ArrayList<ToolAndType> list = (ArrayList<ToolAndType>)extToToolAndTypeListMap.get(ext);
                            if (list == null) {
                                list = new ArrayList<ToolAndType>();
                                extToToolAndTypeListMap.put(ext, list);
                            }
                            list.add(new ToolAndType(tool, type, ext));
                        }
                        ++k;
                    }
                    ++j;
                }
            } else {
                String[] exts = tool.getAllInputExtensions();
                int k = 0;
                while (k < exts.length) {
                    String ext = exts[k];
                    if (tool.buildsFileType(ext)) {
                        ArrayList<ToolAndType> list = (ArrayList<ToolAndType>)extToToolAndTypeListMap.get(ext);
                        if (list == null) {
                            list = new ArrayList<ToolAndType>();
                            extToToolAndTypeListMap.put(ext, list);
                        }
                        list.add(new ToolAndType(tool, null, ext));
                    }
                    ++k;
                }
            }
            ++i;
        }
        return extToToolAndTypeListMap;
    }

    ToolAndType getToolAndType(BuildResource rc, boolean checkVar) {
        ToolInfoHolder h = this.getToolInfo(rc);
        return this.getToolAndType(h, rc, checkVar);
    }

    ToolAndType getToolAndType(ToolInfoHolder h, BuildResource rc, boolean checkVar) {
        String locString = rc.getLocation().toString();
        BuildIOType arg = (BuildIOType)rc.getProducerIOType();
        String linkId = checkVar && arg != null ? arg.getLinkId() : null;
        Iterator iter = h.fExtToToolAndTypeListMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String ext = (String)entry.getKey();
            if (!locString.endsWith(DOT + ext)) continue;
            List list = (List)entry.getValue();
            Iterator itt = list.iterator();
            while (itt.hasNext()) {
                ToolAndType tt = (ToolAndType)itt.next();
                if (!checkVar) {
                    return tt;
                }
                IInputType type = tt.fType;
                if (type == null) {
                    return tt;
                }
                String var = type.getBuildVariable();
                if (var == null || var.length() == 0) {
                    return tt;
                }
                if (!(linkId == null ? var == null || var.length() == 0 : linkId.equals(var))) continue;
                return tt;
            }
        }
        return null;
    }

    protected boolean isSource(IPath path) {
        return !CDataUtil.isExcluded((IPath)path, (ICSourceEntry[])this.fSourceEntries);
    }

    private void composeOutputs(BuildStep inputAction, BuildIOType inputActionArg, BuildResource rc) throws CoreException {
        boolean isSource;
        boolean bl = isSource = inputActionArg == null;
        if (isSource) {
            if (rc.isProjectResource() && !this.isSource(rc.getFullPath().removeFirstSegments(1).makeRelative())) {
                return;
            }
        } else {
            if (inputAction != null && inputAction == this.fTargetStep) {
                BuildIOType arg = (BuildIOType)rc.getProducerIOType();
                if (arg.isPrimary()) {
                    BuildIOType oArg = this.findTypeForExtension(this.fOutputStep, true, rc.getLocation().getFileExtension());
                    if (oArg == null || !arg.isPrimary()) {
                        oArg = this.fOutputStep.createIOType(true, true, null);
                    }
                    oArg.addResource(rc);
                }
                return;
            }
            IOutputType[] secondaryOutputs = this.fCfg.getToolChain().getSecondaryOutputs();
            int i = 0;
            while (i < secondaryOutputs.length) {
                if (secondaryOutputs[i] == inputActionArg.getIoType()) {
                    BuildIOType arg = this.findTypeForExtension(this.fOutputStep, true, rc.getLocation().getFileExtension());
                    if (arg == null || arg.isPrimary()) {
                        arg = this.fOutputStep.createIOType(true, false, null);
                    }
                    arg.addResource(rc);
                }
                ++i;
            }
        }
        IPath location = rc.getLocation();
        IFolderInfo rcInfo = rc.isProjectResource() ? this.fCfg.getResourceInfo(rc.getFullPath().removeFirstSegments(1), false) : this.fCfg.getRootFolderInfo();
        ITool tool = null;
        IInputType inputType = null;
        String ext = null;
        boolean stepRemoved = false;
        if (rcInfo.isExcluded()) {
            if (rcInfo.needsRebuild()) {
                stepRemoved = true;
            } else {
                return;
            }
        }
        ToolInfoHolder h = null;
        if (rcInfo instanceof IFileInfo) {
            IFileInfo fi = (IFileInfo)((Object)rcInfo);
            tool = fi.getToolsToInvoke()[0];
            String[] exts = tool.getAllInputExtensions();
            String locString = location.toString();
            int i = 0;
            while (i < exts.length) {
                String e = exts[i];
                if (locString.endsWith(e)) {
                    inputType = tool.getInputType(e);
                    ext = e;
                }
                ++i;
            }
        } else {
            h = this.getToolInfo(rc);
            ToolAndType tt = this.getToolAndType(h, rc, true);
            if (tt != null) {
                tool = tt.fTool;
                inputType = tt.fType;
                ext = tt.fExt;
            }
        }
        if (ext == null) {
            ext = location.getFileExtension();
        }
        if (tool != null) {
            BuildStep step;
            BuildIOType argument;
            IInputType primaryInputType = tool.getPrimaryInputType();
            if (primaryInputType != null && !primaryInputType.getMultipleOfType() || inputType == null && tool != this.fCfg.calculateTargetTool()) {
                BuildStep action = null;
                argument = null;
                BuildGroup group = null;
                if (h != null) {
                    group = this.createGroup(h, inputType, ext);
                }
                action = this.createStep(tool, inputType);
                if (stepRemoved) {
                    action.setRemoved();
                }
                if (group != null) {
                    group.addAction(action);
                }
                argument = action.createIOType(true, true, inputType);
                argument.addResource(rc);
                if (inputActionArg == null) {
                    inputActionArg = this.findTypeForExtension(inputAction, false, rc.getLocation().getFileExtension());
                    if (inputActionArg == null) {
                        inputActionArg = inputAction.createIOType(false, false, null);
                    }
                    inputActionArg.addResource(rc);
                }
                this.calculateInputs(action);
                this.calculateOutputs(action, argument, rc);
                BuildIOType[] outputs = (BuildIOType[])action.getOutputIOTypes();
                int i = 0;
                while (i < outputs.length) {
                    BuildResource[] rcs = (BuildResource[])outputs[i].getResources();
                    int j = 0;
                    while (j < rcs.length) {
                        this.composeOutputs(action, outputs[i], rcs[j]);
                        ++j;
                    }
                    ++i;
                }
            } else if ((inputType != null ? inputType.getMultipleOfType() : tool == this.fCfg.calculateTargetTool()) && (step = (BuildStep)this.fToolToMultiStepMap.get(tool)) != null) {
                argument = step.getIOTypeForType(inputType, true);
                if (argument == null) {
                    argument = step.createIOType(true, true, inputType);
                }
                argument.addResource(rc);
                if (inputActionArg == null) {
                    inputActionArg = this.findTypeForExtension(inputAction, false, rc.getLocation().getFileExtension());
                    if (inputActionArg == null) {
                        inputActionArg = inputAction.createIOType(false, false, null);
                    }
                    inputActionArg.addResource(rc);
                }
            }
        }
    }

    private BuildGroup createGroup(ToolInfoHolder h, IInputType inType, String ext) {
        String key = inType != null ? inType.getId() : "ext:" + ext;
        BuildGroup group = (BuildGroup)h.fInTypeToGroupMap.get(key);
        if (group == null) {
            group = new BuildGroup();
            h.fInTypeToGroupMap.put(key, group);
        }
        return group;
    }

    public IBuildStep getInputStep() {
        return this.fInputStep;
    }

    public IBuildStep getOutputStep() {
        return this.fOutputStep;
    }

    public boolean checkFlags(int flags) {
        return (this.fFlags & flags) == flags;
    }

    protected void initBase(IConfiguration cfg, IConfigurationBuildState bs, IResourceDelta delta, int flags) {
        this.fCfg = (Configuration)cfg;
        this.fDelta = delta;
        this.fBuildState = bs;
        this.fProject = cfg.getOwner().getProject();
        this.fInfo = ManagedBuildManager.getBuildInfo((IResource)this.fProject);
        this.fFlags = flags;
        this.fSourceEntries = this.fCfg.getSourceEntries();
        if (this.fSourceEntries.length == 0) {
            this.fSourceEntries = new ICSourceEntry[]{new CSourceEntry((IPath)Path.EMPTY, null, 24)};
        } else {
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(cfg);
            this.fSourceEntries = CDataUtil.resolveEntries((ICSourceEntry[])this.fSourceEntries, (ICConfigurationDescription)cfgDes);
        }
        this.fInputStep = this.createStep(null, null);
        this.fOutputStep = this.createStep(null, null);
    }

    protected void initDescription() throws CoreException {
        if (this.fCfg.needsFullRebuild()) {
            this.fInputStep.setRebuildState(true);
        }
        if (this.fBuildState != null && this.fBuildState.getState() == 1) {
            this.fInputStep.setRebuildState(true);
        }
        this.initToolInfos();
        this.initMultiSteps();
        RcVisitor visitor = new RcVisitor();
        this.fProject.accept((IResourceProxyVisitor)visitor, 0);
        if (this.checkFlags(1) && this.fDelta != null) {
            this.fDelta.accept((IResourceDeltaVisitor)visitor);
        }
        this.handleMultiSteps();
        visitor.setMode(true);
        if (this.checkFlags(1) || this.checkFlags(2)) {
            if (this.fDelta != null) {
                this.fDelta.accept((IResourceDeltaVisitor)visitor);
            }
            if (this.fBuildState != null) {
                this.processBuildState();
            }
        }
        this.completeLinking();
        this.synchRebuildState();
    }

    protected void processBuildState() {
        IPath[] paths = this.fBuildState.getFullPathsForState(1);
        this.processBuildState(1, paths);
        paths = this.fBuildState.getFullPathsForState(2);
        this.processBuildState(2, paths);
    }

    protected void processBuildState(int state, IPath[] fullPaths) {
        int i = 0;
        while (i < fullPaths.length) {
            this.processBuildState(state, fullPaths[i]);
            ++i;
        }
    }

    protected void processBuildState(int state, IPath fullPath) {
        BuildResource bRc = (BuildResource)this.getBuildResourceForFullPath(fullPath);
        if (bRc == null) {
            return;
        }
        if (bRc.getProducerIOType() != null && bRc.getProducerIOType().getStep() == this.fInputStep) {
            if (state == 2) {
                if (this.checkFlags(1)) {
                    bRc.setRemoved(true);
                }
            } else if (state == 1 && this.checkFlags(2)) {
                bRc.setRebuildState(true);
            }
        } else if (state == 1 || state == 2 || this.checkFlags(2)) {
            bRc.setRebuildState(true);
            IBuildIOType type = bRc.getProducerIOType();
            if (type != null) {
                ((BuildStep)type.getStep()).setRebuildState(true);
            }
        }
    }

    protected void init(IConfiguration cfg, IConfigurationBuildState bs, IResourceDelta delta, int flags) throws CoreException {
        this.initBase(cfg, bs, delta, flags);
        this.initDescription();
    }

    protected void stepRemoved(BuildStep step) {
        this.fStepList.remove(step);
        if (this.fTargetStep == step) {
            this.fTargetStep = null;
        }
    }

    public BuildResource[][] removeStep(BuildStep step) {
        return step.remove();
    }

    public BuildIOType[][] removeResource(BuildResource rc) {
        return rc.remove();
    }

    private void handleMultiSteps() throws CoreException {
        int i = 0;
        while (i < this.fOrderedMultiActions.length) {
            BuildStep action = this.fOrderedMultiActions[i];
            this.calculateInputs(action);
            this.calculateOutputs(action, action.getPrimaryTypes(true)[0], null);
            if (action.getOutputResources().length == 0) {
                this.removeStep(action);
            }
            BuildIOType[] args = (BuildIOType[])action.getOutputIOTypes();
            int j = 0;
            while (j < args.length) {
                BuildIOType arg = args[j];
                BuildResource[] rcs = (BuildResource[])arg.getResources();
                int k = 0;
                while (k < rcs.length) {
                    BuildResource rc = rcs[k];
                    this.composeOutputs(action, arg, rc);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private void initMultiSteps() {
        BuildStep action;
        ITool[] tools = this.fCfg.getFilteredTools();
        ITool targetTool = this.fCfg.calculateTargetTool();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            IInputType type = tool.getPrimaryInputType();
            action = null;
            if (type != null ? type.getMultipleOfType() : tool == targetTool) {
                action = this.createStep(tool, type);
                action.createIOType(true, true, type);
                this.fToolToMultiStepMap.put(tool, action);
            }
            ++i;
        }
        this.fOrderedMultiActions = new BuildStep[this.fToolToMultiStepMap.size()];
        ITool[] orderedTools = this.getOrderedTools();
        int index = 0;
        int i2 = 0;
        while (i2 < orderedTools.length) {
            action = (BuildStep)this.fToolToMultiStepMap.get(orderedTools[i2]);
            if (action != null) {
                this.fOrderedMultiActions[index++] = action;
            }
            ++i2;
        }
    }

    private void completeLinking() throws CoreException {
        boolean foundUnused = false;
        do {
            BuildStep[] steps = (BuildStep[])this.getSteps();
            foundUnused = false;
            int k = 0;
            while (k < steps.length) {
                BuildStep step = steps[k];
                if (step != this.fOutputStep && step != this.fInputStep) {
                    IBuildResource[] rcs = step.getResources(false);
                    int i = 0;
                    while (i < rcs.length) {
                        if (rcs[i].getDependentIOTypes().length != 0) break;
                        ++i;
                    }
                    if (i == rcs.length) {
                        if (DbgUtil.DEBUG) {
                            DbgUtil.trace("unused step found: " + DbgUtil.stepName(step));
                        }
                        foundUnused = true;
                        if (step.needsRebuild() && step.getTool() != null && step.getTool().getCustomBuildStep()) {
                            if (DbgUtil.DEBUG) {
                                DbgUtil.trace("unused step is an RCBS needing rebuild, settings input step rebuild state to true");
                            }
                            this.fInputStep.setRebuildState(true);
                        }
                        this.removeStep(step);
                    }
                }
                ++k;
            }
        } while (foundUnused);
        Set set = this.fLocationToRcMap.entrySet();
        ArrayList<BuildResource> list = new ArrayList<BuildResource>();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            BuildResource rc = (BuildResource)entry.getValue();
            boolean doRemove = false;
            BuildIOType producerArg = (BuildIOType)rc.getProducerIOType();
            if (producerArg == null) {
                if (rc.getDependentIOTypes().length == 0) {
                    doRemove = true;
                } else {
                    producerArg = this.findTypeForExtension(this.fInputStep, false, rc.getLocation().getFileExtension());
                    if (producerArg == null) {
                        producerArg = this.fInputStep.createIOType(false, false, null);
                    }
                    producerArg.addResource(rc);
                }
            } else if (producerArg.getStep() == this.fInputStep && rc.getDependentIOTypes().length == 0) {
                doRemove = true;
            }
            if (!doRemove) continue;
            list.add(rc);
        }
        iter = list.iterator();
        while (iter.hasNext()) {
            BuildIOType[][] types = this.removeResource((BuildResource)((Object)iter.next()));
            BuildIOType producer = types[0][0];
            if (producer != null && producer.getResources().length == 0) {
                ((BuildStep)producer.getStep()).removeIOType(producer);
            }
            BuildIOType[] deps = types[1];
            int i = 0;
            while (i < deps.length) {
                if (deps[i].getResources().length == 0) {
                    ((BuildStep)deps[i].getStep()).removeIOType(deps[i]);
                }
                ++i;
            }
        }
    }

    protected void resourceRemoved(BuildResource rc) {
        this.fLocationToRcMap.remove(rc.getLocation());
    }

    protected void resourceCreated(BuildResource rc) {
        this.fLocationToRcMap.put(rc.getLocation(), rc);
    }

    private IManagedBuilderMakefileGenerator getMakeGenInitialized() {
        if (this.fMakeGen == null) {
            this.fMakeGen = ManagedBuildManager.getBuildfileGenerator(this.fCfg);
            if (this.fMakeGen instanceof IManagedBuilderMakefileGenerator2) {
                ((IManagedBuilderMakefileGenerator2)this.fMakeGen).initialize(6, this.fCfg, this.fCfg.getEditableBuilder(), (IProgressMonitor)new NullProgressMonitor());
            } else {
                this.fMakeGen.initialize(this.fProject, this.fInfo, null);
            }
        }
        return this.fMakeGen;
    }

    private IPath getTopBuildDirFullPath() {
        if (this.fTopBuildDirFullPath == null) {
            this.fTopBuildDirFullPath = this.fProject.getFullPath().append(this.getMakeGenInitialized().getBuildWorkingDir()).addTrailingSeparator();
        }
        return this.fTopBuildDirFullPath;
    }

    private IPath getTopBuildDirLocation() {
        return this.fProject.getLocation().append(this.getTopBuildDirFullPath().removeFirstSegments(1));
    }

    private BuildResource[] addOutputs(IPath[] paths, BuildIOType buildArg, IPath outDirPath) {
        if (paths != null) {
            ArrayList<BuildResource> list = new ArrayList<BuildResource>();
            int k = 0;
            while (k < paths.length) {
                IPath outLocation;
                Object outFullPath = paths[k];
                if (outFullPath.isAbsolute()) {
                    outLocation = outFullPath;
                    outFullPath = this.fProject.getLocation().isPrefixOf(outLocation) ? this.fProject.getFullPath().append(outLocation.removeFirstSegments(this.fProject.getLocation().segmentCount())) : null;
                } else if (outFullPath.segmentCount() == 1) {
                    outFullPath = outDirPath.append(outFullPath);
                    outLocation = this.fProject.getLocation().append(outFullPath.removeFirstSegments(1));
                } else {
                    outLocation = this.getTopBuildDirLocation().append(outFullPath);
                    outFullPath = this.getTopBuildDirFullPath().append(outFullPath);
                }
                BuildResource outRc = this.createResource(outLocation, (IPath)outFullPath);
                list.add(outRc);
                buildArg.addResource(outRc);
                ++k;
            }
            return list.toArray(new BuildResource[list.size()]);
        }
        return null;
    }

    private void calculateOutputs(BuildStep action, BuildIOType arg, BuildResource buildRc) throws CoreException {
        String linkId;
        BuildResource[] rcs = null;
        ITool tool = action.getTool();
        boolean isMultiAction = action.isMultiAction();
        IPath resPath = null;
        if (!isMultiAction) {
            resPath = buildRc.getFullPath();
            if (resPath == null) {
                resPath = buildRc.getLocation();
            }
        } else {
            rcs = (BuildResource[])action.getPrimaryTypes(true)[0].getResources();
            if (rcs.length == 0) {
                return;
            }
        }
        IPath outDirPath = isMultiAction ? this.getTopBuildDirFullPath() : (buildRc.getProducerIOType().getStep() == this.fInputStep ? this.getTopBuildDirFullPath().append(resPath.removeFirstSegments(1).removeLastSegments(1)).addTrailingSeparator() : resPath.removeLastSegments(1).addTrailingSeparator());
        IInputType inType = (IInputType)arg.getIoType();
        String string = linkId = inType != null ? inType.getBuildVariable() : null;
        if (linkId != null && linkId.length() == 0) {
            linkId = null;
        }
        IOutputType[] outTypes = tool.getOutputTypes();
        if (this.fTargetStep == action) {
            IOutputType type;
            BuildIOType ioType;
            String artifactPrefix;
            String artifactName = this.fCfg.getArtifactName();
            try {
                String tmp = ManagedBuildManager.getBuildMacroProvider().resolveValue(artifactName, "", " ", 3, this.fCfg);
                tmp = tmp.trim();
                if (tmp.length() > 0) {
                    artifactName = tmp;
                }
            }
            catch (BuildMacroException buildMacroException) {}
            String artifactExt = this.fCfg.getArtifactExtension();
            try {
                String tmp = ManagedBuildManager.getBuildMacroProvider().resolveValue(artifactExt, "", " ", 3, this.fCfg);
                tmp = tmp.trim();
                if (tmp.length() > 0) {
                    artifactExt = tmp;
                }
            }
            catch (BuildMacroException buildMacroException) {}
            if ((artifactPrefix = tool.getOutputPrefix()) != null && artifactPrefix.length() != 0) {
                try {
                    String tmp = ManagedBuildManager.getBuildMacroProvider().resolveValue(artifactPrefix, "", " ", 3, this.fCfg);
                    tmp = tmp.trim();
                    if (tmp.length() > 0) {
                        artifactPrefix = tmp;
                    }
                }
                catch (BuildMacroException buildMacroException) {}
                artifactName = String.valueOf(artifactPrefix) + artifactName;
            }
            Path path = new Path(artifactName);
            if (artifactExt != null && artifactExt.length() != 0) {
                path = path.addFileExtension(artifactExt);
            }
            if ((ioType = action.getIOTypeForType(type = action.getTool().getPrimaryOutputType(), false)) == null) {
                ioType = action.createIOType(false, true, type);
            }
            this.addOutputs(new IPath[]{path}, ioType, outDirPath);
        } else if (outTypes != null && outTypes.length > 0) {
            int i = 0;
            while (i < outTypes.length) {
                BuildIOType buildArg;
                IPath[] paths;
                String[] pathStrings;
                boolean primaryOutput;
                IOutputType type;
                block75: {
                    type = outTypes[i];
                    primaryOutput = type == tool.getPrimaryOutputType();
                    String outputPrefix = type.getOutputPrefix();
                    pathStrings = null;
                    paths = null;
                    IBuildObject toolParent = tool.getParent();
                    IConfiguration config = null;
                    if (toolParent instanceof IConfiguration) {
                        config = (IConfiguration)toolParent;
                    } else if (toolParent instanceof IToolChain) {
                        config = ((IToolChain)toolParent).getParent();
                    } else if (toolParent instanceof IResourceConfiguration) {
                        config = ((IResourceConfiguration)toolParent).getParent();
                    } else {
                        throw new AssertionError((Object)"tool parent must be one of configuration, toolchain, or resource configuration");
                    }
                    if (config != null) {
                        try {
                            outputPrefix = ManagedBuildManager.getBuildMacroProvider().resolveValue(outputPrefix, "", " ", 3, config);
                        }
                        catch (BuildMacroException buildMacroException) {}
                    }
                    boolean multOfType = type.getMultipleOfType();
                    IOption option = tool.getOptionBySuperClassId(type.getOptionId());
                    IManagedOutputNameProvider nameProvider = type.getNameProvider();
                    String[] outputNames = type.getOutputNames();
                    buildArg = null;
                    if (option != null) {
                        try {
                            int optType = option.getValueType();
                            if (optType == 2) {
                                String val = option.getStringValue();
                                if (val == null || val.length() <= 0) break block75;
                                try {
                                    val = ManagedBuildManager.getBuildMacroProvider().resolveValue(val, "", " ", 1, new FileContextData(resPath, null, option, tool));
                                }
                                catch (BuildMacroException buildMacroException) {}
                                val = val.trim();
                                if (val.length() > 0) {
                                    pathStrings = new String[]{String.valueOf(outputPrefix) + val};
                                }
                                break block75;
                            }
                            if (optType != 3 && optType != 6 && optType != 7 && optType != 8 && optType != 9 && optType != 10 && optType != 11 && optType != -4 && optType != -5 && optType != -8 && optType != -9 && optType != -10 && optType != -11) break block75;
                            List outputList = (List)option.getValue();
                            if (outputList != null && outputList.size() > 0) {
                                try {
                                    pathStrings = ManagedBuildManager.getBuildMacroProvider().resolveStringListValues(outputList.toArray(new String[outputList.size()]), "", " ", 1, new FileContextData(resPath, null, option, tool));
                                }
                                catch (BuildMacroException buildMacroException) {}
                            }
                            if (pathStrings != null && pathStrings.length > 0 && outputPrefix.length() > 0) {
                                int j = 0;
                                while (j < pathStrings.length) {
                                    pathStrings[j] = pathStrings[j] == null && (pathStrings[j] = pathStrings[j].trim()).length() == 0 ? null : String.valueOf(outputPrefix) + pathStrings[j];
                                    ++j;
                                }
                            }
                        }
                        catch (BuildException buildException) {}
                    } else if (nameProvider != null) {
                        Path[] inPaths;
                        if (buildRc != null) {
                            inPaths = new Path[]{buildRc.getLocation()};
                        } else {
                            inPaths = new Path[rcs.length];
                            int k = 0;
                            while (k < inPaths.length) {
                                inPaths[k] = rcs[k].getLocation();
                                ++k;
                            }
                        }
                        paths = nameProvider.getOutputNames(tool, (IPath[])inPaths);
                    } else if (outputNames != null) {
                        try {
                            pathStrings = ManagedBuildManager.getBuildMacroProvider().resolveStringListValues(outputNames, "", " ", 1, new FileContextData(resPath, null, option, tool));
                        }
                        catch (BuildMacroException buildMacroException) {}
                    } else if (!multOfType && !isMultiAction) {
                        String namePattern = type.getNamePattern();
                        IPath namePatternPath = null;
                        String inExt = resPath.getFileExtension();
                        String outExt = tool.getOutputExtension(inExt);
                        if (namePattern == null || namePattern.length() == 0) {
                            namePattern = String.valueOf(outputPrefix) + WILDCARD;
                            if (outExt != null && outExt.length() > 0) {
                                namePattern = String.valueOf(namePattern) + DOT + outExt;
                            }
                            namePatternPath = Path.fromOSString((String)namePattern);
                        } else {
                            if (outputPrefix.length() > 0) {
                                namePattern = String.valueOf(outputPrefix) + namePattern;
                            }
                            if ((namePatternPath = Path.fromOSString((String)namePattern)).segmentCount() == 1) {
                                namePatternPath = Path.fromOSString((String)namePatternPath.toString());
                            }
                        }
                        paths = new IPath[]{this.resolvePercent(namePatternPath, buildRc.getLocation())};
                    }
                }
                if (paths == null && pathStrings != null) {
                    paths = new IPath[pathStrings.length];
                    int k = 0;
                    while (k < pathStrings.length) {
                        paths[k] = Path.fromOSString((String)pathStrings[k]);
                        ++k;
                    }
                }
                if (paths != null) {
                    if (buildArg == null) {
                        buildArg = action.createIOType(false, primaryOutput, type);
                    }
                    this.addOutputs(paths, buildArg, outDirPath);
                }
                ++i;
            }
        } else {
            String outPrefix = tool.getOutputPrefix();
            IPath outFullPath = Path.fromOSString((String)(String.valueOf(outDirPath.toOSString()) + outPrefix + WILDCARD));
            String inExt = resPath.getFileExtension();
            String outExt = tool.getOutputExtension(inExt);
            outFullPath = this.resolvePercent(outFullPath.addFileExtension(outExt), buildRc.getLocation());
            IPath outLocation = this.fProject.getLocation().append(outFullPath.removeFirstSegments(1));
            BuildIOType buildArg = action.createIOType(false, true, null);
            BuildResource outRc = this.createResource(outLocation, outFullPath);
            buildArg.addResource(outRc);
        }
        if (this.checkFlags(8) && tool != null && buildRc != null) {
            IManagedDependencyGeneratorType depGenType;
            IInputType type = action.getInputType();
            String ext = null;
            if (type != null) {
                String[] exts = type.getSourceExtensions(tool);
                String location = buildRc.getLocation().toOSString();
                int i = 0;
                while (i < exts.length) {
                    if (location.endsWith(exts[i])) {
                        ext = exts[i];
                        break;
                    }
                    ++i;
                }
            }
            if (ext == null) {
                ext = buildRc.getLocation().getFileExtension();
            }
            if (ext != null && (depGenType = tool.getDependencyGeneratorForExtension(ext)) != null) {
                IPath[] depFiles = null;
                if (depGenType instanceof IManagedDependencyGenerator2) {
                    IResource resource;
                    IPath path;
                    IManagedDependencyInfo info;
                    IBuildObject context = tool.getParent();
                    if (context instanceof IToolChain) {
                        context = ((IToolChain)context).getParent();
                    }
                    if ((info = ((IManagedDependencyGenerator2)depGenType).getDependencySourceInfo(path = buildRc.isProjectResource() ? buildRc.getFullPath().removeFirstSegments(1) : buildRc.getLocation(), resource = buildRc.isProjectResource() ? this.fProject.findMember(buildRc.getLocation()) : null, context, tool, this.getDefaultBuildDirLocation())) instanceof IManagedDependencyCommands) {
                        depFiles = ((IManagedDependencyCommands)info).getDependencyFiles();
                    }
                } else if (depGenType.getCalculatorType() == 1 && depGenType instanceof IManagedDependencyGenerator) {
                    depFiles = new IPath[]{new Path(buildRc.getLocation().segment(buildRc.getLocation().segmentCount() - 1)).removeFileExtension().addFileExtension("d")};
                }
                if (depFiles != null) {
                    BuildIOType depType = action.createIOType(false, false, null);
                    this.addOutputs(depFiles, depType, outDirPath);
                }
            }
        }
    }

    protected IPath resolvePercent(IPath outPath, IPath sourceLocation) {
        String fileName = sourceLocation.removeFileExtension().lastSegment();
        String outName = outPath.toOSString().replaceAll(WILDCARD, fileName);
        return Path.fromOSString((String)outName);
    }

    private IPath locationToRel(IPath location) {
        if (this.fProject.getLocation().isPrefixOf(location)) {
            return location.removeFirstSegments(this.fProject.getLocation().segmentCount()).setDevice(null);
        }
        return location;
    }

    public IBuildResource getBuildResource(IPath location) {
        return (BuildResource)this.fLocationToRcMap.get(location);
    }

    public IBuildResource[] getResources() {
        Collection c = this.fLocationToRcMap.values();
        ArrayList list = new ArrayList();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (obj instanceof BuildResource) {
                list.add(obj);
                continue;
            }
            if (!(obj instanceof List)) continue;
            list.addAll((List)obj);
        }
        return list.toArray(new IBuildResource[list.size()]);
    }

    public IBuildResource[] getResources(boolean generated) {
        IBuildResource[] rcs = this.getResources();
        ArrayList<IBuildResource> list = new ArrayList<IBuildResource>();
        int i = 0;
        while (i < rcs.length) {
            IBuildResource rc = rcs[i];
            if (generated == (rc.getProducerStep() != this.fInputStep)) {
                list.add(rc);
            }
            ++i;
        }
        return list.toArray(new IBuildResource[list.size()]);
    }

    public IConfiguration getConfiguration() {
        return this.fCfg;
    }

    public Map getEnvironment() {
        if (this.fEnvironment == null) {
            this.fEnvironment = this.calculateEnvironment();
        }
        return this.fEnvironment;
    }

    protected Map calculateEnvironment() {
        IBuildEnvironmentVariable[] variables = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(this.fCfg, true, true);
        HashMap<String, String> map = new HashMap<String, String>();
        int i = 0;
        while (i < variables.length) {
            IBuildEnvironmentVariable var = variables[i];
            map.put(var.getName(), var.getValue());
            ++i;
        }
        return map;
    }

    public IProject getProject() {
        return this.fProject;
    }

    private void calculateInputs(BuildStep step) throws CoreException {
        ITool tool = step.getTool();
        IInputType[] inTypes = tool.getInputTypes();
        if (inTypes != null && inTypes.length > 0) {
            int i = 0;
            while (i < inTypes.length) {
                IAdditionalInput[] addlInputs;
                IInputType type = inTypes[i];
                type.getBuildVariable();
                boolean primaryInput = type.getPrimaryInput();
                IOption option = tool.getOptionBySuperClassId(type.getOptionId());
                BuildIOType arg = step.getIOTypeForType(type, true);
                if (option != null) {
                    try {
                        List inputs = new ArrayList<String>();
                        int optType = option.getValueType();
                        if (optType == 2) {
                            inputs.add(option.getStringValue());
                        } else if (optType == 3 || optType == 6 || optType == 7 || optType == 8 || optType == 9 || optType == 10 || optType == 11 || optType == -4 || optType == -5 || optType == -8 || optType == -9 || optType == -10 || optType == -11) {
                            inputs = (List)option.getValue();
                        }
                        int j = 0;
                        while (j < inputs.size()) {
                            String inputName = ((String)inputs.get(j)).trim();
                            try {
                                String resolved = null;
                                resolved = ManagedBuildManager.getBuildMacroProvider().resolveValue(inputName, "", " ", 2, new OptionContextData(option, tool));
                                resolved = resolved.trim();
                                if (resolved.length() > 0) {
                                    inputName = resolved;
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            if (arg == null) {
                                arg = step.createIOType(true, primaryInput, type);
                            }
                            this.addInput(inputName, arg);
                            ++j;
                        }
                    }
                    catch (BuildException buildException) {}
                }
                if ((addlInputs = type.getAdditionalInputs()) != null) {
                    int j = 0;
                    while (j < addlInputs.length) {
                        String[] paths;
                        IAdditionalInput addlInput = addlInputs[j];
                        int kind = addlInput.getKind();
                        if ((kind == 2 || kind == 3) && (paths = addlInput.getPaths()) != null) {
                            int k = 0;
                            while (k < paths.length) {
                                String strPath = paths[k];
                                if (!strPath.startsWith("$(")) {
                                    if (arg == null) {
                                        arg = step.createIOType(true, primaryInput, type);
                                    }
                                    this.addInput(strPath, arg);
                                } else if (strPath.endsWith(")")) {
                                    String var = strPath.substring(2, strPath.length() - 1);
                                    if ((var = var.trim()).length() != 0) {
                                        if (VAR_USER_OBJS.equals(var)) {
                                            String[] objs = this.getUserObjs(step);
                                            if (objs != null && objs.length != 0) {
                                                if (arg == null) {
                                                    arg = step.createIOType(true, primaryInput, type);
                                                }
                                                int o = 0;
                                                while (o < objs.length) {
                                                    this.addInput(objs[o], arg);
                                                    ++o;
                                                }
                                            }
                                        } else if (VAR_LIBS.equals(var)) {
                                            ITool libTool = this.fCfg.calculateTargetTool();
                                            if (libTool == null) {
                                                libTool = step.getTool();
                                            }
                                            step.setLibTool(libTool);
                                        } else {
                                            HashSet<BuildIOType> set;
                                            if (arg == null) {
                                                arg = step.createIOType(true, primaryInput, type);
                                            }
                                            if ((set = (HashSet<BuildIOType>)this.fVarToAddlInSetMap.get(var)) == null) {
                                                set = new HashSet<BuildIOType>();
                                                this.fVarToAddlInSetMap.put(var, set);
                                            }
                                            if (set.add(arg)) {
                                                Iterator iter = this.fLocationToRcMap.values().iterator();
                                                while (iter.hasNext()) {
                                                    BuildResource rc = (BuildResource)iter.next();
                                                    BuildIOType t = (BuildIOType)rc.getProducerIOType();
                                                    if (t == null || !var.equals(t.getLinkId())) continue;
                                                    arg.addResource(rc);
                                                }
                                            }
                                        }
                                    }
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.calculateDeps(step);
    }

    private void calculateDeps(BuildStep step) {
        BuildResource[] rcs = (BuildResource[])step.getInputResources();
        HashSet<IPath> depSet = new HashSet<IPath>();
        int i = 0;
        while (i < rcs.length) {
            IManagedDependencyCalculator depCalc = this.getDependencyCalculator(step, rcs[i]);
            if (depCalc != null) {
                IPath[] paths = depCalc.getDependencies();
                int j = 0;
                while (j < paths.length) {
                    depSet.add(paths[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (depSet.size() > 0) {
            BuildIOType ioType = step.createIOType(true, false, null);
            Iterator iter = depSet.iterator();
            while (iter.hasNext()) {
                this.addInput((IPath)iter.next(), ioType);
            }
        }
    }

    protected IManagedDependencyCalculator getDependencyCalculator(BuildStep step, BuildResource bRc) {
        if (!this.checkFlags(4)) {
            return null;
        }
        final ITool tool = step.getTool();
        if (tool == null) {
            return null;
        }
        IManagedDependencyCalculator depCalc = null;
        String ext = bRc.getLocation().getFileExtension();
        if (ext == null) {
            ext = "";
        }
        IManagedDependencyGeneratorType depGenType = tool.getDependencyGeneratorForExtension(ext);
        IManagedDependencyGeneratorType depGen = null;
        if (depGenType != null) {
            switch (depGenType.getCalculatorType()) {
                case 0: 
                case 4: {
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    depGen = depGenType;
                    break;
                }
                default: {
                    depGen = this.getPDOMDependencyGenerator();
                    break;
                }
            }
        } else {
            depGen = this.getPDOMDependencyGenerator();
        }
        if (depGen != null) {
            final IResource rc = BuildDescriptionManager.findResourceForBuildResource(bRc);
            IBuildObject bo = tool.getParent();
            if (bo instanceof IToolChain) {
                bo = ((IToolChain)bo).getParent();
            }
            if (rc != null) {
                IResource[] rcs;
                if (depGen instanceof IManagedDependencyGenerator2) {
                    IManagedDependencyInfo srcInfo = ((IManagedDependencyGenerator2)depGen).getDependencySourceInfo(rc.getLocation(), rc, bo, tool, this.getTopBuildDirLocation());
                    if (srcInfo instanceof IManagedDependencyCalculator) {
                        depCalc = (IManagedDependencyCalculator)srcInfo;
                    }
                } else if (depGen instanceof IManagedDependencyGenerator && (rcs = ((IManagedDependencyGenerator)depGen).findDependencies(rc, this.fProject)) != null && rcs.length > 0) {
                    final IPath[] paths = new IPath[rcs.length];
                    final IBuildObject bof = bo;
                    int i = 0;
                    while (i < paths.length) {
                        paths[i] = rcs[i].getLocation();
                        ++i;
                    }
                    depCalc = new IManagedDependencyCalculator(){

                        public IPath[] getAdditionalTargets() {
                            return null;
                        }

                        public IPath[] getDependencies() {
                            return paths;
                        }

                        public IBuildObject getBuildContext() {
                            return bof;
                        }

                        public IPath getSource() {
                            return rc.getLocation();
                        }

                        public ITool getTool() {
                            return tool;
                        }

                        public IPath getTopBuildDirectory() {
                            return this.getTopBuildDirectory();
                        }
                    };
                }
            }
        }
        return depCalc;
    }

    protected PDOMDependencyGenerator getPDOMDependencyGenerator() {
        if (this.fPdomDepGen == null) {
            this.fPdomDepGen = new PDOMDependencyGenerator();
        }
        return this.fPdomDepGen;
    }

    public String[] getLibs(BuildStep step) {
        Vector<String> libs = new Vector<String>();
        ITool tool = step.getLibTool();
        if (tool != null) {
            IOption[] opts = tool.getOptions();
            int i = 0;
            while (i < opts.length) {
                block10: {
                    IOption option = opts[i];
                    try {
                        IOptionApplicability applicabilitytCalculator;
                        if (option.getValueType() != 6 || (applicabilitytCalculator = option.getApplicabilityCalculator()) != null && !applicabilitytCalculator.isOptionUsedInCommandLine(this.fCfg, tool, option)) break block10;
                        String command = option.getCommand();
                        String[] allLibs = option.getLibraries();
                        int j = 0;
                        while (j < allLibs.length) {
                            try {
                                String[] resolved = ManagedBuildManager.getBuildMacroProvider().resolveStringListValueToMakefileFormat(allLibs[j], "", " ", 2, new OptionContextData(option, tool));
                                if (resolved != null && resolved.length > 0) {
                                    int k = 0;
                                    while (k < resolved.length) {
                                        String string = resolved[k];
                                        if (string.length() > 0) {
                                            libs.add(String.valueOf(command) + string);
                                        }
                                        ++k;
                                    }
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            ++j;
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++i;
            }
        }
        return libs.toArray(new String[libs.size()]);
    }

    public String[] getUserObjs(BuildStep step) {
        Vector<String> objs = new Vector<String>();
        ITool tool = this.fCfg.calculateTargetTool();
        if (tool == null) {
            tool = step.getTool();
        }
        if (tool != null) {
            IOption[] opts = tool.getOptions();
            int i = 0;
            while (i < opts.length) {
                block9: {
                    IOption option = opts[i];
                    try {
                        String[] unresolved;
                        if (option.getValueType() != 7 || (unresolved = option.getUserObjects()) == null || unresolved.length <= 0) break block9;
                        int k = 0;
                        while (k < unresolved.length) {
                            try {
                                String[] resolved = ManagedBuildManager.getBuildMacroProvider().resolveStringListValueToMakefileFormat(unresolved[k], "", " ", 2, new OptionContextData(option, tool));
                                if (resolved != null && resolved.length > 0) {
                                    objs.addAll(Arrays.asList(resolved));
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            ++k;
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++i;
            }
        }
        return objs.toArray(new String[objs.size()]);
    }

    private BuildResource addInput(String path, BuildIOType buildArg) {
        if (path.length() > 0) {
            IPath pPath = Path.fromOSString((String)path);
            return this.addInput(pPath, buildArg);
        }
        return null;
    }

    private BuildResource addInput(IPath path, BuildIOType buildArg) {
        IPath inLocation;
        IPath inFullPath = path;
        if (inFullPath.isAbsolute()) {
            inLocation = inFullPath;
            inFullPath = null;
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(inLocation);
            int i = 0;
            while (i < files.length) {
                IPath fl = files[i].getFullPath();
                if (fl.segment(0).equals(this.fProject.getName())) {
                    inFullPath = fl;
                    break;
                }
                ++i;
            }
            if (inFullPath == null && files.length > 0) {
                inFullPath = files[0].getFullPath();
            }
            if (inFullPath == null && this.fProject.getLocation().isPrefixOf(inLocation)) {
                inFullPath = this.fProject.getFullPath().append(inLocation.removeFirstSegments(this.fProject.getLocation().segmentCount()));
            }
        } else {
            inFullPath = this.fProject.getFullPath().append(inFullPath);
            IFile res = ResourcesPlugin.getWorkspace().getRoot().getFile(inFullPath);
            inLocation = this.calcResourceLocation((IResource)res);
        }
        BuildResource rc = this.createResource(inLocation, inFullPath);
        buildArg.addResource(rc);
        return rc;
    }

    void typeCreated(BuildIOType arg) {
    }

    public BuildResource createResource(String projPath) {
        Path path = new Path(projPath);
        return this.createResource((IPath)path);
    }

    public BuildResource createResource(IPath projPath) {
        return this.createResource(this.fProject.getLocation().append(projPath), this.fProject.getFullPath().append(projPath));
    }

    public BuildResource createResource(IResource rc) {
        return this.createResource(this.calcResourceLocation(rc), rc.getFullPath());
    }

    public BuildResource createResource(IPath location, IPath fullPath) {
        BuildResource rc = (BuildResource)this.getBuildResource(location);
        if (rc == null) {
            rc = new BuildResource(this, location, fullPath);
        }
        return rc;
    }

    public IResourceDelta getDelta() {
        return this.fDelta;
    }

    private ITool[] getOrderedTools() {
        if (this.fOrderedTools == null) {
            Object[] tools = this.fCfg.getFilteredTools();
            int i = 0;
            while (i < tools.length) {
                int j = i;
                while (j < tools.length) {
                    boolean put;
                    ITool tool = tools[j];
                    ToolOrderEstimation order = this.getToolOrder(tool);
                    ITool[] deps = order.getDeps();
                    boolean bl = put = deps.length == 0;
                    if (!put && deps.length <= i) {
                        put = true;
                        int k = 0;
                        while (k < deps.length) {
                            if (this.indexOf(deps[k], tools, 0, i) == -1) {
                                put = false;
                                break;
                            }
                            ++k;
                        }
                    }
                    if (put) {
                        if (i == j) break;
                        ITool tmp = tools[i];
                        tools[i] = tools[j];
                        tools[j] = tmp;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            this.fOrderedTools = tools;
        }
        return this.fOrderedTools;
    }

    private int indexOf(Object obj, Object[] array) {
        return this.indexOf(obj, array, 0, -1);
    }

    private int indexOf(Object obj, Object[] array, int start, int stop) {
        if (start < 0) {
            start = 0;
        }
        if (stop == -1) {
            stop = array.length;
        }
        if (start < stop) {
            int i = start;
            while (i < stop) {
                if (obj == array[i]) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private ToolOrderEstimation getToolOrder(ITool tool) {
        ToolOrderEstimation order = (ToolOrderEstimation)this.fToolOrderMap.get(tool.getId());
        if (order == null) {
            order = new ToolOrderEstimation(tool);
            this.fToolOrderMap.put(tool.getId(), order);
        }
        return order;
    }

    private ITool[] doCalcDeps(ITool tool) {
        if (!this.fToolInProcesSet.add(tool)) {
            if (DbgUtil.DEBUG) {
                DbgUtil.trace("loop dependency for tool" + tool.getName());
            }
            return new ITool[0];
        }
        String[] exts = tool.getAllInputExtensions();
        ITool[] tools = this.fCfg.getFilteredTools();
        HashSet<ITool> set = new HashSet<ITool>();
        int i = 0;
        while (i < tools.length) {
            ITool t = tools[i];
            if (t != tool) {
                int j = 0;
                while (j < exts.length) {
                    String e = exts[j];
                    if (t.producesFileType(e)) {
                        IInputType inType = tool.getInputType(e);
                        IOutputType outType = t.getOutputType(e);
                        if (inType == null && outType == null || inType.getBuildVariable().equals(outType.getBuildVariable())) {
                            set.add(t);
                            ToolOrderEstimation est = this.getToolOrder(t);
                            ITool[] deps = est.getDeps();
                            int k = 0;
                            while (k < deps.length) {
                                if (deps[k] != tool) {
                                    set.add(deps[k]);
                                } else if (DbgUtil.DEBUG) {
                                    DbgUtil.trace("loop dependency for tool" + tool.getName());
                                }
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.fToolInProcesSet.remove(tool);
        return set.toArray(new ITool[set.size()]);
    }

    private ITool[] doCalcConsumers(ITool tool) {
        if (!this.fToolInProcesSet.add(tool)) {
            if (DbgUtil.DEBUG) {
                DbgUtil.trace("loop dependency for tool" + tool.getName());
            }
            return new ITool[0];
        }
        String[] exts = tool.getAllOutputExtensions();
        ITool[] tools = this.fCfg.getFilteredTools();
        HashSet<ITool> set = new HashSet<ITool>();
        int i = 0;
        while (i < tools.length) {
            ITool t = tools[i];
            if (t != tool) {
                int j = 0;
                while (j < exts.length) {
                    String e = exts[j];
                    if (t.buildsFileType(e)) {
                        IOutputType inType = tool.getOutputType(e);
                        IInputType outType = t.getInputType(e);
                        if (inType == null && outType == null || inType.getBuildVariable().equals(outType.getBuildVariable())) {
                            set.add(t);
                            ToolOrderEstimation est = this.getToolOrder(t);
                            ITool[] consumers = est.getConsumers();
                            int k = 0;
                            while (k < consumers.length) {
                                if (consumers[k] != tool) {
                                    set.add(consumers[k]);
                                } else if (DbgUtil.DEBUG) {
                                    DbgUtil.trace("loop dependency for tool" + tool.getName());
                                }
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.fToolInProcesSet.remove(tool);
        return set.toArray(new ITool[set.size()]);
    }

    private IPath[] getGeneratedPaths() {
        if (this.fGeneratedPaths == null) {
            IConfiguration[] cfgs = this.fCfg.getManagedProject().getConfigurations();
            this.fGeneratedPaths = new IPath[cfgs.length];
            int i = 0;
            while (i < cfgs.length) {
                this.fGeneratedPaths[i] = this.fProject.getFullPath().append(cfgs[i].getName());
                ++i;
            }
        }
        return this.fGeneratedPaths;
    }

    protected boolean isGenerated(IPath path) {
        IPath[] paths = this.getGeneratedPaths();
        int i = 0;
        while (i < paths.length) {
            if (paths[i].isPrefixOf(path)) {
                return true;
            }
            ++i;
        }
        return this.getTopBuildDirFullPath().isPrefixOf(path);
    }

    protected void stepCreated(BuildStep step) {
        this.fStepList.add(step);
        ITool tool = step.getTool();
        if (tool != null && tool == this.fCfg.calculateTargetTool()) {
            if (this.fTargetStep != null && DbgUtil.DEBUG) {
                DbgUtil.trace("ERROR: target action already created");
            }
            this.fTargetStep = step;
        }
    }

    public BuildStep createStep(ITool tool, IInputType type) {
        return new BuildStep(this, tool, type);
    }

    public IPath getDefaultBuildDirLocation() {
        return this.getTopBuildDirLocation();
    }

    public IPath getDefaultBuildDirFullPath() {
        return this.getTopBuildDirFullPath();
    }

    protected void resourceAddedToType(BuildIOType type, BuildResource rc) {
        if (!type.isInput()) {
            Set set;
            String var = type.getLinkId();
            if (var == null) {
                var = new String();
            }
            if ((set = (Set)this.fVarToAddlInSetMap.get(var)) != null) {
                Iterator iter = set.iterator();
                while (iter.hasNext()) {
                    BuildIOType t = (BuildIOType)iter.next();
                    t.addResource(rc);
                }
            }
        }
    }

    protected void resourceRemovedFromType(BuildIOType type, BuildResource rc) {
    }

    public IBuildStep[] getSteps() {
        return this.fStepList.toArray(new BuildStep[this.fStepList.size()]);
    }

    public IBuildResource getBuildResource(IResource resource) {
        return this.getBuildResource(this.calcResourceLocation(resource));
    }

    public IBuildResource getBuildResourceForFullPath(IPath fullPath) {
        IPath location = this.calcLocationForFullPath(fullPath);
        return this.getBuildResource(location);
    }

    protected IPath calcLocationForFullPath(IPath fullPath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject proj = root.getProject(fullPath.segment(0));
        IPath rcLocation = proj.getLocation();
        rcLocation = rcLocation != null ? rcLocation.append(fullPath.removeFirstSegments(1)) : root.getLocation().append(fullPath);
        return rcLocation;
    }

    private void initToolInfos() {
        this.fToolInfos = PathSettingsContainer.createRootContainer();
        IResourceInfo[] rcInfos = this.fCfg.getResourceInfos();
        int i = 0;
        while (i < rcInfos.length) {
            IResourceInfo rcInfo = rcInfos[i];
            ToolInfoHolder h = this.getToolInfo(rcInfo.getPath(), true);
            if (rcInfo instanceof IFolderInfo) {
                IFolderInfo fo = (IFolderInfo)rcInfo;
                h.fExtToToolAndTypeListMap = this.initToolAndTypeMap(fo);
            }
            ++i;
        }
    }

    private ToolInfoHolder getToolInfo(BuildResource rc) {
        Path path = rc.isProjectResource() ? rc.getFullPath().removeFirstSegments(1).makeRelative() : Path.EMPTY;
        return this.getToolInfo((IPath)path);
    }

    private ToolInfoHolder getToolInfo(IPath path) {
        return this.getToolInfo(path, false);
    }

    private ToolInfoHolder getToolInfo(IPath path, boolean create) {
        PathSettingsContainer child = this.fToolInfos.getChildContainer(path, create, create);
        ToolInfoHolder h = null;
        if (child != null && (h = (ToolInfoHolder)child.getValue()) == null && create) {
            h = new ToolInfoHolder();
            child.setValue((Object)h);
        }
        return h;
    }

    public IBuildStep getCleanStep() {
        if (this.fCleanStep == null) {
            this.fCleanStep = new BuildStep(this, null, null);
        }
        return this.fCleanStep;
    }

    private class RcVisitor
    implements IResourceProxyVisitor,
    IResourceDeltaVisitor {
        private boolean fPostProcessMode;

        RcVisitor() {
            this.setMode(false);
        }

        public void setMode(boolean postProcess) {
            this.fPostProcessMode = postProcess;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            block5: {
                if (proxy.getType() != 1) break block5;
                this.doVisitFile(proxy.requestResource());
                return false;
            }
            try {
                return !BuildDescription.this.isGenerated(proxy.requestFullPath());
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = e.getLocalizedMessage();
                if (msg == null) {
                    msg = "";
                }
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), msg, (Throwable)e));
            }
        }

        protected boolean postProcessVisit(IResourceDelta delta) {
            IResource rc = delta.getResource();
            if (rc.getType() == 1) {
                IPath rcLocation = BuildDescription.this.calcResourceLocation(rc);
                BuildResource bRc = (BuildResource)BuildDescription.this.getBuildResource(rcLocation);
                if (bRc != null) {
                    if (bRc.getProducerIOType() != null && bRc.getProducerIOType().getStep() == BuildDescription.this.fInputStep) {
                        if (delta.getKind() == 2) {
                            if (BuildDescription.this.checkFlags(1)) {
                                bRc.setRemoved(true);
                            }
                        } else if (BuildDescription.this.checkFlags(2)) {
                            bRc.setRebuildState(true);
                        }
                    } else if (BuildDescription.this.checkFlags(2)) {
                        bRc.setRebuildState(true);
                        IBuildIOType type = bRc.getProducerIOType();
                        if (type != null) {
                            ((BuildStep)type.getStep()).setRebuildState(true);
                        }
                    }
                }
                return false;
            }
            return true;
        }

        public boolean removedCalcVisit(IResourceDelta delta) throws CoreException {
            IResource rc = delta.getResource();
            if (rc.getType() == 1) {
                IPath rcLocation;
                BuildResource bRc;
                if (!BuildDescription.this.isGenerated(rc.getFullPath()) && delta.getKind() == 2 && BuildDescription.this.checkFlags(1) && (bRc = (BuildResource)BuildDescription.this.getBuildResource(rcLocation = BuildDescription.this.calcResourceLocation(rc))) == null) {
                    this.doVisitFile(rc);
                }
                return false;
            }
            return true;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (this.fPostProcessMode) {
                return this.postProcessVisit(delta);
            }
            return this.removedCalcVisit(delta);
        }

        private void doVisitFile(IResource res) throws CoreException {
            BuildResource rc = BuildDescription.this.createResource(res);
            BuildDescription.this.composeOutputs(BuildDescription.this.fInputStep, null, rc);
        }
    }

    private class RebuildStateSynchronizer
    implements IStepVisitor {
        private RebuildStateSynchronizer() {
        }

        public int visit(IBuildStep a) throws CoreException {
            int i;
            IBuildResource[] outRcs;
            BuildStep action = (BuildStep)a;
            BuildResource[] rcs = (BuildResource[])action.getInputResources();
            boolean rebuild = action.needsRebuild();
            boolean removed = action.isRemoved();
            if (DbgUtil.DEBUG) {
                DbgUtil.trace(">>visiting step " + DbgUtil.stepName(a));
            }
            if (!removed) {
                BuildIOType[] args = action.getPrimaryTypes(true);
                int j = 0;
                if (args.length > 0) {
                    j = 0;
                    while (j < args.length) {
                        BuildResource[] ress = (BuildResource[])args[j].getResources();
                        if (ress.length > 0) {
                            int k = 0;
                            k = 0;
                            while (k < ress.length) {
                                if (!ress[k].isRemoved()) break;
                                ++k;
                            }
                            if (k != ress.length) break;
                        }
                        ++j;
                    }
                    if (j == args.length) {
                        removed = true;
                    }
                }
            }
            if (!removed && !rebuild) {
                int i2 = 0;
                while (i2 < rcs.length) {
                    if (rcs[i2].needsRebuild()) {
                        if (DbgUtil.DEBUG) {
                            DbgUtil.trace("resource " + BuildDescription.this.locationToRel(rcs[i2].getLocation()).toString() + " needs rebuild");
                        }
                        rebuild = true;
                        break;
                    }
                    if (rcs[i2].isRemoved()) {
                        if (DbgUtil.DEBUG) {
                            DbgUtil.trace("resource " + BuildDescription.this.locationToRel(rcs[i2].getLocation()).toString() + " is removed");
                        }
                        rebuild = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (removed) {
                if (DbgUtil.DEBUG) {
                    DbgUtil.trace("action to be removed");
                }
                action.setRemoved();
                outRcs = action.getOutputResources();
                i = 0;
                while (i < outRcs.length) {
                    if (DbgUtil.DEBUG) {
                        DbgUtil.trace("setting remove state for resource " + BuildDescription.this.locationToRel(outRcs[i].getLocation()).toString());
                    }
                    ((BuildResource)outRcs[i]).setRemoved(true);
                    ++i;
                }
            } else if (rebuild) {
                if (DbgUtil.DEBUG) {
                    DbgUtil.trace("action needs rebuild");
                }
                action.setRebuildState(true);
                outRcs = action.getOutputResources();
                i = 0;
                while (i < outRcs.length) {
                    if (DbgUtil.DEBUG) {
                        DbgUtil.trace("setting rebuild state for resource " + BuildDescription.this.locationToRel(outRcs[i].getLocation()).toString());
                    }
                    ((BuildResource)outRcs[i]).setRebuildState(true);
                    ++i;
                }
            }
            if (DbgUtil.DEBUG) {
                DbgUtil.trace("<<leaving..");
            }
            return 1;
        }
    }

    private class StepCollector
    implements IStepVisitor {
        private Set fStepSet = new HashSet();

        private StepCollector() {
        }

        public int visit(IBuildStep action) throws CoreException {
            if (DbgUtil.DEBUG) {
                DbgUtil.trace("StepCollector: visiting step " + DbgUtil.stepName(action));
            }
            this.fStepSet.add(action);
            return 1;
        }

        public BuildStep[] getSteps() {
            return this.fStepSet.toArray(new BuildStep[this.fStepSet.size()]);
        }

        public Set getStepSet() {
            return this.fStepSet;
        }

        public void clear() {
            this.fStepSet.clear();
        }
    }

    class ToolAndType {
        ITool fTool;
        IInputType fType;
        String fExt;

        ToolAndType(ITool tool, IInputType inputType, String ext) {
            this.fTool = tool;
            this.fType = inputType;
            this.fExt = ext;
        }
    }

    private class ToolInfoHolder {
        Map fExtToToolAndTypeListMap;
        Map fInTypeToGroupMap = new HashMap();

        private ToolInfoHolder() {
        }
    }

    private class ToolOrderEstimation {
        private ITool fTool;
        private ITool[] fDeps;
        private ITool[] fConsumers;

        private ToolOrderEstimation(ITool tool) {
            this.fTool = tool;
        }

        ITool getTool() {
            return this.fTool;
        }

        ITool[] getDeps() {
            if (this.fDeps == null) {
                this.fDeps = BuildDescription.this.doCalcDeps(this.fTool);
            }
            return this.fDeps;
        }

        ITool[] getConsumers() {
            if (this.fConsumers == null) {
                this.fConsumers = BuildDescription.this.doCalcConsumers(this.fTool);
            }
            return this.fConsumers;
        }

        boolean dependsOn(ITool tool) {
            return BuildDescription.this.indexOf(tool, this.getDeps()) != -1;
        }

        boolean hasConsumer(ITool tool) {
            return BuildDescription.this.indexOf(tool, this.getConsumers()) != -1;
        }
    }
}

