/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildCommand;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.ProcessLauncher;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildProcessManager {
    protected OutputStream out;
    protected OutputStream err;
    protected boolean show;
    protected ProcessLauncher[] processes;
    protected int maxProcesses;
    static int procNumber = 0;

    public BuildProcessManager(OutputStream _out, OutputStream _err, boolean _show, int _procNumber) {
        this.out = _out;
        this.err = _err;
        this.show = _show;
        this.maxProcesses = _procNumber;
        this.processes = new ProcessLauncher[this.maxProcesses];
    }

    public int getMaxProcesses() {
        return this.maxProcesses;
    }

    public ProcessLauncher launchProcess(IBuildCommand cmd, IPath cwd, IProgressMonitor monitor) {
        if (this.hasEmpty()) {
            int i = 0;
            while (i < this.maxProcesses) {
                if (this.processes[i] == null || this.processes[i].queryState() == 0) break;
                ++i;
            }
            if (i < this.maxProcesses) {
                this.processes[i] = new ProcessLauncher(cmd.getCommand(), cmd.getArgs(), this.mapToStringArray(cmd.getEnvironment()), cwd, this.out, this.err, monitor, this.show);
                this.processes[i].launch();
                return this.processes[i];
            }
        }
        return null;
    }

    public ProcessLauncher queryStates() {
        ProcessLauncher result = null;
        int i = 0;
        while (i < this.maxProcesses) {
            int state;
            if (this.processes[i] != null && (state = this.processes[i].queryState()) != 1 && state != 0 && result == null) {
                result = this.processes[i];
            }
            ++i;
        }
        return result;
    }

    public boolean hasEmpty() {
        int i = 0;
        while (i < this.maxProcesses) {
            if (this.processes[i] == null) {
                return true;
            }
            if (this.processes[i].queryState() != 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String[] mapToStringArray(Map map) {
        if (map == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            list.add(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    public static int checkCPUNumber() {
        if (procNumber > 0) {
            return procNumber;
        }
        procNumber = 1;
        int x = 0;
        String os = System.getProperty("os.name");
        if (os != null) {
            if (os.startsWith("Win")) {
                IBuildEnvironmentVariable var;
                IEnvironmentVariableProvider evp = ManagedBuildManager.getEnvironmentVariableProvider();
                if (evp != null && (var = evp.getVariable("NUMBER_OF_PROCESSORS", null, false, false)) != null) {
                    try {
                        x = new Integer(var.getValue());
                        if (x > 0) {
                            procNumber = x;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                String p = "/proc/cpuinfo";
                try {
                    String s;
                    BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(p)));
                    while ((s = r.readLine()) != null) {
                        if (!s.startsWith("processor\t:")) continue;
                        ++x;
                    }
                    r.close();
                    if (x > 0) {
                        procNumber = x;
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (DbgUtil.DEBUG) {
            DbgUtil.trace("Number of processors detected: " + procNumber);
        }
        return procNumber;
    }
}

