/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.build.internal.core.scannerconfig;

import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;

public class CfgScannerConfigUtil {
    public static CfgInfoContext adjustPerRcTypeContext(CfgInfoContext context) {
        Tool tool = (Tool)context.getTool();
        IResourceInfo rcInfo = context.getResourceInfo();
        IInputType inType = context.getInputType();
        boolean adjust = false;
        CfgInfoContext newContext = context;
        if (tool != null) {
            if (inType != null && !tool.hasScannerConfigSettings(inType)) {
                inType = null;
                adjust = true;
            }
            if (inType == null && !tool.hasScannerConfigSettings(null)) {
                tool = null;
                adjust = true;
            }
        }
        if (tool == null) {
            ToolChain tc;
            if (inType != null) {
                inType = null;
                adjust = true;
            }
            if (rcInfo != null && (tc = CfgScannerConfigUtil.getToolChain(rcInfo)) != null && !tc.hasScannerConfigSettings()) {
                adjust = true;
                rcInfo = null;
            }
        }
        if (adjust) {
            newContext = rcInfo == null ? new CfgInfoContext(context.getConfiguration()) : new CfgInfoContext(rcInfo, tool, inType);
        }
        return newContext;
    }

    private static ToolChain getToolChain(IResourceInfo rcInfo) {
        return rcInfo instanceof FolderInfo ? (ToolChain)((FolderInfo)rcInfo).getToolChain() : (ToolChain)((ResourceConfiguration)rcInfo).getBaseToolChain();
    }

    public static String getDefaultProfileId(CfgInfoContext context, boolean searchFirstIfNone) {
        ToolChain tCh;
        String id = null;
        if (context.getInputType() != null) {
            id = context.getInputType().getDiscoveryProfileId(context.getTool());
        }
        if (id == null && context.getTool() != null) {
            id = ((Tool)context.getTool()).getDiscoveryProfileId();
        }
        if (id == null && context.getResourceInfo() != null && (tCh = CfgScannerConfigUtil.getToolChain(context.getResourceInfo())) != null) {
            id = tCh.getScannerConfigDiscoveryProfileId();
        }
        if (id == null) {
            id = ((Configuration)context.getConfiguration()).getDiscoveryProfileId();
        }
        if (id == null && searchFirstIfNone) {
            id = CfgScannerConfigUtil.getFirstProfileId(context.getConfiguration().getFilteredTools());
        }
        return id;
    }

    public static String getFirstProfileId(ITool[] tools) {
        String id = null;
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            IInputType[] types = tool.getInputTypes();
            if (types.length != 0) {
                int k = 0;
                while (k < types.length) {
                    id = types[k].getDiscoveryProfileId(tool);
                    if (id == null) {
                        ++k;
                        continue;
                    }
                    break;
                }
            } else {
                id = ((Tool)tool).getDiscoveryProfileId();
            }
            if (id != null) break;
            ++i;
        }
        return id;
    }
}

