/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildCommand;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.DbgUtil;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IBuildModelBuilder;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IResourceRebuildStateContainer;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CommandBuilder
implements IBuildModelBuilder {
    private static final String PATH_ENV = "PATH";
    private static final String PROPERTY_DELIMITER = "path.separator";
    private static final String PROPERTY_OS_NAME = "os.name";
    private static final String PROPERTY_OS_VALUE = "windows";
    static final String DELIMITER_UNIX = ":";
    static final String DELIMITER_WINDOWS = ";";
    private IBuildCommand fCmd;
    private Process fProcess;
    private String fErrMsg;
    private static final String BUILDER_MSG_HEADER = "InternalBuilder.msg.header";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");

    public CommandBuilder(IBuildCommand cmd, IResourceRebuildStateContainer cr) {
        this.fCmd = cmd;
    }

    protected OutputStream wrap(OutputStream out) {
        return new OutputStreamWrapper(out);
    }

    public int build(OutputStream out, OutputStream err, IProgressMonitor monitor) {
        monitor.beginTask("", this.getNumCommands());
        monitor.subTask("");
        CommandLauncher launcher = this.createLauncher();
        int status = 0;
        launcher.showCommand(true);
        this.fProcess = launcher.execute(this.fCmd.getCommand(), this.fCmd.getArgs(), this.mapToStringArray(this.fCmd.getEnvironment()), this.fCmd.getCWD());
        if (this.fProcess != null) {
            try {
                this.fProcess.getOutputStream().close();
            }
            catch (IOException iOException) {}
        }
        int st = launcher.waitAndRead(this.wrap(out), this.wrap(err), (IProgressMonitor)new SubProgressMonitor(monitor, this.getNumCommands()));
        switch (st) {
            case 0: {
                if (this.fProcess.exitValue() == 0) break;
                status = -1;
                break;
            }
            case 1: {
                status = -3;
                this.fErrMsg = launcher.getErrorMessage();
                if (DbgUtil.DEBUG) {
                    DbgUtil.trace("command cancelled: " + this.fErrMsg);
                }
                this.printMessage(this.fErrMsg, out);
                break;
            }
            default: {
                status = -2;
                this.fErrMsg = launcher.getErrorMessage();
                if (DbgUtil.DEBUG) {
                    DbgUtil.trace("error launching the command: " + this.fErrMsg);
                }
                this.printMessage(this.fErrMsg, out);
            }
        }
        monitor.done();
        return status;
    }

    protected CommandLauncher createLauncher() {
        return new CommandSearchLauncher();
    }

    public String getErrMsg() {
        return this.fErrMsg;
    }

    private String[] mapToStringArray(Map map) {
        if (map == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            list.add(String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
        }
        return list.toArray(new String[list.size()]);
    }

    protected void printMessage(String msg, OutputStream os) {
        if (os != null) {
            msg = String.valueOf(ManagedMakeMessages.getFormattedString(BUILDER_MSG_HEADER, msg)) + LINE_SEPARATOR;
            try {
                os.write(msg.getBytes());
                os.flush();
            }
            catch (IOException iOException) {}
        }
    }

    public int getNumCommands() {
        return 1;
    }

    protected String getCommandLine() {
        StringBuffer buf = new StringBuffer();
        if (this.fCmd != null) {
            buf.append(this.fCmd.getCommand().toOSString());
            String[] args = this.fCmd.getArgs();
            int i = 0;
            while (i < args.length) {
                buf.append(' ');
                buf.append(args[i]);
                ++i;
            }
            buf.append(LINE_SEPARATOR);
        }
        return buf.toString();
    }

    private String getExecutable(String command, Map environment) {
        if (new Path(command).isAbsolute()) {
            return command;
        }
        return this.searchExecutable(command, this.getPaths(environment));
    }

    private String[] getPaths(Map env) {
        String pathsStr = (String)env.get(PATH_ENV);
        if (pathsStr == null) {
            Iterator iter = env.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!PATH_ENV.equalsIgnoreCase((String)entry.getKey())) continue;
                pathsStr = (String)entry.getValue();
                break;
            }
        }
        if (pathsStr != null) {
            String delimiter = this.getDelimiter();
            return pathsStr.split(delimiter);
        }
        return null;
    }

    private String getDelimiter() {
        String delimiter = System.getProperty(PROPERTY_DELIMITER);
        if (delimiter == null) {
            delimiter = this.isWindows() ? DELIMITER_WINDOWS : DELIMITER_UNIX;
        }
        return delimiter;
    }

    private String searchExecutable(String command, String[] paths) {
        if (paths == null) {
            return null;
        }
        int i = 0;
        while (i < paths.length) {
            File file = new File(paths[i], command.toString());
            if (file.isFile()) {
                return file.toString();
            }
            ++i;
        }
        return null;
    }

    private boolean isWindows() {
        String prop = System.getProperty(PROPERTY_OS_NAME);
        return prop != null ? prop.toLowerCase().startsWith(PROPERTY_OS_VALUE) : false;
    }

    private class CommandSearchLauncher
    extends CommandLauncher {
        private CommandSearchLauncher() {
        }

        protected String[] constructCommandArray(String command, String[] commandArgs) {
            String cmd;
            String[] args = new String[1 + commandArgs.length];
            if (!CommandBuilder.this.isWindows() && (cmd = CommandBuilder.this.getExecutable(command, CommandBuilder.this.fCmd.getEnvironment())) != null) {
                command = cmd;
            }
            args[0] = command;
            System.arraycopy(commandArgs, 0, args, 1, commandArgs.length);
            return args;
        }

        protected void printCommandLine(OutputStream os) {
            if (os != null) {
                String cmd = CommandBuilder.this.getCommandLine();
                try {
                    os.write(cmd.getBytes());
                    os.flush();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected class OutputStreamWrapper
    extends OutputStream {
        private OutputStream fOut;

        public OutputStreamWrapper(OutputStream out) {
            this.fOut = out;
        }

        public void write(int b) throws IOException {
            this.fOut.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.fOut.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.fOut.write(b, off, len);
        }

        public void flush() throws IOException {
            this.fOut.flush();
        }

        public void close() throws IOException {
        }
    }
}

