/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig.CfgDiscoveredPathManager;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CLibraryPathEntry;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.LanguageSettingEntriesSerializer;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObjectProperties;
import org.eclipse.cdt.managedbuilder.core.IBuildPropertiesRestriction;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.core.BooleanExpressionApplicabilityCalculator;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObjectProperties;
import org.eclipse.cdt.managedbuilder.internal.core.BuildSettingsUtil;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.IBuildPropertyChangeListener;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedConfigStorageElement;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.ProjectType;
import org.eclipse.cdt.managedbuilder.internal.core.PropertyManager;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfoContainer;
import org.eclipse.cdt.managedbuilder.internal.core.SourcePath;
import org.eclipse.cdt.managedbuilder.internal.core.SupportedProperties;
import org.eclipse.cdt.managedbuilder.internal.core.TargetPlatform;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildConfigurationData;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IConfigurationBuildMacroSupplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.Preferences;

public class Configuration
extends BuildObject
implements IConfiguration,
IBuildPropertiesRestriction,
IBuildPropertyChangeListener,
IRealBuildObjectAssociation {
    private static final String EMPTY_STRING = "";
    private static final IPath[] EMPTY_PATH_ARRAY = new IPath[0];
    private static final String EMPTY_CFG_ID = "org.eclipse.cdt.build.core.emptycfg";
    private String parentId;
    private IConfiguration parent;
    private ProjectType projectType;
    private ManagedProject managedProject;
    private String artifactName;
    private String cleanCommand;
    private String artifactExtension;
    private String errorParserIds;
    private String prebuildStep;
    private String postbuildStep;
    private String preannouncebuildStep;
    private String postannouncebuildStep;
    private String description;
    private ICSourceEntry[] sourceEntries;
    private BuildObjectProperties buildProperties;
    private boolean isTest;
    private SupportedProperties supportedProperties;
    private boolean isExtensionConfig = false;
    private boolean isDirty = false;
    private boolean rebuildNeeded = false;
    private boolean resolved = true;
    private boolean isTemporary = false;
    private PathSettingsContainer pathSettings = PathSettingsContainer.createRootContainer();
    private ResourceInfoContainer rcInfos = new ResourceInfoContainer(this.pathSettings, true);
    private BooleanExpressionApplicabilityCalculator booleanExpressionCalculator;
    private FolderInfo rootFolderInfo;
    private BuildConfigurationData fCfgData;
    private ICConfigurationDescription fCfgDes;
    private ICfgScannerConfigBuilderInfo2Set cfgScannerInfo;
    private boolean isPreferenceConfig;
    private List excludeList;
    private static final String REBUILD_STATE = "rebuildState";
    private static final String RC_CHANGE_STATE = "rcState";
    private int resourceChangeState = -1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Configuration(ProjectType projectType, IManagedConfigElement element, String managedBuildRevision) {
        String artType;
        String props;
        IManagedConfigElement[] enablements;
        this.projectType = projectType;
        this.isExtensionConfig = true;
        this.resolved = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionConfiguration(this);
        if (projectType != null) {
            projectType.addConfiguration(this);
        }
        if ((enablements = element.getChildren("enablement")).length > 0) {
            this.booleanExpressionCalculator = new BooleanExpressionApplicabilityCalculator(enablements);
        }
        IManagedConfigElement[] configElements = element.getChildren();
        ArrayList<IPath> srcPathList = new ArrayList<IPath>();
        this.excludeList = new ArrayList();
        int l = 0;
        while (l < configElements.length) {
            ResourceInfo resConfig;
            IManagedConfigElement configElement = configElements[l];
            if (configElement.getName().equals("toolChain")) {
                this.rootFolderInfo = new FolderInfo((IConfiguration)this, configElement, managedBuildRevision, false);
                this.addResourceConfiguration(this.rootFolderInfo);
            } else if ("folderInfo".equals(configElement.getName())) {
                resConfig = new FolderInfo((IConfiguration)this, configElement, managedBuildRevision, true);
                this.addResourceConfiguration(resConfig);
            } else if ("fileInfo".equals(configElement.getName()) || "resourceConfiguration".equals(configElement.getName())) {
                resConfig = new ResourceConfiguration((IConfiguration)this, configElement, managedBuildRevision);
                this.addResourceConfiguration(resConfig);
            } else if ("sourcePath".equals(configElement.getName())) {
                SourcePath p = new SourcePath(configElement);
                if (p.getPath() != null) {
                    srcPathList.add(p.getPath());
                }
            } else if (configElement.getName().equals("supportedProperties")) {
                this.loadProperties(configElement);
            } else if ("sourceEntries".equals(configElement.getName())) {
                List seList = LanguageSettingEntriesSerializer.loadEntriesList((ICStorageElement)new ManagedConfigStorageElement(configElement), (int)128);
                this.sourceEntries = seList.toArray(new ICSourceEntry[seList.size()]);
            }
            ++l;
        }
        this.sourceEntries = Configuration.createSourceEntries(this.sourceEntries, srcPathList, this.excludeList);
        this.excludeList = null;
        if (this.rootFolderInfo == null) {
            this.createRootFolderInfo();
        }
        if ((props = element.getAttribute("buildProperties")) != null) {
            this.buildProperties = new BuildObjectProperties(props, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this);
        }
        if ((artType = element.getAttribute("buildArtefactType")) != null) {
            if (this.buildProperties == null) {
                this.buildProperties = new BuildObjectProperties(this, this);
            }
            try {
                this.buildProperties.setProperty("org.eclipse.cdt.build.core.buildArtefactType", artType, true);
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        if (projectType != null && projectType.buildProperties != null) {
            if (this.buildProperties == null) {
                this.buildProperties = new BuildObjectProperties(projectType.buildProperties, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this);
            } else {
                IBuildProperty[] properties = projectType.buildProperties.getProperties();
                int i = 0;
                while (i < properties.length) {
                    try {
                        this.buildProperties.internalSetProperty(properties[i].getPropertyType().getId(), properties[i].getValue().getId());
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
            }
        }
        this.setDirty(false);
    }

    private static ICSourceEntry[] createSourceEntries(ICSourceEntry[] curEntries, List pathList, List excludeList) {
        int i = 0;
        while (i < excludeList.size()) {
            IPath path = (IPath)excludeList.get(i);
            if (path.segmentCount() == 0) {
                excludeList.remove(i);
            }
            ++i;
        }
        if (pathList.size() == 0) {
            pathList.add(Path.EMPTY);
        }
        if (pathList.size() == 1 && pathList.get(0).equals(Path.EMPTY) && excludeList.size() == 0) {
            return curEntries;
        }
        int pathSize = pathList.size();
        LinkedHashMap<IPath, ICSourceEntry> map = new LinkedHashMap<IPath, ICSourceEntry>();
        int i2 = 0;
        while (i2 < pathSize) {
            IPath path = (IPath)pathList.get(i2);
            ICSourceEntry entry = (ICSourceEntry)map.get(path);
            if (entry == null) {
                entry = new CSourceEntry(path, null, 24);
            }
            if ((entry = CDataUtil.addExcludePaths((ICSourceEntry)entry, (Collection)excludeList, (boolean)true)) != null) {
                map.put(path, entry);
            }
            ++i2;
        }
        return map.values().toArray(new ICSourceEntry[map.size()]);
    }

    public Configuration(ProjectType projectType, IConfiguration parentConfig, String id) {
        this.setId(id);
        this.projectType = projectType;
        this.isExtensionConfig = true;
        this.resolved = false;
        if (parentConfig != null) {
            this.name = parentConfig.getName();
            this.parent = parentConfig.getParent() == null ? parentConfig : parentConfig.getParent();
        }
        ManagedBuildManager.addExtensionConfiguration(this);
        if (projectType != null) {
            projectType.addConfiguration(this);
            this.setManagedBuildRevision(projectType.getManagedBuildRevision());
        }
    }

    public Configuration(ProjectType projectType, IConfiguration parentConfig, String id, String name) {
        this.setId(id);
        this.setName(name);
        this.projectType = projectType;
        this.parent = parentConfig;
        this.isExtensionConfig = true;
        ManagedBuildManager.addExtensionConfiguration(this);
        if (projectType != null) {
            projectType.addConfiguration(this);
            this.setManagedBuildRevision(projectType.getManagedBuildRevision());
        }
    }

    public Configuration(ManagedProject managedProject, ICStorageElement element, String managedBuildRevision, boolean isPreference) {
        String rcChangeState;
        this.managedProject = managedProject;
        this.isPreferenceConfig = isPreference;
        this.isExtensionConfig = false;
        this.fCfgData = new BuildConfigurationData(this);
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromProject(element);
        if (managedProject != null) {
            managedProject.addConfiguration(this);
        }
        ICStorageElement[] configElements = element.getChildren();
        ArrayList<IPath> srcPathList = new ArrayList<IPath>();
        this.excludeList = new ArrayList();
        int i = 0;
        while (i < configElements.length) {
            ResourceInfo resConfig;
            ICStorageElement configElement = configElements[i];
            if (configElement.getName().equals("toolChain")) {
                this.rootFolderInfo = new FolderInfo((IConfiguration)this, configElement, managedBuildRevision, false);
                this.addResourceConfiguration(this.rootFolderInfo);
            } else if ("folderInfo".equals(configElement.getName())) {
                resConfig = new FolderInfo((IConfiguration)this, configElement, managedBuildRevision, true);
                this.addResourceConfiguration(resConfig);
            } else if ("fileInfo".equals(configElement.getName()) || "resourceConfiguration".equals(configElement.getName())) {
                resConfig = new ResourceConfiguration((IConfiguration)this, configElement, managedBuildRevision);
                this.addResourceConfiguration(resConfig);
            } else if ("sourcePath".equals(configElement.getName())) {
                SourcePath p = new SourcePath(configElement);
                if (p.getPath() != null) {
                    srcPathList.add(p.getPath());
                }
            } else if ("sourceEntries".equals(configElement.getName())) {
                List seList = LanguageSettingEntriesSerializer.loadEntriesList((ICStorageElement)configElement, (int)128);
                this.sourceEntries = seList.toArray(new ICSourceEntry[seList.size()]);
            }
            ++i;
        }
        this.resolveProjectReferences(true);
        this.sourceEntries = Configuration.createSourceEntries(this.sourceEntries, srcPathList, this.excludeList);
        this.excludeList = null;
        PropertyManager mngr = PropertyManager.getInstance();
        String rebuild = mngr.getProperty(this, REBUILD_STATE);
        if (rebuild == null || Boolean.valueOf(rebuild).booleanValue()) {
            this.rebuildNeeded = true;
        }
        if ((rcChangeState = mngr.getProperty(this, RC_CHANGE_STATE)) == null) {
            this.resourceChangeState = -1;
        } else {
            try {
                this.resourceChangeState = Integer.parseInt(rcChangeState);
            }
            catch (NumberFormatException numberFormatException) {
                this.resourceChangeState = -1;
            }
        }
        this.setDirty(false);
    }

    public Configuration(ManagedProject managedProject, ToolChain tCh, String id, String name) {
        this.setId(id);
        this.setName(name);
        this.managedProject = managedProject;
        this.isExtensionConfig = false;
        if (tCh == null) {
            IConfiguration cfg = ManagedBuildManager.getPreferenceConfiguration(false);
            if (cfg != null) {
                this.copySettingsFrom((Configuration)cfg, true);
            }
        } else {
            TargetPlatform tp;
            ITargetPlatform tpBase;
            String subId;
            Configuration baseCfg = (Configuration)ManagedBuildManager.getExtensionConfiguration(EMPTY_CFG_ID);
            this.fCfgData = new BuildConfigurationData(this);
            if (baseCfg.buildProperties != null) {
                this.buildProperties = new BuildObjectProperties(baseCfg.buildProperties, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this);
            }
            this.setManagedBuildRevision(baseCfg.getManagedBuildRevision());
            this.parent = baseCfg.isExtensionConfig || baseCfg.getParent() == null ? baseCfg : baseCfg.getParent();
            this.projectType = baseCfg.projectType;
            this.artifactName = baseCfg.artifactName;
            this.cleanCommand = baseCfg.cleanCommand;
            this.artifactExtension = baseCfg.artifactExtension;
            this.errorParserIds = baseCfg.errorParserIds;
            this.prebuildStep = baseCfg.prebuildStep;
            this.postbuildStep = baseCfg.postbuildStep;
            this.preannouncebuildStep = baseCfg.preannouncebuildStep;
            this.postannouncebuildStep = baseCfg.postannouncebuildStep;
            if (baseCfg.sourceEntries != null) {
                this.sourceEntries = (ICSourceEntry[])baseCfg.sourceEntries.clone();
            }
            String tcId = ManagedBuildManager.calculateChildId(tCh.getId(), null);
            IToolChain newChain = this.createToolChain(tCh, tcId, tCh.getId(), false);
            newChain.createOptions(tCh);
            ITool[] tools = tCh.getTools();
            int i = 0;
            while (i < tools.length) {
                Tool toolChild = (Tool)tools[i];
                subId = ManagedBuildManager.calculateChildId(toolChild.getId(), null);
                newChain.createTool(toolChild, subId, toolChild.getName(), false);
                ++i;
            }
            ITargetPlatform extTp = tpBase = tCh.getTargetPlatform();
            while (extTp != null && !extTp.isExtensionElement()) {
                extTp = extTp.getSuperClass();
            }
            if (extTp != null) {
                int nnn = ManagedBuildManager.getRandomNumber();
                subId = String.valueOf(extTp.getId()) + "." + nnn;
                tp = new TargetPlatform(newChain, subId, tpBase.getName(), (TargetPlatform)tpBase);
            } else {
                subId = ManagedBuildManager.calculateChildId(this.getId(), null);
                String subName = EMPTY_STRING;
                tp = new TargetPlatform((ToolChain)newChain, null, subId, subName, false);
            }
            ((ToolChain)newChain).setTargetPlatform(tp);
            managedProject.addConfiguration(this);
            IBuilder builder = this.getEditableBuilder();
            try {
                builder.setManagedBuildOn(false);
            }
            catch (CoreException coreException) {}
            this.propertiesChanged();
        }
        this.setDirty(true);
        this.setRebuildState(true);
    }

    public Configuration(ManagedProject managedProject, Configuration cloneConfig, String id, boolean cloneChildren, boolean temporary) {
        this(managedProject, cloneConfig, id, cloneChildren, temporary, false);
    }

    public Configuration(ManagedProject managedProject, Configuration cloneConfig, String id, boolean cloneChildren, boolean temporary, boolean isPreferenceConfig) {
        this.setId(id);
        this.setName(cloneConfig.getName());
        this.isPreferenceConfig = isPreferenceConfig;
        this.managedProject = managedProject;
        this.isExtensionConfig = false;
        this.isTemporary = temporary;
        this.copySettingsFrom(cloneConfig, cloneChildren);
    }

    private void copySettingsFrom(Configuration cloneConfig, boolean cloneChildren) {
        this.fCfgData = new BuildConfigurationData(this);
        if (cloneConfig.buildProperties != null) {
            this.buildProperties = new BuildObjectProperties(cloneConfig.buildProperties, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this);
        }
        this.description = cloneConfig.getDescription();
        this.setManagedBuildRevision(cloneConfig.getManagedBuildRevision());
        if (!cloneConfig.isExtensionConfig) {
            cloneChildren = true;
        }
        this.parent = cloneConfig.isExtensionConfig || cloneConfig.getParent() == null ? cloneConfig : cloneConfig.getParent();
        this.parentId = this.parent.getId();
        this.projectType = cloneConfig.projectType;
        if (cloneConfig.artifactName != null) {
            this.artifactName = new String(cloneConfig.artifactName);
        }
        if (cloneConfig.cleanCommand != null) {
            this.cleanCommand = new String(cloneConfig.cleanCommand);
        }
        if (cloneConfig.artifactExtension != null) {
            this.artifactExtension = new String(cloneConfig.artifactExtension);
        }
        if (cloneConfig.errorParserIds != null) {
            this.errorParserIds = new String(cloneConfig.errorParserIds);
        }
        if (cloneConfig.prebuildStep != null) {
            this.prebuildStep = new String(cloneConfig.prebuildStep);
        }
        if (cloneConfig.postbuildStep != null) {
            this.postbuildStep = new String(cloneConfig.postbuildStep);
        }
        if (cloneConfig.preannouncebuildStep != null) {
            this.preannouncebuildStep = new String(cloneConfig.preannouncebuildStep);
        }
        if (cloneConfig.postannouncebuildStep != null) {
            this.postannouncebuildStep = new String(cloneConfig.postannouncebuildStep);
        }
        if (cloneConfig.sourceEntries != null) {
            this.sourceEntries = (ICSourceEntry[])cloneConfig.sourceEntries.clone();
        }
        boolean copyIds = cloneConfig.getId().equals(this.id);
        HashMap toolIdMap = new HashMap();
        IResourceInfo[] infos = cloneConfig.rcInfos.getResourceInfos();
        int i = 0;
        while (i < infos.length) {
            String subId;
            if (infos[i] instanceof FolderInfo) {
                FolderInfo folderInfo = (FolderInfo)infos[i];
                subId = copyIds ? folderInfo.getId() : ManagedBuildManager.calculateChildId(this.getId(), folderInfo.getPath().toString());
                FolderInfo newFolderInfo = new FolderInfo((IConfiguration)this, folderInfo, subId, toolIdMap, cloneChildren);
                this.addResourceConfiguration(newFolderInfo);
            } else {
                ResourceConfiguration fileInfo = (ResourceConfiguration)infos[i];
                subId = copyIds ? fileInfo.getId() : ManagedBuildManager.calculateChildId(this.getId(), fileInfo.getPath().toString());
                ResourceConfiguration newResConfig = new ResourceConfiguration(this, fileInfo, subId, toolIdMap, cloneChildren);
                this.addResourceConfiguration(newResConfig);
            }
            ++i;
        }
        this.resolveProjectReferences(false);
        if (cloneChildren) {
            BuildMacroProvider macroProvider = (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
            macroProvider.expandMacrosInBuildfile(this, macroProvider.areMacrosExpandedInBuildfile(cloneConfig));
        }
        if (this.managedProject != null) {
            this.managedProject.addConfiguration(this);
        }
        if (cloneConfig.isExtensionConfig) {
            this.propertiesChanged();
        }
        if (copyIds) {
            this.rebuildNeeded = cloneConfig.rebuildNeeded;
            this.resourceChangeState = cloneConfig.resourceChangeState;
            this.isDirty = cloneConfig.isDirty;
        } else {
            if (cloneConfig.isExtensionConfig) {
                this.exportArtifactInfo();
            }
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public void applyToManagedProject(ManagedProject mProj) {
        this.managedProject = mProj;
        this.isPreferenceConfig = false;
        this.isTemporary = false;
        this.managedProject.addConfiguration(this);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.name = element.getAttribute("name");
        this.description = element.getAttribute("description");
        this.parentId = element.getAttribute("parent");
        this.artifactName = element.getAttribute("artifactName");
        this.errorParserIds = element.getAttribute("errorParsers");
        this.artifactExtension = element.getAttribute("artifactExtension");
        this.cleanCommand = element.getAttribute("cleanCommand");
        this.prebuildStep = element.getAttribute("prebuildStep");
        this.postbuildStep = element.getAttribute("postbuildStep");
        this.preannouncebuildStep = element.getAttribute("preannouncebuildStep");
        this.postannouncebuildStep = element.getAttribute("postannouncebuildStep");
        String tmp = element.getAttribute("isSystem");
        if (tmp != null) {
            this.isTest = Boolean.valueOf(tmp);
        }
    }

    protected void loadFromProject(ICStorageElement element) {
        String artType;
        String props;
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(element.getAttribute("name"));
        }
        if (element.getAttribute("description") != null) {
            this.description = element.getAttribute("description");
        }
        if ((props = element.getAttribute("buildProperties")) != null) {
            this.buildProperties = new BuildObjectProperties(props, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this);
        }
        if ((artType = element.getAttribute("buildArtefactType")) != null) {
            if (this.buildProperties == null) {
                this.buildProperties = new BuildObjectProperties(this, this);
            }
            try {
                this.buildProperties.setProperty("org.eclipse.cdt.build.core.buildArtefactType", artType, true);
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        if (element.getAttribute("parent") != null) {
            if (this.managedProject != null) {
                this.parent = this.managedProject.getConfiguration(element.getAttribute("parent"));
            }
            if (this.parent == null) {
                this.parent = ManagedBuildManager.getExtensionConfiguration(element.getAttribute("parent"));
            }
        }
        if (element.getAttribute("artifactName") != null) {
            this.artifactName = element.getAttribute("artifactName");
        }
        if (element.getAttribute("errorParsers") != null) {
            this.errorParserIds = element.getAttribute("errorParsers");
        }
        if (element.getAttribute("artifactExtension") != null) {
            this.artifactExtension = element.getAttribute("artifactExtension");
        }
        if (element.getAttribute("cleanCommand") != null) {
            this.cleanCommand = element.getAttribute("cleanCommand");
        }
        if (element.getAttribute("prebuildStep") != null) {
            this.prebuildStep = element.getAttribute("prebuildStep");
        }
        if (element.getAttribute("postbuildStep") != null) {
            this.postbuildStep = element.getAttribute("postbuildStep");
        }
        if (element.getAttribute("preannouncebuildStep") != null) {
            this.preannouncebuildStep = element.getAttribute("preannouncebuildStep");
        }
        if (element.getAttribute("postannouncebuildStep") != null) {
            this.postannouncebuildStep = element.getAttribute("postannouncebuildStep");
        }
    }

    public void serialize(ICStorageElement element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("description", this.description);
        }
        if (this.buildProperties != null) {
            element.setAttribute("buildProperties", this.buildProperties.toString());
            IBuildProperty prop = this.buildProperties.getProperty("org.eclipse.cdt.build.core.buildArtefactType");
            if (prop != null) {
                IBuildPropertyValue val = prop.getValue();
                element.setAttribute("buildArtefactType", val.getId());
            }
        }
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        if (this.artifactName != null) {
            element.setAttribute("artifactName", this.artifactName);
        }
        if (this.errorParserIds != null) {
            element.setAttribute("errorParsers", this.errorParserIds);
        }
        if (this.artifactExtension != null) {
            element.setAttribute("artifactExtension", this.artifactExtension);
        }
        if (this.cleanCommand != null) {
            element.setAttribute("cleanCommand", this.cleanCommand);
        }
        if (this.prebuildStep != null) {
            element.setAttribute("prebuildStep", this.prebuildStep);
        }
        if (this.postbuildStep != null) {
            element.setAttribute("postbuildStep", this.postbuildStep);
        }
        if (this.preannouncebuildStep != null) {
            element.setAttribute("preannouncebuildStep", this.preannouncebuildStep);
        }
        if (this.postannouncebuildStep != null) {
            element.setAttribute("postannouncebuildStep", this.postannouncebuildStep);
        }
        IResourceInfo[] infos = this.rcInfos.getResourceInfos();
        int i = 0;
        while (i < infos.length) {
            String elementName = infos[i].getKind() == 8 ? "fileInfo" : "folderInfo";
            ICStorageElement resElement = element.createChild(elementName);
            ((ResourceInfo)infos[i]).serialize(resElement);
            ++i;
        }
        PropertyManager.getInstance().serialize(this);
        if (this.sourceEntries != null && this.sourceEntries.length > 0) {
            ICStorageElement el = element.createChild("sourceEntries");
            LanguageSettingEntriesSerializer.serializeEntries((ICSettingEntry[])this.sourceEntries, (ICStorageElement)el);
        }
        this.setDirty(false);
    }

    public IConfiguration getParent() {
        return this.parent;
    }

    public IResource getOwner() {
        if (this.managedProject != null) {
            return this.managedProject.getOwner();
        }
        return null;
    }

    public IProjectType getProjectType() {
        return this.projectType;
    }

    public IManagedProject getManagedProject() {
        return this.managedProject;
    }

    public IToolChain createToolChain(IToolChain superClass, String Id, String name, boolean isExtensionElement) {
        if (this.rootFolderInfo == null) {
            this.createRootFolderInfo();
        }
        return this.rootFolderInfo.createToolChain(superClass, Id, name, isExtensionElement);
    }

    private IFolderInfo createRootFolderInfo() {
        String id = ManagedBuildManager.calculateChildId(this.id, null);
        String name = "/";
        this.rootFolderInfo = new FolderInfo((IConfiguration)this, (IPath)new Path(name), id, name, this.isExtensionConfig);
        this.addResourceConfiguration(this.rootFolderInfo);
        return this.rootFolderInfo;
    }

    public IToolChain getToolChain() {
        return this.rootFolderInfo.getToolChain();
    }

    public IResourceConfiguration[] getResourceConfigurations() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.managedbuilder.core.IResourceConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IResourceConfiguration[])this.rcInfos.getResourceInfos(8, clazz);
    }

    public IResourceConfiguration getResourceConfiguration(String resPath) {
        return this.rcInfos.getFileInfo(new Path(resPath).removeFirstSegments(1));
    }

    public ITool[] getFilteredTools() {
        return this.rootFolderInfo.getFilteredTools();
    }

    public ITool[] getTools() {
        return this.rootFolderInfo.getTools();
    }

    public ITool getTool(String id) {
        return this.rootFolderInfo.getTool(id);
    }

    public ITool[] getToolsBySuperClassId(String id) {
        return this.rootFolderInfo.getToolsBySuperClassId(id);
    }

    public ITool getTargetTool() {
        String[] targetToolIds = this.rootFolderInfo.getToolChain().getTargetToolList();
        if (targetToolIds == null || targetToolIds.length == 0) {
            return null;
        }
        ITool[] tools = this.getFilteredTools();
        int i = 0;
        while (i < targetToolIds.length) {
            String targetToolId = targetToolIds[i];
            int j = 0;
            while (j < tools.length) {
                ITool targetTool;
                ITool tool = targetTool = tools[j];
                do {
                    if (!targetToolId.equals(tool.getId())) continue;
                    return targetTool;
                } while ((tool = tool.getSuperClass()) != null);
                ++j;
            }
            ++i;
        }
        return null;
    }

    public String getToolCommand(ITool tool) {
        return tool.getToolCommand();
    }

    public void setToolCommand(ITool tool, String command) {
        tool.setToolCommand(command);
    }

    public IOption setOption(IHoldsOptions holder, IOption option, boolean value) throws BuildException {
        return this.getRootFolderInfo().setOption(holder, option, value);
    }

    public IOption setOption(IHoldsOptions holder, IOption option, String value) throws BuildException {
        return this.getRootFolderInfo().setOption(holder, option, value);
    }

    public IOption setOption(IHoldsOptions holder, IOption option, String[] value) throws BuildException {
        return this.getRootFolderInfo().setOption(holder, option, value);
    }

    void addResourceConfiguration(IResourceInfo resConfig) {
        if (resConfig.getPath().segmentCount() == 0) {
            this.rootFolderInfo = (FolderInfo)resConfig;
        }
        this.rcInfos.addResourceInfo(resConfig);
        this.isDirty = true;
    }

    public void removeResourceConfiguration(IResourceInfo resConfig) {
        ManagedBuildManager.performValueHandlerEvent(resConfig, 2);
        ITool[] tools = resConfig.getTools();
        this.rcInfos.removeResourceInfo(resConfig.getPath());
        ((ResourceInfo)resConfig).removed();
        BuildSettingsUtil.disconnectDepentents((IConfiguration)this, tools);
        this.isDirty = true;
        this.rebuildNeeded = true;
    }

    public String getName() {
        return this.name == null && this.parent != null ? this.parent.getName() : this.name;
    }

    public String getArtifactExtension() {
        String ext = this.getArtifactExtensionAttribute(true);
        return ext != null ? ext : EMPTY_STRING;
    }

    public String getArtifactExtensionAttribute(boolean querySuperClass) {
        if (this.artifactExtension == null) {
            if (this.parent != null) {
                return this.parent.getArtifactExtension();
            }
            return null;
        }
        return this.artifactExtension;
    }

    public String getArtifactName() {
        if (this.artifactName == null) {
            if (this.parent != null) {
                return this.parent.getArtifactName();
            }
            return EMPTY_STRING;
        }
        return this.artifactName;
    }

    public String getBuildArguments() {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (builder != null) {
            return builder.getArguments();
        }
        return new String("-k");
    }

    public String getBuildCommand() {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (builder != null) {
            return builder.getCommand();
        }
        return new String("make");
    }

    public String getPrebuildStep() {
        if (this.prebuildStep == null) {
            if (this.parent != null) {
                return this.parent.getPrebuildStep();
            }
            return EMPTY_STRING;
        }
        return this.prebuildStep;
    }

    public String getPostbuildStep() {
        if (this.postbuildStep == null) {
            if (this.parent != null) {
                return this.parent.getPostbuildStep();
            }
            return EMPTY_STRING;
        }
        return this.postbuildStep;
    }

    public String getPreannouncebuildStep() {
        if (this.preannouncebuildStep == null) {
            if (this.parent != null) {
                return this.parent.getPreannouncebuildStep();
            }
            return EMPTY_STRING;
        }
        return this.preannouncebuildStep;
    }

    public String getPostannouncebuildStep() {
        if (this.postannouncebuildStep == null) {
            if (this.parent != null) {
                return this.parent.getPostannouncebuildStep();
            }
            return EMPTY_STRING;
        }
        return this.postannouncebuildStep;
    }

    public String getCleanCommand() {
        if (this.cleanCommand == null) {
            if (this.parent != null) {
                return this.parent.getCleanCommand();
            }
            if (Platform.getOS().equals("win32")) {
                return new String("del");
            }
            return new String("rm");
        }
        return this.cleanCommand;
    }

    public String getDescription() {
        if (this.description == null) {
            if (this.parent != null) {
                return this.parent.getDescription();
            }
            return EMPTY_STRING;
        }
        return this.description;
    }

    public String getErrorParserIds() {
        if (this.errorParserIds != null) {
            return this.errorParserIds;
        }
        String errorParsers = null;
        if (this.parent != null) {
            errorParsers = this.parent.getErrorParserIds();
        }
        if (errorParsers == null && this.rootFolderInfo != null) {
            errorParsers = this.rootFolderInfo.getErrorParserIds();
        }
        return errorParsers;
    }

    public String getErrorParserIdsAttribute() {
        if (this.errorParserIds != null) {
            return this.errorParserIds;
        }
        String errorParsers = null;
        if (this.parent != null) {
            errorParsers = ((Configuration)this.parent).getErrorParserIdsAttribute();
        }
        return errorParsers;
    }

    public String[] getErrorParserList() {
        Set set = this.contributeErrorParsers(null, true);
        if (set != null) {
            String[] result = new String[set.size()];
            set.toArray(result);
            return result;
        }
        return CCorePlugin.getDefault().getAllErrorParsersIDs();
    }

    public Set contributeErrorParsers(Set set, boolean includeChildren) {
        String parserIDs = this.getErrorParserIdsAttribute();
        if (parserIDs != null) {
            if (set == null) {
                set = new HashSet<String>();
            }
            if (parserIDs.length() != 0) {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                while (tok.hasMoreElements()) {
                    set.add(tok.nextToken());
                }
            }
        }
        if (includeChildren) {
            IResourceInfo[] rcInfos = this.getResourceInfos();
            int i = 0;
            while (i < rcInfos.length) {
                ResourceInfo rcInfo = (ResourceInfo)rcInfos[i];
                set = rcInfo.contributeErrorParsers(set);
                ++i;
            }
        }
        return set;
    }

    public void setArtifactExtension(String extension) {
        if (extension == null && this.artifactExtension == null) {
            return;
        }
        if (this.artifactExtension == null || extension == null || !this.artifactExtension.equals(extension)) {
            this.artifactExtension = extension;
            if (!this.isExtensionElement()) {
                ITool tool = this.calculateTargetTool();
                if (tool != null) {
                    tool.setRebuildState(true);
                } else {
                    this.setRebuildState(true);
                }
            }
            this.isDirty = true;
        }
    }

    public void setArtifactName(String name) {
        if (name == null && this.artifactName == null) {
            return;
        }
        if (this.artifactName == null || name == null || !this.artifactName.equals(name)) {
            this.artifactName = name;
            if (!this.isExtensionElement()) {
                ITool tool = this.calculateTargetTool();
                if (tool != null) {
                    tool.setRebuildState(true);
                } else {
                    this.setRebuildState(true);
                }
            }
            this.isDirty = true;
        }
    }

    public void setErrorParserIds(String ids) {
        String currentIds = this.getErrorParserIds();
        if (ids == null && currentIds == null) {
            return;
        }
        if (currentIds == null || ids == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    public void setCleanCommand(String command) {
        if (command == null && this.cleanCommand == null) {
            return;
        }
        if (this.cleanCommand == null || command == null || !this.cleanCommand.equals(command)) {
            this.cleanCommand = command;
            this.isDirty = true;
        }
    }

    public void setDescription(String description) {
        if (description == null && this.description == null) {
            return;
        }
        if (this.description == null || description == null || !description.equals(this.description)) {
            this.description = description;
            this.isDirty = true;
        }
    }

    public void setBuildArguments(String makeArgs) {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (makeArgs == null) {
            if (!builder.isExtensionElement()) {
                builder.setArguments(makeArgs);
            }
        } else if (!makeArgs.equals(builder.getArguments())) {
            if (builder.isExtensionElement()) {
                String subId = ManagedBuildManager.calculateChildId(builder.getId(), null);
                String builderName = String.valueOf(builder.getName()) + "." + this.getName();
                builder = this.getToolChain().createBuilder(builder, subId, builderName, false);
            }
            builder.setArguments(makeArgs);
        }
    }

    public void setBuildCommand(String command) {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (command == null) {
            if (!builder.isExtensionElement()) {
                builder.setCommand(command);
            }
        } else if (!command.equals(builder.getCommand())) {
            if (builder.isExtensionElement()) {
                String subId = ManagedBuildManager.calculateChildId(builder.getId(), null);
                String builderName = String.valueOf(builder.getName()) + "." + this.getName();
                builder = this.getToolChain().createBuilder(builder, subId, builderName, false);
            }
            builder.setCommand(command);
        }
    }

    public void setPrebuildStep(String step) {
        if (step == null && this.prebuildStep == null) {
            return;
        }
        if (this.prebuildStep == null || step == null || !this.prebuildStep.equals(step)) {
            this.prebuildStep = step;
            this.isDirty = true;
        }
    }

    public void setPostbuildStep(String step) {
        if (step == null && this.postbuildStep == null) {
            return;
        }
        if (this.postbuildStep == null || step == null || !this.postbuildStep.equals(step)) {
            this.postbuildStep = step;
            this.isDirty = true;
        }
    }

    public void setPreannouncebuildStep(String announceStep) {
        if (announceStep == null && this.preannouncebuildStep == null) {
            return;
        }
        if (this.preannouncebuildStep == null || announceStep == null || !this.preannouncebuildStep.equals(announceStep)) {
            this.preannouncebuildStep = announceStep;
            this.isDirty = true;
        }
    }

    public void setPostannouncebuildStep(String announceStep) {
        if (announceStep == null && this.postannouncebuildStep == null) {
            return;
        }
        if (this.postannouncebuildStep == null || announceStep == null || !this.postannouncebuildStep.equals(announceStep)) {
            this.postannouncebuildStep = announceStep;
            this.isDirty = true;
        }
    }

    public boolean isSupported() {
        IFolderInfo foInfo = this.getRootFolderInfo();
        if (foInfo != null) {
            return foInfo.isSupported();
        }
        return false;
    }

    public boolean isHeaderFile(String ext) {
        return this.getRootFolderInfo().isHeaderFile(ext);
    }

    public boolean isExtensionElement() {
        return this.isExtensionConfig;
    }

    public boolean isDirty() {
        if (this.isExtensionConfig) {
            return false;
        }
        if (this.isDirty) {
            return true;
        }
        IResourceInfo[] infos = this.rcInfos.getResourceInfos();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].isDirty()) {
                return true;
            }
            ++i;
        }
        return this.isDirty;
    }

    public boolean needsRebuild() {
        return this.needsRebuild(true);
    }

    public boolean needsFullRebuild() {
        return this.needsRebuild(false);
    }

    public boolean needsRebuild(boolean checkChildren) {
        boolean needRebuild;
        boolean bl = needRebuild = this.rebuildNeeded || this.resourceChangesRequireRebuild();
        if (needRebuild || !checkChildren) {
            return needRebuild;
        }
        IResourceInfo[] infos = this.rcInfos.getResourceInfos();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].needsRebuild()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            IResourceInfo[] infos = this.rcInfos.getResourceInfos();
            int i = 0;
            while (i < infos.length) {
                infos[i].setDirty(false);
                ++i;
            }
        }
    }

    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionElement() && rebuild) {
            return;
        }
        if (this.rebuildNeeded != rebuild) {
            this.rebuildNeeded = rebuild;
            this.saveRebuildState();
        }
        if (!this.rebuildNeeded) {
            this.setResourceChangeState(0);
            IResourceInfo[] infos = this.rcInfos.getResourceInfos();
            int i = 0;
            while (i < infos.length) {
                infos[i].setRebuildState(false);
                ++i;
            }
        }
    }

    public boolean hasOverriddenBuildCommand() {
        IBuilder superB;
        IBuilder builder = this.getToolChain().getBuilder();
        if (builder != null && (superB = builder.getSuperClass()) != null) {
            String superA;
            String superC;
            String command = builder.getCommand();
            if (command != null && (superC = superB.getCommand()) != null && !command.equals(superC)) {
                return true;
            }
            String args = builder.getArguments();
            if (args != null && (superA = superB.getArguments()) != null && !args.equals(superA)) {
                return true;
            }
        }
        return false;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceInfo[] infos = (ResourceInfo[])this.rcInfos.getResourceInfos(clazz);
            int i = 0;
            while (i < infos.length) {
                infos[i].resolveReferences();
                ++i;
            }
            if (this.parentId != null) {
                this.parent = ManagedBuildManager.getExtensionConfiguration(this.parentId);
            }
        }
    }

    public void reset() {
        ((FolderInfo)this.getRootFolderInfo()).resetOptionSettings();
    }

    public IResourceConfiguration createResourceConfiguration(IFile file) {
        return this.createFileInfo(file.getFullPath().removeFirstSegments(1));
    }

    public IFileInfo createFileInfo(IPath path) {
        String resourceName = path.lastSegment();
        String id = ManagedBuildManager.calculateChildId(this.getId(), path.toString());
        return this.createFileInfo(path, id, resourceName);
    }

    public IFileInfo createFileInfo(IPath path, String id, String name) {
        IResourceInfo info = this.getResourceInfo(path, false);
        IFileInfo fileInfo = null;
        if (info instanceof IFileInfo) {
            fileInfo = (IFileInfo)info;
        } else if (info instanceof IFolderInfo) {
            IFolderInfo base = (IFolderInfo)info;
            fileInfo = this.createFileInfo(path, base, null, id, name);
        }
        return fileInfo;
    }

    public IFileInfo createFileInfo(IPath path, IFolderInfo base, ITool baseTool, String id, String name) {
        if (base.getPath().equals((Object)path)) {
            return null;
        }
        ResourceConfiguration fileInfo = new ResourceConfiguration((FolderInfo)base, baseTool, id, name, path);
        this.addResourceConfiguration(fileInfo);
        ManagedBuildManager.performValueHandlerEvent(fileInfo, 1);
        return fileInfo;
    }

    public IFileInfo createFileInfo(IPath path, IFileInfo base, String id, String name) {
        if (base.getPath().equals((Object)path)) {
            return null;
        }
        ResourceConfiguration fileInfo = new ResourceConfiguration((ResourceConfiguration)base, path, id, name);
        this.addResourceConfiguration(fileInfo);
        ManagedBuildManager.performValueHandlerEvent(fileInfo, 1);
        return fileInfo;
    }

    public IConfigurationEnvironmentVariableSupplier getEnvironmentVariableSupplier() {
        IToolChain toolChain = this.getToolChain();
        if (toolChain != null) {
            return toolChain.getEnvironmentVariableSupplier();
        }
        return null;
    }

    public PluginVersionIdentifier getVersion() {
        if (this.version == null && this.rootFolderInfo.getToolChain() != null) {
            return this.rootFolderInfo.getToolChain().getVersion();
        }
        return this.version;
    }

    public void setVersion(PluginVersionIdentifier version) {
    }

    public IConfigurationBuildMacroSupplier getBuildMacroSupplier() {
        IToolChain toolChain = this.getToolChain();
        if (toolChain != null) {
            return toolChain.getBuildMacroSupplier();
        }
        return null;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void updateManagedBuildRevision(String revision) {
        super.updateManagedBuildRevision(revision);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ResourceInfo[] infos = (ResourceInfo[])this.rcInfos.getResourceInfos(clazz);
        int i = 0;
        while (i < infos.length) {
            infos[i].updateManagedBuildRevision(revision);
            ++i;
        }
    }

    public void setParent(IConfiguration parent) {
        if (this.parent != parent) {
            this.parent = parent;
            if (!this.isExtensionElement()) {
                this.setDirty(true);
            }
        }
    }

    public ITool calculateTargetTool() {
        ITool tool = this.getTargetTool();
        if (tool == null) {
            tool = this.getToolFromOutputExtension(this.getArtifactExtension());
        }
        if (tool == null) {
            IConfiguration extCfg = this;
            while (extCfg != null && !extCfg.isExtensionElement()) {
                extCfg = extCfg.getParent();
            }
            if (extCfg != null) {
                tool = this.getToolFromOutputExtension(extCfg.getArtifactExtension());
            }
        }
        return tool;
    }

    public ITool getToolFromOutputExtension(String extension) {
        return this.getRootFolderInfo().getToolFromOutputExtension(extension);
    }

    public ITool getToolFromInputExtension(String sourceExtension) {
        return this.getRootFolderInfo().getToolFromInputExtension(sourceExtension);
    }

    public void addResourceChangeState(int state) {
        this.setResourceChangeState(state | this.resourceChangeState);
    }

    private void setResourceChangeState(int state) {
        if (this.resourceChangeState != state) {
            this.resourceChangeState = state;
            this.saveResourceChangeState();
        }
    }

    private boolean resourceChangesRequireRebuild() {
        return this.isInternalBuilderEnabled() ? this.resourceChangeState != 0 : (this.resourceChangeState & 2) == 2;
    }

    private void saveRebuildState() {
        PropertyManager.getInstance().setProperty(this, REBUILD_STATE, Boolean.toString(this.rebuildNeeded));
    }

    private void saveResourceChangeState() {
        PropertyManager.getInstance().setProperty(this, RC_CHANGE_STATE, Integer.toString(this.resourceChangeState));
    }

    public void enableInternalBuilder(boolean enable) {
        if (enable == this.isInternalBuilderEnabled()) {
            return;
        }
        IBuilder builder = this.getBuilderForInternalBuilderEnablement(enable, true);
        if (builder != null) {
            if (enable) {
                this.savePrevBuilderId(this.getBuilder());
            }
            this.changeBuilder(builder, ManagedBuildManager.calculateChildId(builder.getId(), null), builder.getName(), true);
            if (enable) {
                try {
                    this.setManagedBuildOn(true);
                }
                catch (BuildException buildException) {}
            }
        }
    }

    public boolean canEnableInternalBuilder(boolean enable) {
        return this.getBuilderForInternalBuilderEnablement(enable, true) != null;
    }

    /*
     * Unable to fully structure code
     */
    private IBuilder getBuilderForInternalBuilderEnablement(boolean enable, boolean checkCompatibility) {
        block6: {
            block5: {
                newBuilder = null;
                if (!enable) break block5;
                if (this.supportsBuild(true, false) && (b = ManagedBuildManager.getInternalBuilder()) != null && (!checkCompatibility || this.isBuilderCompatible(b))) {
                    newBuilder = b;
                }
                break block6;
            }
            id = this.getPrevBuilderId();
            if (id != null && (b = ManagedBuildManager.getExtensionBuilder(id)) != null && (!checkCompatibility || this.isBuilderCompatible(b))) {
                newBuilder = b;
            }
            if (newBuilder != null) break block6;
            tc = this.getToolChain();
            while (tc != null) {
                block7: {
                    b = tc.getBuilder();
                    if (!b.isInternalBuilder()) ** GOTO lbl17
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        b = b.getSuperClass();
lbl17:
                        // 2 sources

                        ** while (b != null && !b.isExtensionElement())
                    }
lbl18:
                    // 1 sources

                    if (b != null && (!checkCompatibility || this.isBuilderCompatible(b))) {
                        newBuilder = b;
                        break;
                    }
                }
                tc = tc.getSuperClass();
            }
        }
        return newBuilder;
    }

    private void savePrevBuilderId(IBuilder builder) {
        ToolChain tc;
        IBuilder b = builder;
        while (b != null && !b.isExtensionElement()) {
            b = b.getSuperClass();
        }
        if (b == null) {
            b = builder;
        }
        if ((tc = (ToolChain)this.getToolChain()) != null) {
            tc.setNonInternalBuilderId(b.getId());
        }
    }

    private String getPrevBuilderId() {
        ToolChain tc = (ToolChain)this.getToolChain();
        if (tc != null) {
            return tc.getNonInternalBuilderId();
        }
        return null;
    }

    public boolean isInternalBuilderEnabled() {
        return this.getBuilder().isInternalBuilder();
    }

    public void setInternalBuilderIgnoreErr(boolean ignore) {
        try {
            this.getEditableBuilder().setStopOnError(!ignore);
        }
        catch (CoreException coreException) {}
    }

    public boolean getInternalBuilderIgnoreErr() {
        return !this.getBuilder().isStopOnError();
    }

    public void setInternalBuilderParallel(boolean parallel) {
        if (this.getInternalBuilderParallel() == parallel) {
            return;
        }
        try {
            this.getEditableBuilder().setParallelBuildOn(parallel);
        }
        catch (CoreException coreException) {}
    }

    public boolean getInternalBuilderParallel() {
        return this.getBuilder().isParallelBuildOn();
    }

    public void setParallelDef(boolean parallel_def) {
        if (this.getParallelDef() == parallel_def) {
            return;
        }
        int num = this.getParallelNumber();
        if (num != 0) {
            this.setParallelNumber(-num);
        } else if (parallel_def) {
            this.setParallelNumber(-1);
        } else {
            this.setParallelNumber(1);
        }
    }

    public boolean getParallelDef() {
        int num = this.getBuilder().getParallelizationNum();
        return num <= 0;
    }

    public void setParallelNumber(int n) {
        try {
            this.getEditableBuilder().setParallelizationNum(n);
        }
        catch (CoreException coreException) {}
    }

    public int getParallelNumber() {
        return this.getBuilder().getParallelizationNum();
    }

    private Preferences getPreferences(String name) {
        if (this.isTemporary) {
            return null;
        }
        IProject project = (IProject)this.getOwner();
        if (project == null || !project.exists() || !project.isOpen()) {
            return null;
        }
        IEclipsePreferences prefs = new ProjectScope(project).getNode(ManagedBuilderCorePlugin.getUniqueIdentifier());
        if (prefs != null && (prefs = prefs.node(this.getId())) != null && name != null) {
            prefs = prefs.node(name);
        }
        return prefs;
    }

    public IResourceInfo[] getResourceInfos() {
        return this.rcInfos.getResourceInfos();
    }

    public IResourceInfo getResourceInfo(IPath path, boolean exactPath) {
        return this.rcInfos.getResourceInfo(path, exactPath);
    }

    public IResourceInfo getResourceInfoById(String id) {
        IResourceInfo[] infos = this.rcInfos.getResourceInfos();
        int i = 0;
        while (i < infos.length) {
            if (id.equals(infos[i].getId())) {
                return infos[i];
            }
            ++i;
        }
        return null;
    }

    public IFolderInfo getRootFolderInfo() {
        return this.rootFolderInfo;
    }

    ResourceInfoContainer getRcInfoContainer(IResourceInfo rcInfo) {
        PathSettingsContainer cr = this.pathSettings.getChildContainer(rcInfo.getPath(), true, true);
        return new ResourceInfoContainer(cr, false);
    }

    public CConfigurationData getConfigurationData() {
        return this.fCfgData;
    }

    public void removeResourceInfo(IPath path) {
        IResourceInfo info = this.getResourceInfo(path, true);
        if (info != null) {
            this.removeResourceConfiguration(info);
        }
    }

    public IFolderInfo createFolderInfo(IPath path) {
        String resourceName = path.lastSegment();
        String id = ManagedBuildManager.calculateChildId(this.getId(), path.toString());
        return this.createFolderInfo(path, id, resourceName);
    }

    public IFolderInfo createFolderInfo(IPath path, String id, String name) {
        IResourceInfo info = this.getResourceInfo(path, false);
        IFolderInfo folderInfo = null;
        if (info instanceof IFileInfo) {
            folderInfo = null;
        } else if (info instanceof IFolderInfo) {
            IFolderInfo base = (IFolderInfo)info;
            folderInfo = this.createFolderInfo(path, base, id, name);
        }
        return folderInfo;
    }

    public IFolderInfo createFolderInfo(IPath path, IFolderInfo base, String id, String name) {
        if (base.getPath().equals((Object)path)) {
            return null;
        }
        FolderInfo folderInfo = new FolderInfo((FolderInfo)base, id, name, path);
        this.addResourceConfiguration(folderInfo);
        folderInfo.propertiesChanged();
        ManagedBuildManager.performValueHandlerEvent(folderInfo, 1);
        return folderInfo;
    }

    public ICSourceEntry[] getSourceEntries() {
        if (this.sourceEntries == null) {
            if (this.parent != null) {
                return this.parent.getSourceEntries();
            }
            return new ICSourceEntry[]{new CSourceEntry((IPath)Path.EMPTY, null, 24)};
        }
        return (ICSourceEntry[])this.sourceEntries.clone();
    }

    public void setSourceEntries(ICSourceEntry[] entries) {
        this.setSourceEntries(entries, true);
    }

    public void setSourceEntries(ICSourceEntry[] entries, boolean setRebuildState) {
        if (Arrays.equals(this.getSourceEntries(), entries)) {
            return;
        }
        this.sourceEntries = entries != null ? (ICSourceEntry[])entries.clone() : null;
        this.exportArtifactInfo();
        if (setRebuildState) {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public void setErrorParserAttribute(String[] ids) {
        if (ids == null) {
            this.errorParserIds = null;
        } else if (ids.length == 0) {
            this.errorParserIds = EMPTY_STRING;
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append(ids[0]);
            int i = 1;
            while (i < ids.length) {
                buf.append(";").append(ids[i]);
                ++i;
            }
            this.errorParserIds = buf.toString();
        }
    }

    public void setErrorParserList(String[] ids) {
        if (ids == null) {
            this.resetErrorParsers();
        } else {
            this.resetErrorParsers();
            HashSet oldSet = this.contributeErrorParsers(null, true);
            if (oldSet == null) {
                oldSet = new HashSet();
            }
            HashSet<String> newSet = new HashSet<String>();
            newSet.addAll(Arrays.asList(ids));
            newSet.remove(null);
            HashSet newCopy = (HashSet)newSet.clone();
            newSet.removeAll(oldSet);
            oldSet.removeAll(newCopy);
            HashSet removed = oldSet;
            HashSet<String> added = newSet;
            this.removeErrorParsers(removed);
            this.setErrorParserAttribute(added.toArray(new String[added.size()]));
        }
    }

    public void resetErrorParsers() {
        this.errorParserIds = null;
        IResourceInfo[] rcInfos = this.getResourceInfos();
        int i = 0;
        while (i < rcInfos.length) {
            ResourceInfo rcInfo = (ResourceInfo)rcInfos[i];
            rcInfo.resetErrorParsers();
            ++i;
        }
    }

    void removeErrorParsers(Set set) {
        HashSet oldSet = this.contributeErrorParsers(null, false);
        if (oldSet == null) {
            oldSet = new HashSet();
        }
        oldSet.removeAll(set);
        this.setErrorParserAttribute(oldSet.toArray(new String[oldSet.size()]));
        IResourceInfo[] rcInfos = this.getResourceInfos();
        int i = 0;
        while (i < rcInfos.length) {
            ResourceInfo rcInfo = (ResourceInfo)rcInfos[i];
            rcInfo.removeErrorParsers(set);
            ++i;
        }
    }

    public CBuildData getBuildData() {
        return this.getEditableBuilder().getBuildData();
    }

    public IBuilder getEditableBuilder() {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (builder.isExtensionElement()) {
            String subId = ManagedBuildManager.calculateChildId(builder.getId(), null);
            String builderName = String.valueOf(builder.getName()) + "." + this.getName();
            builder = this.getToolChain().createBuilder(builder, subId, builderName, false);
        }
        return builder;
    }

    public IBuilder getBuilder() {
        return this.getToolChain().getBuilder();
    }

    public String getOutputPrefix(String outputExtension) {
        String ext = outputExtension == null ? new String() : outputExtension;
        String flags = new String();
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                flags = tool.getOutputPrefix();
            }
            ++index;
        }
        return flags;
    }

    public ICConfigurationDescription getConfigurationDescription() {
        return this.fCfgDes;
    }

    public void setConfigurationDescription(ICConfigurationDescription cfgDes) {
        this.fCfgDes = cfgDes;
    }

    public IBuildObjectProperties getBuildProperties() {
        if (this.buildProperties == null) {
            BuildObjectProperties parentProps = this.findBuildProperties();
            this.buildProperties = parentProps != null ? new BuildObjectProperties(parentProps, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this) : new BuildObjectProperties(this, this);
        }
        return this.buildProperties;
    }

    private BuildObjectProperties findBuildProperties() {
        if (this.buildProperties == null) {
            if (this.parent != null) {
                return ((Configuration)this.parent).findBuildProperties();
            }
            return null;
        }
        return this.buildProperties;
    }

    public boolean supportsType(IBuildPropertyType type) {
        return this.supportsType(type.getId());
    }

    public boolean supportsValue(IBuildPropertyType type, IBuildPropertyValue value) {
        return this.supportsValue(type.getId(), value.getId());
    }

    public void propertiesChanged() {
        if (this.isExtensionConfig) {
            return;
        }
        BooleanExpressionApplicabilityCalculator calculator = this.getBooleanExpressionCalculator();
        if (calculator != null) {
            calculator.adjustConfiguration(this, false);
        }
        IResourceInfo[] infos = this.getResourceInfos();
        int i = 0;
        while (i < infos.length) {
            ((ResourceInfo)infos[i]).propertiesChanged();
            ++i;
        }
    }

    public BooleanExpressionApplicabilityCalculator getBooleanExpressionCalculator() {
        if (this.booleanExpressionCalculator == null && this.parent != null) {
            return ((Configuration)this.parent).getBooleanExpressionCalculator();
        }
        return this.booleanExpressionCalculator;
    }

    public boolean isSystemObject() {
        if (this.isTest) {
            return true;
        }
        if (this.getProjectType() != null) {
            return this.getProjectType().isSystemObject();
        }
        return false;
    }

    public String getOutputExtension(String resourceExtension) {
        return this.getRootFolderInfo().getOutputExtension(resourceExtension);
    }

    public String getOutputFlag(String outputExt) {
        String ext = outputExt == null ? new String() : outputExt;
        String flags = new String();
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                flags = tool.getOutputFlag();
            }
            ++index;
        }
        return flags;
    }

    public IManagedCommandLineInfo generateToolCommandLineInfo(String sourceExtension, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, IPath inputLocation, IPath outputLocation) {
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.buildsFileType(sourceExtension)) {
                String cmd = tool.getToolCommand();
                try {
                    String resolvedCommand = null;
                    resolvedCommand = inputLocation != null && inputLocation.toString().indexOf(" ") != -1 || outputLocation != null && outputLocation.toString().indexOf(" ") != -1 ? ManagedBuildManager.getBuildMacroProvider().resolveValue(cmd, EMPTY_STRING, " ", 1, new FileContextData(inputLocation, outputLocation, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(cmd, EMPTY_STRING, " ", 1, new FileContextData(inputLocation, outputLocation, null, tool));
                    resolvedCommand = resolvedCommand.trim();
                    if (resolvedCommand.length() > 0) {
                        cmd = resolvedCommand;
                    }
                }
                catch (BuildMacroException buildMacroException) {}
                IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
                return gen.generateCommandLineInfo(tool, cmd, flags, outputFlag, outputPrefix, outputName, inputResources, tool.getCommandLinePattern());
            }
            ++index;
        }
        return null;
    }

    public String[] getUserObjects(String extension) {
        Vector<String> objs = new Vector<String>();
        ITool tool = this.calculateTargetTool();
        if (tool == null) {
            tool = this.getToolFromOutputExtension(extension);
        }
        if (tool != null) {
            IOption[] opts = tool.getOptions();
            int i = 0;
            while (i < opts.length) {
                block9: {
                    IOption option = opts[i];
                    try {
                        String[] unresolved;
                        if (option.getValueType() != 7 || (unresolved = option.getUserObjects()) == null || unresolved.length <= 0) break block9;
                        int k = 0;
                        while (k < unresolved.length) {
                            try {
                                String[] resolved = ManagedBuildManager.getBuildMacroProvider().resolveStringListValueToMakefileFormat(unresolved[k], EMPTY_STRING, " ", 2, new OptionContextData(option, tool));
                                if (resolved != null && resolved.length > 0) {
                                    objs.addAll(Arrays.asList(resolved));
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            ++k;
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++i;
            }
        }
        return objs.toArray(new String[objs.size()]);
    }

    public String[] getLibs(String extension) {
        Vector<String> libs = new Vector<String>();
        ITool tool = this.calculateTargetTool();
        if (tool == null) {
            tool = this.getToolFromOutputExtension(extension);
        }
        if (tool != null) {
            IOption[] opts = tool.getOptions();
            int i = 0;
            while (i < opts.length) {
                block11: {
                    IOption option = opts[i];
                    try {
                        IOptionApplicability applicabilitytCalculator;
                        if (option.getValueType() != 6 || (applicabilitytCalculator = option.getApplicabilityCalculator()) != null && !applicabilitytCalculator.isOptionUsedInCommandLine(this, tool, option)) break block11;
                        String command = option.getCommand();
                        String[] allLibs = option.getLibraries();
                        int j = 0;
                        while (j < allLibs.length) {
                            try {
                                String[] resolved = ManagedBuildManager.getBuildMacroProvider().resolveStringListValueToMakefileFormat(allLibs[j], EMPTY_STRING, " ", 2, new OptionContextData(option, tool));
                                if (resolved != null && resolved.length > 0) {
                                    int k = 0;
                                    while (k < resolved.length) {
                                        String string = resolved[k];
                                        if (string.length() > 0) {
                                            libs.add(String.valueOf(command) + string);
                                        }
                                        ++k;
                                    }
                                }
                            }
                            catch (BuildMacroException buildMacroException) {}
                            ++j;
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++i;
            }
        }
        return libs.toArray(new String[libs.size()]);
    }

    public boolean buildsFileType(String srcExt) {
        return this.getRootFolderInfo().buildsFileType(srcExt);
    }

    public void exportArtifactInfo() {
        ICConfigurationDescription des;
        String valueId;
        if (this.isExtensionConfig) {
            return;
        }
        IBuildObjectProperties props = this.getBuildProperties();
        IBuildProperty prop = props.getProperty("org.eclipse.cdt.build.core.buildArtefactType");
        if (prop != null && ("org.eclipse.cdt.build.core.buildArtefactType.sharedLib".equals(valueId = prop.getValue().getId()) || "org.eclipse.cdt.build.core.buildArtefactType.staticLib".equals(valueId)) && (des = ManagedBuildManager.getDescriptionForConfiguration(this)) != null && !des.isReadOnly()) {
            ICOutputEntry[] entries = this.getConfigurationData().getBuildData().getOutputDirectories();
            IPath path = this.getOwner().getFullPath();
            ArrayList<Object> list = new ArrayList<Object>(entries.length + 1);
            list.add(new CIncludePathEntry(path.toString(), 8));
            entries = CDataUtil.resolveEntries((ICOutputEntry[])entries, (ICConfigurationDescription)des);
            int i = 0;
            while (i < entries.length) {
                ICOutputEntry out = entries[i];
                String value = out.getValue();
                Path p = new Path(value);
                if (!p.isAbsolute()) {
                    value = this.getOwner().getFullPath().append(value).toString();
                }
                CLibraryPathEntry lib = new CLibraryPathEntry(value, out.getFlags() & 0xFFFFFFEF);
                list.add(lib);
                ++i;
            }
            des.createExternalSetting(null, null, null, (ICSettingEntry[])list.toArray(new ICLanguageSettingEntry[list.size()]));
        }
    }

    public boolean supportsBuild(boolean managed) {
        return this.supportsBuild(managed, true);
    }

    public boolean supportsBuild(boolean managed, boolean checkBuilder) {
        IBuilder builder;
        IResourceInfo[] rcs = this.getResourceInfos();
        int i = 0;
        while (i < rcs.length) {
            if (!rcs[i].supportsBuild(managed)) {
                return false;
            }
            ++i;
        }
        return !checkBuilder || (builder = this.getBuilder()) == null || builder.supportsBuild(managed);
    }

    public boolean supportsType(String typeId) {
        SupportedProperties props = this.findSupportedProperties();
        boolean supports = false;
        if (props != null) {
            supports = props.supportsType(typeId);
        }
        if (!supports) {
            supports = ((ToolChain)this.getToolChain()).supportsType(typeId);
        }
        return supports;
    }

    public boolean supportsValue(String typeId, String valueId) {
        SupportedProperties props = this.findSupportedProperties();
        boolean supports = false;
        if (props != null) {
            supports = props.supportsValue(typeId, valueId);
        }
        if (!supports) {
            supports = ((ToolChain)this.getToolChain()).supportsValue(typeId, valueId);
        }
        return supports;
    }

    private SupportedProperties findSupportedProperties() {
        if (this.supportedProperties == null && this.parent != null) {
            return ((Configuration)this.parent).findSupportedProperties();
        }
        return this.supportedProperties;
    }

    private void loadProperties(IManagedConfigElement el) {
        this.supportedProperties = new SupportedProperties(el);
    }

    public String[] getRequiredTypeIds() {
        SupportedProperties props = this.findSupportedProperties();
        ArrayList<String> list = new ArrayList<String>();
        if (props != null) {
            list.addAll(Arrays.asList(props.getRequiredTypeIds()));
        }
        list.addAll(Arrays.asList(((ToolChain)this.getToolChain()).getRequiredTypeIds()));
        return list.toArray(new String[list.size()]);
    }

    public String[] getSupportedTypeIds() {
        SupportedProperties props = this.findSupportedProperties();
        ArrayList<String> list = new ArrayList<String>();
        if (props != null) {
            list.addAll(Arrays.asList(props.getSupportedTypeIds()));
        }
        list.addAll(Arrays.asList(((ToolChain)this.getToolChain()).getSupportedTypeIds()));
        return list.toArray(new String[list.size()]);
    }

    public String[] getSupportedValueIds(String typeId) {
        SupportedProperties props = this.findSupportedProperties();
        ArrayList<String> list = new ArrayList<String>();
        if (props != null) {
            list.addAll(Arrays.asList(props.getSupportedValueIds(typeId)));
        }
        list.addAll(Arrays.asList(((ToolChain)this.getToolChain()).getSupportedValueIds(typeId)));
        return list.toArray(new String[list.size()]);
    }

    public boolean requiresType(String typeId) {
        SupportedProperties props = this.findSupportedProperties();
        boolean requires = false;
        if (props != null) {
            requires = props.requiresType(typeId);
        }
        if (!requires) {
            requires = ((ToolChain)this.getToolChain()).requiresType(typeId);
        }
        return requires;
    }

    public boolean isManagedBuildOn() {
        return this.getBuilder().isManagedBuildOn();
    }

    public void setManagedBuildOn(boolean on) throws BuildException {
        try {
            this.getEditableBuilder().setManagedBuildOn(on);
        }
        catch (CoreException e) {
            throw new BuildException(e.getLocalizedMessage());
        }
    }

    public void changeBuilder(IBuilder newBuilder, String id, String name) {
        this.changeBuilder(newBuilder, id, name, false);
    }

    public void changeBuilder(IBuilder newBuilder, String id, String name, boolean allBuildSettings) {
        ToolChain tc = (ToolChain)this.getToolChain();
        Builder cur = (Builder)this.getEditableBuilder();
        Builder newCfgBuilder = null;
        if (newBuilder.getParent() == tc) {
            newCfgBuilder = (Builder)newBuilder;
        } else {
            IBuilder curReal = ManagedBuildManager.getRealBuilder(cur);
            IBuilder newReal = ManagedBuildManager.getRealBuilder(newBuilder);
            if (newReal != curReal) {
                IBuilder extBuilder = newBuilder;
                while (extBuilder != null && !extBuilder.isExtensionElement()) {
                    extBuilder = extBuilder.getSuperClass();
                }
                if (extBuilder == null) {
                    extBuilder = newBuilder;
                }
                newCfgBuilder = new Builder(tc, extBuilder, id, name, false);
                newCfgBuilder.copySettings(cur, allBuildSettings);
            }
        }
        if (newCfgBuilder != null) {
            tc.setBuilder(newCfgBuilder);
        }
    }

    public boolean isBuilderCompatible(IBuilder builder) {
        return builder.supportsBuild(this.isManagedBuildOn());
    }

    ITool findToolById(String id) {
        IResourceInfo[] rcInfos = this.getResourceInfos();
        ITool tool = null;
        int i = 0;
        while (i < rcInfos.length) {
            ResourceInfo info = (ResourceInfo)rcInfos[i];
            tool = info.getToolById(id);
            if (tool != null) break;
            ++i;
        }
        return tool;
    }

    void resolveProjectReferences(boolean onLoad) {
        IResourceInfo[] rcInfos = this.getResourceInfos();
        int i = 0;
        while (i < rcInfos.length) {
            ResourceInfo info = (ResourceInfo)rcInfos[i];
            info.resolveProjectReferences(onLoad);
            ++i;
        }
    }

    public boolean isPerRcTypeDiscovery() {
        ToolChain tc = (ToolChain)this.getRootFolderInfo().getToolChain();
        return tc.isPerRcTypeDiscovery();
    }

    public void setPerRcTypeDiscovery(boolean on) {
        ToolChain tc = (ToolChain)this.getRootFolderInfo().getToolChain();
        tc.setPerRcTypeDiscovery(on);
    }

    public CfgDiscoveredPathManager.PathInfoCache setDiscoveredPathInfo(CfgDiscoveredPathManager.PathInfoCache info) {
        ToolChain tc = (ToolChain)this.getRootFolderInfo().getToolChain();
        return tc.setDiscoveredPathInfo(info);
    }

    public CfgDiscoveredPathManager.PathInfoCache getDiscoveredPathInfo() {
        ToolChain tc = (ToolChain)this.getRootFolderInfo().getToolChain();
        return tc.getDiscoveredPathInfo();
    }

    public String getDiscoveryProfileId() {
        ToolChain tc = (ToolChain)this.getRootFolderInfo().getToolChain();
        return tc.getScannerConfigDiscoveryProfileId();
    }

    public CfgDiscoveredPathManager.PathInfoCache clearDiscoveredPathInfo() {
        ToolChain tc = (ToolChain)this.getRootFolderInfo().getToolChain();
        return tc.clearDiscoveredPathInfo();
    }

    public ICfgScannerConfigBuilderInfo2Set getCfgScannerConfigInfo() {
        return this.cfgScannerInfo;
    }

    public void setCfgScannerConfigInfo(ICfgScannerConfigBuilderInfo2Set info) {
        this.cfgScannerInfo = info;
    }

    public void clearCachedData() {
        this.cfgScannerInfo = null;
    }

    public boolean isPreference() {
        return this.isPreferenceConfig;
    }

    public IBuildPropertyValue getBuildArtefactType() {
        IBuildProperty prop;
        BuildObjectProperties props = this.findBuildProperties();
        if (props != null && (prop = props.getProperty("org.eclipse.cdt.build.core.buildArtefactType")) != null) {
            return prop.getValue();
        }
        return null;
    }

    public void setBuildArtefactType(String id) throws BuildException {
        IBuildObjectProperties props = this.getBuildProperties();
        try {
            props.setProperty("org.eclipse.cdt.build.core.buildArtefactType", id);
        }
        catch (CoreException e) {
            throw new BuildException(e.getLocalizedMessage());
        }
    }

    boolean isExcluded(IPath path) {
        ICSourceEntry[] entries = this.getSourceEntries();
        return CDataUtil.isExcluded((IPath)path, (ICSourceEntry[])entries);
    }

    void setExcluded(IPath path, boolean isFolder, boolean excluded) {
        if (this.excludeList == null) {
            ICSourceEntry[] newEntries = this.getUpdatedEntries(path, isFolder, excluded);
            if (newEntries != null) {
                this.setSourceEntries(newEntries, false);
            }
        } else if (excluded) {
            this.excludeList.add(path);
        }
    }

    private ICSourceEntry[] getUpdatedEntries(IPath path, boolean isFolder, boolean excluded) {
        try {
            ICSourceEntry[] entries = this.getSourceEntries();
            return CDataUtil.setExcluded((IPath)path, (boolean)isFolder, (boolean)excluded, (ICSourceEntry[])entries, (boolean)false);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
            return null;
        }
    }

    boolean canExclude(IPath path, boolean isFolder, boolean excluded) {
        if (this.excludeList == null) {
            ICSourceEntry[] newEntries = this.getUpdatedEntries(path, isFolder, excluded);
            return newEntries != null;
        }
        if (excluded) {
            this.excludeList.add(path);
        }
        return true;
    }

    public IRealBuildObjectAssociation getExtensionObject() {
        return this.isExtensionConfig ? this : (Configuration)this.getParent();
    }

    public IRealBuildObjectAssociation[] getIdenticBuildObjects() {
        return new Configuration[]{(Configuration)this.getExtensionObject()};
    }

    public IRealBuildObjectAssociation getRealBuildObject() {
        return this.getExtensionObject();
    }

    public IRealBuildObjectAssociation getSuperClassObject() {
        return (IRealBuildObjectAssociation)((Object)this.getParent());
    }

    public int getType() {
        return 32;
    }

    public boolean isRealBuildObject() {
        return this.getRealBuildObject() == this;
    }

    public String getUniqueRealName() {
        return this.getName();
    }

    public boolean isExtensionBuildObject() {
        return this.isExtensionElement();
    }
}

