/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.tcmodification;

import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;

public class ListMap
implements Cloneable {
    private HashMap fMap = new HashMap();
    private CollectionEntrySet fCollectionEntrySet;

    public void add(Object key, Object value) {
        List l = this.get(key, true);
        l.add(value);
    }

    public List removeAll(Object key) {
        return (List)this.fMap.remove(key);
    }

    public List get(Object key, boolean create) {
        List l = (List)this.fMap.get(key);
        if (l == null && create) {
            l = this.newList(1);
            this.fMap.put(key, l);
        }
        return l;
    }

    public Collection valuesToCollection(Collection c) {
        if (c == null) {
            c = this.newList(20);
        }
        Iterator iter = this.fMap.values().iterator();
        while (iter.hasNext()) {
            List l = (List)iter.next();
            c.addAll(l);
        }
        return c;
    }

    public List getValues() {
        return (List)this.valuesToCollection(null);
    }

    public Object[] getValuesArray(Class clazz) {
        List list = this.getValues();
        Object[] result = (Object[])Array.newInstance(clazz, list.size());
        return list.toArray(result);
    }

    protected List newList(int size) {
        return new ArrayList(size);
    }

    protected List cloneList(List l) {
        return (List)((ArrayList)l).clone();
    }

    public Collection putValuesToCollection(Collection c) {
        Iterator iter = this.collectionEntrySet().iterator();
        while (iter.hasNext()) {
            List l = ((CollectionEntry)iter.next()).getValue();
            c.addAll(l);
        }
        return c;
    }

    public void remove(Object key, Object value) {
        List c = this.get(key, false);
        if (c != null && c.remove(value) && c.size() == 0) {
            this.fMap.remove(key);
        }
    }

    public Object get(Object key, int num) {
        List l = this.get(key, false);
        if (l != null) {
            return l.get(num);
        }
        return null;
    }

    public Object remove(Object key, int num) {
        List l = this.get(key, false);
        if (l != null) {
            Object result = null;
            if (l.size() > num) {
                result = l.remove(num);
            }
            return result;
        }
        return null;
    }

    public Object removeLast(Object key) {
        List l = this.get(key, false);
        if (l != null) {
            Object result = null;
            if (l.size() > 0) {
                result = l.remove(l.size() - 1);
            }
            return result;
        }
        return null;
    }

    public void removeAll(Object key, Collection values) {
        List c = this.get(key, false);
        if (c != null && c.removeAll(values) && c.size() == 0) {
            this.fMap.remove(key);
        }
    }

    public void clearEmptyLists() {
        Iterator iter = this.fMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (((List)entry.getValue()).size() != 0) continue;
            iter.remove();
        }
    }

    public Set collectionEntrySet() {
        if (this.fCollectionEntrySet == null) {
            this.fCollectionEntrySet = new CollectionEntrySet();
        }
        return this.fCollectionEntrySet;
    }

    public void difference(ListMap map) {
        Iterator iter = map.fMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Collection thisC = (Collection)this.fMap.get(entry.getKey());
            if (thisC == null || !thisC.removeAll((Collection)entry.getValue()) || thisC != null) continue;
            this.fMap.remove(entry.getKey());
        }
    }

    public ValueIter valueIter() {
        return new ValueIter();
    }

    public Object clone() {
        try {
            ListMap clone = (ListMap)super.clone();
            clone.fMap = (HashMap)this.fMap.clone();
            Iterator iter = clone.fMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                entry.setValue(this.cloneList((List)entry.getValue()));
            }
        }
        catch (CloneNotSupportedException e) {
            ManagedBuilderCorePlugin.log(e);
        }
        return null;
    }

    public class CollectionEntry {
        private Map.Entry fEntry;

        CollectionEntry(Map.Entry entry) {
            this.fEntry = entry;
        }

        public Object getKey() {
            return this.fEntry.getKey();
        }

        public List getValue() {
            return (List)this.fEntry.getValue();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CollectionEntry)) {
                return false;
            }
            return this.fEntry.equals(((CollectionEntry)obj).fEntry);
        }

        public int hashCode() {
            return this.fEntry.hashCode();
        }
    }

    private class CollectionEntrySet
    extends AbstractSet {
        private Set fMapEntrySet;

        private CollectionEntrySet() {
            this.fMapEntrySet = ListMap.this.fMap.entrySet();
        }

        public Iterator iterator() {
            return new Iter();
        }

        public int size() {
            return this.fMapEntrySet.size();
        }

        private class Iter
        implements Iterator {
            private Iterator fIter;

            private Iter() {
                this.fIter = CollectionEntrySet.this.fMapEntrySet.iterator();
            }

            public boolean hasNext() {
                return this.fIter.hasNext();
            }

            public Object next() {
                return new CollectionEntry((Map.Entry)this.fIter.next());
            }

            public void remove() {
                this.fIter.remove();
            }
        }
    }

    public class ValueIter {
        private Map fIterMap;

        public ValueIter() {
            this.fIterMap = new HashMap(ListMap.this.fMap);
            Iterator iter = this.fIterMap.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Collection c = (Collection)entry.getValue();
                entry.setValue(c.iterator());
            }
        }

        public Iterator get(Object key) {
            Iterator iter = (Iterator)this.fIterMap.get(key);
            if (iter != null && !iter.hasNext()) {
                this.fIterMap.remove(key);
                return null;
            }
            return iter;
        }
    }
}

