/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.mingw;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.core.runtime.Platform;

public class MingwEnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private final IBuildEnvironmentVariable path;

    public MingwEnvironmentVariableSupplier() {
        String bin = String.valueOf(Platform.getInstallLocation().getURL().getFile().substring(1)) + "mingw/bin";
        if (!new File(bin).exists()) {
            bin = WindowsRegistry.getRegistry().getLocalMachineValue("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\MinGW", "InstallLocation");
            if (bin != null) {
                bin = String.valueOf(bin) + "\\bin";
            }
            if (bin == null || !new File(bin).exists()) {
                bin = "C:/MinGW/bin";
            }
        }
        this.path = new MingwBuildEnvironmentVariable("PATH", bin, 3);
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (variableName.equals(this.path.getName())) {
            return this.path;
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        return new IBuildEnvironmentVariable[]{this.path};
    }

    private static class MingwBuildEnvironmentVariable
    implements IBuildEnvironmentVariable {
        private final String name;
        private final String value;
        private final int operation;

        public MingwBuildEnvironmentVariable(String name, String value, int operation) {
            this.name = name;
            this.value = value;
            this.operation = operation;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getOperation() {
            return this.operation;
        }

        public String getDelimiter() {
            return ";";
        }
    }
}

