/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.managedbuilder.core.IAdditionalInput;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IOutputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.Messages;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BuildStepsTab
extends AbstractCBuildPropertyTab {
    Combo combo;
    Text preCmd;
    Text preDes;
    Text postCmd;
    Text postDes;
    ITool tool;
    IConfiguration config;
    ICResourceDescription cfgdescr;
    IFileInfo rcfg;
    private static final String label1 = Messages.getString("BuildStepsTab.0");
    private static final String label2 = Messages.getString("BuildStepsTab.1");
    private static final String PATH_SEPERATOR = ";";
    private static final String rcbsToolId = new String("org.eclipse.cdt.managedbuilder.ui.rcbs");
    private static final String rcbsToolName = new String("Resource Custom Build Step");
    private static final String rcbsToolInputTypeId = new String("org.eclipse.cdt.managedbuilder.ui.rcbs.inputtype");
    private static final String rcbsToolInputTypeName = new String("Resource Custom Build Step Input Type");
    private static final String rcbsToolOutputTypeId = new String("org.eclipse.cdt.managedbuilder.ui.rcbs.outputtype");
    private static final String rcbsToolOutputTypeName = new String("Resource Custom Build Step Output Type");
    private static final String PREFIX = "ResourceCustomBuildStepBlock";
    private static final String LABEL = "ResourceCustomBuildStepBlock.label";
    private static final String RCBS_APPLICABILITY = "ResourceCustomBuildStepBlock.label.applicability";
    private static final String RCBS_BEFORE = "ResourceCustomBuildStepBlock.label.applicability.rule.before";
    private static final String RCBS_AFTER = "ResourceCustomBuildStepBlock.label.applicability.rule.after";
    private static final String RCBS_OVERRIDE = "ResourceCustomBuildStepBlock.label.applicability.rule.override";
    private static final String RCBS_DISABLE = "ResourceCustomBuildStepBlock.label.applicability.rule.disable";
    private static final String[] rcbsApplicabilityRules = new String[]{new String(UIMessages.getString((String)"ResourceCustomBuildStepBlock.label.applicability.rule.override")), new String(UIMessages.getString((String)"ResourceCustomBuildStepBlock.label.applicability.rule.disable"))};

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        if (this.page.isForProject()) {
            this.createForProject();
        } else {
            this.createForFile();
        }
    }

    private void createForProject() {
        Group g1 = this.setupGroup(this.usercomp, Messages.getString("BuildStepsTab.2"), 1, 768);
        this.setupLabel((Composite)g1, label1, 1, 1);
        this.preCmd = this.setupText((Composite)g1, 1, 768);
        this.preCmd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildStepsTab.this.getCfg().setPrebuildStep(BuildStepsTab.this.preCmd.getText());
            }
        });
        this.setupLabel((Composite)g1, label2, 1, 1);
        this.preDes = this.setupText((Composite)g1, 1, 768);
        this.preDes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildStepsTab.this.getCfg().setPreannouncebuildStep(BuildStepsTab.this.preDes.getText());
            }
        });
        Group g2 = this.setupGroup(this.usercomp, Messages.getString("BuildStepsTab.3"), 1, 768);
        this.setupLabel((Composite)g2, label1, 1, 1);
        this.postCmd = this.setupText((Composite)g2, 1, 768);
        this.postCmd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildStepsTab.this.getCfg().setPostbuildStep(BuildStepsTab.this.postCmd.getText());
            }
        });
        this.setupLabel((Composite)g2, label2, 1, 1);
        this.postDes = this.setupText((Composite)g2, 1, 768);
        this.postDes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BuildStepsTab.this.getCfg().setPostannouncebuildStep(BuildStepsTab.this.postDes.getText());
            }
        });
    }

    private void createForFile() {
        Group g1 = this.setupGroup(this.usercomp, Messages.getString("BuildStepsTab.4"), 1, 768);
        this.setupLabel((Composite)g1, UIMessages.getString((String)RCBS_APPLICABILITY), 1, 1);
        this.combo = new Combo((Composite)g1, 2060);
        this.combo.setItems(rcbsApplicabilityRules);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildStepsTab.this.rcfg.setRcbsApplicability(BuildStepsTab.this.sel2app(BuildStepsTab.this.combo.getSelectionIndex()));
            }
        });
        this.setupLabel((Composite)g1, Messages.getString("BuildStepsTab.5"), 1, 1);
        this.preCmd = this.setupText((Composite)g1, 1, 768);
        this.preCmd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildStepsTab.this.page.isForProject()) {
                    BuildStepsTab.this.getCfg().setPrebuildStep(BuildStepsTab.this.preCmd.getText());
                } else {
                    IAdditionalInput[] add;
                    IInputType[] ein = BuildStepsTab.this.tool.getInputTypes();
                    if (ein != null && ein.length > 0 && (add = ein[0].getAdditionalInputs()) != null && add.length > 0) {
                        add[0].setPaths(BuildStepsTab.this.preCmd.getText());
                    }
                }
            }
        });
        this.setupLabel((Composite)g1, Messages.getString("BuildStepsTab.6"), 1, 1);
        this.preDes = this.setupText((Composite)g1, 1, 768);
        this.preDes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildStepsTab.this.page.isForProject()) {
                    BuildStepsTab.this.getCfg().setPreannouncebuildStep(BuildStepsTab.this.preDes.getText());
                } else {
                    Object[] out = BuildStepsTab.this.tool.getOutputTypes();
                    if (BuildStepsTab.this.valid(out)) {
                        out[0].setOutputNames(BuildStepsTab.this.preDes.getText());
                    }
                }
            }
        });
        this.setupLabel((Composite)g1, label1, 1, 1);
        this.postCmd = this.setupText((Composite)g1, 1, 768);
        this.postCmd.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildStepsTab.this.page.isForProject()) {
                    BuildStepsTab.this.getCfg().setPostbuildStep(BuildStepsTab.this.postCmd.getText());
                } else {
                    BuildStepsTab.this.tool.setToolCommand(BuildStepsTab.this.postCmd.getText());
                }
            }
        });
        this.setupLabel((Composite)g1, label2, 1, 1);
        this.postDes = this.setupText((Composite)g1, 1, 768);
        this.postDes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (BuildStepsTab.this.page.isForProject()) {
                    BuildStepsTab.this.getCfg().setPostannouncebuildStep(BuildStepsTab.this.postDes.getText());
                } else {
                    BuildStepsTab.this.tool.setAnnouncement(BuildStepsTab.this.postDes.getText());
                }
            }
        });
    }

    public void updateData(ICResourceDescription cfgd) {
        if (cfgd == null) {
            return;
        }
        this.config = this.getCfg(cfgd.getConfiguration());
        this.cfgdescr = cfgd;
        this.update();
    }

    private void update() {
        if (this.page.isForProject()) {
            this.preCmd.setText(this.config.getPrebuildStep());
            this.preDes.setText(this.config.getPreannouncebuildStep());
            this.postCmd.setText(this.config.getPostbuildStep());
            this.postDes.setText(this.config.getPostannouncebuildStep());
        } else {
            this.rcfg = (IFileInfo)this.getResCfg(this.cfgdescr);
            this.combo.select(this.app2sel(this.rcfg.getRcbsApplicability()));
            this.tool = this.getRcbsTool(this.rcfg);
            if (this.tool != null) {
                IAdditionalInput[] add;
                String s = "";
                IInputType[] tmp = this.tool.getInputTypes();
                if (tmp != null && tmp.length > 0 && (add = tmp[0].getAdditionalInputs()) != null && add.length > 0) {
                    s = this.createList(add[0].getPaths());
                }
                this.preCmd.setText(s);
                s = "";
                IOutputType[] tmp2 = this.tool.getOutputTypes();
                if (tmp2 != null && tmp2.length > 0) {
                    s = this.createList(tmp2[0].getOutputNames());
                }
                this.preDes.setText(s);
                this.postCmd.setText(this.tool.getToolCommand());
                this.postDes.setText(this.tool.getAnnouncement());
            } else {
                this.preCmd.setText("");
                this.preDes.setText("");
                this.postCmd.setText("");
                this.postDes.setText("");
            }
        }
    }

    private ITool getRcbsTool(IFileInfo rcConfig) {
        ITool[] rcbsTools = this.getRcbsTools((IResourceInfo)rcConfig);
        ITool rcbsTool = null;
        if (rcbsTools != null) {
            rcbsTool = rcbsTools[0];
        } else {
            rcbsTool = rcConfig.createTool(null, String.valueOf(rcbsToolId) + "." + ManagedBuildManager.getRandomNumber(), rcbsToolName, false);
            rcbsTool.setCustomBuildStep(true);
            IInputType rcbsToolInputType = rcbsTool.createInputType(null, String.valueOf(rcbsToolInputTypeId) + "." + ManagedBuildManager.getRandomNumber(), rcbsToolInputTypeName, false);
            IAdditionalInput rcbsToolInputTypeAdditionalInput = rcbsToolInputType.createAdditionalInput(new String());
            rcbsToolInputTypeAdditionalInput.setKind(3);
            rcbsTool.createOutputType(null, String.valueOf(rcbsToolOutputTypeId) + "." + ManagedBuildManager.getRandomNumber(), rcbsToolOutputTypeName, false);
        }
        return rcbsTool;
    }

    private ITool[] getRcbsTools(IResourceInfo rcConfig) {
        ArrayList<ITool> list = new ArrayList<ITool>();
        ITool[] tools = rcConfig.getTools();
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            if (tool.getCustomBuildStep() && !tool.isExtensionElement()) {
                list.add(tool);
            }
            ++i;
        }
        if (list.size() != 0) {
            return list.toArray(new ITool[list.size()]);
        }
        return null;
    }

    private String createList(String[] items) {
        if (items == null) {
            return new String();
        }
        StringBuffer path = new StringBuffer("");
        int i = 0;
        while (i < items.length) {
            path.append(items[i]);
            if (i < items.length - 1) {
                path.append(PATH_SEPERATOR);
            }
            ++i;
        }
        return path.toString();
    }

    public void performApply(ICResourceDescription src, ICResourceDescription dst) {
        if (this.page.isForProject()) {
            IConfiguration cfg1 = this.getCfg(src.getConfiguration());
            IConfiguration cfg2 = this.getCfg(dst.getConfiguration());
            cfg2.setPrebuildStep(cfg1.getPrebuildStep());
            cfg2.setPreannouncebuildStep(cfg1.getPreannouncebuildStep());
            cfg2.setPostbuildStep(cfg1.getPostbuildStep());
            cfg2.setPostannouncebuildStep(cfg1.getPostannouncebuildStep());
        } else {
            IFileInfo rcfg1 = (IFileInfo)this.getResCfg(src);
            IFileInfo rcfg2 = (IFileInfo)this.getResCfg(dst);
            rcfg2.setRcbsApplicability(rcfg1.getRcbsApplicability());
            ITool tool1 = this.getRcbsTool(rcfg1);
            ITool tool2 = this.getRcbsTool(rcfg2);
            Object[] ein1 = tool1.getInputTypes();
            Object[] ein2 = tool2.getInputTypes();
            if (this.valid(ein1) && this.valid(ein2)) {
                Object[] add1 = ein1[0].getAdditionalInputs();
                Object[] add2 = ein2[0].getAdditionalInputs();
                if (this.valid(add1) && this.valid(add2)) {
                    add2[0].setPaths(this.createList(add1[0].getPaths()));
                }
            }
            Object[] tmp1 = tool1.getOutputTypes();
            Object[] tmp2 = tool2.getOutputTypes();
            if (this.valid(tmp1) && this.valid(tmp2)) {
                tmp2[0].setOutputNames(this.createList(tmp1[0].getOutputNames()));
            }
            tool2.setToolCommand(tool1.getToolCommand());
            tool2.setAnnouncement(tool1.getAnnouncement());
        }
    }

    private int sel2app(int index) {
        String sel = this.combo.getItem(index);
        if (UIMessages.getString((String)RCBS_OVERRIDE).equals(sel)) {
            return 1;
        }
        if (UIMessages.getString((String)RCBS_AFTER).equals(sel)) {
            return 3;
        }
        if (UIMessages.getString((String)RCBS_BEFORE).equals(sel)) {
            return 2;
        }
        return 4;
    }

    private boolean valid(Object[] arr) {
        return arr != null && arr.length > 0;
    }

    private int app2sel(int val) {
        switch (val) {
            case 3: {
                return this.combo.indexOf(UIMessages.getString((String)RCBS_AFTER));
            }
            case 2: {
                return this.combo.indexOf(UIMessages.getString((String)RCBS_BEFORE));
            }
            case 4: {
                return this.combo.indexOf(UIMessages.getString((String)RCBS_DISABLE));
            }
        }
        return this.combo.indexOf(UIMessages.getString((String)RCBS_OVERRIDE));
    }

    public boolean canBeVisible() {
        if (this.page.isForProject() || this.page.isForFile()) {
            return this.getCfg().getBuilder().isManagedBuildOn();
        }
        return false;
    }

    protected void performDefaults() {
        if (this.page.isForProject()) {
            this.config.setPrebuildStep(null);
            this.config.setPreannouncebuildStep(null);
            this.config.setPostbuildStep(null);
            this.config.setPostannouncebuildStep(null);
        } else {
            Object[] tmp;
            Object[] add;
            this.rcfg.setRcbsApplicability(4);
            ITool tool = this.getRcbsTool(this.rcfg);
            Object[] ein = tool.getInputTypes();
            if (this.valid(ein) && this.valid(add = ein[0].getAdditionalInputs())) {
                add[0].setPaths(null);
            }
            if (this.valid(tmp = tool.getOutputTypes())) {
                tmp[0].setOutputNames(null);
            }
            tool.setToolCommand(null);
            tool.setAnnouncement(null);
        }
        this.update();
    }

    protected void updateButtons() {
    }
}

