/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractCBuildPropertyTab;
import org.eclipse.cdt.managedbuilder.ui.properties.AbstractToolSettingUI;
import org.eclipse.cdt.managedbuilder.ui.properties.ToolSettingsPrefStore;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.cdt.ui.newui.MultiLineTextFieldEditor;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class BuildToolSettingUI
extends AbstractToolSettingUI {
    private static final String ALL_OPTIONS = UIMessages.getString((String)"BuildToolSettingsPage.alloptions");
    private static final String COMMAND = "BuildToolSettingsPage.tool.command";
    private static final String ADVANCED_GROUP = "BuildToolSettingsPage.tool.advancedSettings";
    private static final String COMMAND_LINE_PATTERN = "BuildToolSettingsPage.tool.commandLinePattern";
    private static final String DEFAULT_SEPERATOR = ";";
    private static final String WHITESPACE = " ";
    private MultiLineTextFieldEditor allOptionFieldEditor;
    private StringFieldEditor commandStringField;
    private StringFieldEditor commandLinePatternField;
    private Vector defaultOptionNames;
    private HashMap stringOptionsMap;
    private ITool fTool;
    private HashMap userObjsMap;

    public BuildToolSettingUI(AbstractCBuildPropertyTab page, IResourceInfo info, ITool _tool) {
        super(info);
        this.fTool = _tool;
        this.buildPropPage = page;
        this.stringOptionsMap = new HashMap();
        this.userObjsMap = new HashMap();
    }

    public Point computeSize() {
        return super.computeSize();
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        Composite parent = this.getFieldEditorParent();
        FontMetrics fm = AbstractCPropertyTab.getFontMetrics((Control)parent);
        this.commandStringField = new StringFieldEditor(this.fTool.getId(), UIMessages.getString((String)COMMAND), parent);
        this.commandStringField.setEmptyStringAllowed(false);
        GridData gd = (GridData)this.commandStringField.getTextControl(parent).getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)3);
        this.addField((FieldEditor)this.commandStringField);
        Composite par = this.getFieldEditorParent();
        this.allOptionFieldEditor = new MultiLineTextFieldEditor(ToolSettingsPrefStore.ALL_OPTIONS_ID, ALL_OPTIONS, par);
        this.allOptionFieldEditor.getTextControl(par).setEditable(false);
        gd.grabExcessHorizontalSpace = true;
        gd.minimumWidth = Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)20);
        this.addField((FieldEditor)this.allOptionFieldEditor);
        this.addField(this.createLabelEditor(this.getFieldEditorParent(), WHITESPACE));
        this.addField(this.createLabelEditor(this.getFieldEditorParent(), UIMessages.getString((String)ADVANCED_GROUP)));
        parent = this.getFieldEditorParent();
        this.commandLinePatternField = new StringFieldEditor(String.valueOf(this.fTool.getId()) + "org.eclipse.commandLinePatternId", UIMessages.getString((String)COMMAND_LINE_PATTERN), parent);
        gd = (GridData)this.commandLinePatternField.getTextControl(parent).getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)30);
        gd.minimumWidth = Dialog.convertWidthInCharsToPixels((FontMetrics)fm, (int)20);
        this.addField((FieldEditor)this.commandLinePatternField);
    }

    protected FieldEditor createLabelEditor(Composite parent, String title) {
        return new LabelFieldEditor(parent, title);
    }

    private Vector getDefaultOptionNames() {
        if (this.defaultOptionNames == null) {
            this.defaultOptionNames = new Vector();
            this.defaultOptionNames.add("Other flags");
            this.defaultOptionNames.add("Linker flags");
            this.defaultOptionNames.add("Archiver flags");
            this.defaultOptionNames.add("Assembler flags");
        }
        return this.defaultOptionNames;
    }

    private Vector getOptionVector(String rawOptionString) {
        Vector<String> tokens = new Vector<String>(Arrays.asList(rawOptionString.split("\\s")));
        Vector<String> output = new Vector<String>(tokens.size());
        Iterator<String> iter = tokens.iterator();
        while (iter.hasNext()) {
            String token = iter.next();
            int firstIndex = token.indexOf("\"");
            int lastIndex = token.lastIndexOf("\"");
            if (firstIndex != -1 && firstIndex == lastIndex) {
                while (iter.hasNext()) {
                    String nextToken = iter.next();
                    token = String.valueOf(token) + WHITESPACE + nextToken;
                    if (nextToken.indexOf("\"") != -1) break;
                }
            }
            output.add(token);
        }
        return output;
    }

    public boolean isFor(Object tool, Object unused) {
        if (tool != null && tool instanceof ITool && unused == null) {
            return tool.equals(this.fTool);
        }
        return false;
    }

    public void parseAllOptions() {
        IOption opt;
        String alloptions = this.getToolSettingsPrefStore().getString(ToolSettingsPrefStore.ALL_OPTIONS_ID);
        ArrayList<String> optionsList = new ArrayList<String>();
        StringBuffer addnOptions = new StringBuffer();
        Vector optionsArr = this.getOptionVector(alloptions);
        Iterator optIter = optionsArr.iterator();
        while (optIter.hasNext()) {
            String optionValue = (String)optIter.next();
            boolean optionValueExist = false;
            IOption[] options = this.fTool.getOptions();
            int k = 0;
            while (k < options.length) {
                opt = options[k];
                Iterator stringOptsIter = this.stringOptionsMap.values().iterator();
                while (stringOptsIter.hasNext()) {
                    if (((String)stringOptsIter.next()).indexOf(optionValue) == -1) continue;
                    optionValueExist = true;
                }
                Iterator userObjsIter = this.userObjsMap.values().iterator();
                while (userObjsIter.hasNext()) {
                    if (((String)userObjsIter.next()).indexOf(optionValue) == -1) continue;
                    optionValueExist = true;
                }
                if (!optionValueExist) {
                    try {
                        switch (opt.getValueType()) {
                            case 0: {
                                String boolCommand = opt.getCommand();
                                if (boolCommand != null && boolCommand.equals(optionValue)) {
                                    this.setOption(opt, true);
                                    optionValueExist = true;
                                }
                                if ((boolCommand = opt.getCommandFalse()) != null && boolCommand.equals(optionValue)) {
                                    this.setOption(opt, false);
                                    optionValueExist = true;
                                }
                                break;
                            }
                            case 1: {
                                String enumeration = "";
                                String[] enumValues = opt.getApplicableValues();
                                int i = 0;
                                while (i < enumValues.length) {
                                    if (opt.getEnumCommand(enumValues[i]).equals(optionValue)) {
                                        enumeration = enumValues[i];
                                        optionValueExist = true;
                                    }
                                    ++i;
                                }
                                if (!enumeration.equals("")) {
                                    this.setOption(opt, enumeration);
                                }
                                break;
                            }
                            case -11: 
                            case -10: 
                            case -9: 
                            case -8: 
                            case -5: 
                            case -4: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: {
                                if (opt.getCommand() != null && optionValue.startsWith(opt.getCommand())) {
                                    optionsList.add(optionValue);
                                    optionValueExist = true;
                                }
                                break;
                            }
                        }
                    }
                    catch (BuildException buildException) {}
                }
                ++k;
            }
            if (optionValueExist) continue;
            addnOptions.append(String.valueOf(optionValue) + WHITESPACE);
        }
        Set set = this.stringOptionsMap.keySet();
        int s = 0;
        while (s < set.size()) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                String val = (String)this.stringOptionsMap.get(key);
                if (alloptions.indexOf(val) != -1) continue;
                StringBuffer buf = new StringBuffer();
                String[] vals = val.split(WHITESPACE);
                int t = 0;
                while (t < vals.length) {
                    if (alloptions.indexOf(vals[t]) != -1) {
                        buf.append(String.valueOf(vals[t]) + WHITESPACE);
                    }
                    ++t;
                }
                this.setOption((IOption)key, buf.toString().trim());
            }
            ++s;
        }
        Set objSet = this.userObjsMap.keySet();
        int s2 = 0;
        while (s2 < objSet.size()) {
            Iterator iterator = objSet.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                String val = (String)this.userObjsMap.get(key);
                ArrayList<String> list = new ArrayList<String>();
                String[] vals = BuildToolSettingUI.parseString(val);
                int t = 0;
                while (t < vals.length) {
                    if (alloptions.indexOf(vals[t]) != -1) {
                        list.add(vals[t]);
                    }
                    ++t;
                }
                String[] listArr = new String[list.size()];
                list.toArray(listArr);
                this.setOption((IOption)key, listArr);
            }
            ++s2;
        }
        IOption[] options = this.fTool.getOptions();
        int k = 0;
        while (k < options.length) {
            opt = options[k];
            try {
                switch (opt.getValueType()) {
                    case 0: {
                        ArrayList optsList = new ArrayList(optionsArr);
                        if (opt.getCommand() != null && opt.getCommand().length() > 0 && !optsList.contains(opt.getCommand())) {
                            this.setOption(opt, false);
                        }
                        if (opt.getCommandFalse() != null && opt.getCommandFalse().length() > 0 && !optsList.contains(opt.getCommandFalse())) {
                            this.setOption(opt, true);
                        }
                        break;
                    }
                    case 2: {
                        if (this.getDefaultOptionNames().contains(opt.getName())) {
                            String newOptions = opt.getStringValue();
                            if (addnOptions.length() > 0) {
                                newOptions = String.valueOf(newOptions) + WHITESPACE + addnOptions.toString().trim();
                            }
                            this.setOption(opt, newOptions);
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ArrayList<String> newList = new ArrayList<String>();
                        int i = 0;
                        while (i < optionsList.size()) {
                            if (opt.getCommand() != null && ((String)optionsList.get(i)).startsWith(opt.getCommand())) {
                                newList.add(((String)optionsList.get(i)).substring(opt.getCommand().length()));
                            }
                            ++i;
                        }
                        String[] strlist = new String[newList.size()];
                        newList.toArray(strlist);
                        newList.clear();
                        this.setOption(opt, strlist);
                        break;
                    }
                }
            }
            catch (BuildException buildException) {}
            ++k;
        }
    }

    public static String[] parseString(String stringList) {
        if (stringList == null || stringList.length() == 0) {
            return new String[0];
        }
        return stringList.split(DEFAULT_SEPERATOR);
    }

    protected void setOption(IOption option, boolean value) {
        try {
            this.fInfo.setOption((IHoldsOptions)this.fTool, option, value);
        }
        catch (BuildException buildException) {}
    }

    protected void setOption(IOption option, String value) {
        try {
            this.fInfo.setOption((IHoldsOptions)this.fTool, option, value);
        }
        catch (BuildException buildException) {}
    }

    protected void setOption(IOption option, String[] value) {
        try {
            this.fInfo.setOption((IHoldsOptions)this.fTool, option, value);
        }
        catch (BuildException buildException) {}
    }

    public boolean performOk() {
        boolean result = super.performOk();
        return result;
    }

    public void updateFields() {
        this.allOptionFieldEditor.load();
    }

    public void setValues() {
        this.commandStringField.load();
        this.commandLinePatternField.load();
        this.updateFields();
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.commandStringField) {
            this.fTool.setToolCommand(this.commandStringField.getStringValue());
            this.updateFields();
        } else if (event.getSource() == this.commandLinePatternField) {
            this.fTool.setCommandLinePattern(this.commandLinePatternField.getStringValue());
        }
    }

    class LabelFieldEditor
    extends FieldEditor {
        private String fTitle;
        private Label fTitleLabel;

        public LabelFieldEditor(Composite parent, String title) {
            this.fTitle = title;
            this.createControl(parent);
        }

        protected void adjustForNumColumns(int numColumns) {
            ((GridData)this.fTitleLabel.getLayoutData()).horizontalSpan = 2;
        }

        protected void doFillIntoGrid(Composite parent, int numColumns) {
            this.fTitleLabel = new Label(parent, 64);
            this.fTitleLabel.setText(this.fTitle);
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            gd.grabExcessHorizontalSpace = false;
            gd.horizontalSpan = 2;
            this.fTitleLabel.setLayoutData((Object)gd);
        }

        public int getNumberOfControls() {
            return 1;
        }

        protected void doLoad() {
        }

        protected void doLoadDefault() {
        }

        protected void doStore() {
        }
    }
}

