/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageData;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;

public final class MBSCustomPageManager {
    public static final String PAGE_ID = "org.eclipse.cdt.managedbuilder.ui.wizard.platformPage";
    public static final String NATURE_ID = "natureID";
    public static final String VERSIONS_SUPPORTED = "versionsSupported";
    public static final String TOOLCHAIN_ID = "toolchainID";
    public static final String PROJECT_TYPE_ID = "projectTypeID";
    public static final String NATURE = "nature";
    public static final String TOOLCHAIN = "toolchain";
    public static final String PROJECT_TYPE = "projectType";
    public static final String PAGE_CLASS = "pageClass";
    public static final String OPERATION_CLASS = "operationClass";
    public static final String ID = "ID";
    public static final String WIZARD_PAGE = "wizardPage";
    private static Map idToPageDataMap = null;
    private static Set pageSet = null;
    private static Map pageIDtoPagePropertiesMap = null;
    private static final String EXTENSION_POINT_ID = "org.eclipse.cdt.managedbuilder.ui.newWizardPages";
    private static List hiddenList;

    public static void loadExtensions() throws BuildException {
        MBSCustomPageManager.loadExtensionsSynchronized();
    }

    private static synchronized void loadExtensionsSynchronized() throws BuildException {
        IExtension[] extensions;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null) {
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int k = 0;
                while (k < elements.length) {
                    IConfigurationElement element = elements[k];
                    if (!element.getName().equals(WIZARD_PAGE)) {
                        throw new BuildException(String.valueOf(UIMessages.getString((String)"MBSCustomPageManager.error0")) + element.getName() + UIMessages.getString((String)"MBSCustomPageManager.error1") + EXTENSION_POINT_ID);
                    }
                    MBSCustomPageManager.loadWizardPage(element);
                    ++k;
                }
                ++i;
            }
        }
    }

    private static void loadWizardPage(IConfigurationElement element) throws BuildException {
        MBSCustomPageData currentPageData;
        String id = element.getAttribute(ID);
        IWizardPage wizardPage = null;
        Object operation = null;
        try {
            wizardPage = (IWizardPage)element.createExecutableExtension(PAGE_CLASS);
            if (element.getAttribute(OPERATION_CLASS) != null) {
                operation = element.createExecutableExtension(OPERATION_CLASS);
            }
        }
        catch (CoreException e) {
            throw new BuildException(e.getMessage());
        }
        if (operation instanceof Runnable) {
            currentPageData = new MBSCustomPageData(id, wizardPage, (Runnable)operation, false);
        } else if (operation instanceof IRunnableWithProgress || operation == null) {
            currentPageData = new MBSCustomPageData(id, wizardPage, (IRunnableWithProgress)operation, false);
        } else {
            throw new BuildException(element.getName());
        }
        idToPageDataMap.put(id, currentPageData);
        pageSet.add(currentPageData);
        IConfigurationElement[] children = element.getChildren();
        int k = 0;
        while (k < children.length) {
            IConfigurationElement childElement = children[k];
            if (childElement.getName().equals(PROJECT_TYPE)) {
                MBSCustomPageManager.loadProjectType(childElement, currentPageData);
            } else if (childElement.getName().equals(TOOLCHAIN)) {
                MBSCustomPageManager.loadToolchain(childElement, currentPageData);
            } else if (childElement.getName().equals(NATURE)) {
                MBSCustomPageManager.loadNature(childElement, currentPageData);
            } else {
                throw new BuildException(String.valueOf(UIMessages.getString((String)"MBSCustomPageManager.error2")) + element.getName() + UIMessages.getString((String)"MBSCustomPageManager.error3") + EXTENSION_POINT_ID);
            }
            ++k;
        }
    }

    private static void loadProjectType(IConfigurationElement element, MBSCustomPageData currentPageData) throws BuildException {
        String projectType = element.getAttribute(PROJECT_TYPE_ID);
        if (projectType == null) {
            throw new BuildException(UIMessages.getString((String)"MBSCustomPageManager.error4"));
        }
        currentPageData.addProjectType(projectType);
    }

    private static void loadToolchain(IConfigurationElement element, MBSCustomPageData currentPageData) throws BuildException {
        String[] versionsSupported;
        String toolchainID = element.getAttribute(TOOLCHAIN_ID);
        if (toolchainID != null) {
            String unparsedVersions = element.getAttribute(VERSIONS_SUPPORTED);
            versionsSupported = null;
            if (unparsedVersions != null) {
                versionsSupported = unparsedVersions.split(",");
            }
        } else {
            throw new BuildException(UIMessages.getString((String)"MBSCustomPageManager.error5"));
        }
        currentPageData.addToolchain(toolchainID, versionsSupported);
    }

    private static void loadNature(IConfigurationElement element, MBSCustomPageData currentPageData) throws BuildException {
        String nature = element.getAttribute(NATURE_ID);
        if (nature == null) {
            throw new BuildException(UIMessages.getString((String)"MBSCustomPageManager.error6"));
        }
        currentPageData.addNature(nature);
    }

    public static MBSCustomPageData getPageData(String pageID) {
        return (MBSCustomPageData)idToPageDataMap.get(pageID);
    }

    public static boolean isPageVisible(String pageID) {
        MBSCustomPageData page = MBSCustomPageManager.getPageData(pageID);
        if (page == null) {
            return false;
        }
        if (MBSCustomPageManager.getPageHideStatus(pageID)) {
            return false;
        }
        Map pagePropertiesMap = (Map)pageIDtoPagePropertiesMap.get(PAGE_ID);
        Object projectType = pagePropertiesMap.get(PROJECT_TYPE);
        List toolchainList = (List)pagePropertiesMap.get(TOOLCHAIN);
        Object nature = pagePropertiesMap.get(NATURE);
        if (page.shouldBeVisibleForNature(nature) && page.shouldBeVisibleForProjectType(projectType)) {
            MBSCustomPageData.ToolchainData[] toolchainData = page.getToolchains();
            if (toolchainData == null || toolchainList == null) {
                return true;
            }
            int k = 0;
            while (k < toolchainData.length) {
                Iterator toolchainIterator = toolchainList.iterator();
                while (toolchainIterator.hasNext()) {
                    String version;
                    String id;
                    IToolChain toolchain = (IToolChain)toolchainIterator.next();
                    if (toolchain == null || !page.shouldBeVisibleForToolchain(id = ManagedBuildManager.getIdFromIdAndVersion((String)toolchain.getId()), version = ManagedBuildManager.getVersionFromIdAndVersion((String)toolchain.getId()))) continue;
                    return true;
                }
                ++k;
            }
        }
        return false;
    }

    public static void addPageProperty(String pageID, String key, Object data) {
        TreeMap<String, Object> propertiesMap = (TreeMap<String, Object>)pageIDtoPagePropertiesMap.get(pageID);
        if (propertiesMap == null) {
            propertiesMap = new TreeMap<String, Object>();
            pageIDtoPagePropertiesMap.put(pageID, propertiesMap);
        }
        propertiesMap.put(key, data);
    }

    public static Object getPageProperty(String pageID, String key) {
        Map propertiesMap = (Map)pageIDtoPagePropertiesMap.get(pageID);
        if (propertiesMap != null) {
            return propertiesMap.get(key);
        }
        return null;
    }

    public static IWizardPage getNextPage(String currentPageID) {
        MBSCustomPageData pageData = MBSCustomPageManager.getPageData(currentPageID);
        Iterator iterator = pageSet.iterator();
        while (iterator.hasNext()) {
            if (!pageData.equals((MBSCustomPageData)iterator.next())) continue;
            IWizardPage nextPage = null;
            while (iterator.hasNext() && nextPage == null) {
                MBSCustomPageData potentialPage = (MBSCustomPageData)iterator.next();
                if (!MBSCustomPageManager.isPageVisible(potentialPage.getID())) continue;
                nextPage = potentialPage.getWizardPage();
            }
            return nextPage;
        }
        return null;
    }

    public static void addStockPage(IWizardPage page, String pageID) {
        MBSCustomPageData pageData = new MBSCustomPageData(pageID, page, null, true);
        idToPageDataMap.put(pageID, pageData);
        pageSet.add(pageData);
    }

    public static IWizardPage getPreviousPage(String currentPageID) {
        MBSCustomPageData pageData = MBSCustomPageManager.getPageData(currentPageID);
        MBSCustomPageData currentData = null;
        Iterator iterator = pageSet.iterator();
        Stack<MBSCustomPageData> pageDataStack = new Stack<MBSCustomPageData>();
        while (iterator.hasNext()) {
            currentData = (MBSCustomPageData)iterator.next();
            if (currentData == pageData) break;
            pageDataStack.push(currentData);
        }
        if (currentData == pageData) {
            IWizardPage prevPage = null;
            boolean pageFound = false;
            while (pageDataStack.size() != 0 && !pageFound) {
                MBSCustomPageData potentialPage = (MBSCustomPageData)pageDataStack.pop();
                if (!MBSCustomPageManager.isPageVisible(potentialPage.getID())) continue;
                pageFound = true;
                prevPage = potentialPage.getWizardPage();
            }
            if (pageFound) {
                return prevPage;
            }
        }
        return null;
    }

    public static IWizardPage[] getPages() {
        IWizardPage[] pages = new IWizardPage[pageSet.size()];
        Iterator iterator = pageSet.iterator();
        int k = 0;
        while (iterator.hasNext()) {
            MBSCustomPageData page = (MBSCustomPageData)iterator.next();
            pages[k++] = page.getWizardPage();
        }
        return pages;
    }

    public static IWizardPage[] getCustomPages() {
        LinkedHashSet<IWizardPage> customPageSet = new LinkedHashSet<IWizardPage>();
        Iterator pageIterator = pageSet.iterator();
        while (pageIterator.hasNext()) {
            MBSCustomPageData page = (MBSCustomPageData)pageIterator.next();
            if (page.isStockPage()) continue;
            customPageSet.add(page.getWizardPage());
        }
        Iterator iterator = customPageSet.iterator();
        IWizardPage[] pages = new IWizardPage[customPageSet.size()];
        int k = 0;
        while (iterator.hasNext()) {
            pages[k++] = (IWizardPage)iterator.next();
        }
        return pages;
    }

    public static IRunnableWithProgress[] getOperations() {
        LinkedHashSet<IRunnableWithProgress> operationSet = new LinkedHashSet<IRunnableWithProgress>();
        Iterator pageIterator = pageSet.iterator();
        while (pageIterator.hasNext()) {
            MBSCustomPageData page = (MBSCustomPageData)pageIterator.next();
            if (page.isStockPage() || !MBSCustomPageManager.isPageVisible(page.getID()) || page.getOperation() == null) continue;
            operationSet.add(page.getOperation());
        }
        if (operationSet.size() == 0) {
            return null;
        }
        Iterator iterator = operationSet.iterator();
        IRunnableWithProgress[] operations = new IRunnableWithProgress[operationSet.size()];
        int k = 0;
        while (iterator.hasNext()) {
            operations[k++] = (IRunnableWithProgress)iterator.next();
        }
        return operations;
    }

    public static void init() {
        idToPageDataMap = new TreeMap();
        pageIDtoPagePropertiesMap = new TreeMap();
        pageSet = new LinkedHashSet();
        hiddenList = new ArrayList();
    }

    private MBSCustomPageManager() {
    }

    public static void setPageHideStatus(String Id, boolean status) {
        if (hiddenList.contains(Id)) {
            if (!status) {
                hiddenList.remove(Id);
            }
        } else if (status) {
            hiddenList.add(Id);
        }
    }

    public static boolean getPageHideStatus(String Id) {
        return hiddenList.contains(Id);
    }
}

