/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.wizards;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.ui.properties.Messages;
import org.eclipse.cdt.managedbuilder.ui.wizards.CfgHolder;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSWizardHandler;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Composite;

public class STDWizardHandler
extends MBSWizardHandler {
    public STDWizardHandler(Composite p, IWizard w) {
        super(Messages.getString("StdBuildWizard.0"), p, w);
    }

    public void addTc(IToolChain tc) {
        if (tc == null) {
            this.full_tcs.put(UIMessages.getString((String)"StdProjectTypeHandler.0"), null);
        } else {
            if (tc.isAbstract() || tc.isSystemObject()) {
                return;
            }
            this.full_tcs.put(tc.getUniqueRealName(), tc);
        }
    }

    public void createProject(IProject project, boolean defaults, boolean onFinish) throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.createProjectDescription(project, false, !onFinish);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)project);
        ManagedProject mProj = new ManagedProject(des);
        info.setManagedProject((IManagedProject)mProj);
        this.cfgs = CfgHolder.unique(this.fConfigPage.getCfgItems(defaults));
        this.cfgs = CfgHolder.reorder(this.cfgs);
        int i = 0;
        while (i < this.cfgs.length) {
            String s = this.cfgs[i].getToolChain() == null ? "0" : ((ToolChain)this.cfgs[i].getToolChain()).getId();
            Configuration cfg = new Configuration(mProj, (ToolChain)this.cfgs[i].getToolChain(), ManagedBuildManager.calculateChildId((String)s, null), this.cfgs[i].getName());
            IBuilder bld = cfg.getEditableBuilder();
            if (bld != null) {
                if (bld.isInternalBuilder()) {
                    IConfiguration prefCfg = ManagedBuildManager.getPreferenceConfiguration((boolean)false);
                    IBuilder prefBuilder = prefCfg.getBuilder();
                    cfg.changeBuilder(prefBuilder, ManagedBuildManager.calculateChildId((String)cfg.getId(), null), prefBuilder.getName());
                    bld = cfg.getEditableBuilder();
                    bld.setBuildPath(null);
                }
                bld.setManagedBuildOn(false);
            } else {
                System.out.println(UIMessages.getString((String)"StdProjectTypeHandler.3"));
            }
            cfg.setArtifactName(STDWizardHandler.removeSpaces((String)project.getName()));
            CConfigurationData data = cfg.getConfigurationData();
            des.createConfiguration(ManagedBuildManager.CFG_DATA_PROVIDER_ID, data);
            ++i;
        }
        mngr.setProjectDescription(project, des);
        this.doPostProcess(project);
    }

    public boolean canCreateWithoutToolchain() {
        return true;
    }

    public IToolChain[] getSelectedToolChains() {
        if (this.full_tcs.size() == 0 || this.table.getSelection().length == 0) {
            return new IToolChain[1];
        }
        return super.getSelectedToolChains();
    }
}

